/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serializer.dom3;

import com.sun.org.apache.xerces.internal.util.XML11Char;
import com.sun.org.apache.xerces.internal.util.XMLChar;
import com.sun.org.apache.xml.internal.serializer.SerializationHandler;
import com.sun.org.apache.xml.internal.serializer.dom3.DOMErrorImpl;
import com.sun.org.apache.xml.internal.serializer.dom3.NamespaceSupport;
import com.sun.org.apache.xml.internal.serializer.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.ls.LSSerializerFilter;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.LocatorImpl;

final class DOM3TreeWalker {
    private SerializationHandler fSerializer = null;
    private LocatorImpl fLocator = new LocatorImpl();
    private DOMErrorHandler fErrorHandler = null;
    private LSSerializerFilter fFilter = null;
    private LexicalHandler fLexicalHandler = null;
    private int fWhatToShowFilter;
    private String fNewLine = null;
    private Properties fDOMConfigProperties = null;
    private boolean fInEntityRef = false;
    private String fXMLVersion = null;
    private boolean fIsXMLVersion11 = false;
    private boolean fIsLevel3DOM = false;
    private int fFeatures = 0;
    boolean fNextIsRaw = false;
    private static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    private static final String XMLNS_PREFIX = "xmlns";
    private static final String XML_URI = "http://www.w3.org/XML/1998/namespace";
    private static final String XML_PREFIX = "xml";
    protected NamespaceSupport fNSBinder;
    protected NamespaceSupport fLocalNSBinder;
    private int fElementDepth = 0;
    private static final int CANONICAL = 1;
    private static final int CDATA = 2;
    private static final int CHARNORMALIZE = 4;
    private static final int COMMENTS = 8;
    private static final int DTNORMALIZE = 16;
    private static final int ELEM_CONTENT_WHITESPACE = 32;
    private static final int ENTITIES = 64;
    private static final int INFOSET = 128;
    private static final int NAMESPACES = 256;
    private static final int NAMESPACEDECLS = 512;
    private static final int NORMALIZECHARS = 1024;
    private static final int SPLITCDATA = 2048;
    private static final int VALIDATE = 4096;
    private static final int SCHEMAVALIDATE = 8192;
    private static final int WELLFORMED = 16384;
    private static final int DISCARDDEFAULT = 32768;
    private static final int PRETTY_PRINT = 65536;
    private static final int IGNORE_CHAR_DENORMALIZE = 131072;
    private static final int XMLDECL = 262144;
    private static final Hashtable s_propKeys = new Hashtable();

    DOM3TreeWalker(SerializationHandler serializationHandler, DOMErrorHandler dOMErrorHandler, LSSerializerFilter lSSerializerFilter, String string) {
        this.fSerializer = serializationHandler;
        this.fErrorHandler = dOMErrorHandler;
        this.fFilter = lSSerializerFilter;
        this.fLexicalHandler = null;
        this.fNewLine = string;
        this.fNSBinder = new NamespaceSupport();
        this.fLocalNSBinder = new NamespaceSupport();
        this.fDOMConfigProperties = this.fSerializer.getOutputFormat();
        this.fSerializer.setDocumentLocator(this.fLocator);
        this.initProperties(this.fDOMConfigProperties);
        try {
            this.fLocator.setSystemId(System.getProperty("user.dir") + File.separator + "dummy.xsl");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void traverse(Node node) throws SAXException {
        Node node2;
        this.fSerializer.startDocument();
        if (node.getNodeType() != 9) {
            node2 = node.getOwnerDocument();
            if (node2 != null && node2.getImplementation().hasFeature("Core", "3.0")) {
                this.fIsLevel3DOM = true;
            }
        } else if (((Document)node).getImplementation().hasFeature("Core", "3.0")) {
            this.fIsLevel3DOM = true;
        }
        if (this.fSerializer instanceof LexicalHandler) {
            this.fLexicalHandler = this.fSerializer;
        }
        if (this.fFilter != null) {
            this.fWhatToShowFilter = this.fFilter.getWhatToShow();
        }
        node2 = node;
        while (null != node) {
            this.startNode(node);
            Node node3 = null;
            node3 = node.getFirstChild();
            while (null == node3) {
                this.endNode(node);
                if (node2.equals(node)) break;
                node3 = node.getNextSibling();
                if (null != node3 || null != (node = node.getParentNode()) && !node2.equals(node)) continue;
                if (null != node) {
                    this.endNode(node);
                }
                node3 = null;
                break;
            }
            node = node3;
        }
        this.fSerializer.endDocument();
    }

    public void traverse(Node node, Node node2) throws SAXException {
        Node node3;
        this.fSerializer.startDocument();
        if (node.getNodeType() != 9) {
            node3 = node.getOwnerDocument();
            if (node3 != null && node3.getImplementation().hasFeature("Core", "3.0")) {
                this.fIsLevel3DOM = true;
            }
        } else if (((Document)node).getImplementation().hasFeature("Core", "3.0")) {
            this.fIsLevel3DOM = true;
        }
        if (this.fSerializer instanceof LexicalHandler) {
            this.fLexicalHandler = this.fSerializer;
        }
        if (this.fFilter != null) {
            this.fWhatToShowFilter = this.fFilter.getWhatToShow();
        }
        while (null != node) {
            this.startNode(node);
            node3 = null;
            node3 = node.getFirstChild();
            while (null == node3) {
                this.endNode(node);
                if (null != node2 && node2.equals(node)) break;
                node3 = node.getNextSibling();
                if (null != node3 || null != (node = node.getParentNode()) && (null == node2 || !node2.equals(node))) continue;
                node3 = null;
                break;
            }
            node = node3;
        }
        this.fSerializer.endDocument();
    }

    private final void dispatachChars(Node node) throws SAXException {
        if (this.fSerializer != null) {
            this.fSerializer.characters(node);
        } else {
            String string = ((Text)node).getData();
            this.fSerializer.characters(string.toCharArray(), 0, string.length());
        }
    }

    protected void startNode(Node node) throws SAXException {
        if (node instanceof Locator) {
            Locator locator = (Locator)((Object)node);
            this.fLocator.setColumnNumber(locator.getColumnNumber());
            this.fLocator.setLineNumber(locator.getLineNumber());
            this.fLocator.setPublicId(locator.getPublicId());
            this.fLocator.setSystemId(locator.getSystemId());
        } else {
            this.fLocator.setColumnNumber(0);
            this.fLocator.setLineNumber(0);
        }
        switch (node.getNodeType()) {
            case 10: {
                this.serializeDocType((DocumentType)node, true);
                break;
            }
            case 8: {
                this.serializeComment((Comment)node);
                break;
            }
            case 11: {
                break;
            }
            case 9: {
                break;
            }
            case 1: {
                this.serializeElement((Element)node, true);
                break;
            }
            case 7: {
                this.serializePI((ProcessingInstruction)node);
                break;
            }
            case 4: {
                this.serializeCDATASection((CDATASection)node);
                break;
            }
            case 3: {
                this.serializeText((Text)node);
                break;
            }
            case 5: {
                this.serializeEntityReference((EntityReference)node, true);
                break;
            }
        }
    }

    protected void endNode(Node node) throws SAXException {
        switch (node.getNodeType()) {
            case 9: {
                break;
            }
            case 10: {
                this.serializeDocType((DocumentType)node, false);
                break;
            }
            case 1: {
                this.serializeElement((Element)node, false);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.serializeEntityReference((EntityReference)node, false);
                break;
            }
        }
    }

    protected boolean applyFilter(Node node, int n) {
        if (this.fFilter != null && (this.fWhatToShowFilter & n) != 0) {
            short s = this.fFilter.acceptNode(node);
            switch (s) {
                case 2: 
                case 3: {
                    return false;
                }
            }
        }
        return true;
    }

    protected void serializeDocType(DocumentType documentType, boolean bl) throws SAXException {
        String string = documentType.getNodeName();
        String string2 = documentType.getPublicId();
        String string3 = documentType.getSystemId();
        String string4 = documentType.getInternalSubset();
        if (string4 != null && !"".equals(string4)) {
            if (bl) {
                try {
                    Writer writer = this.fSerializer.getWriter();
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("<!DOCTYPE ");
                    stringBuffer.append(string);
                    if (null != string2) {
                        stringBuffer.append(" PUBLIC \"");
                        stringBuffer.append(string2);
                        stringBuffer.append('\"');
                    }
                    if (null != string3) {
                        if (null == string2) {
                            stringBuffer.append(" SYSTEM \"");
                        } else {
                            stringBuffer.append(" \"");
                        }
                        stringBuffer.append(string3);
                        stringBuffer.append('\"');
                    }
                    stringBuffer.append(" [ ");
                    stringBuffer.append(this.fNewLine);
                    stringBuffer.append(string4);
                    stringBuffer.append("]>");
                    stringBuffer.append(this.fNewLine);
                    writer.write(stringBuffer.toString());
                    writer.flush();
                }
                catch (IOException iOException) {
                    throw new SAXException(Utils.messages.createMessage("ER_WRITING_INTERNAL_SUBSET", null), iOException);
                }
            }
        } else if (bl) {
            if (this.fLexicalHandler != null) {
                this.fLexicalHandler.startDTD(string, string2, string3);
            }
        } else if (this.fLexicalHandler != null) {
            this.fLexicalHandler.endDTD();
        }
    }

    protected void serializeComment(Comment comment) throws SAXException {
        if ((this.fFeatures & 8) != 0) {
            String string = comment.getData();
            if ((this.fFeatures & 0x4000) != 0) {
                this.isCommentWellFormed(string);
            }
            if (this.fLexicalHandler != null) {
                if (!this.applyFilter(comment, 128)) {
                    return;
                }
                this.fLexicalHandler.comment(string.toCharArray(), 0, string.length());
            }
        }
    }

    protected void serializeElement(Element element, boolean bl) throws SAXException {
        if (bl) {
            ++this.fElementDepth;
            if ((this.fFeatures & 0x4000) != 0) {
                this.isElementWellFormed(element);
            }
            if (!this.applyFilter(element, 1)) {
                return;
            }
            if ((this.fFeatures & 0x100) != 0) {
                this.fNSBinder.pushContext();
                this.fLocalNSBinder.reset();
                this.recordLocalNSDecl(element);
                this.fixupElementNS(element);
            }
            this.fSerializer.startElement(element.getNamespaceURI(), element.getLocalName(), element.getNodeName());
            this.serializeAttList(element);
        } else {
            --this.fElementDepth;
            if (!this.applyFilter(element, 1)) {
                return;
            }
            this.fSerializer.endElement(element.getNamespaceURI(), element.getLocalName(), element.getNodeName());
            if ((this.fFeatures & 0x100) != 0) {
                this.fNSBinder.popContext();
            }
        }
    }

    protected void serializeAttList(Element element) throws SAXException {
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            String string;
            boolean bl;
            Node node = namedNodeMap.item(i);
            String string2 = node.getLocalName();
            String string3 = node.getNodeName();
            String string4 = node.getPrefix() == null ? "" : node.getPrefix();
            String string5 = node.getNodeValue();
            String string6 = null;
            if (this.fIsLevel3DOM) {
                string6 = ((Attr)node).getSchemaTypeInfo().getTypeName();
            }
            string6 = string6 == null ? "CDATA" : string6;
            String string7 = node.getNamespaceURI();
            if (string7 != null && string7.length() == 0) {
                string7 = null;
                string3 = node.getLocalName();
            }
            boolean bl2 = ((Attr)node).getSpecified();
            boolean bl3 = true;
            boolean bl4 = false;
            boolean bl5 = bl = string3.equals(XMLNS_PREFIX) || string3.startsWith("xmlns:");
            if ((this.fFeatures & 0x4000) != 0) {
                this.isAttributeWellFormed(node);
            }
            if ((this.fFeatures & 0x100) != 0 && !bl) {
                if (string7 != null) {
                    string4 = string4 == null ? "" : string4;
                    String string8 = this.fNSBinder.getPrefix(string7);
                    string = this.fNSBinder.getURI(string4);
                    if ("".equals(string4) || "".equals(string8) || !string4.equals(string8)) {
                        if (string8 != null && !"".equals(string8)) {
                            string4 = string8;
                            string3 = string8.length() > 0 ? string8 + ":" + string2 : string2;
                        } else if (string4 != null && !"".equals(string4) && string == null) {
                            if ((this.fFeatures & 0x200) != 0) {
                                this.fSerializer.addAttribute(XMLNS_URI, string4, "xmlns:" + string4, "CDATA", string7);
                                this.fNSBinder.declarePrefix(string4, string7);
                                this.fLocalNSBinder.declarePrefix(string4, string7);
                            }
                        } else {
                            int n2 = 1;
                            string4 = "NS" + n2++;
                            while (this.fLocalNSBinder.getURI(string4) != null) {
                                string4 = "NS" + n2++;
                            }
                            string3 = string4 + ":" + string2;
                            if ((this.fFeatures & 0x200) != 0) {
                                this.fSerializer.addAttribute(XMLNS_URI, string4, "xmlns:" + string4, "CDATA", string7);
                                this.fNSBinder.declarePrefix(string4, string7);
                                this.fLocalNSBinder.declarePrefix(string4, string7);
                            }
                        }
                    }
                } else if (string2 == null) {
                    String string9 = Utils.messages.createMessage("ER_NULL_LOCAL_ELEMENT_NAME", new Object[]{string3});
                    if (this.fErrorHandler != null) {
                        this.fErrorHandler.handleError(new DOMErrorImpl(2, string9, "ER_NULL_LOCAL_ELEMENT_NAME", null, null, null));
                    }
                }
            }
            if ((this.fFeatures & 0x8000) != 0 && bl2 || (this.fFeatures & 0x8000) == 0) {
                bl4 = true;
            } else {
                bl3 = false;
            }
            if (bl4 && this.fFilter != null && (this.fFilter.getWhatToShow() & 2) != 0 && !bl) {
                short s = this.fFilter.acceptNode(node);
                switch (s) {
                    case 2: 
                    case 3: {
                        bl3 = false;
                        break;
                    }
                }
            }
            if (bl3 && bl) {
                if ((this.fFeatures & 0x200) != 0 && string2 != null && !"".equals(string2)) {
                    this.fSerializer.addAttribute(string7, string2, string3, string6, string5);
                }
            } else if (bl3 && !bl) {
                if ((this.fFeatures & 0x200) != 0 && string7 != null) {
                    this.fSerializer.addAttribute(string7, string2, string3, string6, string5);
                } else {
                    this.fSerializer.addAttribute("", string2, string3, string6, string5);
                }
            }
            if (!bl || (this.fFeatures & 0x200) == 0) continue;
            int n3 = string3.indexOf(":");
            String string10 = string = n3 < 0 ? "" : string3.substring(n3 + 1);
            if ("".equals(string)) continue;
            this.fSerializer.namespaceAfterStartElement(string, string5);
        }
    }

    protected void serializePI(ProcessingInstruction processingInstruction) throws SAXException {
        ProcessingInstruction processingInstruction2 = processingInstruction;
        String string = processingInstruction2.getNodeName();
        if ((this.fFeatures & 0x4000) != 0) {
            this.isPIWellFormed(processingInstruction);
        }
        if (!this.applyFilter(processingInstruction, 64)) {
            return;
        }
        if (string.equals("xslt-next-is-raw")) {
            this.fNextIsRaw = true;
        } else {
            this.fSerializer.processingInstruction(string, processingInstruction2.getData());
        }
    }

    protected void serializeCDATASection(CDATASection cDATASection) throws SAXException {
        if ((this.fFeatures & 0x4000) != 0) {
            this.isCDATASectionWellFormed(cDATASection);
        }
        if ((this.fFeatures & 2) != 0) {
            String string = cDATASection.getNodeValue();
            int n = string.indexOf("]]>");
            if ((this.fFeatures & 0x800) != 0) {
                if (n >= 0) {
                    String string2 = string.substring(0, n + 2);
                    String string3 = Utils.messages.createMessage("cdata-sections-splitted", null);
                    if (this.fErrorHandler != null) {
                        this.fErrorHandler.handleError(new DOMErrorImpl(1, string3, "cdata-sections-splitted", null, string2, null));
                    }
                }
            } else if (n >= 0) {
                String string4 = string.substring(0, n + 2);
                String string5 = Utils.messages.createMessage("cdata-sections-splitted", null);
                if (this.fErrorHandler != null) {
                    this.fErrorHandler.handleError(new DOMErrorImpl(2, string5, "cdata-sections-splitted"));
                }
                return;
            }
            if (!this.applyFilter(cDATASection, 8)) {
                return;
            }
            if (this.fLexicalHandler != null) {
                this.fLexicalHandler.startCDATA();
            }
            this.dispatachChars(cDATASection);
            if (this.fLexicalHandler != null) {
                this.fLexicalHandler.endCDATA();
            }
        } else {
            this.dispatachChars(cDATASection);
        }
    }

    protected void serializeText(Text text) throws SAXException {
        if (this.fNextIsRaw) {
            this.fNextIsRaw = false;
            this.fSerializer.processingInstruction("javax.xml.transform.disable-output-escaping", "");
            this.dispatachChars(text);
            this.fSerializer.processingInstruction("javax.xml.transform.enable-output-escaping", "");
        } else {
            boolean bl = false;
            if ((this.fFeatures & 0x4000) != 0) {
                this.isTextWellFormed(text);
            }
            boolean bl2 = false;
            if (this.fIsLevel3DOM) {
                bl2 = text.isElementContentWhitespace();
            }
            if (bl2) {
                if ((this.fFeatures & 0x20) != 0) {
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (!this.applyFilter(text, 4)) {
                return;
            }
            if (bl) {
                this.dispatachChars(text);
            }
        }
    }

    protected void serializeEntityReference(EntityReference entityReference, boolean bl) throws SAXException {
        if (bl) {
            EntityReference entityReference2 = entityReference;
            if ((this.fFeatures & 0x40) != 0) {
                if ((this.fFeatures & 0x4000) != 0) {
                    this.isEntityReferneceWellFormed(entityReference);
                }
                if ((this.fFeatures & 0x100) != 0) {
                    this.checkUnboundPrefixInEntRef(entityReference);
                }
            }
            if (this.fLexicalHandler != null) {
                this.fLexicalHandler.startEntity(entityReference2.getNodeName());
            }
        } else {
            EntityReference entityReference3 = entityReference;
            if (this.fLexicalHandler != null) {
                this.fLexicalHandler.endEntity(entityReference3.getNodeName());
            }
        }
    }

    protected boolean isXMLName(String string, boolean bl) {
        if (string == null) {
            return false;
        }
        if (!bl) {
            return XMLChar.isValidName(string);
        }
        return XML11Char.isXML11ValidName(string);
    }

    protected boolean isValidQName(String string, String string2, boolean bl) {
        if (string2 == null) {
            return false;
        }
        boolean bl2 = false;
        bl2 = !bl ? (string == null || XMLChar.isValidNCName(string)) && XMLChar.isValidNCName(string2) : (string == null || XML11Char.isXML11ValidNCName(string)) && XML11Char.isXML11ValidNCName(string2);
        return bl2;
    }

    protected boolean isWFXMLChar(String string, Character c) {
        if (string == null || string.length() == 0) {
            return true;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        if (this.fIsXMLVersion11) {
            int n2 = 0;
            while (n2 < n) {
                char c2;
                char c3;
                if (!XML11Char.isXML11Invalid(cArray[n2++]) || XMLChar.isHighSurrogate(c3 = cArray[n2 - 1]) && n2 < n && XMLChar.isLowSurrogate(c2 = cArray[n2++]) && XMLChar.isSupplemental(XMLChar.supplemental(c3, c2))) continue;
                c = new Character(c3);
                return false;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                char c4;
                char c5;
                if (!XMLChar.isInvalid(cArray[n3++]) || XMLChar.isHighSurrogate(c5 = cArray[n3 - 1]) && n3 < n && XMLChar.isLowSurrogate(c4 = cArray[n3++]) && XMLChar.isSupplemental(XMLChar.supplemental(c5, c4))) continue;
                c = new Character(c5);
                return false;
            }
        }
        return true;
    }

    protected Character isWFXMLChar(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        if (this.fIsXMLVersion11) {
            int n2 = 0;
            while (n2 < n) {
                char c;
                char c2;
                if (!XML11Char.isXML11Invalid(cArray[n2++]) || XMLChar.isHighSurrogate(c2 = cArray[n2 - 1]) && n2 < n && XMLChar.isLowSurrogate(c = cArray[n2++]) && XMLChar.isSupplemental(XMLChar.supplemental(c2, c))) continue;
                Character c3 = new Character(c2);
                return c3;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                char c;
                char c4;
                if (!XMLChar.isInvalid(cArray[n3++]) || XMLChar.isHighSurrogate(c4 = cArray[n3 - 1]) && n3 < n && XMLChar.isLowSurrogate(c = cArray[n3++]) && XMLChar.isSupplemental(XMLChar.supplemental(c4, c))) continue;
                Character c5 = new Character(c4);
                return c5;
            }
        }
        return null;
    }

    protected void isCommentWellFormed(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        if (this.fIsXMLVersion11) {
            int n2 = 0;
            while (n2 < n) {
                char c;
                if (XML11Char.isXML11Invalid(c = cArray[n2++])) {
                    char c2;
                    if (XMLChar.isHighSurrogate(c) && n2 < n && XMLChar.isLowSurrogate(c2 = cArray[n2++]) && XMLChar.isSupplemental(XMLChar.supplemental(c, c2))) continue;
                    String string2 = Utils.messages.createMessage("ER_WF_INVALID_CHARACTER_IN_COMMENT", new Object[]{new Character(c)});
                    if (this.fErrorHandler == null) continue;
                    this.fErrorHandler.handleError(new DOMErrorImpl(3, string2, "wf-invalid-character", null, null, null));
                    continue;
                }
                if (c != '-' || n2 >= n || cArray[n2] != '-') continue;
                String string3 = Utils.messages.createMessage("ER_WF_DASH_IN_COMMENT", null);
                if (this.fErrorHandler == null) continue;
                this.fErrorHandler.handleError(new DOMErrorImpl(3, string3, "wf-invalid-character", null, null, null));
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                char c;
                if (XMLChar.isInvalid(c = cArray[n3++])) {
                    char c3;
                    if (XMLChar.isHighSurrogate(c) && n3 < n && XMLChar.isLowSurrogate(c3 = cArray[n3++]) && XMLChar.isSupplemental(XMLChar.supplemental(c, c3))) continue;
                    String string4 = Utils.messages.createMessage("ER_WF_INVALID_CHARACTER_IN_COMMENT", new Object[]{new Character(c)});
                    if (this.fErrorHandler == null) continue;
                    this.fErrorHandler.handleError(new DOMErrorImpl(3, string4, "wf-invalid-character", null, null, null));
                    continue;
                }
                if (c != '-' || n3 >= n || cArray[n3] != '-') continue;
                String string5 = Utils.messages.createMessage("ER_WF_DASH_IN_COMMENT", null);
                if (this.fErrorHandler == null) continue;
                this.fErrorHandler.handleError(new DOMErrorImpl(3, string5, "wf-invalid-character", null, null, null));
            }
        }
    }

    protected void isElementWellFormed(Node node) {
        boolean bl = false;
        bl = (this.fFeatures & 0x100) != 0 ? this.isValidQName(node.getPrefix(), node.getLocalName(), this.fIsXMLVersion11) : this.isXMLName(node.getNodeName(), this.fIsXMLVersion11);
        if (!bl) {
            String string = Utils.messages.createMessage("wf-invalid-character-in-node-name", new Object[]{"Element", node.getNodeName()});
            if (this.fErrorHandler != null) {
                this.fErrorHandler.handleError(new DOMErrorImpl(3, string, "wf-invalid-character-in-node-name", null, null, null));
            }
        }
    }

    protected void isAttributeWellFormed(Node node) {
        Object object;
        String string;
        boolean bl = false;
        bl = (this.fFeatures & 0x100) != 0 ? this.isValidQName(node.getPrefix(), node.getLocalName(), this.fIsXMLVersion11) : this.isXMLName(node.getNodeName(), this.fIsXMLVersion11);
        if (!bl) {
            string = Utils.messages.createMessage("wf-invalid-character-in-node-name", new Object[]{"Attr", node.getNodeName()});
            if (this.fErrorHandler != null) {
                this.fErrorHandler.handleError(new DOMErrorImpl(3, string, "wf-invalid-character-in-node-name", null, null, null));
            }
        }
        if ((string = node.getNodeValue()).indexOf(60) >= 0) {
            object = Utils.messages.createMessage("ER_WF_LT_IN_ATTVAL", new Object[]{((Attr)node).getOwnerElement().getNodeName(), node.getNodeName()});
            if (this.fErrorHandler != null) {
                this.fErrorHandler.handleError(new DOMErrorImpl(3, (String)object, "ER_WF_LT_IN_ATTVAL", null, null, null));
            }
        }
        object = node.getChildNodes();
        block4: for (int i = 0; i < object.getLength(); ++i) {
            Node node2 = object.item(i);
            if (node2 == null) continue;
            switch (node2.getNodeType()) {
                case 3: {
                    this.isTextWellFormed((Text)node2);
                    continue block4;
                }
                case 5: {
                    this.isEntityReferneceWellFormed((EntityReference)node2);
                    continue block4;
                }
            }
        }
    }

    protected void isPIWellFormed(ProcessingInstruction processingInstruction) {
        Object object;
        if (!this.isXMLName(processingInstruction.getNodeName(), this.fIsXMLVersion11)) {
            object = Utils.messages.createMessage("wf-invalid-character-in-node-name", new Object[]{"ProcessingInstruction", processingInstruction.getTarget()});
            if (this.fErrorHandler != null) {
                this.fErrorHandler.handleError(new DOMErrorImpl(3, (String)object, "wf-invalid-character-in-node-name", null, null, null));
            }
        }
        if ((object = this.isWFXMLChar(processingInstruction.getData())) != null) {
            String string = Utils.messages.createMessage("ER_WF_INVALID_CHARACTER_IN_PI", new Object[]{Integer.toHexString(Character.getNumericValue(((Character)object).charValue()))});
            if (this.fErrorHandler != null) {
                this.fErrorHandler.handleError(new DOMErrorImpl(3, string, "wf-invalid-character", null, null, null));
            }
        }
    }

    protected void isCDATASectionWellFormed(CDATASection cDATASection) {
        Character c = this.isWFXMLChar(cDATASection.getData());
        if (c != null) {
            String string = Utils.messages.createMessage("ER_WF_INVALID_CHARACTER_IN_CDATA", new Object[]{Integer.toHexString(Character.getNumericValue(c.charValue()))});
            if (this.fErrorHandler != null) {
                this.fErrorHandler.handleError(new DOMErrorImpl(3, string, "wf-invalid-character", null, null, null));
            }
        }
    }

    protected void isTextWellFormed(Text text) {
        Character c = this.isWFXMLChar(text.getData());
        if (c != null) {
            String string = Utils.messages.createMessage("ER_WF_INVALID_CHARACTER_IN_TEXT", new Object[]{Integer.toHexString(Character.getNumericValue(c.charValue()))});
            if (this.fErrorHandler != null) {
                this.fErrorHandler.handleError(new DOMErrorImpl(3, string, "wf-invalid-character", null, null, null));
            }
        }
    }

    protected void isEntityReferneceWellFormed(EntityReference entityReference) {
        Object object;
        if (!this.isXMLName(entityReference.getNodeName(), this.fIsXMLVersion11)) {
            object = Utils.messages.createMessage("wf-invalid-character-in-node-name", new Object[]{"EntityReference", entityReference.getNodeName()});
            if (this.fErrorHandler != null) {
                this.fErrorHandler.handleError(new DOMErrorImpl(3, (String)object, "wf-invalid-character-in-node-name", null, null, null));
            }
        }
        object = entityReference.getParentNode();
        DocumentType documentType = entityReference.getOwnerDocument().getDoctype();
        if (documentType != null) {
            NamedNodeMap namedNodeMap = documentType.getEntities();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                String string;
                String string2;
                Entity entity = (Entity)namedNodeMap.item(i);
                String string3 = entityReference.getNodeName() == null ? "" : entityReference.getNodeName();
                String string4 = entityReference.getNamespaceURI() == null ? "" : entityReference.getNamespaceURI();
                String string5 = entity.getNodeName() == null ? "" : entity.getNodeName();
                String string6 = string2 = entity.getNamespaceURI() == null ? "" : entity.getNamespaceURI();
                if (object.getNodeType() == 1 && string2.equals(string4) && string5.equals(string3) && entity.getNotationName() != null) {
                    string = Utils.messages.createMessage("ER_WF_REF_TO_UNPARSED_ENT", new Object[]{entityReference.getNodeName()});
                    if (this.fErrorHandler != null) {
                        this.fErrorHandler.handleError(new DOMErrorImpl(3, string, "ER_WF_REF_TO_UNPARSED_ENT", null, null, null));
                    }
                }
                if (object.getNodeType() != 2 || !string2.equals(string4) || !string5.equals(string3) || entity.getPublicId() == null && entity.getSystemId() == null && entity.getNotationName() == null) continue;
                string = Utils.messages.createMessage("ER_WF_REF_TO_EXTERNAL_ENT", new Object[]{entityReference.getNodeName()});
                if (this.fErrorHandler == null) continue;
                this.fErrorHandler.handleError(new DOMErrorImpl(3, string, "ER_WF_REF_TO_EXTERNAL_ENT", null, null, null));
            }
        }
    }

    protected void checkUnboundPrefixInEntRef(Node node) {
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            Node node3 = node2.getNextSibling();
            if (node2.getNodeType() == 1) {
                Object object;
                String string = node2.getPrefix();
                if (string != null && this.fNSBinder.getURI(string) == null) {
                    object = Utils.messages.createMessage("unbound-prefix-in-entity-reference", new Object[]{node.getNodeName(), node2.getNodeName(), string});
                    if (this.fErrorHandler != null) {
                        this.fErrorHandler.handleError(new DOMErrorImpl(3, (String)object, "unbound-prefix-in-entity-reference", null, null, null));
                    }
                }
                object = node2.getAttributes();
                for (int i = 0; i < object.getLength(); ++i) {
                    String string2 = object.item(i).getPrefix();
                    if (string2 == null || this.fNSBinder.getURI(string2) != null) continue;
                    String string3 = Utils.messages.createMessage("unbound-prefix-in-entity-reference", new Object[]{node.getNodeName(), node2.getNodeName(), object.item(i)});
                    if (this.fErrorHandler == null) continue;
                    this.fErrorHandler.handleError(new DOMErrorImpl(3, string3, "unbound-prefix-in-entity-reference", null, null, null));
                }
            }
            if (node2.hasChildNodes()) {
                this.checkUnboundPrefixInEntRef(node2);
            }
            node2 = node3;
        }
    }

    protected void recordLocalNSDecl(Node node) {
        NamedNodeMap namedNodeMap = ((Element)node).getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = namedNodeMap.item(i);
            String string = node2.getLocalName();
            String string2 = node2.getPrefix();
            String string3 = node2.getNodeValue();
            String string4 = node2.getNamespaceURI();
            string = string == null || XMLNS_PREFIX.equals(string) ? "" : string;
            string2 = string2 == null ? "" : string2;
            string3 = string3 == null ? "" : string3;
            String string5 = string4 = string4 == null ? "" : string4;
            if (!XMLNS_URI.equals(string4)) continue;
            if (XMLNS_URI.equals(string3)) {
                String string6 = Utils.messages.createMessage("ER_NS_PREFIX_CANNOT_BE_BOUND", new Object[]{string2, XMLNS_URI});
                if (this.fErrorHandler == null) continue;
                this.fErrorHandler.handleError(new DOMErrorImpl(2, string6, "ER_NS_PREFIX_CANNOT_BE_BOUND", null, null, null));
                continue;
            }
            if (XMLNS_PREFIX.equals(string2)) {
                if (string3.length() == 0) continue;
                this.fNSBinder.declarePrefix(string, string3);
                continue;
            }
            this.fNSBinder.declarePrefix("", string3);
        }
    }

    protected void fixupElementNS(Node node) throws SAXException {
        String string = ((Element)node).getNamespaceURI();
        String string2 = ((Element)node).getPrefix();
        String string3 = ((Element)node).getLocalName();
        if (string != null) {
            String string4 = this.fNSBinder.getURI(string2 = string2 == null ? "" : string2);
            if (string4 == null || !string4.equals(string)) {
                if ((this.fFeatures & 0x200) != 0) {
                    if ("".equals(string2) || "".equals(string)) {
                        ((Element)node).setAttributeNS(XMLNS_URI, XMLNS_PREFIX, string);
                    } else {
                        ((Element)node).setAttributeNS(XMLNS_URI, "xmlns:" + string2, string);
                    }
                }
                this.fLocalNSBinder.declarePrefix(string2, string);
                this.fNSBinder.declarePrefix(string2, string);
            }
        } else if (string3 == null || "".equals(string3)) {
            String string5 = Utils.messages.createMessage("ER_NULL_LOCAL_ELEMENT_NAME", new Object[]{node.getNodeName()});
            if (this.fErrorHandler != null) {
                this.fErrorHandler.handleError(new DOMErrorImpl(2, string5, "ER_NULL_LOCAL_ELEMENT_NAME", null, null, null));
            }
        } else {
            string = this.fNSBinder.getURI("");
            if (string != null && string.length() > 0) {
                ((Element)node).setAttributeNS(XMLNS_URI, XMLNS_PREFIX, "");
                this.fLocalNSBinder.declarePrefix("", "");
                this.fNSBinder.declarePrefix("", "");
            }
        }
    }

    protected void initProperties(Properties properties) {
        Enumeration enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            Object v = s_propKeys.get(string2);
            if (v == null) continue;
            if (v instanceof Integer) {
                int n = (Integer)v;
                if (properties.getProperty(string2).endsWith("yes")) {
                    this.fFeatures |= n;
                    continue;
                }
                this.fFeatures &= ~n;
                continue;
            }
            if ("{http://www.w3.org/TR/DOM-Level-3-LS}format-pretty-print".equals(string2)) {
                if (properties.getProperty(string2).endsWith("yes")) {
                    this.fSerializer.setIndent(true);
                    this.fSerializer.setIndentAmount(4);
                    continue;
                }
                this.fSerializer.setIndent(false);
                continue;
            }
            if ("omit-xml-declaration".equals(string2)) {
                if (properties.getProperty(string2).endsWith("yes")) {
                    this.fSerializer.setOmitXMLDeclaration(true);
                    continue;
                }
                this.fSerializer.setOmitXMLDeclaration(false);
                continue;
            }
            if ("{http://xml.apache.org/xerces-2j}xml-version".equals(string2)) {
                String string3 = properties.getProperty(string2);
                if ("1.1".equals(string3)) {
                    this.fIsXMLVersion11 = true;
                    this.fSerializer.setVersion(string3);
                    continue;
                }
                this.fSerializer.setVersion("1.0");
                continue;
            }
            if ("encoding".equals(string2)) {
                String string4 = properties.getProperty(string2);
                if (string4 == null) continue;
                this.fSerializer.setEncoding(string4);
                continue;
            }
            if (!"{http://xml.apache.org/xalan}entities".equals(string2) || !"com/sun/org/apache/xml/internal/serializer/XMLEntities".equals(string = properties.getProperty(string2))) continue;
            this.fSerializer.setDTDEntityExpansion(false);
        }
        if (this.fNewLine != null) {
            this.fSerializer.setOutputProperty("{http://xml.apache.org/xalan}line-separator", this.fNewLine);
        }
    }

    static {
        int n = 2;
        Integer n2 = new Integer(n);
        s_propKeys.put("{http://www.w3.org/TR/DOM-Level-3-LS}cdata-sections", n2);
        int n3 = 8;
        n2 = new Integer(n3);
        s_propKeys.put("{http://www.w3.org/TR/DOM-Level-3-LS}comments", n2);
        int n4 = 32;
        n2 = new Integer(n4);
        s_propKeys.put("{http://www.w3.org/TR/DOM-Level-3-LS}element-content-whitespace", n2);
        int n5 = 64;
        n2 = new Integer(n5);
        s_propKeys.put("{http://www.w3.org/TR/DOM-Level-3-LS}entities", n2);
        int n6 = 256;
        n2 = new Integer(n6);
        s_propKeys.put("{http://www.w3.org/TR/DOM-Level-3-LS}namespaces", n2);
        int n7 = 512;
        n2 = new Integer(n7);
        s_propKeys.put("{http://www.w3.org/TR/DOM-Level-3-LS}namespace-declarations", n2);
        int n8 = 2048;
        n2 = new Integer(n8);
        s_propKeys.put("{http://www.w3.org/TR/DOM-Level-3-LS}split-cdata-sections", n2);
        int n9 = 16384;
        n2 = new Integer(n9);
        s_propKeys.put("{http://www.w3.org/TR/DOM-Level-3-LS}well-formed", n2);
        int n10 = 32768;
        n2 = new Integer(n10);
        s_propKeys.put("{http://www.w3.org/TR/DOM-Level-3-LS}discard-default-content", n2);
        s_propKeys.put("{http://www.w3.org/TR/DOM-Level-3-LS}format-pretty-print", "");
        s_propKeys.put("omit-xml-declaration", "");
        s_propKeys.put("{http://xml.apache.org/xerces-2j}xml-version", "");
        s_propKeys.put("encoding", "");
        s_propKeys.put("{http://xml.apache.org/xalan}entities", "");
    }
}

