/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.Const;
import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.generic.BranchHandle;
import com.sun.org.apache.bcel.internal.generic.BranchInstruction;
import com.sun.org.apache.bcel.internal.generic.CPInstruction;
import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.CodeExceptionGen;
import com.sun.org.apache.bcel.internal.generic.CompoundInstruction;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.Instruction;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.InstructionListObserver;
import com.sun.org.apache.bcel.internal.generic.LocalVariableGen;
import com.sun.org.apache.bcel.internal.generic.Select;
import com.sun.org.apache.bcel.internal.generic.TargetLostException;
import com.sun.org.apache.bcel.internal.util.ByteSequence;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class InstructionList
implements Iterable<InstructionHandle> {
    private InstructionHandle start = null;
    private InstructionHandle end = null;
    private int length = 0;
    private int[] byte_positions;
    private List<InstructionListObserver> observers;

    public InstructionList() {
    }

    public InstructionList(Instruction instruction) {
        this.append(instruction);
    }

    public InstructionList(BranchInstruction branchInstruction) {
        this.append(branchInstruction);
    }

    public InstructionList(CompoundInstruction compoundInstruction) {
        this.append(compoundInstruction.getInstructionList());
    }

    public boolean isEmpty() {
        return this.start == null;
    }

    public static InstructionHandle findHandle(InstructionHandle[] instructionHandleArray, int[] nArray, int n, int n2) {
        int n3 = 0;
        int n4 = n - 1;
        do {
            int n5;
            int n6;
            if ((n6 = nArray[n5 = (n3 + n4) / 2]) == n2) {
                return instructionHandleArray[n5];
            }
            if (n2 < n6) {
                n4 = n5 - 1;
                continue;
            }
            n3 = n5 + 1;
        } while (n3 <= n4);
        return null;
    }

    public InstructionHandle findHandle(int n) {
        int[] nArray = this.byte_positions;
        InstructionHandle instructionHandle = this.start;
        for (int i = 0; i < this.length; ++i) {
            if (nArray[i] == n) {
                return instructionHandle;
            }
            instructionHandle = instructionHandle.getNext();
        }
        return null;
    }

    public InstructionList(byte[] byArray) {
        Object object;
        Object object2;
        int[] nArray;
        InstructionHandle[] instructionHandleArray;
        Object object3;
        int n = 0;
        try {
            ByteSequence byteSequence = new ByteSequence(byArray);
            object3 = null;
            try {
                instructionHandleArray = new InstructionHandle[byArray.length];
                nArray = new int[byArray.length];
                while (byteSequence.available() > 0) {
                    int n2;
                    nArray[n] = n2 = byteSequence.getIndex();
                    object2 = Instruction.readInstruction(byteSequence);
                    object = object2 instanceof BranchInstruction ? this.append((BranchInstruction)object2) : this.append((Instruction)object2);
                    ((InstructionHandle)object).setPosition(n2);
                    instructionHandleArray[n] = object;
                    ++n;
                }
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                if (byteSequence != null) {
                    if (object3 != null) {
                        try {
                            byteSequence.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object3).addSuppressed(throwable);
                        }
                    } else {
                        byteSequence.close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new ClassGenException(iOException.toString(), iOException);
        }
        this.byte_positions = new int[n];
        System.arraycopy(nArray, 0, this.byte_positions, 0, n);
        for (int i = 0; i < n; ++i) {
            if (!(instructionHandleArray[i] instanceof BranchHandle)) continue;
            object3 = (BranchInstruction)instructionHandleArray[i].getInstruction();
            int n3 = ((BranchInstruction)object3).getPosition() + ((BranchInstruction)object3).getIndex();
            object2 = InstructionList.findHandle(instructionHandleArray, nArray, n, n3);
            if (object2 == null) {
                throw new ClassGenException("Couldn't find target for branch: " + object3);
            }
            ((BranchInstruction)object3).setTarget((InstructionHandle)object2);
            if (!(object3 instanceof Select)) continue;
            object = (Select)object3;
            int[] nArray2 = ((Select)object).getIndices();
            for (int j = 0; j < nArray2.length; ++j) {
                n3 = ((BranchInstruction)object3).getPosition() + nArray2[j];
                object2 = InstructionList.findHandle(instructionHandleArray, nArray, n, n3);
                if (object2 == null) {
                    throw new ClassGenException("Couldn't find target for switch: " + object3);
                }
                ((Select)object).setTarget(j, (InstructionHandle)object2);
            }
        }
    }

    public InstructionHandle append(InstructionHandle instructionHandle, InstructionList instructionList) {
        if (instructionList == null) {
            throw new ClassGenException("Appending null InstructionList");
        }
        if (instructionList.isEmpty()) {
            return instructionHandle;
        }
        InstructionHandle instructionHandle2 = instructionHandle.getNext();
        InstructionHandle instructionHandle3 = instructionList.start;
        instructionHandle.setNext(instructionList.start);
        instructionList.start.setPrev(instructionHandle);
        instructionList.end.setNext(instructionHandle2);
        if (instructionHandle2 != null) {
            instructionHandle2.setPrev(instructionList.end);
        } else {
            this.end = instructionList.end;
        }
        this.length += instructionList.length;
        instructionList.clear();
        return instructionHandle3;
    }

    public InstructionHandle append(Instruction instruction, InstructionList instructionList) {
        InstructionHandle instructionHandle = this.findInstruction2(instruction);
        if (instructionHandle == null) {
            throw new ClassGenException("Instruction " + instruction + " is not contained in this list.");
        }
        return this.append(instructionHandle, instructionList);
    }

    public InstructionHandle append(InstructionList instructionList) {
        if (instructionList == null) {
            throw new ClassGenException("Appending null InstructionList");
        }
        if (instructionList.isEmpty()) {
            return null;
        }
        if (this.isEmpty()) {
            this.start = instructionList.start;
            this.end = instructionList.end;
            this.length = instructionList.length;
            instructionList.clear();
            return this.start;
        }
        return this.append(this.end, instructionList);
    }

    private void append(InstructionHandle instructionHandle) {
        if (this.isEmpty()) {
            this.start = this.end = instructionHandle;
            instructionHandle.setNext(instructionHandle.setPrev(null));
        } else {
            this.end.setNext(instructionHandle);
            instructionHandle.setPrev(this.end);
            instructionHandle.setNext(null);
            this.end = instructionHandle;
        }
        ++this.length;
    }

    public InstructionHandle append(Instruction instruction) {
        InstructionHandle instructionHandle = InstructionHandle.getInstructionHandle(instruction);
        this.append(instructionHandle);
        return instructionHandle;
    }

    public BranchHandle append(BranchInstruction branchInstruction) {
        BranchHandle branchHandle = BranchHandle.getBranchHandle(branchInstruction);
        this.append(branchHandle);
        return branchHandle;
    }

    public InstructionHandle append(Instruction instruction, Instruction instruction2) {
        return this.append(instruction, new InstructionList(instruction2));
    }

    public InstructionHandle append(Instruction instruction, CompoundInstruction compoundInstruction) {
        return this.append(instruction, compoundInstruction.getInstructionList());
    }

    public InstructionHandle append(CompoundInstruction compoundInstruction) {
        return this.append(compoundInstruction.getInstructionList());
    }

    public InstructionHandle append(InstructionHandle instructionHandle, CompoundInstruction compoundInstruction) {
        return this.append(instructionHandle, compoundInstruction.getInstructionList());
    }

    public InstructionHandle append(InstructionHandle instructionHandle, Instruction instruction) {
        return this.append(instructionHandle, new InstructionList(instruction));
    }

    public BranchHandle append(InstructionHandle instructionHandle, BranchInstruction branchInstruction) {
        BranchHandle branchHandle = BranchHandle.getBranchHandle(branchInstruction);
        InstructionList instructionList = new InstructionList();
        instructionList.append(branchHandle);
        this.append(instructionHandle, instructionList);
        return branchHandle;
    }

    public InstructionHandle insert(InstructionHandle instructionHandle, InstructionList instructionList) {
        if (instructionList == null) {
            throw new ClassGenException("Inserting null InstructionList");
        }
        if (instructionList.isEmpty()) {
            return instructionHandle;
        }
        InstructionHandle instructionHandle2 = instructionHandle.getPrev();
        InstructionHandle instructionHandle3 = instructionList.start;
        instructionHandle.setPrev(instructionList.end);
        instructionList.end.setNext(instructionHandle);
        instructionList.start.setPrev(instructionHandle2);
        if (instructionHandle2 != null) {
            instructionHandle2.setNext(instructionList.start);
        } else {
            this.start = instructionList.start;
        }
        this.length += instructionList.length;
        instructionList.clear();
        return instructionHandle3;
    }

    public InstructionHandle insert(InstructionList instructionList) {
        if (this.isEmpty()) {
            this.append(instructionList);
            return this.start;
        }
        return this.insert(this.start, instructionList);
    }

    private void insert(InstructionHandle instructionHandle) {
        if (this.isEmpty()) {
            this.start = this.end = instructionHandle;
            instructionHandle.setNext(instructionHandle.setPrev(null));
        } else {
            this.start.setPrev(instructionHandle);
            instructionHandle.setNext(this.start);
            instructionHandle.setPrev(null);
            this.start = instructionHandle;
        }
        ++this.length;
    }

    public InstructionHandle insert(Instruction instruction, InstructionList instructionList) {
        InstructionHandle instructionHandle = this.findInstruction1(instruction);
        if (instructionHandle == null) {
            throw new ClassGenException("Instruction " + instruction + " is not contained in this list.");
        }
        return this.insert(instructionHandle, instructionList);
    }

    public InstructionHandle insert(Instruction instruction) {
        InstructionHandle instructionHandle = InstructionHandle.getInstructionHandle(instruction);
        this.insert(instructionHandle);
        return instructionHandle;
    }

    public BranchHandle insert(BranchInstruction branchInstruction) {
        BranchHandle branchHandle = BranchHandle.getBranchHandle(branchInstruction);
        this.insert(branchHandle);
        return branchHandle;
    }

    public InstructionHandle insert(Instruction instruction, Instruction instruction2) {
        return this.insert(instruction, new InstructionList(instruction2));
    }

    public InstructionHandle insert(Instruction instruction, CompoundInstruction compoundInstruction) {
        return this.insert(instruction, compoundInstruction.getInstructionList());
    }

    public InstructionHandle insert(CompoundInstruction compoundInstruction) {
        return this.insert(compoundInstruction.getInstructionList());
    }

    public InstructionHandle insert(InstructionHandle instructionHandle, Instruction instruction) {
        return this.insert(instructionHandle, new InstructionList(instruction));
    }

    public InstructionHandle insert(InstructionHandle instructionHandle, CompoundInstruction compoundInstruction) {
        return this.insert(instructionHandle, compoundInstruction.getInstructionList());
    }

    public BranchHandle insert(InstructionHandle instructionHandle, BranchInstruction branchInstruction) {
        BranchHandle branchHandle = BranchHandle.getBranchHandle(branchInstruction);
        InstructionList instructionList = new InstructionList();
        instructionList.append(branchHandle);
        this.insert(instructionHandle, instructionList);
        return branchHandle;
    }

    public void move(InstructionHandle instructionHandle, InstructionHandle instructionHandle2, InstructionHandle instructionHandle3) {
        InstructionHandle instructionHandle4;
        if (instructionHandle == null || instructionHandle2 == null) {
            throw new ClassGenException("Invalid null handle: From " + instructionHandle + " to " + instructionHandle2);
        }
        if (instructionHandle3 == instructionHandle || instructionHandle3 == instructionHandle2) {
            throw new ClassGenException("Invalid range: From " + instructionHandle + " to " + instructionHandle2 + " contains target " + instructionHandle3);
        }
        for (instructionHandle4 = instructionHandle; instructionHandle4 != instructionHandle2.getNext(); instructionHandle4 = instructionHandle4.getNext()) {
            if (instructionHandle4 == null) {
                throw new ClassGenException("Invalid range: From " + instructionHandle + " to " + instructionHandle2);
            }
            if (instructionHandle4 != instructionHandle3) continue;
            throw new ClassGenException("Invalid range: From " + instructionHandle + " to " + instructionHandle2 + " contains target " + instructionHandle3);
        }
        instructionHandle4 = instructionHandle.getPrev();
        InstructionHandle instructionHandle5 = instructionHandle2.getNext();
        if (instructionHandle4 != null) {
            instructionHandle4.setNext(instructionHandle5);
        } else {
            this.start = instructionHandle5;
        }
        if (instructionHandle5 != null) {
            instructionHandle5.setPrev(instructionHandle4);
        } else {
            this.end = instructionHandle4;
        }
        instructionHandle.setPrev(instructionHandle2.setNext(null));
        if (instructionHandle3 == null) {
            if (this.start != null) {
                this.start.setPrev(instructionHandle2);
            }
            instructionHandle2.setNext(this.start);
            this.start = instructionHandle;
        } else {
            instructionHandle5 = instructionHandle3.getNext();
            instructionHandle3.setNext(instructionHandle);
            instructionHandle.setPrev(instructionHandle3);
            instructionHandle2.setNext(instructionHandle5);
            if (instructionHandle5 != null) {
                instructionHandle5.setPrev(instructionHandle2);
            } else {
                this.end = instructionHandle2;
            }
        }
    }

    public void move(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        this.move(instructionHandle, instructionHandle, instructionHandle2);
    }

    private void remove(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) throws TargetLostException {
        Object object;
        InstructionHandle instructionHandle3;
        InstructionHandle[] instructionHandleArray;
        if (instructionHandle == null && instructionHandle2 == null) {
            instructionHandleArray = this.start;
            instructionHandle3 = this.end;
            this.end = null;
            this.start = null;
        } else {
            if (instructionHandle == null) {
                instructionHandleArray = this.start;
                this.start = instructionHandle2;
            } else {
                instructionHandleArray = instructionHandle.getNext();
                instructionHandle.setNext(instructionHandle2);
            }
            if (instructionHandle2 == null) {
                instructionHandle3 = this.end;
                this.end = instructionHandle;
            } else {
                instructionHandle3 = instructionHandle2.getPrev();
                instructionHandle2.setPrev(instructionHandle);
            }
        }
        instructionHandleArray.setPrev(null);
        instructionHandle3.setNext(null);
        ArrayList<InstructionHandle[]> arrayList = new ArrayList<InstructionHandle[]>();
        for (object = instructionHandleArray; object != null; object = ((InstructionHandle)object).getNext()) {
            ((InstructionHandle)object).getInstruction().dispose();
        }
        object = new StringBuilder("{ ");
        Object object2 = instructionHandleArray;
        while (object2 != null) {
            instructionHandle2 = ((InstructionHandle)object2).getNext();
            --this.length;
            if (((InstructionHandle)object2).hasTargeters()) {
                arrayList.add((InstructionHandle[])object2);
                ((StringBuilder)object).append(((InstructionHandle)object2).toString(true)).append(" ");
                ((InstructionHandle)object2).setNext(((InstructionHandle)object2).setPrev(null));
            } else {
                ((InstructionHandle)object2).dispose();
            }
            object2 = instructionHandle2;
        }
        ((StringBuilder)object).append("}");
        if (!arrayList.isEmpty()) {
            object2 = new InstructionHandle[arrayList.size()];
            arrayList.toArray((T[])object2);
            throw new TargetLostException((InstructionHandle[])object2, ((StringBuilder)object).toString());
        }
    }

    public void delete(InstructionHandle instructionHandle) throws TargetLostException {
        this.remove(instructionHandle.getPrev(), instructionHandle.getNext());
    }

    public void delete(Instruction instruction) throws TargetLostException {
        InstructionHandle instructionHandle = this.findInstruction1(instruction);
        if (instructionHandle == null) {
            throw new ClassGenException("Instruction " + instruction + " is not contained in this list.");
        }
        this.delete(instructionHandle);
    }

    public void delete(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) throws TargetLostException {
        this.remove(instructionHandle.getPrev(), instructionHandle2.getNext());
    }

    public void delete(Instruction instruction, Instruction instruction2) throws TargetLostException {
        InstructionHandle instructionHandle = this.findInstruction1(instruction);
        if (instructionHandle == null) {
            throw new ClassGenException("Instruction " + instruction + " is not contained in this list.");
        }
        InstructionHandle instructionHandle2 = this.findInstruction2(instruction2);
        if (instructionHandle2 == null) {
            throw new ClassGenException("Instruction " + instruction2 + " is not contained in this list.");
        }
        this.delete(instructionHandle, instructionHandle2);
    }

    private InstructionHandle findInstruction1(Instruction instruction) {
        for (InstructionHandle instructionHandle = this.start; instructionHandle != null; instructionHandle = instructionHandle.getNext()) {
            if (instructionHandle.getInstruction() != instruction) continue;
            return instructionHandle;
        }
        return null;
    }

    private InstructionHandle findInstruction2(Instruction instruction) {
        for (InstructionHandle instructionHandle = this.end; instructionHandle != null; instructionHandle = instructionHandle.getPrev()) {
            if (instructionHandle.getInstruction() != instruction) continue;
            return instructionHandle;
        }
        return null;
    }

    public boolean contains(InstructionHandle instructionHandle) {
        if (instructionHandle == null) {
            return false;
        }
        for (InstructionHandle instructionHandle2 = this.start; instructionHandle2 != null; instructionHandle2 = instructionHandle2.getNext()) {
            if (instructionHandle2 != instructionHandle) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Instruction instruction) {
        return this.findInstruction1(instruction) != null;
    }

    public void setPositions() {
        this.setPositions(false);
    }

    public void setPositions(boolean bl) {
        Instruction instruction;
        InstructionHandle instructionHandle;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int[] nArray = new int[this.length];
        if (bl) {
            for (instructionHandle = this.start; instructionHandle != null; instructionHandle = instructionHandle.getNext()) {
                instruction = instructionHandle.getInstruction();
                if (!(instruction instanceof BranchInstruction)) continue;
                Instruction instruction2 = ((BranchInstruction)instruction).getTarget().getInstruction();
                if (!this.contains(instruction2)) {
                    throw new ClassGenException("Branch target of " + Const.getOpcodeName(instruction.getOpcode()) + ":" + instruction2 + " not in instruction list");
                }
                if (instruction instanceof Select) {
                    InstructionHandle[] instructionHandleArray;
                    for (InstructionHandle instructionHandle2 : instructionHandleArray = ((Select)instruction).getTargets()) {
                        instruction2 = instructionHandle2.getInstruction();
                        if (this.contains(instruction2)) continue;
                        throw new ClassGenException("Branch target of " + Const.getOpcodeName(instruction.getOpcode()) + ":" + instruction2 + " not in instruction list");
                    }
                }
                if (instructionHandle instanceof BranchHandle) continue;
                throw new ClassGenException("Branch instruction " + Const.getOpcodeName(instruction.getOpcode()) + ":" + instruction2 + " not contained in BranchHandle.");
            }
        }
        for (instructionHandle = this.start; instructionHandle != null; instructionHandle = instructionHandle.getNext()) {
            instruction = instructionHandle.getInstruction();
            instructionHandle.setPosition(n3);
            nArray[n4++] = n3;
            switch (instruction.getOpcode()) {
                case 167: 
                case 168: {
                    n += 2;
                    break;
                }
                case 170: 
                case 171: {
                    n += 3;
                }
            }
            n3 += instruction.getLength();
        }
        for (instructionHandle = this.start; instructionHandle != null; instructionHandle = instructionHandle.getNext()) {
            n2 += instructionHandle.updatePosition(n2, n);
        }
        n4 = 0;
        n3 = 0;
        for (instructionHandle = this.start; instructionHandle != null; instructionHandle = instructionHandle.getNext()) {
            instruction = instructionHandle.getInstruction();
            instructionHandle.setPosition(n3);
            nArray[n4++] = n3;
            n3 += instruction.getLength();
        }
        if (this.length == n4) {
            this.byte_positions = nArray;
        } else {
            this.byte_positions = new int[n4];
            System.arraycopy(nArray, 0, this.byte_positions, 0, n4);
        }
    }

    public byte[] getByteCode() {
        this.setPositions();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            for (InstructionHandle instructionHandle = this.start; instructionHandle != null; instructionHandle = instructionHandle.getNext()) {
                Instruction instruction = instructionHandle.getInstruction();
                instruction.dump(dataOutputStream);
            }
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return new byte[0];
        }
        return byteArrayOutputStream.toByteArray();
    }

    public Instruction[] getInstructions() {
        ArrayList<Instruction> arrayList = new ArrayList<Instruction>();
        try (ByteSequence byteSequence = new ByteSequence(this.getByteCode());){
            while (byteSequence.available() > 0) {
                arrayList.add(Instruction.readInstruction(byteSequence));
            }
        }
        catch (IOException iOException) {
            throw new ClassGenException(iOException.toString(), iOException);
        }
        return arrayList.toArray(new Instruction[arrayList.size()]);
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        for (InstructionHandle instructionHandle = this.start; instructionHandle != null; instructionHandle = instructionHandle.getNext()) {
            stringBuilder.append(instructionHandle.toString(bl)).append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public Iterator<InstructionHandle> iterator() {
        return new Iterator<InstructionHandle>(){
            private InstructionHandle ih;
            {
                this.ih = InstructionList.this.start;
            }

            @Override
            public InstructionHandle next() throws NoSuchElementException {
                if (this.ih == null) {
                    throw new NoSuchElementException();
                }
                InstructionHandle instructionHandle = this.ih;
                this.ih = this.ih.getNext();
                return instructionHandle;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return this.ih != null;
            }
        };
    }

    public InstructionHandle[] getInstructionHandles() {
        InstructionHandle[] instructionHandleArray = new InstructionHandle[this.length];
        InstructionHandle instructionHandle = this.start;
        for (int i = 0; i < this.length; ++i) {
            instructionHandleArray[i] = instructionHandle;
            instructionHandle = instructionHandle.getNext();
        }
        return instructionHandleArray;
    }

    public int[] getInstructionPositions() {
        return this.byte_positions;
    }

    public InstructionList copy() {
        Instruction instruction;
        Object object;
        InstructionHandle instructionHandle;
        HashMap<InstructionHandle, InstructionHandle> hashMap = new HashMap<InstructionHandle, InstructionHandle>();
        InstructionList instructionList = new InstructionList();
        for (instructionHandle = this.start; instructionHandle != null; instructionHandle = instructionHandle.getNext()) {
            object = instructionHandle.getInstruction();
            instruction = ((Instruction)object).copy();
            if (instruction instanceof BranchInstruction) {
                hashMap.put(instructionHandle, instructionList.append((BranchInstruction)instruction));
                continue;
            }
            hashMap.put(instructionHandle, instructionList.append(instruction));
        }
        instructionHandle = this.start;
        object = instructionList.start;
        while (instructionHandle != null) {
            instruction = instructionHandle.getInstruction();
            Instruction instruction2 = ((InstructionHandle)object).getInstruction();
            if (instruction instanceof BranchInstruction) {
                BranchInstruction branchInstruction = (BranchInstruction)instruction;
                BranchInstruction branchInstruction2 = (BranchInstruction)instruction2;
                InstructionHandle instructionHandle2 = branchInstruction.getTarget();
                branchInstruction2.setTarget((InstructionHandle)hashMap.get(instructionHandle2));
                if (branchInstruction instanceof Select) {
                    InstructionHandle[] instructionHandleArray = ((Select)branchInstruction).getTargets();
                    InstructionHandle[] instructionHandleArray2 = ((Select)branchInstruction2).getTargets();
                    for (int i = 0; i < instructionHandleArray.length; ++i) {
                        instructionHandleArray2[i] = (InstructionHandle)hashMap.get(instructionHandleArray[i]);
                    }
                }
            }
            instructionHandle = instructionHandle.getNext();
            object = ((InstructionHandle)object).getNext();
        }
        return instructionList;
    }

    public void replaceConstantPool(ConstantPoolGen constantPoolGen, ConstantPoolGen constantPoolGen2) {
        for (InstructionHandle instructionHandle = this.start; instructionHandle != null; instructionHandle = instructionHandle.getNext()) {
            Instruction instruction = instructionHandle.getInstruction();
            if (!(instruction instanceof CPInstruction)) continue;
            CPInstruction cPInstruction = (CPInstruction)instruction;
            Constant constant = constantPoolGen.getConstant(cPInstruction.getIndex());
            cPInstruction.setIndex(constantPoolGen2.addConstant(constant, constantPoolGen));
        }
    }

    private void clear() {
        this.end = null;
        this.start = null;
        this.length = 0;
    }

    public void dispose() {
        for (InstructionHandle instructionHandle = this.end; instructionHandle != null; instructionHandle = instructionHandle.getPrev()) {
            instructionHandle.dispose();
        }
        this.clear();
    }

    public InstructionHandle getStart() {
        return this.start;
    }

    public InstructionHandle getEnd() {
        return this.end;
    }

    public int getLength() {
        return this.length;
    }

    public int size() {
        return this.length;
    }

    public void redirectBranches(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        for (InstructionHandle instructionHandle3 = this.start; instructionHandle3 != null; instructionHandle3 = instructionHandle3.getNext()) {
            Instruction instruction = instructionHandle3.getInstruction();
            if (!(instruction instanceof BranchInstruction)) continue;
            BranchInstruction branchInstruction = (BranchInstruction)instruction;
            InstructionHandle instructionHandle4 = branchInstruction.getTarget();
            if (instructionHandle4 == instructionHandle) {
                branchInstruction.setTarget(instructionHandle2);
            }
            if (!(branchInstruction instanceof Select)) continue;
            InstructionHandle[] instructionHandleArray = ((Select)branchInstruction).getTargets();
            for (int i = 0; i < instructionHandleArray.length; ++i) {
                if (instructionHandleArray[i] != instructionHandle) continue;
                ((Select)branchInstruction).setTarget(i, instructionHandle2);
            }
        }
    }

    public void redirectLocalVariables(LocalVariableGen[] localVariableGenArray, InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        for (LocalVariableGen localVariableGen : localVariableGenArray) {
            InstructionHandle instructionHandle3 = localVariableGen.getStart();
            InstructionHandle instructionHandle4 = localVariableGen.getEnd();
            if (instructionHandle3 == instructionHandle) {
                localVariableGen.setStart(instructionHandle2);
            }
            if (instructionHandle4 != instructionHandle) continue;
            localVariableGen.setEnd(instructionHandle2);
        }
    }

    public void redirectExceptionHandlers(CodeExceptionGen[] codeExceptionGenArray, InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        for (CodeExceptionGen codeExceptionGen : codeExceptionGenArray) {
            if (codeExceptionGen.getStartPC() == instructionHandle) {
                codeExceptionGen.setStartPC(instructionHandle2);
            }
            if (codeExceptionGen.getEndPC() == instructionHandle) {
                codeExceptionGen.setEndPC(instructionHandle2);
            }
            if (codeExceptionGen.getHandlerPC() != instructionHandle) continue;
            codeExceptionGen.setHandlerPC(instructionHandle2);
        }
    }

    public void addObserver(InstructionListObserver instructionListObserver) {
        if (this.observers == null) {
            this.observers = new ArrayList<InstructionListObserver>();
        }
        this.observers.add(instructionListObserver);
    }

    public void removeObserver(InstructionListObserver instructionListObserver) {
        if (this.observers != null) {
            this.observers.remove(instructionListObserver);
        }
    }

    public void update() {
        if (this.observers != null) {
            for (InstructionListObserver instructionListObserver : this.observers) {
                instructionListObserver.notify(this);
            }
        }
    }
}

