/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public class MethodParameter
implements Cloneable {
    private int name_index;
    private int access_flags;

    public MethodParameter() {
    }

    MethodParameter(DataInput dataInput) throws IOException {
        this.name_index = dataInput.readUnsignedShort();
        this.access_flags = dataInput.readUnsignedShort();
    }

    public int getNameIndex() {
        return this.name_index;
    }

    public void setNameIndex(int n) {
        this.name_index = n;
    }

    public String getParameterName(ConstantPool constantPool) {
        if (this.name_index == 0) {
            return null;
        }
        return ((ConstantUtf8)constantPool.getConstant(this.name_index, (byte)1)).getBytes();
    }

    public int getAccessFlags() {
        return this.access_flags;
    }

    public void setAccessFlags(int n) {
        this.access_flags = n;
    }

    public boolean isFinal() {
        return (this.access_flags & 0x10) != 0;
    }

    public boolean isSynthetic() {
        return (this.access_flags & 0x1000) != 0;
    }

    public boolean isMandated() {
        return (this.access_flags & Short.MIN_VALUE) != 0;
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.name_index);
        dataOutputStream.writeShort(this.access_flags);
    }

    public MethodParameter copy() {
        try {
            return (MethodParameter)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

