/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ConstantUtf8
extends Constant {
    private final String bytes;
    private static volatile int considered = 0;
    private static volatile int hits = 0;
    private static volatile int skipped = 0;
    private static volatile int created = 0;
    private static final int MAX_CACHED_SIZE = 200;
    private static final boolean BCEL_STATISTICS = false;

    static void printStats() {
        System.err.println("Cache hit " + hits + "/" + considered + ", " + skipped + " skipped");
        System.err.println("Total of " + created + " ConstantUtf8 objects created");
    }

    static void clearStats() {
        created = 0;
        skipped = 0;
        considered = 0;
        hits = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConstantUtf8 getCachedInstance(String string) {
        if (string.length() > 200) {
            ++skipped;
            return new ConstantUtf8(string);
        }
        ++considered;
        Class<ConstantUtf8> clazz = ConstantUtf8.class;
        synchronized (ConstantUtf8.class) {
            ConstantUtf8 constantUtf8 = (ConstantUtf8)CACHE_HOLDER.CACHE.get(string);
            if (constantUtf8 != null) {
                ++hits;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return constantUtf8;
            }
            constantUtf8 = new ConstantUtf8(string);
            CACHE_HOLDER.CACHE.put(string, constantUtf8);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return constantUtf8;
        }
    }

    public static ConstantUtf8 getInstance(String string) {
        return new ConstantUtf8(string);
    }

    public static ConstantUtf8 getInstance(DataInput dataInput) throws IOException {
        return ConstantUtf8.getInstance(dataInput.readUTF());
    }

    public ConstantUtf8(ConstantUtf8 constantUtf8) {
        this(constantUtf8.getBytes());
    }

    ConstantUtf8(DataInput dataInput) throws IOException {
        super((byte)1);
        this.bytes = dataInput.readUTF();
        ++created;
    }

    public ConstantUtf8(String string) {
        super((byte)1);
        if (string == null) {
            throw new IllegalArgumentException("bytes must not be null!");
        }
        this.bytes = string;
        ++created;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitConstantUtf8(this);
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(super.getTag());
        dataOutputStream.writeUTF(this.bytes);
    }

    public final String getBytes() {
        return this.bytes;
    }

    @Deprecated
    public final void setBytes(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final String toString() {
        return super.toString() + "(\"" + Utility.replace(this.bytes, "\n", "\\n") + "\")";
    }

    private static class CACHE_HOLDER {
        private static final int MAX_CACHE_ENTRIES = 20000;
        private static final int INITIAL_CACHE_CAPACITY = 26666;
        private static final HashMap<String, ConstantUtf8> CACHE = new LinkedHashMap<String, ConstantUtf8>(26666, 0.75f, true){
            private static final long serialVersionUID = -8506975356158971766L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, ConstantUtf8> entry) {
                return this.size() > 20000;
            }
        };

        private CACHE_HOLDER() {
        }
    }
}

