/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantObject;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantLong
extends Constant
implements ConstantObject {
    private long bytes;

    public ConstantLong(long l) {
        super((byte)5);
        this.bytes = l;
    }

    public ConstantLong(ConstantLong constantLong) {
        this(constantLong.getBytes());
    }

    ConstantLong(DataInput dataInput) throws IOException {
        this(dataInput.readLong());
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitConstantLong(this);
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(super.getTag());
        dataOutputStream.writeLong(this.bytes);
    }

    public final long getBytes() {
        return this.bytes;
    }

    public final void setBytes(long l) {
        this.bytes = l;
    }

    @Override
    public final String toString() {
        return super.toString() + "(bytes = " + this.bytes + ")";
    }

    @Override
    public Object getConstantValue(ConstantPool constantPool) {
        return this.bytes;
    }
}

