/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.org.jvnet.fastinfoset.sax.helpers;

import com.sun.xml.internal.fastinfoset.CommonResourceBundle;
import com.sun.xml.internal.fastinfoset.algorithm.BuiltInEncodingAlgorithmFactory;
import com.sun.xml.internal.org.jvnet.fastinfoset.EncodingAlgorithm;
import com.sun.xml.internal.org.jvnet.fastinfoset.EncodingAlgorithmException;
import com.sun.xml.internal.org.jvnet.fastinfoset.FastInfosetException;
import com.sun.xml.internal.org.jvnet.fastinfoset.sax.EncodingAlgorithmAttributes;
import java.io.IOException;
import java.util.Map;
import org.xml.sax.Attributes;

public class EncodingAlgorithmAttributesImpl
implements EncodingAlgorithmAttributes {
    private static final int DEFAULT_CAPACITY = 8;
    private static final int URI_OFFSET = 0;
    private static final int LOCALNAME_OFFSET = 1;
    private static final int QNAME_OFFSET = 2;
    private static final int TYPE_OFFSET = 3;
    private static final int VALUE_OFFSET = 4;
    private static final int ALGORITHMURI_OFFSET = 5;
    private static final int SIZE = 6;
    private Map _registeredEncodingAlgorithms;
    private int _length;
    private String[] _data = new String[48];
    private int[] _algorithmIds = new int[8];
    private Object[] _algorithmData = new Object[8];
    private String[] _alphabets = new String[8];
    private boolean[] _toIndex = new boolean[8];

    public EncodingAlgorithmAttributesImpl() {
        this(null, null);
    }

    public EncodingAlgorithmAttributesImpl(Attributes attributes) {
        this(null, attributes);
    }

    public EncodingAlgorithmAttributesImpl(Map map, Attributes attributes) {
        this._registeredEncodingAlgorithms = map;
        if (attributes != null) {
            if (attributes instanceof EncodingAlgorithmAttributes) {
                this.setAttributes((EncodingAlgorithmAttributes)attributes);
            } else {
                this.setAttributes(attributes);
            }
        }
    }

    public final void clear() {
        for (int i = 0; i < this._length; ++i) {
            this._data[i * 6 + 4] = null;
            this._algorithmData[i] = null;
        }
        this._length = 0;
    }

    public void addAttribute(String string, String string2, String string3, String string4, String string5) {
        if (this._length >= this._algorithmData.length) {
            this.resize();
        }
        int n = this._length * 6;
        this._data[n++] = this.replaceNull(string);
        this._data[n++] = this.replaceNull(string2);
        this._data[n++] = this.replaceNull(string3);
        this._data[n++] = this.replaceNull(string4);
        this._data[n++] = this.replaceNull(string5);
        this._toIndex[this._length] = false;
        this._alphabets[this._length] = null;
        ++this._length;
    }

    public void addAttribute(String string, String string2, String string3, String string4, String string5, boolean bl, String string6) {
        if (this._length >= this._algorithmData.length) {
            this.resize();
        }
        int n = this._length * 6;
        this._data[n++] = this.replaceNull(string);
        this._data[n++] = this.replaceNull(string2);
        this._data[n++] = this.replaceNull(string3);
        this._data[n++] = this.replaceNull(string4);
        this._data[n++] = this.replaceNull(string5);
        this._toIndex[this._length] = bl;
        this._alphabets[this._length] = string6;
        ++this._length;
    }

    public void addAttributeWithBuiltInAlgorithmData(String string, String string2, String string3, int n, Object object) {
        if (this._length >= this._algorithmData.length) {
            this.resize();
        }
        int n2 = this._length * 6;
        this._data[n2++] = this.replaceNull(string);
        this._data[n2++] = this.replaceNull(string2);
        this._data[n2++] = this.replaceNull(string3);
        this._data[n2++] = "CDATA";
        this._data[n2++] = "";
        this._data[n2++] = null;
        this._algorithmIds[this._length] = n;
        this._algorithmData[this._length] = object;
        this._toIndex[this._length] = false;
        this._alphabets[this._length] = null;
        ++this._length;
    }

    public void addAttributeWithAlgorithmData(String string, String string2, String string3, String string4, int n, Object object) {
        if (this._length >= this._algorithmData.length) {
            this.resize();
        }
        int n2 = this._length * 6;
        this._data[n2++] = this.replaceNull(string);
        this._data[n2++] = this.replaceNull(string2);
        this._data[n2++] = this.replaceNull(string3);
        this._data[n2++] = "CDATA";
        this._data[n2++] = "";
        this._data[n2++] = string4;
        this._algorithmIds[this._length] = n;
        this._algorithmData[this._length] = object;
        this._toIndex[this._length] = false;
        this._alphabets[this._length] = null;
        ++this._length;
    }

    public void replaceWithAttributeAlgorithmData(int n, String string, int n2, Object object) {
        if (n < 0 || n >= this._length) {
            return;
        }
        int n3 = n * 6;
        this._data[n3 + 4] = null;
        this._data[n3 + 5] = string;
        this._algorithmIds[n] = n2;
        this._algorithmData[n] = object;
        this._toIndex[n] = false;
        this._alphabets[n] = null;
    }

    public void setAttributes(Attributes attributes) {
        this._length = attributes.getLength();
        if (this._length > 0) {
            if (this._length >= this._algorithmData.length) {
                this.resizeNoCopy();
            }
            int n = 0;
            for (int i = 0; i < this._length; ++i) {
                this._data[n++] = attributes.getURI(i);
                this._data[n++] = attributes.getLocalName(i);
                this._data[n++] = attributes.getQName(i);
                this._data[n++] = attributes.getType(i);
                this._data[n++] = attributes.getValue(i);
                ++n;
                this._toIndex[i] = false;
                this._alphabets[i] = null;
            }
        }
    }

    public void setAttributes(EncodingAlgorithmAttributes encodingAlgorithmAttributes) {
        this._length = encodingAlgorithmAttributes.getLength();
        if (this._length > 0) {
            if (this._length >= this._algorithmData.length) {
                this.resizeNoCopy();
            }
            int n = 0;
            for (int i = 0; i < this._length; ++i) {
                this._data[n++] = encodingAlgorithmAttributes.getURI(i);
                this._data[n++] = encodingAlgorithmAttributes.getLocalName(i);
                this._data[n++] = encodingAlgorithmAttributes.getQName(i);
                this._data[n++] = encodingAlgorithmAttributes.getType(i);
                this._data[n++] = encodingAlgorithmAttributes.getValue(i);
                this._data[n++] = encodingAlgorithmAttributes.getAlgorithmURI(i);
                this._algorithmIds[i] = encodingAlgorithmAttributes.getAlgorithmIndex(i);
                this._algorithmData[i] = encodingAlgorithmAttributes.getAlgorithmData(i);
                this._toIndex[i] = false;
                this._alphabets[i] = null;
            }
        }
    }

    @Override
    public final int getLength() {
        return this._length;
    }

    @Override
    public final String getLocalName(int n) {
        if (n >= 0 && n < this._length) {
            return this._data[n * 6 + 1];
        }
        return null;
    }

    @Override
    public final String getQName(int n) {
        if (n >= 0 && n < this._length) {
            return this._data[n * 6 + 2];
        }
        return null;
    }

    @Override
    public final String getType(int n) {
        if (n >= 0 && n < this._length) {
            return this._data[n * 6 + 3];
        }
        return null;
    }

    @Override
    public final String getURI(int n) {
        if (n >= 0 && n < this._length) {
            return this._data[n * 6 + 0];
        }
        return null;
    }

    @Override
    public final String getValue(int n) {
        if (n >= 0 && n < this._length) {
            String string = this._data[n * 6 + 4];
            if (string != null) {
                return string;
            }
        } else {
            return null;
        }
        if (this._algorithmData[n] == null || this._registeredEncodingAlgorithms == null) {
            return null;
        }
        try {
            String string = this.convertEncodingAlgorithmDataToString(this._algorithmIds[n], this._data[n * 6 + 5], this._algorithmData[n]).toString();
            this._data[n * 6 + 4] = string;
            return string;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (FastInfosetException fastInfosetException) {
            return null;
        }
    }

    @Override
    public final int getIndex(String string) {
        for (int i = 0; i < this._length; ++i) {
            if (!string.equals(this._data[i * 6 + 2])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final String getType(String string) {
        int n = this.getIndex(string);
        if (n >= 0) {
            return this._data[n * 6 + 3];
        }
        return null;
    }

    @Override
    public final String getValue(String string) {
        int n = this.getIndex(string);
        if (n >= 0) {
            return this.getValue(n);
        }
        return null;
    }

    @Override
    public final int getIndex(String string, String string2) {
        for (int i = 0; i < this._length; ++i) {
            if (!string2.equals(this._data[i * 6 + 1]) || !string.equals(this._data[i * 6 + 0])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final String getType(String string, String string2) {
        int n = this.getIndex(string, string2);
        if (n >= 0) {
            return this._data[n * 6 + 3];
        }
        return null;
    }

    @Override
    public final String getValue(String string, String string2) {
        int n = this.getIndex(string, string2);
        if (n >= 0) {
            return this.getValue(n);
        }
        return null;
    }

    @Override
    public final String getAlgorithmURI(int n) {
        if (n >= 0 && n < this._length) {
            return this._data[n * 6 + 5];
        }
        return null;
    }

    @Override
    public final int getAlgorithmIndex(int n) {
        if (n >= 0 && n < this._length) {
            return this._algorithmIds[n];
        }
        return -1;
    }

    @Override
    public final Object getAlgorithmData(int n) {
        if (n >= 0 && n < this._length) {
            return this._algorithmData[n];
        }
        return null;
    }

    @Override
    public final String getAlpababet(int n) {
        if (n >= 0 && n < this._length) {
            return this._alphabets[n];
        }
        return null;
    }

    @Override
    public final boolean getToIndex(int n) {
        if (n >= 0 && n < this._length) {
            return this._toIndex[n];
        }
        return false;
    }

    private final String replaceNull(String string) {
        return string != null ? string : "";
    }

    private final void resizeNoCopy() {
        int n = this._length * 3 / 2 + 1;
        this._data = new String[n * 6];
        this._algorithmIds = new int[n];
        this._algorithmData = new Object[n];
    }

    private final void resize() {
        int n = this._length * 3 / 2 + 1;
        String[] stringArray = new String[n * 6];
        int[] nArray = new int[n];
        Object[] objectArray = new Object[n];
        String[] stringArray2 = new String[n];
        boolean[] blArray = new boolean[n];
        System.arraycopy(this._data, 0, stringArray, 0, this._length * 6);
        System.arraycopy(this._algorithmIds, 0, nArray, 0, this._length);
        System.arraycopy(this._algorithmData, 0, objectArray, 0, this._length);
        System.arraycopy(this._alphabets, 0, stringArray2, 0, this._length);
        System.arraycopy(this._toIndex, 0, blArray, 0, this._length);
        this._data = stringArray;
        this._algorithmIds = nArray;
        this._algorithmData = objectArray;
        this._alphabets = stringArray2;
        this._toIndex = blArray;
    }

    private final StringBuffer convertEncodingAlgorithmDataToString(int n, String string, Object object) throws FastInfosetException, IOException {
        EncodingAlgorithm encodingAlgorithm = null;
        if (n < 9) {
            encodingAlgorithm = BuiltInEncodingAlgorithmFactory.getAlgorithm(n);
        } else {
            if (n == 9) {
                throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.CDATAAlgorithmNotSupported"));
            }
            if (n >= 32) {
                if (string == null) {
                    throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.URINotPresent") + n);
                }
                encodingAlgorithm = (EncodingAlgorithm)this._registeredEncodingAlgorithms.get(string);
                if (encodingAlgorithm == null) {
                    throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.algorithmNotRegistered") + string);
                }
            } else {
                throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.identifiers10to31Reserved"));
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        encodingAlgorithm.convertToCharacters(object, stringBuffer);
        return stringBuffer;
    }
}

