package websocketRPC.log;

import app.DBInit;
import config.CacheConfig;
import jun.db.core.DataStore;
import jun.db.impl.DataStoreFactory;
import util.DBF;
import util.DateTool;
import util.FF;
import webApp.App;

import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;


public class RPCLogPool
{


    public static volatile boolean needSave = false;
    public static volatile String table = "";
    public static volatile String dbpool = "";

    static Thread saveThread;
    static ConcurrentLinkedQueue<RPCLog> logCache = new ConcurrentLinkedQueue<RPCLog>();

    public static DataStore ds = null;
    private static volatile boolean exitSave = false;

    public static void stop()
    {
        exitSave = true;
    }

    public static void push(RPCLog msg)
    {
        if (needSave)
        {
            if( logCache.size()>10000) return; //防止爆了
            logCache.add(msg);
        }

    }


    public static void init()
    {

        //如果服务不需要连接池，那么也不能记录入日志
         if( ! App.getInstance().instanceProxy.needDBPool())
         {
             needSave=false;  //也不要记日志，  不然，缓冲池就要爆了
             return;
         }

        needSave = CacheConfig.get("/日志/系统日志/needsave", false);
        dbpool = CacheConfig.get("/日志/系统日志/dbpool", "");
        table = CacheConfig.get("/日志/系统日志/table", "app_syslog");
        FF.log(App.appName + " 调取系统日志策略：needSave:" + needSave + "  dbpool:" + dbpool + " table:" + table);

        if (  needSave)
        {
            save(ds);
            stop();
            FF.delay(10 * 1000);//10秒后， 日志表应该建好了， 因为自已所在的服务可能不负责建表，只在config服务中建表，，


            initParam(needSave, dbpool, table);

            start();
        }else {
            save(ds);
            stop();
        }

    }


    public static void initTable(boolean needSave, String dbpool, String table)
    {

        //不需要每个服务都来建表， 只需要一个就好了

        if (!App.appName.equals("config")) return;
        DBF dbf = DBF.getInstance();
        Connection con = null;
        try
        {

            if (needSave)
            {
                con = dbf.getConnection(dbpool);
                String path = App.AppRoot + "/config/db/table";
                if (!FF.tableExists(con, table))
                {

                    DBInit.InitTable(con, path, table, "app_syslog.sql", null, null, false);

                }
            }
        } catch (Exception e)
        {

        } finally
        {
            dbf.releaseConnection(con);
        }

    }


    public static void initParam(boolean needSave, String dbpool, String table)
    {
        RPCLogPool.needSave = needSave;
        RPCLogPool.dbpool = dbpool;
        RPCLogPool.table = table;

        initDataStore();
    }

    private static void initDataStore()
    {

        if (!needSave) return;


        DBF dbf = DBF.getInstance();
        Connection con = null;
        try
        {

            con = dbf.getConnection(dbpool);
            if (con == null)
            {
                FF.log(dbpool + " 无法连接，RPC日志无法保存");
            }
            else
            {
                ds = DataStoreFactory.newDataStore(con, "select * from " + table);
                ds.setUpdateProperty(table, "id", "*", "id");
            }
        } catch (Exception e)
        {
            FF.log(FF.exceptionMessage(e));
        } finally
        {
            dbf.releaseConnection(con);


        }

    }

    public static void save(DataStore ds)
    {

        if (!needSave) return;
        if (table.isEmpty()) return;

        DBF dbf = DBF.getInstance();
        Connection con = null;

        try
        {

            con = dbf.getConnection(dbpool);
            if (con == null) return;
            ds.setConnection(con);
            ds.update(true);
            ds.reset();
        } catch (Exception e)
        {
            FF.log(FF.exceptionMessage(e));
        } finally
        {
            dbf.releaseConnection(con);

        }

    }

    public static void start()
    {
        exitSave = false;

        saveThread = new Thread()
        {


            @Override
            public void run()
            {

                long lastUpdateTime = System.currentTimeMillis();

                while (true)
                {

                    /*为什么不用LinkedBlockingQueue
                        由于LinkedBlockingQueue   ，take方法在队列空的时候会阻塞，直到有队列成员被放进来。
                        所以当没有消息时，它一直阻塞，就无法中断它，当然解决办法也是有的，发送一个特定内容的消息
                        让它退出阻塞，并判断消息是不是某特定消息，是，就终止线程。
                        */
                    while (logCache.isEmpty())
                    {
                        if (exitSave) return;
                        FF.sleep(100);

                        if (!needSave || ds == null) continue;
                        long ct = System.currentTimeMillis();
                        //超过100条数据，或超过10秒钟，就保存
                        if (ds.getRowCount() == 1000 || (ct - lastUpdateTime) > 60000)
                        {
                            save(ds);

                            lastUpdateTime = System.currentTimeMillis();
                        }
                    }


                    //poll并不阻塞队列，当队列为空时，它直接返回null ,所以msg是可能为null的，所以前面要处理一下，避免没有消息时进入下面的处理
                    RPCLog log = logCache.poll();
                    //如果没有消息了，并且需要结束，那么退出吧
                    if (log == null && exitSave)
                    {
                        save(ds);
                        return;
                    }

                    if (log == null) continue;
                    if (ds == null) continue;


                    try
                    {

                        int row = ds.insertRow(ds.getRowCount());
                        ds.setValue(row, "id", DataStoreFactory.newLongID2String());
                        ds.setValue(row, "userid", log.userid);
                        ds.setValue(row, "address", log.address);
                        ds.setValue(row, "calldate", log.calldate);
                        ds.setValue(row, "clientcode", log.clientcode);
                        ds.setValue(row, "comment", log.comment);
                        ds.setValue(row, "methodname", log.methodname);
                        ds.setValue(row, "parameter", log.parameter);
                        ds.setValue(row, "username", log.username);
                        ds.setValue(row, "cost", log.cost);


                        long ct = System.currentTimeMillis();
                        //超过100条数据，或超过10秒钟，就保存
                        if (ds.getRowCount() == 1000 || (ct - lastUpdateTime) > 60000)
                        {
                            save(ds);

                            lastUpdateTime = System.currentTimeMillis();
                        }

                    } catch (Exception e)
                    {
                        FF.log("put value error: " + FF.exceptionMessage(e));
                    } finally
                    {

                    }
                }

            }


        };

        saveThread.setName("RPC-log-save-"+App.appName+"-"+ FF.get_yyyyMMdd_HHmm_FormatedDate(new Date()));
        saveThread.start();
        FF.log(" syslog  save thread start...");
    }


}
