
package websocketRPC;

import app.User;
import config.CacheConfig;
import io.zbus.rpc.RpcFilter;
import jun.db.util.TimeMark;
import org.json.JSONObject;
import org.mockito.Mockito;
import rpc.NeedRPCLog;
import util.*;
import webApp.App;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.*;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;


@ServerEndpoint(value = "/websocket/RPC", configurator = ClientInfoConfigurator.class)
public class WSRPCServer
{

    private static ConcurrentHashMap<String, Method> classMethodMap = new ConcurrentHashMap<String, Method>();
    private static ConcurrentHashMap<String, String> methodNeedLog = new ConcurrentHashMap<String, String>();


    public String id;
    //   private static final AtomicInteger connectionIds = new AtomicInteger(0);
    //   public static final Set<WSRPCServer> connections = new CopyOnWriteArraySet<>();
    //  public static final ConcurrentHashMap<String , Session>  id2sessionMap= new ConcurrentHashMap<>();

    public Session session;

    private StringBuffer msgBuffer=new StringBuffer();

    /*
    public static ObjectPool<HttpServletRequest> pool ;

    static
    {


        int maxTotal=1000;
        int maxIdle=30;
        int minIdle=5;
        int maxWaitMillis=60*1000;

        MockHttpServletRequestFactory factory = new MockHttpServletRequestFactory( );

        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(maxTotal);
        config.setMaxIdle(maxIdle);
        config.setMinIdle(minIdle);
        config.setMaxWaitMillis(maxWaitMillis);

        pool = new GenericObjectPool(factory, config);

    }
*/

    public WSRPCServer()
    {

    }


    @OnOpen
    public void onOpen(Session session)
    {
        this.session = session;
        FF.log( "id="+ session.getId()+"  "+ session.getRequestURI());

        session.addMessageHandler(new MessageHandler.Partial<String>() {
            @Override
            public void onMessage(String message, boolean isLast) {
                msgBuffer.append(message);
                if( isLast)
                {

                    onWholeMessage( msgBuffer.toString());
                    msgBuffer=new StringBuffer();

                }
            }
        });

    }


    @OnClose
    public void onClose()
    {


    }


    //@OnMessage
    public void onWholeMessage(String message)
    {
        //System.out.println("websocket收到消息:" + message);
        if( message.equals("ping"))
        {
            sendMessage("pong");
            return;
        }

        JSONObject ret= RPC(message);
        sendMessage(ret.toString());
    }


    @OnError
    public void onError(Throwable t) throws Throwable
    {
        //可以不用管，比如在网页刷新时，或关闭时，服务器推送信息过去，就出现这个问题，忽略，不用管它
        //t.printStackTrace();
        //关闭日志，不然在日志中看到一堆Error，容易认人怀疑系统稳定性。这其实是正常的
       // FF.log("server RPC  Error: " + t.toString());
        //FF.log("server RPC  Error: " +   "id="+ session.getId()+"  "+ session.getRequestURI());

       // t.printStackTrace();
    }


    public void sendMessage(String msg)
    {
        try
        {

                session.getBasicRemote().sendText(msg);

        } catch (IOException e)
        {
            FF.log(e.getMessage());


        }

    }



    private static JSONObject RPC(String content)
    {



        JSONObject p = new JSONObject(content);

        HttpServletRequest request = null;
        HttpServletResponse response = null; //Mockito.mock(HttpServletResponse.class);

        String className = p.getString("className", "");
        String methodName = p.getString("methodName", "");
        JSONObject param = p.getJSONObject("param", null);



        // 在这个属性中保存了用户的token
        String encrypedTokenid =  p.getString(FF.ENCRYPTED_TOKENID,""); //获取用户 token


        // request=pool.borrowObject();

        //实测结果 大跌眼睛，用对象池，反而速度更慢(慢很多，不理解）
        request = Mockito.mock(HttpServletRequest.class);

        //模拟返回cookie
        Mockito.when(request.getCookies( )).thenReturn(  null );
        //在FF.getClientIpAddr需要用到 getRemoteAddr ，返回IP，所以mock一下
        //ip放在 p中，参看 WSRPC. [标记20190612-1]
        Mockito.when(request.getRemoteAddr( )).thenReturn(  p.getString("${rpcRouteRemoteAddr}$","") );
        //FF.getTokenIdFromRequest中需要从 request中获取tokern， mock一下 ，参看 [标记20190612-2]
        Mockito.when( request.getHeader(FF.ENCRYPTED_TOKENID)).thenReturn(  encrypedTokenid );

        JSONObject ret= RPC(className , methodName, param, request, response);
        //标记要回写回去
        ret.put(WSRPC.KEY_WebsocketRPCSequenceNo, p.getString(WSRPC.KEY_WebsocketRPCSequenceNo,""));

        return ret;

    }


    public static JSONObject RPC(String className , String methodName , JSONObject param , HttpServletRequest request ,HttpServletResponse response )
    {

        if(CacheConfig.get("/系统配置/RPC方案","HTTP").equals("HTTP"))
        {
            //FF.log("local call  with http "+ className+"."+ methodName);
            return RPCRouter.RPC(request, response, "", className, methodName, param);
        }



        TimeStamp tm = new TimeStamp(false);
        JSONObject ret = null;
        long d1 = System.currentTimeMillis();

        RPCBase rpc=null;
        try
        {
              rpc =  RPCBase.newInstance(className);
            tm.stamp("RPCRouter  forName 创建类实例 "+ className);


            //至此，request中包含了用户的Token信息，用来模拟用户登录

            rpc.init(request, response);

            String methodFullName = className + "." + methodName;


            String err = ((RPCBase) rpc).rightVerify(methodFullName, param);
            if (!err.isEmpty()) throw new Exception(err);

            Method m = classMethodMap.get(methodFullName);
            tm.stamp("RPCRouter  get Method  " + methodFullName);

            if (m == null)
            {
                Class c = rpc.getClass();
                m = c.getMethod(methodName, new Class[]{JSONObject.class});
                classMethodMap.put(methodFullName, m);

                for (Annotation annotation : m.getDeclaredAnnotations())
                {
                    if (annotation instanceof NeedRPCLog)
                    {
                        methodNeedLog.put(methodFullName, ((NeedRPCLog) annotation).comment());
                        break;
                    }
                }
                tm.stamp("RPCRouter  扫描注解 ");
            }

            //2020.11.01 增加执行剪注入
            if( RPCInject.injectAble(App.appName , className, methodName,"before" ))
            {
                ret= RPCInject.beforeRPC(App.appName , className, methodName,param , request, response);
                if(ret!=null)
                {
                    if( ! ret.getBoolean("success",false))
                    {
                        tm.stamp( methodFullName+ "执行前注入脚本返回:"+ ret.toString()+"  执行终止");
                        return ret;
                    }
                }
            }

            ret = (JSONObject) m.invoke(rpc, new Object[]{param});

            tm.stamp("RPCRouter  执行调用完成  ");

            if (ret == null)
            {
                ret = new JSONObject().put("success", true).put("message", "");
            }

            //如果有NeedRPCLog注解在方法上，那么才记录日志 ，避免日志过多



            if( RPCInject.injectAble(App.appName , className, methodName,"after" ))
            {
                RPCInject.afterRPC(App.appName , className, methodName, param  );
            }

            tm.stamp("RPCRouter  记录日志 ，全部完成 ");
            //如果有NeedRPCLog注解在方法上，那么才记录日志 ，避免日志过多
            if (methodNeedLog.containsKey(methodFullName))
            {
                RPCRouter.RpcCallLog(request, methodFullName, param, methodNeedLog.get(methodFullName) ,tm.getCost());
            }


        } catch (Exception e)
        {
            FF.log(e.getMessage());
            ret = new JSONObject().put("success", false).put("message", e.getClass().getName() + ":" + e.getMessage());

        } finally
        {


            RPCClassBuilder.returnObject(rpc); //回归对象池，回归前会放弃对 rquest, response的引用
            long d2 = System.currentTimeMillis();
            ret.put("rpcCallCost", d2 - d1);

            //@off
         //   if( request!=null) try{ pool.returnObject(request); }catch(Exception e){}
            //@on
        }

        return ret;
    }



}
