package websocketRPC;

import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;

import java.net.URI;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class WSRPCClientFactory implements PooledObjectFactory<WSRPCClient>
{

    private URI endpointURI;
    private String producerGroupName;
    private  int c=0;

    private static AtomicInteger seqNumGenerator = new AtomicInteger(0);

    public WSRPCClientFactory(URI endpointURI )
    {
        this.endpointURI= endpointURI ;

    }

    @Override
    public PooledObject<WSRPCClient> makeObject()
    {
        try
        {
                //2021.10.26增加序号，标记远程调用 客户端标识
            int no = seqNumGenerator.getAndAdd(1);
            WSRPCClient client= new WSRPCClient(endpointURI , no );


            if (client.start())  return new DefaultPooledObject(client);
        }catch(Exception e)
        {

        }
        return null;

    }


    @Override
    public void destroyObject(PooledObject<WSRPCClient> pooledObject) throws Exception
    {
        pooledObject.getObject().close();
    }

    @Override
    public boolean validateObject(PooledObject<WSRPCClient> pooledObject)
    {
        return true;
    }

    @Override
    public void activateObject(PooledObject<WSRPCClient> pooledObject) throws Exception
    {
        //System.out.println("  "+ pooledObject.getObject().getInstanceName()+" 被激活");
    }

    @Override
    public void passivateObject(PooledObject<WSRPCClient> pooledObject) throws Exception
    {
       // System.out.println("  "+ pooledObject.getObject().getInstanceName()+" 休息去了");
    }
}
