package websocketRPC;

import config.CacheConfig;
import jun.db.impl.DataStoreFactory;
import org.json.JSONObject;
import util.BuildParamFromRequest;
import util.DelayRun;
import util.FF;
import webApp.App;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.concurrent.ConcurrentLinkedQueue;

public class RPCInject
{

    private static String  KEY_SCRIPTCODE="$scriptcode$741211";
    private static ConcurrentLinkedQueue<JSONObject>  queue = new ConcurrentLinkedQueue<JSONObject>();

    static Thread runThread;
    private static volatile boolean exitRun = false;

    public static void stop()
    {
        exitRun = true;
    }

    public static void start()
    {


        runThread = new Thread()
        {


            @Override
            public void run()
            {

                long lastUpdateTime = System.currentTimeMillis();

                while (true)
                {

                    /*为什么不用LinkedBlockingQueue
                        由于LinkedBlockingQueue   ，take方法在队列空的时候会阻塞，直到有队列成员被放进来。
                        所以当没有消息时，它一直阻塞，就无法中断它，当然解决办法也是有的，发送一个特定内容的消息
                        让它退出阻塞，并判断消息是不是某特定消息，是，就终止线程。
                        */
                    while (queue.isEmpty())
                    {
                        if (exitRun) return;
                        try
                        {
                            Thread.sleep(100);
                        } catch (Exception e)
                        {
                        }
                    }


                    //poll并不阻塞队列，当队列为空时，它直接返回null ,所以msg是可能为null的，所以前面要处理一下，避免没有消息时进入下面的处理
                    JSONObject  kv = queue.poll();
                    //如果没有消息了，并且需要结束，那么退出吧
                    if (kv == null && exitRun)
                    {
                        return;
                    }

                    if (kv == null) continue;

                    try
                    {
                        String scriptCode= kv.getString(KEY_SCRIPTCODE,"");
                        kv.remove(KEY_SCRIPTCODE);
                        FF.runScript(scriptCode, kv  );

                    } catch (Exception e)
                    {
                        FF.log("put value error: " + FF.exceptionMessage(e));
                    }
                }

            }


        };

        runThread.setName(App.appName +"-websocketRPC-run");
        runThread.start();
        FF.log("  RPCInject  run  thread start...");
    }

    public static boolean  injectAble (String  service , String className ,String method ,String when)
    {
        if( ! CacheConfig.apiInjectEnable) return false;
        String key=service+"."+className+"."+method+"."+when;
        if(  CacheConfig.apiInjectConfig.containsKey(key)) return true;
        if(  CacheConfig.apiInjectConfig.containsKey("*.*.*."+when)) return true;
        return false;
    }

    public static JSONObject beforeRPC(String  service , String className ,String method ,JSONObject param, HttpServletRequest request , HttpServletResponse response)
    {

        String key= service+"."+className+"."+method+".before";
        String script= CacheConfig.apiInjectConfig.get(key);
        if( script==null) return null;


        JSONObject ret= new JSONObject();
        ret.put("success",true);
        ret.put("message","");

        JSONObject p= new JSONObject();
        p.put("service",service);
        p.put("method" , className+"."+method);
        p.put("param", param);


        try
        {
            //先将url参数放入
            JSONObject reqParam = BuildParamFromRequest.buildParam(request, response);
            p.put("request", reqParam);


            Object v = FF.runScript(script, p, request, response); //如果脚本返回的是JSON对象，已经转换成String了

            if( v==null) return null;
            if( v.toString().equals("null")) return null;
            ret= new JSONObject( v.toString());   //如果脚本返回的是JSON对象，已经转换成String了
        }catch(Exception e)
        {
            ret.put("success",false);
            ret.put("message", FF.exceptionMessage(e));
        }

        return ret;
    }


    public static void afterRPC( String  service , String className ,String method ,JSONObject param )
    {

        String key= service+"."+className+"."+method+".after";
        String script= CacheConfig.apiInjectConfig.get(key);
        if( script==null) return  ;

        JSONObject p= new JSONObject();
        p.put("service",service);
        p.put("method" , className+"."+method);
        p.put("param", param);
        p.put(KEY_SCRIPTCODE ,script);

        queue.add(p);


    }

}
