package websocketRPC;

import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.mockito.Mockito;
import util.FF;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MockHttpServletRequestFactory implements PooledObjectFactory<HttpServletRequest>
{
    @Override
    public PooledObject<HttpServletRequest> makeObject() throws Exception
    {
        HttpServletRequest request = Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = null; //Mockito.mock(HttpServletResponse.class);
        //模拟返回cookie
        Mockito.when(request.getCookies( )).thenReturn(  null );

         return  new DefaultPooledObject(request);

    }

    @Override
    public void destroyObject(PooledObject<HttpServletRequest> pooledObject) throws Exception
    {

    }

    @Override
    public boolean validateObject(PooledObject<HttpServletRequest> pooledObject)
    {
        return false;
    }

    @Override
    public void activateObject(PooledObject<HttpServletRequest> pooledObject) throws Exception
    {

    }

    @Override
    public void passivateObject(PooledObject<HttpServletRequest> pooledObject) throws Exception
    {

    }
}
