package websocketRPC;

import app.User;
import util.FF;

import javax.servlet.http.HttpServletRequest;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import java.lang.reflect.Field;

public class ClientInfoConfigurator extends ServerEndpointConfig.Configurator
{
    @Override
    public void modifyHandshake(ServerEndpointConfig config,
                                HandshakeRequest request,
                                HandshakeResponse response)
    {
        try
        {
            //这个 request 中有一个私有的名为 request的成员， 是HttpServletRequest;现在用非常规方式取出来，从中取用户信息
            Field field = request.getClass().getDeclaredField("request");
            field.setAccessible(true);
            HttpServletRequest req = (HttpServletRequest) field.get(request);

            config.getUserProperties().put("id", FF.getStringFromRequest(req ,"id",""));
            config.getUserProperties().put("clientInfo", FF.getStringFromRequest(req ,"clientInfo",""));


        } catch (Exception e)
        {

        }
    }
}