
package websocket;

import org.json.JSONArray;
import org.json.JSONObject;
import util.AppCache;
import util.FF;
import util.RPCRouter;
import websocketRPC.RPCContext;
import websocketRPC.WSRPC;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;


//用  test2模块中的 PureWebSocketClient来做压力测试
/*
*   nginx 中   worker_processes  auto;   可改成与CPU核心数一样
*
*
*
* */


@ServerEndpoint(value = "/websocket/chat", configurator = GetUserInfoConfigurator.class)
public class PushServer
{

    public static int M10=1024*1024*10;
    private static final AtomicLong connectionIds = new AtomicLong(0);
    public static final Set<PushServer> connections = new CopyOnWriteArraySet<>();

    public static final String  CS_TOPIC_FILESERVICE = "文件同步服务";

    static AtomicLong seqNumGenerator = new AtomicLong(1);
    static ConcurrentHashMap<Long, RPCContext> no2ctx = new ConcurrentHashMap<>();

    public static String PONG = "";

    public Session session;
    public int userId;
    public String userName;
    public String userShowName;
    public String lastLoginClientCode;
    public String portraitLastUpdate ; // 头像最后更新时间
    public String clientIP = "";
    public String clientComputerName= "";
    public String clientPort="";//客户端打印助手的端口
    public boolean isPrintAgent=false;
    public String topic = "";//关心什么主题
    public Date when;  //什么时候连接上的
    public long connectionID;


    public PushServer()
    {

    }

    public static int userCount()
    {

        HashMap<Integer, Integer> map = new HashMap();
        for (PushServer client : connections)
        {
            if( client.userId<0) continue;
            map.put(client.userId, 1);
        }
        return map.size();

    }


    public static JSONArray onLineUserInfo ()
    {
        HashMap<String, Integer> map = new HashMap();
        JSONArray ret= new JSONArray();
        for (PushServer client : connections)
        {
            if( client.userId<0) continue;
            if( map.containsKey( client.userId +"@"+ client.clientIP)) continue;
            JSONObject one= new JSONObject();
            one.put("id" , client.userId);
            one.put("name" , client.userName);
            one.put("showName" , client.userShowName);
            one.put("lastLoginClientCode", client.lastLoginClientCode);
            one.put("portraitLastUpdate" , client.portraitLastUpdate);
            one.put("ip" , client.clientIP);
            String t=AppCache.getCache("lastActiveDate:"+ client.userId,"");
            t= t.substring(0,4)+"-"+ t.substring(4,6)+"-"+ t.substring(6,8)+" "+ t.substring(8,10)+":"+t.substring( 10,12)+":"+t.substring(12,14);
            one.put("lastActiveTime" , t);

            map.put(client.userId+"@"+ client.clientIP, 1);
            ret.put( one);
        }
        return  ret;

    }

    public static long getNextSequentNumber()
    {
        return seqNumGenerator.getAndAdd(1);
    }

    public static int connectionCount()
    {
        return connections.size();
    }

    @OnOpen
    public void onOpen(Session session)
    {

        //本服务接受两类客户端的连接， 1.应用助手， 2.浏览器中的websocket连接
        // 对于应用助手，它通过客户机器名称来标识， 对浏览器中的连接，通过登录用户信息来识别

        //应用助手建立的连接， 缓冲区设置成10M ，其它使用默认的 8K
        if( session.getUserProperties().containsKey("printAgent"))
        {
            if ((boolean) session.getUserProperties().get("printAgent") == true)
            {
                session.setMaxTextMessageBufferSize(M10);
                session.setMaxBinaryMessageBufferSize(M10);
                isPrintAgent = true; //表示本连接是应用助手连上来的
            }
        }

        this.session = session;
        connections.add(this);
        this.clientComputerName = (String)session.getUserProperties().get("myName");// 应用助手连接时传的参数
        this.connectionID= connectionIds.incrementAndGet();
        this.userId = ((Integer) session.getUserProperties().get("currentUserId")).intValue();
        this.userName = ((String) session.getUserProperties().get("currentUserName"));
        this.userShowName = ((String) session.getUserProperties().get("currentUserShowName"));
        this.lastLoginClientCode=((String) session.getUserProperties().get("lastloginclientcode"));
        this.portraitLastUpdate =((String) session.getUserProperties().get("portraitLastUpdate"));
        this.clientIP = ((String) session.getUserProperties().get("clientIP"));
        this.clientPort = ((String) session.getUserProperties().get("clientPort"));

        this.when = new Date();
        // 不要在本类中用 FF.log ，具体原因不想查了， 结果是，可能前端会收到这些信息并显示，只要订阅了任意主题
//        FF.log( " im  on open "+ this.userName +"   No:"+ this.connectionID);
    }


    @OnClose
    public void onClose()
    {
 //       FF.log(" im   on close" + this.userName +" No:"+ this.connectionID);
        connections.remove(this);
    }


    @OnMessage
    public void onMessage(String message)
    {
        //FF.log("websocket收到消息:" + message);
        try
        {
            JSONObject js = new JSONObject(message);
            if (js != null)
            {
                String action = js.getString("action", "");
                if (action.equals("setTopic"))
                {
                    this.topic = "," + js.getString("topic", "") + ",";
                }

                //客户端的ping
                if (action.equals("ping"))
                {

                    sendMessage(this.userId, "pong", "pong");
                }

                //消息发送给目标方，有两种，一种是前台输入信息，发送给目标人，此时
                // 是通过  websocket通信的， 当前就是这种，基本不用，
                // 还有一种是通过后台直接api调用往目标用户推送消息，不在此处理
                if (action.equals("sendMessage"))
                {
                    int toUserId = js.getInt("userid", 0);
                    String topic = js.getString("topic", "");
                    String msg = js.getString("message", "");
                    JSONObject backMSG = new JSONObject();
                    backMSG.put("message", msg);
                    backMSG.put("fromUserId", this.userId);
                    backMSG.put("toUserId" , toUserId);
                //    backMSG.put("senderName", this.userName);
                 //   backMSG.put("senderShowName", this.userShowName);

                    sendMessage(toUserId, topic, backMSG.toString());
                }

                //如果是RPC返回，那么释放锁，并且返回结果
                long no =js.getLong(WSRPC.KEY_WebsocketRPCSequenceNo, 0);
                if(no>0)
                {
                    RPCContext ctx= no2ctx.get(no);
                    if( ctx != null)
                    {
                        no2ctx.remove(no);
                        js.remove(WSRPC.KEY_WebsocketRPCSequenceNo);
                        ctx.response=js;
                        ctx.semp.release();
                    }
                }

            }
        } catch (Exception e)
        {

        }

    }


    @OnError
    public void onError(Throwable t) throws Throwable
    {
        //可以不用管，比如在网页刷新时，或关闭时，服务器推送信息过去，就出现这个问题，忽略，不用管它
        //t.printStackTrace();
        //FF.log("Chat Error: " + t.toString());
    }


    public static void broadcastMessage(String topic, String msg)
    {
        sendMessage(-1, topic, msg);
    }

    public static void sendMessage(int userid, String topic, String msg)
    {


        for (PushServer client : connections)
        {
            try
            {


                    if (userid < 0 || client.userId == userid)
                    {


                        //pong消息，无论客户端有没有订阅此主题都要发送
                        if (msg.equals("pong") || client.topic.isEmpty() || client.topic.indexOf("," + topic + ",") >= 0)
                        {
                            sendText(client.session, msg );

                        }
                    }

            } catch (Exception e)
            {
                if ( e instanceof  java.lang.IllegalStateException  ) return;

               // FF.log("Chat Error: Failed to send message to client");
                connections.remove(client);
                try
                {
                    client.session.close();
                } catch (IOException e1)
                {
                    // Ignore
                }


            }
        }
    }

    public static void sendText(Session session , String msg)
    {
        synchronized (session)
        {
            try
            {
                session.getBasicRemote().sendText(msg);
            } catch (IOException e)
            {
                session.getAsyncRemote().sendText(msg);
            }
        }

    }
    /**
     * 得到在线的打印助手名称列表
     * @return
     */
    public static JSONArray getOnlinePrintAgents(   ) {


        JSONArray ret = new JSONArray();
        for (PushServer client : connections)
        {


            if (client.topic.indexOf("," + CS_TOPIC_FILESERVICE + ",") >= 0)
            {
                JSONObject one=new JSONObject();
                one.put("name",   client.clientComputerName);
                one.put("ip" , client.clientIP);
                one.put("port" , client.clientPort);
                ret.put(one);
            }
        }
        return ret;

    }


    public static String sendMessageAndGetResponse( String computerName, String topic, String msg /*必须是一个JSON对象*/, int timeOutMilliSecond)
    {

        for (PushServer client : connections)
        {
            try
            {

                    if ( computerName.isEmpty() || computerName.equals( client.clientComputerName ) )
                    {


                        //pong消息，无论客户端有没有订阅此主题都要发送
                        if ( client.topic.isEmpty() || client.topic.indexOf("," + topic + ",") >= 0)
                        {

                            //申请一个唯一编号
                            long no =  getNextSequentNumber();
                            RPCContext ctx = new RPCContext();

                            //把编号与ctx对应起来
                            no2ctx.put(no, ctx);

                            JSONObject js = new JSONObject( msg );

                            js.put(WSRPC.KEY_WebsocketRPCSequenceNo, no);

                            boolean isTimeout=false;
                            try
                            {

                                long startTime = System.currentTimeMillis();
                                ctx.semp.acquire();//获取信号量，视为申请一个许可，申请后，许可证没有了，让标记1 处阻塞

                                sendText( client.session , js.toString());


                                //上面写数据后，client 收到数据，然后反馈 ，这个过程是异步的，
                                //因此， 此时必须阻塞起来，等client回馈。

                                //服务器处理消息后，会把no标记也带上，返回回来，这样用它来追踪客户，通知客户消息已经回馈回来了
                                // no2ctx [no]可以定位到客户的semp标记，回馈事件中，将它释放，于是下面的 tryAcquire得以解除阻塞并返回true


                                //FF.log(new Date()+" 等待回应："+no);
                                //标记1  ，阻塞，直到收回复的消息后，解除
                                if (ctx.semp.tryAcquire(timeOutMilliSecond, TimeUnit.MILLISECONDS))
                                {

                                    return ctx.response.toString();
                                }

                                isTimeout=true;
                                FF.log( "websocket  call  "+ js.toString()+" 序号:"+ computerName+":"+no +" 超时 ,耗时： " + ( System.currentTimeMillis() - startTime)+" ms \n"+
                                                "失败的调用是："+ js.toString() +"\n"+
                                                "移除： 序号:"+ no);
                                return new JSONObject().put("success", false)
                                        .put("timeout",true)  //2020.03.05 增加表明是调用超时
                                        .put("message",     "调用超时:" +js.toString()+", timeout="+ timeOutMilliSecond+" 毫秒").toString();



                            } catch (Exception e)
                            {
                                return new JSONObject().put("success", false).put("message", e.getMessage()).toString();

                            } finally
                            {


                                no2ctx.remove(no);
                            }


                        }

                }
            } catch (Exception e)
            {
                JSONObject ret= new JSONObject().put("success",false);
                ret.put("success",false);
                if ( e instanceof  java.lang.IllegalStateException  )
                {
                    ret.put("message", FF.exceptionMessage(e));
                    return ret.toString();
                }

                // FF.log("Chat Error: Failed to send message to client");
                connections.remove(client);
                try
                {
                    client.session.close();
                } catch (IOException e1)
                {
                    // Ignore
                }


            }
        }
        JSONObject ret= new JSONObject().put("success",false).put( "message", computerName+" 这个目标不存在");
        return ret.toString();
    }


    /**
     * 本函数是统一调用sso服务的PushServer
     * 因为系统各个微服务都有pushServer ,但客户端不能对每个都去连接
     * * ，因此需要在每个微服务中统一使用sso的Pusherver来发送websocket消息
     * * ，本类就是提供此用途
     *
     * @param fromUserId
     * @param toUserId
     * @param msg
     */
    public static void sendMessage(int fromUserId, int toUserId, String topic, JSONObject msg)
    {
        msg.put("fromUserId", fromUserId);
        msg.put("toUserId", toUserId);
        msg.put("topic", topic);

        try
        {
            JSONObject ret = RPCRouter.dispatch("im", "api.IM",
                                                "chat", msg, null, null, false);

        } catch (Exception e)
        {
           // FF.log("sendMessage 失败，原因是：" + e.getMessage());
        }

    }


}
