package websocket;

import app.User;
import org.json.JSONObject;
import util.FF;
import util.TimeStamp;
import websocketRPC.WSRPC;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import java.lang.reflect.Field;

public class GetUserInfoConfigurator extends ServerEndpointConfig.Configurator
{
    @Override
    public void modifyHandshake(ServerEndpointConfig config,
                                HandshakeRequest request,
                                HandshakeResponse response)
    {
        try
        {

            TimeStamp tm= new TimeStamp(true);
            tm.stamp("开始注册websocket");

            //这个 request 中有一个私有的名为 request的成员， 是HttpServletRequest;现在用非常规方式取出来，从中取用户信息
            Field field = request.getClass().getDeclaredField("request");
            field.setAccessible(true);
            HttpServletRequest req = (HttpServletRequest) field.get(request);

            User user = User.getUserFromRequest(req);

            // 当应用处于allinone 时，各个服务在一个域中，可以共享cookie ,此时可以获取到cookie中的 token ,当
            // im是独立的一个服务时，由于跨域的限制，无法获取到用户信息，
            // 所以 是通过 url中的get方式传递一个 token数据过来，这个 token不是真实的token，而是一个临时的key，需要通过它再去获取真正的token


            if (user.getId() < 0)
            {
                String guid = FF.getStringFromRequest(req, "token", "");

                JSONObject ret = WSRPC.dispatch("sso", "sso.Chat", "getTokenByKey", new JSONObject().put("guid", guid),
                                                req, null, false);

                if (ret.getBoolean("success"))
                {
                    String token = ret.getString("token", "");
                    user = User.getUserFromTokenId(token);
                }
            }
            config.getUserProperties().put("currentUserId", user.getId());
            config.getUserProperties().put("currentUserName", user.getName());
            config.getUserProperties().put("currentUserShowName", user.getShowName());
            config.getUserProperties().put("lastloginclientcode", user.lastloginclientcode);
            config.getUserProperties().put("portraitLastUpdate", user.portraitLastModifyDate);


            config.getUserProperties().put("clientIP", FF.getClientIpAddr(req));
            config.getUserProperties().put("clientPort", req.getParameter("myPort"));

            config.getUserProperties().put("myName", FF.getClientIpAddr(req));

            //可能会传递一个myName过来
            String myName =req.getParameter("myName");
            if( myName==null) myName="";
            config.getUserProperties().put("myName", myName);

            String printAgent =req.getParameter("printAgent");
           if( printAgent!=null && printAgent.equalsIgnoreCase("true"))
           {
               config.getUserProperties().put("printAgent", true);
           }else {
               config.getUserProperties().put("printAgent", false);
           }

            tm.stamp("注册websocket完成");
        } catch (Exception e)
        {

        }
    }
}