package webApp;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.SizeAndTimeBasedRollingPolicy;
import ch.qos.logback.core.util.FileSize;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.core.util.StatusPrinter;
import jun.db.impl.DataStoreFactory;
import org.json.JSONArray;
import org.slf4j.LoggerFactory;
import util.FF;

import java.io.File;
import java.io.InputStream;

public class LogBackConfigLoader
{

    public LogBackConfigLoader()
    {

    }

    public void load(String root, String appName)
    {


        ch.qos.logback.classic.Logger logger;
        String s_appender = FF.getVMProperty("APP_LOG_APPENDER", "FILE").toLowerCase();
        FF.logToFile = s_appender.indexOf("file") >= 0;
        FF.logToConsole = s_appender.indexOf("console") >= 0;



        LoggerContext context = (LoggerContext) LoggerFactory.getILoggerFactory();


        logger = context.getLogger(DataStoreFactory.newGUID() + "APP." + appName);
        logger.setAdditive(false);

        RollingFileAppender appender = new RollingFileAppender();
        appender.setContext(context);
        appender.setName("APP_" + appName);

        try
        {
            String logPath = FF.getVMProperty("APP_LOG_ROOT", App.USRHome + "/appLogs");

            appender.setFile(OptionHelper.substVars(logPath + "/" + appName + "/log.log", context));
            appender.setAppend(true);
            appender.setPrudent(false);
            SizeAndTimeBasedRollingPolicy policy = new SizeAndTimeBasedRollingPolicy();
            String fp = OptionHelper.substVars(logPath + "/" + appName + "/log.log.%d{yyyy-MM-dd}.%i", context);

            policy.setMaxFileSize(FileSize.valueOf(FF.getVMProperty("APP_LOG_SIZE", "10MB")));
            policy.setFileNamePattern(fp);
            policy.setMaxHistory(FF.String2Int(FF.getVMProperty("APP_LOG_COUNT", "20")));
            policy.setTotalSizeCap(FileSize.valueOf(FF.getVMProperty("APP_LOG_TOTAL_SIZE", "200MB")));
            policy.setParent(appender);
            policy.setContext(context);
            policy.start();

            PatternLayoutEncoder encoder = new PatternLayoutEncoder();
            encoder.setContext(context);
            encoder.setPattern("%d{yyyy-MM-dd/HH:mm:ss.SSS}|%X{localIp}|[%t] %-5level %logger{50} %line - %m%n");
            encoder.start();

            appender.setRollingPolicy(policy);
            appender.setEncoder(encoder);
            appender.start();


            if (FF.logToFile) logger.addAppender(appender);


            /*设置动态日志控制台输出*/
            ConsoleAppender consoleAppender = new ConsoleAppender();
            consoleAppender.setContext(context);
            consoleAppender.setEncoder(encoder);
            consoleAppender.start();

            if (FF.logToConsole) logger.addAppender(consoleAppender);


            StatusPrinter.printInCaseOfErrorsOrWarnings(context);
        }catch(Exception e)
        {

        }
        FF.logger = logger;

        load2_default( );

    }

    public void load2_default( )
    {

        InputStream is = this.getClass().getClassLoader().getResourceAsStream("logback.json");
        byte[] b= new byte[100*1024];
        try
        {
            int n = is.read(b);
            String s = new String(b, "UTF-8");

            JSONArray ja= new JSONArray(s);
            for( int i=0;i<ja.length();i++)
            {
                String loggerName= ja.getJSONObject(i).getString("logger","");
                String level=ja.getJSONObject(i).getString("level","");
                ch.qos.logback.classic.Logger   log=(ch.qos.logback.classic.Logger) LoggerFactory.getLogger(loggerName);
                log.setLevel(Level.toLevel(level));
                System.out.println( loggerName+"日志级别被调整为："+level);
            }

        }catch(Exception e)
        {

        }



    }

    public void load2(String root, String appName)
    {

        FF.logger = LoggerFactory.getLogger("APP." + appName);

        System.setProperty("APP_NAME", appName);

        if (FF.getVMProperty("APP_LOG_ROOT", "").isEmpty())
        {
            System.setProperty("APP_LOG_ROOT", App.USRHome + "/AppLogs");
        }

        String APP_LOG_LEVEL_FILE = FF.getVMProperty("APP_LOG_LEVEL_FILE", "INFO");
        String APP_LOG_LEVEL_CONSOLE = FF.getVMProperty("APP_LOG_LEVEL_CONSOLE", "INFO");

        //强制设置一下，在配置中需要用到这两个级别
        System.setProperty("APP_LOG_LEVEL_FILE", APP_LOG_LEVEL_FILE);
        System.setProperty("APP_LOG_LEVEL_CONSOLE", APP_LOG_LEVEL_CONSOLE);


        LoggerContext lc = (LoggerContext) LoggerFactory.getILoggerFactory();

        /*
        1. Class.getResourceAsStream(String path) ： path 不以’/'开头时默认是从此类所在的包下取资源，
            以’/'开头则是从ClassPath根下获取。其只是通过path构造一个绝对路径，
           最终还是由ClassLoader获取资源。 

        2. Class.getClassLoader.getResourceAsStream(String path) ：默认则是从ClassPath根下获取，
           path不能以’/'开头，最终是由ClassLoader获取资源。 

        3. ServletContext. getResourceAsStream(String path)：默认从WebAPP根目录下取资源，
           Tomcat下path是否以’/'开头无所谓，当然这和具体的容器实现有关。 

         */
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("logback_" + appName + ".xml");

        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext(lc);
        lc.reset();
        try
        {
            configurator.doConfigure(is);
        } catch (Exception e)
        {
            System.out.println(e.getMessage());
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings(lc);

    }

}
