package webApp;

import util.FF;

import java.io.File;
import java.io.IOException;
import java.nio.file.*;
import java.util.LinkedList;

public class FileWatch extends Thread
{

    public volatile boolean exit = false;

    public String[] filePaths;
    public Runnable callback;

    public FileWatch(String[] paths , Runnable callback)
    {
        this.filePaths = paths;
        this.callback=callback;

        this.setName( "文件变化监听-"+App.appName);
    }

    @Override
    public void run()
    {
        WatchService watchService = null;
        try
        {

            // 获取文件系统的WatchService对象
            watchService = FileSystems.getDefault().newWatchService();


            for (String filePath : filePaths)
            {
                File file = new File(filePath);
                if( !file.exists()) continue;

                Paths.get(file.getAbsolutePath()).register(watchService
                        , StandardWatchEventKinds.ENTRY_CREATE
                        , StandardWatchEventKinds.ENTRY_MODIFY
                        , StandardWatchEventKinds.ENTRY_DELETE);

               // FF.log(  file.getAbsolutePath()+"文件变化已监控");
                LinkedList<File> fList = new LinkedList<File>();
                fList.addLast(file);
                while (fList.size() > 0)
                {
                    File f = fList.removeFirst();
                    if( !f.exists()) continue;

                    File[] fs = f.listFiles();
                    if (fs == null) continue;
                    for (File file2 : fs)
                    {
                        if (file2.isDirectory())
                        {//下一级目录
                            fList.addLast(file2);
                            //依次注册子目录
                            Paths.get(file2.getAbsolutePath()).register(watchService
                                    , StandardWatchEventKinds.ENTRY_CREATE
                                    , StandardWatchEventKinds.ENTRY_MODIFY
                                    , StandardWatchEventKinds.ENTRY_DELETE);
                          //  FF.log(  file2.getAbsolutePath()+"文件变化已监控");
                        }
                    }
                }
            }


            while (!exit)
            {


                // 获取下一个文件改动事件
                WatchKey key = watchService.take();

                for (WatchEvent<?> event : key.pollEvents())
                {
                    FF.log( event.context() + " --> " + event.kind());
                    if( callback!=null) callback.run();

                    if (exit) break;

                }
                // 重设WatchKey
                boolean valid = key.reset();
                // 如果重设失败，退出监听
                if (!valid)
                {
                    break;
                }
            }

        } catch (Exception e)
        {
            FF.log(e);
            return;
        }
    }

    public static void main(String[] arg)
    {
        try
        {
            FileWatch fw= new FileWatch( new String[]{ "/Users/zengjun/aaa/apidoc"},null);

            fw.start();
            while (true)
            {

                Thread.sleep(1000);


            }
        } catch (Exception e)
        {

        }
    }


}
