package webApp;

import com.netflix.discovery.DefaultEurekaClientConfig;
import util.FF;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 当需要向Eureka注册服务时，需要知道Eureka服务在哪 ， 以及一些参数设置，
 * 本类就是提供这些参数，
 */

public class EurekaClientConfigByUDP extends DefaultEurekaClientConfig
{

    public List<String> serviceList=null;
    public EurekaClientConfigByUDP()
    {
        super();
    }

    //从环境变量中取，如果没有定义，则从配置文件中取，配置文件默认是 web-inf/classes/eureka-client.properties
    public List<String> getEurekaServerServiceUrls(String myZone)
    {

        if( serviceList!=null ) return  serviceList;

        String serviceUrls = FF.getVMProperty( "EUREKA_SERVICEURL_DEFAULT",""); //http://localhost:8080/eureka/v2")

        FF.log("环境变量 EUREKA_SERVICEURL_DEFAULT=" + serviceUrls);
        if (serviceUrls.isEmpty())
        {
            serviceUrls = "http://localhost:" + FF.getTomcatPort() + "/eureka/v2";
            FF.log("自动设置 eureka.serviceUrl.default =" + serviceUrls);

        }

        serviceList=Arrays.asList(serviceUrls.split(","));
        return serviceList;

    }


}
