package webApp; /**
 * Created by zengjun on 2017/11.25
 */

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

@WebListener()
public class AppListener implements ServletContextListener,
        HttpSessionListener, HttpSessionAttributeListener
{

    // Public constructor is required by servlet spec
    public AppListener()
    {
    }

    // -------------------------------------------------------
    // ServletContextListener implementation
    // -------------------------------------------------------
    public void contextInitialized(ServletContextEvent sce)
    {
        String subpath = sce.getServletContext().getContextPath();

        subpath=subpath.replaceAll("/","");
        if( subpath.isEmpty()) subpath="app";
        App.appName=subpath;
        App.getInstance( ).contextInitialized( sce.getServletContext());
    }

    public void contextDestroyed(ServletContextEvent sce)
    {
        App.getInstance().contextDestroyed(sce.getServletContext());
    }

    // -------------------------------------------------------
    // HttpSessionListener implementation
    // -------------------------------------------------------
    public void sessionCreated(HttpSessionEvent se)
    {
      /* Session is created. */
    }

    public void sessionDestroyed(HttpSessionEvent se)
    {
      /* Session is destroyed. */
    }

    // -------------------------------------------------------
    // HttpSessionAttributeListener implementation
    // -------------------------------------------------------

    public void attributeAdded(HttpSessionBindingEvent sbe)
    {
      /* This method is called when an attribute 
         is added to a session.
      */
    }

    public void attributeRemoved(HttpSessionBindingEvent sbe)
    {
      /* This method is called when an attribute
         is removed from a session.
      */
    }

    public void attributeReplaced(HttpSessionBindingEvent sbe)
    {
      /* This method is invoked when an attibute
         is replaced in a session.
      */
    }
}
