/*
 * 创建日期: 2007-10-22
 *
 *
 * 功能描述：
 *
 */

package webApp;

import app.DBInit;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.netflix.appinfo.*;
import com.netflix.appinfo.providers.EurekaConfigBasedInstanceInfoProvider;
import com.netflix.discovery.*;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.metrics.prometheus.PrometheusMetricsTrackerFactory;
import config.CacheConfig;
import config.CacheCustomProperty;
import config.CacheResource;
import jun.db.impl.DataStoreFactory;
import jun.db.impl.IDPool;
import nettyrpc.manage.NettyRPC;


import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.InputStreamReader;
import java.sql.Driver;
import java.sql.DriverManager;

import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import tag.SourceVersionTag;
import util.*;
import websocket.PushServer;
import websocketRPC.RPCInject;
import websocketRPC.WSRPC;
import websocketRPC.log.RPCLogPool;

import javax.servlet.ServletContext;
import javax.sql.DataSource;
import java.net.InetAddress;
import java.util.*;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class App extends MyDataCenterInstanceConfig
{

    public static String PASSWORD_PREFIX = "encryped:";

    //Eureka 服务注册
    public static ApplicationInfoManager applicationInfoManager; //用来注册服务
    public static volatile boolean registToEurekaOK = false;
    public static EurekaClient eurekaClient; //用来注销服务，或查询其它服务

    public static volatile boolean showdownNow = false;

    public static String appName;

    public static com.typesafe.config.Config appConfig = null;

    public static boolean needURLFilter = true;

    private static App app = null;
    public static String COMPUTERNAME = "";
    public static String IPADDRESS = "";
    public static int LOCAL_PORT = 0;
    public static String IPADDRESS_AND_PORT = ""; // 用在日志输出时用于显示日志所在

    public static String AppRoot;
    public static String ContextPath = "";
    public static String FileRoot = "";
    public static String HomeURL = "";
    public static String OSName = "";
    public static String USRHome = "";

    public static boolean isWindows = false;
    public static boolean isLinux = false;
    public static boolean isMacos = false;


    public static String CacheDataPath = "";


    public IApp instanceProxy;


    public static String zbusMQNameServer = "";
    public static volatile boolean canConnectZBus = false;
    public static volatile boolean zbusMQConnected = false;
    public static volatile boolean zbusMQ_valid = false;
    public static volatile boolean logServie_valid = false;


    public static volatile boolean systemTableInitOK = false; //初始化表，完成

    public static ScheduledExecutorService timer_dbpool = null;

    public static ScheduledExecutorService timer_zbusMQ = null;
    public static ScheduledExecutorService timer = null;


    public static String hostName = "";

    public static volatile boolean dbPoolInitOK = false; //需要在 config.AppConfig中访问，所以需要volatile
    public static volatile int dbPoolInitInfoPushToUserId = 0; //数据库初始化的信息，推送给谁

    public static volatile boolean appInitOK = false;


    public static ArrayList<mq_zbus.PushConsumer> msgConsumerZBusList = new ArrayList<mq_zbus.PushConsumer>();


    private App(IApp iapp)
    {
        this.instanceProxy = iapp;
    }

    private int connectToMQTryCount = 0;
    private int connectToZBusTryCount = 0;


    public static App getInstance()
    {
        if (app != null) return app;
        IApp iapp;
        String appClass = "app." + App.appName + ".AppInit";
        try
        {

            Class c = Class.forName(appClass);
            iapp = (IApp) c.newInstance();
        } catch (Exception e)
        {
            FF.logger.error("不存在 " + appClass + " 类，服务无法启动初始化");
            iapp = null;
        }
        app = new App(iapp);
        return app;
    }

    public void contextInitialized(ServletContext context)
    {
        FF.log("应用服务器：" + context.getServerInfo() + FF.date2String (new Date() ,"yyyy.MM.dd HH:mm:ss"));

        System.setProperty("file.encoding", "UTF-8"); //强制设置这个参数 ， 避免  string.getByte() 没有加字符集参数时的乱码
        //参看 https://blog.csdn.net/wo541075754/article/details/116255279
        System.setProperty("druid.mysql.usePingMethod", "false");

        zbusMQ_valid = true;


        OSName = System.getProperty("os.name");
        USRHome = System.getProperty("user.home");

        if (OSName.toLowerCase().indexOf("window") >= 0)
        {
            isWindows = true;
            USRHome = "c:";
        }

        if (OSName.toLowerCase().indexOf("mac") >= 0)
        {
            isMacos = true;
        }


        if (OSName.toLowerCase().indexOf("linux") >= 0)
        {
            isLinux = true;
        }


        //日志归档初始化
        LogService.init();

        IDPool.init(10000); //默认初始化10000个ID

        //appConfig=ConfigFactory.load();

        //目录需要最早设置好
        initSomePath(context); //动态取得一些目录信息
        timer = Executors.newScheduledThreadPool(1, new NamedThreadFactory("APP-TIMER-" + App.appName));
        timer_dbpool = Executors.newScheduledThreadPool(1, new NamedThreadFactory("数据库连接检测-" + App.appName));
        timer_zbusMQ = Executors.newScheduledThreadPool(1, new NamedThreadFactory("Log服务检测-" + App.appName));


        DelayRun.delayRun("开启资源文件监控线程", new TimerTask()
        {
            @Override
            public void run()
            {
                //开启资源文件监控线程
                SourceVersionTag.startFileWatch(App.AppRoot, new Runnable()
                {
                    @Override
                    public void run()
                    {
                        //延迟5秒后刷新资源文件版本号
                        DelayRun.delayRun("resourceFileChanged", new TimerTask()
                        {

                            @Override
                            public void run()
                            {
                                SourceVersionTag.cacheFileMD5(App.AppRoot);
                            }
                        }, 5 * 1000);
                    }
                });
                //先计算一下资源文件版本号
                SourceVersionTag.cacheFileMD5(App.AppRoot);

            }
        }, 1000);


        //为什么 注册到eureka不是周期性处理呢？
        //因为 一旦注册上之后， 即使eureka死了，再起来， 本客户端也能自动再连接上，不需要再自已循环去连接
        DelayRun.delayRun("registToEureka", new TimerTask()

        {
            @Override
            public void run()
            {
                registToEureka();

            }
        }, 2 * 1000);  //不延迟一下， 会出现无法eureka客户端无法刷新服务信息，一直无法连接到 zbus


        //每N秒钟，去看一下连接池配置

        timer_dbpool.scheduleWithFixedDelay(new Runnable()
        {
            public void run()
            {
                {

                    initDBPool();//连接数据库

                }
            }
        }, 2, 5, TimeUnit.SECONDS);


        //每10秒钟，去看一下zbusMQ是否可连
       //  2023.12.29 去掉了zbus ,改成 log 服务的检测
        timer_zbusMQ.scheduleWithFixedDelay(new Runnable()
        {
            public void run()
            {
                {

                     if(logServie_valid) return;

                     logServie_valid = ServiceUtil.serviceIsReady("log") ;

                }
            }
        }, 2, 2, TimeUnit.SECONDS);

 
        //广播消息的接收

        InnerMessageConsumer.addFilter("dbpool-reset", new mq_zbus_MessageFilter_dbpool());
        InnerMessageConsumer.addFilter("dbpoolmap-reset", new mq_zbus_MessageFilter_dbpoolmap_reset());


        InnerMessageConsumer.addFilter("cache-reset", new mq_zbus_MessageFilter_cache());
        InnerMessageConsumer.addFilter("app_config_changed", new mq_zbus_MessageFilter_app_config_changed());
        InnerMessageConsumer.addFilter("app_resource_changed", new mq_zbus_MessageFilter_app_resource_changed());

        InnerMessageConsumer.addFilter("app_customproperty_changed", new mq_zbus_MessageFilter_app_customproperty_changed());


        String bat = "cmd.exe /c start " + App.FileRoot + "/main.bat";
        if (FF.fileExists(bat))
        {
            FF.log("执行" + bat);
            ExecuteCMD cmd = new ExecuteCMD();
            Vector resultCmd = cmd.execute(bat);
            FF.sleep(5000);
        }
    }


    public void closeZBusConnection()
    {

        //设置标记，避免在复位时，定时任务又把它启动起来
        canConnectZBus = false;
        zbusMQConnected = false;


        mq_zbus.MessageProducer.destroy();

        FF.log("zbus 消息生产者关闭");


        for (mq_zbus.PushConsumer pc : msgConsumerZBusList)
        {
            pc.shutDown();
        }
        FF.log("zbus 消息消费者关闭");
        canConnectZBus = true;//允许连接，让定时任务重新初始化连接
        FF.log("zbus 准备重新连接 ");
    }

    public void initIP()
    {
        String[] ips = FF.getAllIPAddress();



        try
        {
            App.COMPUTERNAME = InetAddress.getLocalHost().getHostName();
            App.IPADDRESS = ips.length > 0 ? ips[ ips.length -1 ] : InetAddress.getLocalHost().getHostAddress();
            App.LOCAL_PORT = FF.getTomcatPort();

        } catch (Exception e)
        {

        }

        /*
        # 打印当前容器的ID
        echo $HOSTNAME
        # 打印当前容器的IP地址
        hostname -i
        */

        if( isLinux)
        {
            String cmdIP = FF.executeShellCommand("hostname -i"); // 仅在 linux 下有效
            FF.log("hostname -i 结果：" + cmdIP);
            if (!cmdIP.isEmpty())
            {
                App.IPADDRESS = cmdIP;
            }
        }

        //下面的结果，是实操观察的结果，并非是从什么文档中看到的，所以不见得是正确的
        // 也不清楚是不是 swirl 工具做了什么设置
        //容器中的ip地址 ， 针对 ingress 网络，通常是以 10.255.开头
        //  针对  xxxx_default 网络， ip地址通常是以 10.0.开头的
        //  还会有一个 172.18.打头的ip地址 ， 不清楚是什么网络分配的

        //如果多网卡，那么可以在环境变量中定义使用哪个开头的IP
        String ipMask = FF.getVMProperty("APP_IP_MASK", "");
        if (!ipMask.isEmpty())
        {
            FF.log("IP地址优先使用：" + ipMask + "开头的");
            if (!App.IPADDRESS.startsWith(ipMask))
            {

                for (int i = 0; i < ips.length; i++)
                {
                    String ip = ips[i];
                    if (ip.startsWith(ipMask))
                    {
                        App.IPADDRESS = ip;
                        break;
                    }
                }
            }
        }




        FF.log("服用使用IP: " + App.IPADDRESS);
    }
    private void initSomePath(ServletContext context)
    {

        initIP();

        //上下文目录
        String subpath = context.getContextPath();
        if (subpath.equals("/")) subpath = "";
        App.ContextPath = subpath;

        App.HomeURL = getHomePageUrl();

        final String path = FF.getAppRealPath(context, "");
        App.AppRoot = path;
        //初始化日志
        LogBackConfigLoader llcl = new LogBackConfigLoader();
        llcl.load(path, appName);

        //在ssoLoginCheck中有用到
        FF.setHomeURL(App.HomeURL);

        FileRoot = FF.getVMProperty("APP_FILE_ROOT", "");

        if (FileRoot.isEmpty())
        {
            FileRoot = USRHome + "/appFileRoot";
        }

        FF.MkDirs(FileRoot);
        //如果配置的目录无法创建，那么重新初始化为缺省的目录
        if (!FF.dirExists(FileRoot))
        {
            FileRoot = USRHome + "/appFileRoot";
        }


        CacheDataPath = FileRoot + "/cache";


        //让应用自已再处理个性化的东西
        instanceProxy.initSomePath(context);


        CacheDataPath = App.FileRoot + "/cache";


        if (appName.equals("cache")) FF.log("数据缓存目录：" + CacheDataPath);


        //System.setProperty("javax.net.ssl.trustStore", "/usr/local/etc/nginx/server.key.org");


    }


    public void contextDestroyed(ServletContext context)
    {
        showdownNow = true; // 用来通知那些不停死循环的线程，可以结束了

        instanceProxy.onShutdown();

        timer_dbpool.shutdownNow();
        timer_zbusMQ.shutdownNow();
        timer.shutdownNow();

        FF.log("关闭资源文件变化监控");
        SourceVersionTag.stopFileWath();//关闭资源文件变化监控
        FF.log("RPC服务停止");
        NettyRPC.shutdown();
        WSRPC.shutdown();
        FF.log("停止任务调度");

        HttpUtil.shutdown();

        DBF.shutDown();

        IDPool.shutdown();

        DataStoreFactory.uidGeneratorDestroy(); //id 线程关闭

        try
        {
            Enumeration<Driver> drivers = DriverManager.getDrivers();
            while (drivers.hasMoreElements())
            {
                DriverManager.deregisterDriver(drivers.nextElement());
            }
        } catch (Exception e)
        {

        }

        FF.log("连接池关闭");


        // zbus关闭
        closeZBusConnection();

        //日志归档的终止
        LogService.destroy();

        unRegistToEureka();


        FF.log("应用停止完成");

        //到这里了，如果某些线程还是无法结束，那么暴力一下吧
        // 如果多个服务放在一个tomcat下，停止其中一个，会导致整个Tomcat停止
        Thread[] threads = findAllThreads();
        for (Thread thread : threads)
        {
            thread.interrupt();
        }

        DelayRun.delayRun("shutdown", new TimerTask()
        {
            @Override
            public void run()
            {
                System.exit(0);
            }
        }, 3 * 1000);

        FF.log("API切入结束");
        RPCInject.stop();


    }

    public static Thread[] findAllThreads()
    {
        ThreadGroup group =
                Thread.currentThread().getThreadGroup();
        ThreadGroup topGroup = group;
        // traverse the ThreadGroup tree to the top
        while (group != null)
        {
            topGroup = group;
            group = group.getParent();
        }
        // Create a destination array that is about
        // twice as big as needed to be very confident
        // that none are clipped.
        int estimatedSize = topGroup.activeCount() * 2;
        Thread[] slackList = new Thread[estimatedSize];
        // Load the thread references into the oversized
        // array. The actual number of threads loaded
        // is returned.
        int actualSize = topGroup.enumerate(slackList);
        // copy into a list that is the exact size
        Thread[] list = new Thread[actualSize];
        System.arraycopy(slackList, 0, list, 0, actualSize);
        return list;
    }


    /**
     * 删除了连接池配置，或禁用了，这个情况没有处理
     *
     * @param name
     * @param userid 推送消息给谁
     */
    public void resetDBPool(String name, int userid)
    {


        App.dbPoolInitInfoPushToUserId = userid;

        if (name.equals("all"))
        {
            DBF.shutDown();

            FF.log("所有连接池关闭");

            App.dbPoolInitOK = false; //标记复位让它重新连接

            FF.log("连接池重新初始化");
        }
        else
        {
            FF.log(name + "连接池准备复位");

            //不用 restart 是因为可能配置发生了变化，所以直接删除旧的连接池，重新创建新的连接池
            initSomeoneDBPool(name);


        }

        //某个连接池变了， 指不定某个服务可能需要做点什么
        app.instanceProxy.dbpoolReseted(name);

    }


    public void registToEureka()
    {
        //DynamicPropertyFactory configInstance = Archaius1Utils.initConfig("eureka-server");

        //EurekaInstanceConfig，重在应用实例，例如，应用名、应用的端口等等。
        EurekaInstanceConfig instanceConfig = this;
        InstanceInfo instanceInfo = new EurekaConfigBasedInstanceInfoProvider(instanceConfig).get();
        //EurekaClientConfig，重在 Eureka-Client，例如， 连接的 Eureka-Server 的地址、获取服务提供者列表的频率、注册自身为服务提供者的频率等等。
        //下面的会读取claspath下的 eureka-client.properties配置文件
        EurekaClientConfig clientConfig = new EurekaClientConfigByUDP();

        applicationInfoManager = new ApplicationInfoManager(instanceConfig, instanceInfo);
        App.eurekaClient = new DiscoveryClient(applicationInfoManager, clientConfig);

        applicationInfoManager.setInstanceStatus(InstanceInfo.InstanceStatus.STARTING);


        initIP();


        HashMap<String, String> map = new HashMap<String, String>();
        map.put("realPath", AppRoot);//本应用的上下文路径

        //记下没有映射过的原始的服务访问地址
        map.put("homePageUrlWithoutMap", this.getHomePageUrl(false));
        map.put("ipaddress", App.IPADDRESS);

        //2020.03.06 增加局域网地址
        FF.log("local_ipaddress =" + App.IPADDRESS);
        FF.log("local_port=" + FF.getTomcatPort());
        FF.log("contextPath=" + ContextPath);//本应用的上下文路径

        map.put("local_ipaddress", App.IPADDRESS);
        map.put("local_port", "" + FF.getTomcatPort());
        map.put("contextPath", ContextPath);//本应用的上下文路径


        //应用实例，可以覆盖registerAppMetadata函数，登记一些应用有用的信息
        instanceProxy.registerAppMetadata(map);


        applicationInfoManager.registerAppMetadata(map);

        applicationInfoManager.setInstanceStatus(InstanceInfo.InstanceStatus.UP);

        FF.log(App.IPADDRESS + "   " + App.getInstance().getVirtualHostName() + "   服务注册成功..");

        //远程调用必须的参数初始化
        FF.log("注册到Eureka:" + instanceConfig.getVirtualHostName() + "  " + App.IPADDRESS);
        RPCRouter.init(App.HomeURL, App.eurekaClient, instanceConfig.getVirtualHostName(), App.IPADDRESS);
        //增加对NettyRPC的支持
        NettyRPC.init(App.HomeURL, App.eurekaClient, instanceConfig.getVirtualHostName(), App.IPADDRESS);
        //增加对websocket RPC的支持
        WSRPC.init(App.HomeURL, App.eurekaClient, instanceConfig.getVirtualHostName(), App.IPADDRESS);

        registToEurekaOK = true;

    }

    private void unRegistToEureka()
    {
        if (eurekaClient != null)
        {
            System.out.println("关闭 " + App.IPADDRESS + "   " + App.getInstance().instanceProxy.getVirtualHostName() + "  服务");
            eurekaClient.shutdown();
        }
    }


    private void connectToZBusMQ()
    {


        if (!canConnectZBus) return;

        if (zbusMQConnected) return;


        if (!registToEurekaOK) return;

        zbusMQNameServer = FF.getZBusNameServer();

        if (zbusMQNameServer.isEmpty())
        {
            FF.log(appName + "暂时无法从Eureka中获取zbus服务地址信息，稍候再试");
            return;
        }

        FF.log(" zbus地址：" + zbusMQNameServer);

        int maxTotal = 20; //cfg.get("生产者池最大数", 20);
        int maxIdle = 5; //cfg.get("生产者池最大空闲数", 5);
        int minIdle = 1; //cfg.get("生产者池最小空闲数", 1);
        int maxWaitMillis = 10000; //  cfg.get("最大等待毫秒", 10000);

        boolean isHostConnectable = false;
        String[] nameSrvs = zbusMQNameServer.split(";");
        for (int i = 0; i < nameSrvs.length; i++)
        {
            String hostAndPort = nameSrvs[i];
            String[] t = hostAndPort.split(":");
            if (t.length < 2) continue;
            String host = t[0];
            int port = FF.String2Int(t[1]);
            isHostConnectable = FF.isHostConnectable(host, port);
            if (isHostConnectable) break; // 只要其中的一个nameSrv 是可连接的，那么就连接它，不需要全部
        }

        if (!isHostConnectable)
        {
            FF.log("zbusMQ 不可用，再等等");
            return;//如果还不能连接，说明它没有启动，那么再等等吧
        }

        //创建消息接收器
        //系统消息，包括 连接池复位等
        FF.log("zbusMQ 可用，" + App.getInstance().getVirtualHostName() + "连接它");
        try
        {
            registMessageConsumer(new mq_zbus.PushConsumer())

                    .connect("system" + DataStoreFactory.newGUID(), //注意本消费者，是需要以广播的方式消费消息，所以此参数必须是与其它消费者不同的
                             "system");
        } catch (Exception e)
        {

            return;
        }


        instanceProxy.registMessageConsumerToZBusMQ();
        //构建消息发送者
        mq_zbus.MessageProducer.init(maxTotal, maxIdle, minIdle, maxWaitMillis);

        zbusMQConnected = true;


    }


    private void initDBPool()
    {


        if (App.dbPoolInitOK)
        {
            //  FF.log("连接池已经创建完成。");
            return;
        }

        if (!registToEurekaOK)
        {
            System.out.println(appName + " 注册到eureka尚未完成。等等");
            return;
        }

        DBF.name = this.getAppname();

        //   2023.12.29 取消了 zbus ，换成log
        if (!App.appName.equals("log"))
        {
            if (!ServiceUtil.serviceIsReady("log"))
            {
                FF.log(App.appName + "等待log服务上线");
                return;
            }
        }


        //canConnectZBus = true;



        if (!App.appName.equals("config") && !App.appName.equals("log"))
        {
            if (!ServiceUtil.serviceIsReady("config"))
            {
                FF.log(App.appName + "等待config服务上线");
                return;
            }
        }


        try
        {

            //如果不需要数据库连接 ，那么直接设置标记，退出
            if (instanceProxy.needDBPool())
            {

                FF.log("初始化连接");
                if (!initSomeoneDBPool(null).getBoolean("success", false)) return; //全部初始化

                FF.log("初始化连接完成");
                if (DBF.dbPoolCount() > 0)
                {
                    DelayRun.delayRun("initSystemTable", new TimerTask()
                    {
                        @Override
                        public void run()
                        {
                            //自动建系统表
                            initSystemTable();
                        }
                    }, 10);
                }


                instanceProxy.beforeDBPoolInitOK();
                FF.log(" 2====");
            }

        } catch (Exception e)
        {
            //2020.11.20 自从修改了 CacheConfig.reloadConfig后，以及调整WSRPC.dispatchToService 调用失败后重试另外副本后
            // config 服务就会出一个异常 ， 导致 dbPoolInitOK=true 没有执行。
            //所以就把  cache(Exception e) 提前到它之前处理， 屏蔽异常，保证  dbPoolInitOK 设置成功
            FF.log("=====异常========");

            FF.log("初始化Druid连接池连接主数据库异常" + FF.exceptionMessage(e));
        }
        App.dbPoolInitOK = true;

        FF.log(appName + " dbPoolInit  OK   ");
        canConnectZBus = true;
        //必须在dbPoolInitOK后，再做 onStartup 因为 在config中需要在设置 dbPoolInitOK 后，其它的应用才会做连接池的初始始化及
        //在 onStartup中做一些启动后的事宜


        //注意 zbus 不要处理 CacheConfig.reloadConfig
        //因为 config 等待zbus启动成功，而如果zbus启动时，又要调用 config服务，那么两个就死循环等待了
        // 所以在 2020.11.20  去掉了zbus对 下面3个初始化， 实际上它也不需要
        if (!appName.equals("zbus"))
        {
            //主配置中心的缓存

            FF.log(appName + "缓存系统设置项");
            CacheConfig.reloadConfig();
            FF.log(appName + "缓存自定义属性");
            CacheCustomProperty.reloadConfig();

            FF.log(appName + "缓存资源");
            CacheResource.reloadConfig();

            FF.log("API切入开始");
            RPCInject.start();

            // init中会判断是否需要重新初始化，如果需要，那么就复位重新初始化
            RPCLogPool.init();

        }

        JSONObject cfg = WSRPC.dispatch("config", "service.AppConfig",
                                        "getWorkerId", new JSONObject().put("service", appName).put("ip", IPADDRESS)
                                                .put("port", LOCAL_PORT), null, null, false);

        int workerId = cfg.getInt("workerId", 0);
        if (workerId == 0)
        {
            FF.log(appName + " 无法获取 workerid ");
            workerId = FF.buildRandom(2);
        }
        FF.log("workerid=" + workerId);

        DataStoreFactory.setUidGeneratorWorkerId(workerId);


        //交给应用做一些事情
        instanceProxy.onStartup();


        FF.log(appName + "应用初始化完成");

        appInitOK = true;


    }

    private void appInitLogInfo(String info)
    {
        info = "[" + appName + "]" + info;
        FF.log(info);
        String topic = "resetdbpool"; //前端关注 resetdbpool这个主题
        if (App.dbPoolInitInfoPushToUserId > 0)
        {
            if (App.appName.equals("config"))
            {
                PushServer.sendMessage(App.dbPoolInitInfoPushToUserId, topic, info);
            }
            else
            {
                WSRPC.dispatch("config", "service.AppConfig", "pushMessage",
                               new JSONObject().put("topic", topic)
                                       .put("userid", App.dbPoolInitInfoPushToUserId)
                                       .put("message", info), null, null,
                               true  //广播方式
                );
            }
        }
    }

    // 重新初始化某个连接池
    // 如果它是一个租户连接，则是重新加载此租户连接的对各个企业的映射关系
    private JSONObject initSomeoneDBPool(String someone)
    {
        if (someone == null) someone = "all";

        JSONObject ret = new JSONObject().put("success", true);
        //如果不需要数据库连接 ，那么直接设置标记，退出
        if (!instanceProxy.needDBPool()) return ret;

        appInitLogInfo("初始化连接池：" + " - " + someone);

        //只有config服务是自已取连接池，其它的都是通过config来获取连接池
        JSONObject dbConfig = instanceProxy.getDBConfig();


        try
        {


            if (dbConfig == null)
            {
                dbConfig = WSRPC.dispatch("config", "service.AppConfig",
                                          "getDBPoolConfig", new JSONObject(), null, null, false);
            }

            //如果获取数据库连接配置不成功，那么就继续
            //注意，不成功，可能是config服务还没有初始化完成

            //不管成功不成功，都显示一下提示信息
            //因为cofnig获取连接，即使失败，也要让它启动起来，好重新设置
            FF.log("getDBPoolConfig  result  :" + dbConfig.getString("message", ""));

            if (dbConfig.getBoolean("success", false) == false)
            {
                return dbConfig; //退出 ，等待下一次尝试
            }


            //ja中仅包含了启用的连接池配置
            JSONArray ja = dbConfig.getJSONArray("dbpool", null);
            JSONArray jamap = dbConfig.getJSONArray("dbpoolmap", null);

            //当前配置中可以使用的连接池
            ArrayList<String> currentPoolNames = new ArrayList<>();
            for (int i = 0; i < ja.length(); i++)
            {
                currentPoolNames.add(ja.getJSONObject(i).getString("name", ""));
            }


            //如果是全部重新初始化，那么看看，是不是禁用了一些连接池
            if (someone.equals("all"))
            {
                //当前已经存在的连接池
                ArrayList<String> dbs = DBF.getPoolNames();

                for (int i = 0; i < dbs.size(); i++)
                {
                    String name = dbs.get(i);
                    if (!currentPoolNames.contains(name))
                    {
                        DataSource dds = DBF.getDataSource(name);
                        if (dds != null)
                        {
                            if (dds instanceof DruidDataSource) ((DruidDataSource) dds).close();
                            if (dds instanceof HikariDataSource) ((HikariDataSource) dds).close();
                            DBF.remove(someone);//移除先
                            appInitLogInfo("关闭所有" + someone + "连接");
                        }
                    }

                    //可能是租户连接
                    DBF.removeAbstractPoolName(name);
                    DBF.removeMap(name, "*");


                }


            }
            else
            {//如果只是复位某个连接池那么只需要看看这个连接池是不是禁用了
                DataSource dds = DBF.getDataSource(someone);
                if (dds != null)
                {

                    if (dds instanceof DruidDataSource) ((DruidDataSource) dds).close();
                    if (dds instanceof HikariDataSource) ((HikariDataSource) dds).close();
                    DBF.remove(someone);//移除先
                    appInitLogInfo("关闭" + someone + "所有连接");
                }

                //可能是租户连接
                DBF.removeAbstractPoolName(someone);
                DBF.removeMap(someone, "*");

            }


            if (ja != null)
            {
                for (int i = 0; i < ja.length(); i++)
                {


                    JSONObject js = ja.getJSONObject(i);
                    String name = js.getString("name", "");

                    String poolType = js.getString("poolType", "");

                    if (!name.equals(someone) && !someone.equals("all")) continue;

                    //如果是租户连接，那么只需要把名称登记一下即可
                    if (poolType.equals("corporate"))
                    {
                        DBF.addAbstractPoolName(name);
                        continue; //
                    }

                    //数据库连接池配置了，如果不申请使用，它是不会初始化的，所以尽管配置好了，不会造成不必要的浪费
                    try
                    {

                        DataSource ds = null;

                        String password = js.getString("password", "");
                        if (password.startsWith(PASSWORD_PREFIX))
                            password = FF.decryptString(password.substring(PASSWORD_PREFIX.length()));

                        String poolProviderType = js.getString("poolProviderType", "druid");
                        if (poolProviderType.equalsIgnoreCase("druid"))
                        {

                            Map prop = FF.json2map(js, true);
                            DruidDataSource dataSource = new DruidDataSource();

                            prop.put("password", password);


                            DruidDataSourceFactory.config(dataSource, prop);
                            // 上面的函数居然没有对 maxEvictableIdleTimeMillis做处理， 不理解
                            dataSource.setMaxEvictableIdleTimeMillis(js.getInt("maxEvictableIdleTimeMillis", 25200000));
                            dataSource.setName(js.getString("name", ""));

                            //socketTimeout 等同于 connectionTimeout
                            //超时最小 30秒
                            dataSource.setConnectTimeout( Math.max( 30000 , js.getInt("connectionTimeout", 120000)));
                            dataSource.setSocketTimeout( Math.max( 30000 , js.getInt("connectionTimeout", 120000)));




                            ds = dataSource;

                        }
                        else
                        {


                            HikariDataSource hikariDataSource = new HikariDataSource();

                            hikariDataSource.setDriverClassName(js.getString("driverClassName", ""));
                            hikariDataSource.setJdbcUrl(js.getString("url", ""));
                            hikariDataSource.setUsername(js.getString("username", ""));
                            hikariDataSource.setPassword(password);
                            //最小空闲连接数量
                            hikariDataSource.setMinimumIdle(js.getInt("minIdle", 1));
                            hikariDataSource.setIdleTimeout(js.getInt("minEvictableIdleTimeMillis", 600000)); //此属性控制允许连接在池中闲置的最长时间,此设置仅适用于minimumIdle设置为小于maximumPoolSize的情况 默认:600000(10minutes)
                            //连接池最大连接数，默认是10

                            //超时最小 30秒

                            hikariDataSource.setConnectionTimeout( Math.max( 30000 ,js.getInt("connectionTimeout", 120000)));//等待连接池分配连接的最大时长（毫秒），超过这个时长还没可用的连接则发生SQLException

                            hikariDataSource.setMaximumPoolSize(js.getInt("maxActive", 10));
                            hikariDataSource.setPoolName(name);

                            hikariDataSource.setMaxLifetime(js.getInt("maxEvictableIdleTimeMillis", 1800000));
                            hikariDataSource.setConnectionTestQuery(js.getString("validationQuery", "select 1"));

                            int leakDetect = FF.getVMProperty("HikariCP_leakDetectionThreshold", 0);
                            if (leakDetect > 0)
                            {
                                hikariDataSource.setLeakDetectionThreshold(leakDetect * 60 * 1000);

                            }


                            hikariDataSource.setMetricsTrackerFactory(new PrometheusMetricsTrackerFactory());

                            hikariDataSource.setRegisterMbeans(true);

                            ds = hikariDataSource;


                        }

                        //先看它是不是已经在池中，如果是，那么先删除它，再重新加入
                        DataSource dds = DBF.getDataSource(name);
                        if (dds != null)
                        {
                            if (dds instanceof DruidDataSource) ((DruidDataSource) dds).close();
                            if (dds instanceof HikariDataSource) ((HikariDataSource) dds).close();
                            DBF.remove(name);//移除先
                        }
                        //加到池中

                        DBF.addPool(name, ds);

                        appInitLogInfo(name + "连接池初始化完成 ");
                    } catch (Exception e)
                    {
                        FF.log(js.toString() + "连接异常：" + e.getMessage());
                    }
                }
            }

            if (jamap != null)
            {
                for (int i = 0; i < jamap.length(); i++)
                {


                    JSONObject js = jamap.getJSONObject(i);
                    String dbpool = js.getString("dbpool", "");
                    String corporationid = js.getString("corporationid", "");
                    String dbpoolinstance = js.getString("dbpoolinstance", "");

                    if (!dbpool.equals(someone) && !someone.equals("all")) continue;

                    //映射关系
                    DBF.addMap(dbpool, corporationid, dbpoolinstance);


                }
            }

            return ret;
        } catch (Exception e)
        {
            appInitLogInfo("异常：" + e.getMessage());
            return new JSONObject().put("success", false).put("message", e.getMessage());
        }


    }


    /**
     * DBInit.initSystemTable是在 App启动时，异步执行的，当它执行完成后， 触发本事件
     * 因为在initSystemTable中可能初始化数据，在做完后，需要交给app做一些处理，比如 app_config在初始化完成后 需要重建fullname
     */
    public void afterInitSystemTable()
    {
        instanceProxy.afterInitSystemTable();
    }


    public static mq_zbus.PushConsumer registMessageConsumer(mq_zbus.PushConsumer pc)
    {
        msgConsumerZBusList.add(pc);
        return pc;
    }


    public void initSystemTable()
    {
        try
        {
            FF.log(appName + "  开始初始化系统表");
            systemTableInitOK = false;
            DBInit dbinit = new DBInit("", AppRoot);
            dbinit.InitSystemTable();
        } catch (Exception e)
        {

        } finally
        {

            systemTableInitOK = true;
            FF.log(appName + "  系统表初始化完成 ，systemTableInitOK=true");
        }

    }


    public static String replaceTokerInFileName(String file)
    {
        String ret = file;
        if (ret.startsWith("{fileroot}")) ret = FF.replaceAll(ret, "{fileroot}", App.AppRoot);
        return ret;

    }

    public static void systemFeedbackAction(int userid, String info)
    {

    }


//========================================================
    //以下是Eureka服务实例的一些参数配置项


    @Override
    /**
     * 返回本机的IP地址
     */
    public String getHostName(boolean refresh)
    {
        String ret = instanceProxy.getHostName(refresh);
        if (ret != null) return ret;

        try
        {
            ret = App.IPADDRESS;
            //FF.log("getHostName 使用本机IP"+ret);
            return ret;

        } catch (Exception e)
        {

            return super.getHostName(refresh);
        }
    }


    /***
     *获取对外服务的端口号
     * @return
     */
    @Override
    public int getNonSecurePort()
    {
        int port = instanceProxy.getNonSecurePort();
        if (port != 0) return port;
        return FF.getTomcatPort();
    }

    @Override
    public int getLeaseRenewalIntervalInSeconds()
    {
        return 5;
    }

    /**
     * 这个就是 VipAddress ,就是服务的名称
     *
     * @return
     */
    @Override
    public String getVirtualHostName()
    {

        return instanceProxy.getVirtualHostName();
    }


    /**
     * 这个是服务的显示名，如果vipaddress名称一样， 显示名也一样，那么只会显示出一个服务 ，如果显示名不一样，就会显示出多个服务
     *
     * @return
     */
    @Override
    public String getAppname()
    {

        String ret = instanceProxy.getAppname();
        if (ret != null) return ret;
        return instanceProxy.getVirtualHostName() + "-" + getHostName(true) + "-" + this.getNonSecurePort();
    }

    /**
     * 注意是拼上上下文路径，而不是VIPName，只不过是缺省状态下，单机部署时，vipName与contextPath通常取成一样的
     *
     * @return
     */
    @Override
    public String getHomePageUrl()
    {

        return getHomePageUrl(true);

    }

    /**
     * 得到服务自已的地址
     *
     * @param useMap 是否使用映射的地址
     * @return
     */
    public String getHomePageUrl(boolean useMap)
    {


        String host = getHostName(true);
        String port = "" + getNonSecurePort();

        String protocol = FF.getVMProperty("APP_PROTOCOL", "http");


        //以应用的所在目录为 section ,取配置，如果没有，则取 default的配置
        if (useMap)
        {

            String app_host = FF.getVMProperty("APP_HOST", "");
            String app_port = FF.getVMProperty("APP_PORT", "");

            if (!app_host.isEmpty())
            {

                host = app_host;

            }

            if (!app_port.isEmpty())
            {

                port = app_port;


            }


        }

        port = ":" + port;
        if (port.equals(":80")) port = "";
        if (port.equals(":443") || protocol.equalsIgnoreCase("https"))
        {
            port = "";
            protocol = "https";
        }


        String ret = protocol + "://" + host + port;
        IPADDRESS_AND_PORT = host + port;

        FF.log("地址：" + ret);

        //ContextPath自带 /  比如  /config  ，但是如果没有上下文子目录，那么它并不是 '/' ，而是空字符串 ''
        if (!App.ContextPath.isEmpty()) ret = ret + App.ContextPath;
        //FF.log("getHomePageUrl = " + ret);
        return ret;

    }

    @Override
    public String getHealthCheckUrl()
    {
        return getHomePageUrl() + "/healthcheck";
    }

    @Override
    public String getStatusPageUrl()
    {
        return getHomePageUrl() + "/Status";
    }


    class mq_zbus_MessageFilter_dbpool implements MessageFilter
    {
        @Override
        public void onMessage(JSONObject msg)
        {
            final App app = App.getInstance();
            int delay = 10 * 1000;
            String t = msg.getString("message", "");
            JSONObject js = new JSONObject(t);
            final String name = js.getString("dbpool", "all");
            final int userid = js.getInt("userid", 1);
            //config服务基本上马上就复位连接池，其它的服务，需要等10秒后，才执行，因为需要先让config初始中化完成
            if (app.getVirtualHostName().equals("config")) delay = 100;

            //  DelayRun.delayRun("dbpool_reset", new TimerTask()
            // {

            //    @Override
            //    public void run()
            //     {
            FF.log(app.getVirtualHostName() + "收到连接池复位消息，现在就复位连接池" + name);
            app.resetDBPool(name, userid);
            //   }
            // }, delay);

        }


    }


    /**
     * 某个企业的连接池映射变化了，需要重新复位
     */
    class mq_zbus_MessageFilter_dbpoolmap_reset implements MessageFilter
    {
        @Override
        public void onMessage(JSONObject msg)
        {


            String t = msg.getString("message", "");
            FF.log(t);

            JSONObject js = new JSONObject(t);

            JSONArray data = js.getJSONArray("data", new JSONArray());

            int n = data.length();
            String corporationid = js.getString("corporationid", "0", true);


            DBF.removeMap("*", corporationid);

            for (int i = 0; i < n; i++)
            {
                JSONObject one = data.getJSONObject(i);
                String dbpool = one.getString("dbpool", "");
                String dbpoolinstance = one.getString("dbpoolinstance", "");
                DBF.addMap(dbpool, corporationid, dbpoolinstance);
            }
            FF.log(app.getVirtualHostName() + "收到企业连接池映射复位消息，连接池映射复位成功");

        }

    }

    //缓存复位

    class mq_zbus_MessageFilter_cache implements MessageFilter
    {
        @Override
        public void onMessage(JSONObject msg)
        {
            final App app = App.getInstance();

            //config服务基本上马上就复位连接池，其它的服务，需要等10秒后，才执行，因为需要先让config初始中化完成
            String appName = app.getVirtualHostName();

            if (appName.equals("cache"))
            {
                instanceProxy.onReset();
            }

        }
    }


    class mq_zbus_MessageFilter_app_config_changed implements MessageFilter
    {
        @Override
        public void onMessage(JSONObject msg)
        {
            App app = App.getInstance();
            try
            {
                FF.log(app.getVirtualHostName() + "收到app_config变化通知：" + msg.getString("message", ""));
                //主配置中心的缓存
            } catch (Exception e)
            {
                FF.log(e);
            }
            CacheConfig.reloadConfig();

            // init中会判断是否需要重新初始化，如果需要，那么就复位重新初始化
            RPCLogPool.init();

            app.instanceProxy.app_config_changed(msg);

            boolean b = CacheConfig.get("/日志/前端日志查看/enabled", "false").equalsIgnoreCase("true");
            FF.zbusEnable = b;
        }
    }

    class mq_zbus_MessageFilter_app_resource_changed implements MessageFilter
    {
        @Override
        public void onMessage(JSONObject msg)
        {
            App app = App.getInstance();
            try
            {

                FF.log(app.getVirtualHostName() + "收到app_resource 变化通知：" + msg.getString("message", ""));
                //主配置中心的缓存
            } catch (Exception e)
            {
                FF.log(e);
            }
            CacheResource.reloadConfig();
        }
    }

    class mq_zbus_MessageFilter_app_customproperty_changed implements MessageFilter
    {
        @Override
        public void onMessage(JSONObject msg)
        {
            App app = App.getInstance();
            try
            {
                FF.log(app.getVirtualHostName() + "收到app_customproperty变化通知：" + msg.getString("message", ""));

            } catch (Exception e)
            {
                FF.log(e);
            }
            //自定义属性缓存

            CacheCustomProperty.reloadConfig();
        }
    }


}


class ExecuteCMD
{

    Process p;

    public ExecuteCMD()
    {
    }

    public Vector execute(String shellCommand)
    {
        try
        {
            Start(shellCommand);
            Vector vResult = new Vector();
            DataInputStream in = new DataInputStream(p.getInputStream());
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String line;
            do
            {
                line = reader.readLine();
                if (line == null)
                {
                    break;
                }
                else
                {
                    vResult.addElement(line);
                }
            }
            while (true);
            reader.close();
            return vResult;

        } catch (Exception e)
        {
            // error
            return null;
        }
    }

    public void Start(String shellCommand)
    {
        try
        {
            if (p != null)
            {
                p.destroy();
                p = null;
            }
            Runtime sys = Runtime.getRuntime();
            p = sys.exec(shellCommand);
        } catch (Exception e)
        {
            FF.log(e.toString());
        }
    }

}
