package util;

import org.json.JSONObject;
import websocketRPC.WSRPC;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Enumeration;


/**
 * 本类是提供HTTP接口方式来触发脚本执行
 */
@WebServlet(name = "runTask", urlPatterns = "/runTask")
public class runTask extends HttpServlet
{
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
    {
        doGet(request, response);
    }

    @Override
    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException
    {
        doPost(req, resp);
    }


    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
    {

        //禁用缓存
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0);


        /* 允许跨域的主机地址 */
        response.setHeader("Access-Control-Allow-Origin", "*");
        /* 允许跨域的请求方法GET, POST, HEAD 等 */
        response.setHeader("Access-Control-Allow-Methods", "*");
        /* 重新预检验跨域的缓存时间 (s) */
        response.setHeader("Access-Control-Max-Age", "36000");
        /* 允许跨域的请求头 */
        response.setHeader("Access-Control-Allow-Headers", "*");
        /* 是否携带cookie */
        response.setHeader("Access-Control-Allow-Credentials", "true");

        //浏览器将CORS请求分为两类：简单请求（simple request）和非简单请求（not-simple-request）。
        // 非简单请求 会在正式通信之前，增加一次HTTP请求，称之为预检请求。浏览器会先发起OPTIONS方法到服务器，
        // 以获知服务器是否允许该实际请求。

        if (request.getMethod().equals("OPTIONS"))
        {
            response.setStatus(HttpServletResponse.SC_OK);
            return;
        }
        // 经过以上处理，可以解决非同域前端的跨域调用问题。已实测通过


        //请求人信息也放入参数
        String taskid = getTaskId(request);
        // 服务隔离支持
        String sharding = AppCache.getCache("ScriptSharding:" + taskid, "");
        // 是否有sql及注入
        boolean sqlInject = AppCache.getCache("ScriptSQLInject:" + taskid, "false").equals("true");


        JSONObject queryParam = BuildParamFromRequest.buildParam(request, response, true, sqlInject);


        JSONObject p = new JSONObject();
        p.put("task", taskid);//实际上是脚本的代码
        p.put("data", queryParam);

        //2021.01.09 增加 runTask带上表单信息
        p.put("templateID", request.getHeader("templateid"));
        p.put("currentGUID", request.getHeader("currentGUID"));

        p.put("moduleDefineKey", request.getHeader("moduleDefineKey"));
        p.put("authorizationURL", request.getHeader("authorizationURL"));
        p.put("authorizationTemplate", request.getHeader("authorizationTemplate"));


        //超时放长一点
        JSONObject ret = WSRPC.dispatch("script", "script.rpcTask",
                                        "runTask", p, request, response, false, 3600, sharding);

        String returnValue = "";
        //2020.03.05 如果调用异常，直接throw，而不是返回 一个null ，这样与正常返回 null值 区分开来
        // 因为有些脚本执行后，就没有返回值 ，但是可能存在这个runTask远程调用失败的情况，这种情况需要返回 异常，而不是null值
        if (!ret.getBoolean("success", false))
        {

            returnValue = ret.getString("message", "");
            FF.log("脚本服务执行异常：" + returnValue);
        }
        else
        {
            returnValue = ret.getString("returnValue", "");
            //有的需要指定返回 的statusCode
            JSONObject js = new JSONObject(returnValue);
            int statusCode = js.getInt("responseStatusCode", 0);
            if (statusCode != 0) response.setStatus(statusCode);
            //如果是在脚本中做了登录，那么因为 WSRPC不能传递response，所以需要在这里设置一下token
            if (js.getBoolean("$login$", false))
            {
                String tokenid = js.getString("token", "");
                //token是加过密的，所以要解开先。FF.setCookie 会对key及value再次加密
                FF.setCookie(response, "tokenid", "/", FF.decryptString(tokenid), -1); //临时的，不存放到硬盘，关闭浏览器，就丢失
                //标记20230214

            }
        }
        response.getWriter().print(returnValue);

    }


    public static String getTaskId(HttpServletRequest request)
    {
        String taskid = request.getParameter("task");
        if (taskid == null) taskid = "";
        if (!taskid.isEmpty()) return taskid;


        Enumeration hn = request.getHeaderNames();
        JSONObject header = new JSONObject();
        while (hn.hasMoreElements())
        {
            String key = hn.nextElement().toString();
            String value = request.getHeader(key);
            header.put(key, value);
            //允许在头部定义要调用的脚本代码或ID
            if (key.equalsIgnoreCase("task")) return value;

        }
        return "";

    }

}