package util;

import org.owasp.esapi.ESAPI;
import org.owasp.esapi.codecs.Codec;
import org.owasp.esapi.codecs.MySQLCodec;

import java.sql.Connection;

public class esapi
{

    /**
     * 注意本函数不是对SQL做什么处理，而是对str做防止 SQL注入的处理
     * 比如 本来 str是一个ID值， 在SQL中，防止 被注入为    id='xxx' or 1=1 or ''
     *
     * @param con
     * @param str
     * @return
     */

    public static Codec mysqlCodec = new MySQLCodec(MySQLCodec.Mode.STANDARD);

    public static String encodeForSQL(String str)
    {
        String ret = ESAPI.encoder().encodeForSQL(mysqlCodec, str);

        ret = ret.replaceAll("(\\s)*", "");  //去掉所有的空格

        ret = ret.replaceAll("--", "");  //去掉所有的双减号，避免被注释掉条件

        return ret;

    }
}
