package util;

import app.User;
import config.CacheConfig;
import dfs.IFileServer;
import dfs.UploadFile;
import jun.db.impl.DataStoreFactory;
import org.json.JSONObject;
import webApp.App;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Date;

@WebServlet(name = "watermark", urlPatterns = "/watermark")
public class Watermark extends HttpServlet
{


    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
    {

        doPost(request, response);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException
    {

        req.setCharacterEncoding("UTF-8");

        /* 允许跨域的主机地址 */
        res.setHeader("Access-Control-Allow-Origin", "*");
        /* 允许跨域的请求方法GET, POST, HEAD 等 */
        res.setHeader("Access-Control-Allow-Methods", "*");
        /* 重新预检验跨域的缓存时间 (s) */
        res.setHeader("Access-Control-Max-Age", "36000");
        /* 允许跨域的请求头 */
        res.setHeader("Access-Control-Allow-Headers", "*");
        /* 是否携带cookie */
        res.setHeader("Access-Control-Allow-Credentials", "false");






        try( BufferedOutputStream bos = new BufferedOutputStream(res.getOutputStream());)
        {

            res.setContentType("text/html;charset = UTF-8");//很重要
            res.setCharacterEncoding("UTF-8");




            String extName = ".png";

            String mimeType = req.getSession().getServletContext().getMimeType(extName);
            if (mimeType == null) mimeType = "";
            if (mimeType.isEmpty()) mimeType = "APPLICATION/OCTET-STREAM";

            res.setContentType(mimeType);

            //如果大于20，可能会问题

            //   if (fileName.length() > 20) fileName = fileName.substring(fileName.length() - 20, fileName.length());
            //	  这个很重要，不然文件名称会乱码  *2
            String fileName = "watermark.png";
            //如果是预览，那么不要设置文件名称，不然就成了下载，而不是直接在浏览器中打开

            res.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");

            String watermark = FF.getStringFromRequest(req, "watermark", new Date().toString());
            String path= App.FileRoot + "/temp/";
            FF.MkDirs(path);
            String file = PDF_addstamp.createImage(watermark, path);



            try( BufferedInputStream bis =new BufferedInputStream(Files.newInputStream(Paths.get(file)));)
            {
                int once = 32768;
                byte buffer[] = new byte[once];
                int actually = 0;

                while (true)
                {
                    actually = bis.read(buffer);
                    if (actually <= 0) break;
                    bos.write(buffer, 0, actually);

                }

                bis.close();
                bos.flush();
                bos.close();

                FF.log("下载文件完成");

                FF.deleteFile(file);
            }catch(Exception e)
            {
                FF.log(FF.exceptionMessage(e));
            }


        } catch (Exception e)
        {

            //res.sendRedirect("../SystemTip.jsp?info="+  URLEncoder.encode("文件下载发生错误","UTF-8")  );
            //在之前，已经做了res.setHeader，bos.write等操作，此时出现异常可能是连接断开之类的异常，
            //那么在这个 exception 的处理中再 res.sendRedirect 就会出现
            // illegeStateException (因为你已经commit了res),这里的异常直接忽略就可以了.

            FF.log("下载异常：" + e.getMessage());


        }

    }

}
