package util;

import org.junit.jupiter.api.Test;
import util.FF;

import java.net.URLEncoder;
import java.util.*;

public class URLUtil
{


    public static String   URLEncoder(String url)
    {
        String pureUrl= getBaseURL(url);
        String params= getParameterStringOfURL(url);
        LinkedHashMap<String ,String> paramMap =  splitParameter(  params);
        Iterator it = paramMap.keySet().iterator();
        StringBuffer ret = new StringBuffer(1024);
        ret.append(pureUrl);

        for(boolean isFirst = true; it.hasNext(); isFirst = false) {
            String pName = (String)it.next();
            String pValue = (String)paramMap.get(pName);

            try {
                pValue = FF.replaceAll(pValue, " ", FF.spaceToken);
                if (!pValue.isEmpty()) {
                    //避免反复 encode 引起地址无法在浏览器中访问
                    if( ! hasUrlEncoded(pValue))  pValue = URLEncoder.encode(pValue, "UTF-8");
                }
            } catch (Exception e) {
                FF.log (" URLUtil.URLEncoder异常：url=" + url + "  错误：" + e.getMessage());
                pValue =  paramMap.get(pName);
            }

            ret.append(isFirst ? "?" : "&");
            ret.append(pName).append("=").append(pValue);
        }

        return ret.toString();
    }

    /**
     * 拆分出基本的URL，去掉参数
     * @param url
     * @return
     */
    public static String  getBaseURL(String url)
    {
        url=url.trim();
        int p=url.indexOf("?");
        if( p<0) return url;
        return url.substring(0,p);
    }

    /**
     * 拆分出参数
     * @param url
     * @return
     */
    public static String  getParameterStringOfURL(String url)
    {
        url=url.trim();
        int p=url.indexOf("?");
        if( p<0) return url;
        return url.substring( p+1);
    }

    /**
     * 拆分出参数。按原始的参数顺序，返回一个map
     * @param param
     * @return
     */
    public static LinkedHashMap<String ,String>  splitParameter(String param)
    {
        if( param.indexOf("?")>0)  param= param.substring( param.indexOf("?")+1);
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();

        String[] s = param.split("[&]");
        for (String t : s)
        {
            int p = t.indexOf("=");
            if (p < 0) continue; //有错
            String k = t.substring(0, p );
            String v = t.substring(p + 1);
            ret.put(k, v);
        }

        return ret;
    }

    /**
     * 拆分出参数。按参数名排序 返回一个map
     * @param param
     * @return
     */
    public static String  rebuildParameterToSorted (String param)
    {
        SortedMap<String, String> sm = new TreeMap<String, String>();

        String[] s = param.split("[&]");
        for (String t : s)
        {
            int p = t.indexOf("=");
            if (p < 0) continue; //有错
            String k = t.substring(0, p );
            String v = t.substring(p + 1);
            sm.put(k, v);
        }

        StringBuffer sb= new StringBuffer(1024);

        Set es = sm.entrySet();
        Iterator it = es.iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry) it.next();
            String k = (String) entry.getKey();
            String v = (String) entry.getValue();
            if( sb.length()>0) sb.append("&");
            sb.append(k + "=" + v  );

        }

        return sb.toString();
    }


    private static BitSet dontNeedEncoding;

    static {
        dontNeedEncoding = new BitSet(256);
        int i;
        for (i = 'a'; i <= 'z'; i++) {
            dontNeedEncoding.set(i);
        }
        for (i = 'A'; i <= 'Z'; i++) {
            dontNeedEncoding.set(i);
        }
        for (i = '0'; i <= '9'; i++) {
            dontNeedEncoding.set(i);
        }
        dontNeedEncoding.set('+');
        /**
         * 这里会有误差,比如输入一个字符串 123+456,它到底是原文就是123+456还是123 456做了urlEncode后的内容呢？<br>
         * 其实问题是一样的，比如遇到123%2B456,它到底是原文即使如此，还是123+456 urlEncode后的呢？ <br>
         * 在这里，我认为只要符合urlEncode规范的，就当作已经urlEncode过了<br>
         * 毕竟这个方法的初衷就是判断string是否urlEncode过<br>
         */

        dontNeedEncoding.set('-');
        dontNeedEncoding.set('_');
        dontNeedEncoding.set('.');
        dontNeedEncoding.set('*');
        //实践证明，下面的几个字符也不会被编码
        dontNeedEncoding.set('!');
        dontNeedEncoding.set('(');
        dontNeedEncoding.set(')');

    }


    /**
     * 判断str是否urlEncoder.encode过<br>
     * 经常遇到这样的情况，拿到一个URL,但是搞不清楚到底要不要encode.<Br>
     * 不做encode吧，担心出错，做encode吧，又怕重复了<Br>
     *
     * @param str
     * @return
     */
    public static boolean hasUrlEncoded(String str) {

        /**
         * 支持JAVA的URLEncoder.encode出来的string做判断。 即: 将' '转成'+' <br>
         * 0-9a-zA-Z保留 <br>
         * '-'，'_'，'.'，'*'保留 <br>
         * 其他字符转成%XX的格式，X是16进制的大写字符，范围是[0-9A-F]
         */
        boolean needEncode = false;
        for (int i = 0; i < str.length(); i++) {
            char c = str.charAt(i);
            if (dontNeedEncoding.get((int) c)) {
                continue;
            }
            if (c == '%' && (i + 2) < str.length()) {
                // 判断是否符合urlEncode规范
                char c1 = str.charAt(++i);
                char c2 = str.charAt(++i);
                if (isDigit16Char(c1) && isDigit16Char(c2)) {
                    continue;
                }
            }
            // 其他字符，肯定需要urlEncode
            needEncode = true;
            break;
        }

        return !needEncode;
    }

    /**
     * 判断c是否是16进制的字符
     *
     * @param c
     * @return
     */
    private static boolean isDigit16Char(char c) {
        return (c >= '0' && c <= '9') || (c >= 'A' && c <= 'F');
    }

    public static void main(String[] arg)
    {
        String t= "fileServer?bucketName=default&objectName=凭证归档/202107/210700008[v5].pdf&fileName=210700008.pdf&serverIndex=1&action=view";

        System.out.println( t );


        t=URLEncoder(t);
        System.out.println( t );

        t=URLEncoder(t);
        System.out.println( t );
        t=URLEncoder(t);
        System.out.println( t );

    }

}
