/*
 * 创建日期: 2006-12-19
 *
 * 
 *  
 * 功能描述：
 *
 */

package util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.zip.Deflater;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;

public class StringZIP
{

	public static String zip(String str)
	{

		if (str == null || str.length() == 0) {
			return str;
		}
		try
		{
			ByteArrayOutputStream out = new ByteArrayOutputStream();
			GZIPOutputStream gzip = new GZIPOutputStream(out);
			gzip.write(str.getBytes("UTF-8"));
			gzip.close();
			out.close();
 			String ret = new String(jun.db.util.Base64Coder.encode( out.toByteArray()) );
			return ret;
		}catch(Exception e)
		{
			FF.log(e);
			return str;
		}
	}
	
	
	public static String unzip( String str )
	{
		if (str == null || str.length() == 0) {
			return str;
		}
		try
		{
			byte[] bs = jun.db.util.Base64Coder.decode(str.toCharArray());
			ByteArrayOutputStream out = new ByteArrayOutputStream();
			ByteArrayInputStream in = new ByteArrayInputStream(bs);
			GZIPInputStream gunzip = new GZIPInputStream(in);
			byte[] buffer = new byte[256];
			int n;
			while ((n = gunzip.read(buffer)) >= 0)
			{
				out.write(buffer, 0, n);
			}

			out.close();
			gunzip.close();
			return out.toString("UTF-8");
		}catch(Exception e)
		{
			FF.log(e);
			return str;
		}

		 
	}

}
