package util;

import org.json.JSONObject;
import websocketRPC.WSRPC;

import javax.servlet.http.HttpServletRequest;

public class Session
{

    /**
     * 注意， 设置键时，必须是广播
     * @param key
     * @param value
     * @return
     */
    public static String setCache(String key, String value)
    {
        try
        {
            JSONObject ret= WSRPC.dispatch("sso", "api.SessionManage", "setCache",
                                           new JSONObject().put("key", key).put("value", value), null, null, true, 30);
            if (ret.getBoolean("success",true)) return "";
            return ret.getString("message","");
        }catch(Exception e)
        {
            return e.getMessage();
        }

    }

    public static String renewal(HttpServletRequest request )
    {

        try
        {
            JSONObject ret= WSRPC.dispatch("sso", "api.SessionManage", "renewal",
                                           new JSONObject()  , request, null, true, 30);
            if (ret.getBoolean("success",true)) return "";
            return ret.getString("message","");
        }catch(Exception e)
        {
            return e.getMessage();
        }

    }


    /**
     * 注意，读取键时，必须不能是广播
     * @param key
     * @param defaultValue
     * @return
     */
       public static String getCache(String key, String defaultValue)
    {
        try
        {
            JSONObject ret=WSRPC.dispatch("sso", "api.SessionManage", "getCache",
                                             new JSONObject().put("key", key), null, null,
                                             false,//读取键时，必须不能是广播
                                             30);

            if(! ret.getBoolean("success",false))
            {
                FF.log(" Session.getCache  error: " +  ret.getString("message",""));
            }
            return ret.getString("value","");
        }catch(Exception e)
        {

            return e.getMessage();
        }

    }


    public static boolean isArchitect(int userid )
    {
        try
        {
            JSONObject ret=WSRPC.dispatch("sso", "api.SessionManage", "isArchitect",
                                             new JSONObject().put("userid", userid), null, null,
                                             false,//读取键时，必须不能是广播
                                             10);

            return ret.getBoolean( "isArchitect",false);
        }catch(Exception e)
        {
            FF.log(  e.getMessage());
            return false;
        }

    }


    /**
     *  注意，删除键时，必须是广播
     * @param key
     * @return
     */
    public static String removeCache(String key  )
    {
        try
        {
            JSONObject ret=WSRPC.dispatch("sso", "api.SessionManage", "removeCache",
                                             new JSONObject().put("key", key), null, null, true, 10);
            if (ret.getBoolean("success",true)) return "";
            return ret.getString("message","");
        }catch(Exception e)
        {
            return e.getMessage();
        }
    }



}
