package util;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import nettyrpc.manage.RPCServerInfo;
import org.json.JSONObject;
import webApp.App;

import java.util.ArrayList;
import java.util.List;

/**
 * 从 Eureka中获取服务的信息
 */
public class ServiceUtil  extends RPCBase
{


    public static final String  COMMON_SERVICE_PORT="common_service_port";
    public static final String  COMMON_SERVICE_HOST="common_service_host";

    @Override
    public boolean mustLogin(String method, JSONObject param)
    {
        return false;
    }

    /**
     * 得到 的是确保能访问的 zbus服务器地址 ，因为地址 是有缓存的， 使用前要判断一下服务是否可达
     * @param serviceName
     * @return
     */
    public static ArrayList<ServiceInfo> getAllServerInfoForService(  String serviceName)
    {
        ArrayList<ServiceInfo> ret = new ArrayList<ServiceInfo>();
        try
        {
            String vipAddress = serviceName; //需要调用的服务的名称

            List<InstanceInfo> serverInfoList = App.eurekaClient.getInstancesByVipAddress(vipAddress, false); //非加密方式

            for (InstanceInfo nextServerInfo : serverInfoList)
            {
                //检查服务的状态是不是有效的

                String healthCheckURL = nextServerInfo.getHealthCheckUrl();
                //  FF.log(healthCheckURL +"检查是否正常");
                if (!FF.getStringFromURL(healthCheckURL, "UTF-8").equals("ok"))
                {
                    FF.log("服务：" + healthCheckURL + "似乎无法访问。继续找下一个可用的服务器");
                    continue;
                }

                    //得到了一个可用的，经过检测的服务地址


                String ip = (String)nextServerInfo.getMetadata().get(COMMON_SERVICE_HOST);   //  nextServerInfo.getIPAddr();
                int port = FF.String2Int(nextServerInfo.getMetadata().get(COMMON_SERVICE_PORT));
                ret.add(new ServiceInfo(ip, port));
            }
        }catch (Exception e)
        {
            FF.log( "getAllServerInfoForService中发生异常："+e.getMessage());
            ret.add(new ServiceInfo("localhost", 8080));
        }
        return ret;
    }


    /**
     * 得到服务所有的地址，不验证它是否可用
     *
     * @param serviceName
     * @return
     * @throws Exception
     */
    public static ArrayList<String> getAllHomeURLForService(String serviceName) throws Exception
    {
        ArrayList<String> urls = new ArrayList<String>();
        String vipAddress = serviceName; //需要调用的服务的名称

        List<InstanceInfo> serverInfoList = App.eurekaClient.getInstancesByVipAddress(vipAddress, false); //非加密方式

        for (InstanceInfo nextServerInfo : serverInfoList)
        {
            //检查服务的状态是不是有效的
            String healthCheckURL = nextServerInfo.getHealthCheckUrl();

            String serviceHomePageURL = nextServerInfo.getHomePageUrl();
            urls.add(serviceHomePageURL);
        }
        return urls;
    }

    /**
     * 得到一个可用的服务的地址
     *
     * @param serviceName
     * @return
     * @throws Exception
     */
    public static String getHomeURLForService(String serviceName) throws Exception
    {
        String vipAddress = serviceName; //需要调用的服务的名称

        InstanceInfo nextServerInfo = null;



        while (true)
        {
            try
            {
                nextServerInfo = App.eurekaClient.getNextServerFromEureka(vipAddress, false); //非加密方式
            } catch (Exception e)
            {
                //FF.log("无法从eureka中获取 " + vipAddress + "服务信息");
                //String ret = "http://localhost:" + FF.getTomcatPort() + "/" + serviceName;
                //FF.log("服务 可能还在注册中，先返回一个猜测的地址 " + ret);
                //return ret;
                throw new Exception("无法获取服务" + serviceName);

            }



            if (nextServerInfo == null) throw new Exception(serviceName + "不存在");
            //检查服务的状态是不是有效的

            String healthCheckURL = nextServerInfo.getHealthCheckUrl();
            //  FF.log(healthCheckURL +"检查是否正常");
            if (!FF.getStringFromURL(healthCheckURL, "UTF-8").equals("ok"))
            {
                FF.log("服务：" + healthCheckURL + "似乎无法访问。继续找下一个可用的服务器");
                nextServerInfo = null;

            }
            else
            {
                //得到了一个可用的，经过检测的服务地址，那退出循环，开始做正事
                break;
            }


        }

        if (nextServerInfo == null) throw new Exception("无法获取提供正常服务的" + serviceName);
        String serviceHomePageURL = nextServerInfo.getHomePageUrl();
        return serviceHomePageURL;
    }


    public static boolean   serviceIsReady(String service)
    {
        try
        {
            String url=getHomeURLForService(service);
            return !url.isEmpty();

        }catch (Exception e)
        {
            return false;
        }
    }


    public JSONObject getServiceHomeURL(JSONObject param)
    {
        JSONObject ret = new JSONObject("{success:true}");
        String service= param.getString("service","");
        try
        {
            ret.put("value", ServiceUtil.getHomeURLForService(service));
        }catch (Exception e)
        {
            ret.put("value", e.getMessage());
        }
        return ret;
    }

}
