package util;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.common.comm.Protocol;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import config.CacheConfig;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class SMSService
{


    public static boolean isSendSMSEnabled()
    {
        if (CacheConfig.get("/短信服务/短信验证码服务/enabledonserver", "false").equals("true"))
        {
            String scriptcodeonserver = CacheConfig.get("/短信服务/短信验证码服务/scriptcodeonserver", "");
            if (!scriptcodeonserver.isEmpty()) return true;
        }
        if (CacheConfig.get("/短信服务/华为云短信验证码服务/enabled", "false").equals("true")) return true;

        if (CacheConfig.get("/短信服务/阿里云短信验证码服务/enabled", "false").equals("true")) return true;

        return false;

    }

    public static String sendSMS(String tel, String code)
    {

        if (CacheConfig.get("/短信服务/短信验证码服务/enabledonserver", "false").equals("true"))
        {
            String scriptcodeonserver = CacheConfig.get("/短信服务/短信验证码服务/scriptcodeonserver", "");
            if (scriptcodeonserver.isEmpty()) return "没有指定短信验证码服务由哪个脚本提供";
            try
            {
                Object o = FF.runScript(scriptcodeonserver, new JSONObject().put("mobile", tel).put("code", code),
                                        FF.EHR, null);
                if (o == null) return "null";
                return o.toString();
            } catch (Exception e)
            {
                FF.log(FF.exceptionMessage(e));
                return FF.exceptionMessage(e);
            }

        }

        //华为云短信接入
        if (CacheConfig.get("/短信服务/华为云短信验证码服务/enabled", "false").equals("true"))
        {
            String accessKeyId = CacheConfig.get("/短信服务/华为云短信验证码服务/AccessKeyID", "");
            String accessKeySecurity = CacheConfig.get("/短信服务/华为云短信验证码服务/password", "");
            if (accessKeySecurity.startsWith("encryped:"))
            {
                accessKeySecurity = accessKeySecurity.substring(9);
                accessKeySecurity = FF.decryptString(accessKeySecurity);

            }
            String sender = CacheConfig.get("/短信服务/华为云短信验证码服务/sender", "");
            String signName = CacheConfig.get("/短信服务/华为云短信验证码服务/signName", "");
            String templateid = CacheConfig.get("/短信服务/华为云短信验证码服务/templateid", "");
            String callbackURL = CacheConfig.get("/短信服务/华为云短信验证码服务/callbackurl", "");

            return SMSService_huawei.sendSMS(accessKeyId, accessKeySecurity, sender, templateid, signName, tel, code, callbackURL);

        }


        //阿里里云接入
        if (CacheConfig.get("/短信服务/阿里云短信验证码服务/enabled", "false").equals("false"))
            return "验证码短信功能未启用";
        String accessKeyId = CacheConfig.get("/短信服务/阿里云短信验证码服务/AccessKeyID", "");
        String accessKeySecurity = CacheConfig.get("/短信服务/阿里云短信验证码服务/password", "");
        if (accessKeySecurity.startsWith("encryped:"))
        {
            accessKeySecurity = accessKeySecurity.substring(9);
            accessKeySecurity = FF.decryptString(accessKeySecurity);

        }

        String signName = CacheConfig.get("/短信服务/阿里云短信验证码服务/signName", "");
        String templateid = CacheConfig.get("/短信服务/阿里云短信验证码服务/templateid", "");

        DefaultProfile profile = DefaultProfile.getProfile("cn-hangzhou", accessKeyId, accessKeySecurity);
        IAcsClient client = new DefaultAcsClient(profile);

        CommonRequest request = new CommonRequest();
        request.setSysMethod(MethodType.POST);
        request.setSysDomain("dysmsapi.aliyuncs.com");
        request.setSysVersion("2017-05-25");
        request.setSysAction("SendSms");
        request.putQueryParameter("PhoneNumbers", tel);
        request.putQueryParameter("SignName", signName);
        request.putQueryParameter("TemplateCode", templateid);
        request.putQueryParameter("TemplateParam", "{\"code\":\"" + code + "\"}");
        try
        {
            CommonResponse response = client.getCommonResponse(request);
            return response.getData();
        } catch (Exception e)
        {
            return FF.exceptionMessage(e);
        }

    }


    public static String sendSMS(String sign, String templateid, String tel, String p, String sender)
    {


        if (CacheConfig.get("/短信服务/短信验证码服务/enabledonserver", "false").equals("true"))
        {
            FF.log("使用脚本代理发送短信");
            String scriptcodeonserver = CacheConfig.get("/短信服务/短信验证码服务/scriptcodeonserver", "");
            if (scriptcodeonserver.isEmpty()) return "没有指定短信验证码服务由哪个脚本提供";
            try
            {
                Object o = FF.runScript(scriptcodeonserver, new JSONObject().put("mobile", tel).put("param", p).put("sign", sign).put("templateid", templateid),
                                        FF.EHR, null);
                if (o == null) return "null";
                return o.toString();
            } catch (Exception e)
            {
                FF.log(FF.exceptionMessage(e));
                return FF.exceptionMessage(e);
            }

        }

        //华为云短信接入
        if (CacheConfig.get("/短信服务/华为云短信验证码服务/enabled", "false").equals("true"))
        {
            FF.log("使用华为云发送短信");
            String accessKeyId = CacheConfig.get("/短信服务/华为云短信验证码服务/AccessKeyID", "");
            String accessKeySecurity = CacheConfig.get("/短信服务/华为云短信验证码服务/password", "");
            if (accessKeySecurity.startsWith("encryped:"))
            {
                accessKeySecurity = accessKeySecurity.substring(9);
                accessKeySecurity = FF.decryptString(accessKeySecurity);

            }

            if (sender.isEmpty()) sender = CacheConfig.get("/短信服务/华为云短信验证码服务/sender", "");


            String callbackURL = CacheConfig.get("/短信服务/华为云短信验证码服务/callbackurl", "");

            return SMSService_huawei.sendSMS(accessKeyId, accessKeySecurity, sender, templateid, sign, tel, p, callbackURL);

        }


        //阿里里云接入
        if (CacheConfig.get("/短信服务/阿里云短信验证码服务/enabled", "false").equals("true"))
        {
            FF.log("使用阿里云短信服务");

            String accessKeyId = CacheConfig.get("/短信服务/阿里云短信验证码服务/AccessKeyID", "");
            String accessKeySecret = CacheConfig.get("/短信服务/阿里云短信验证码服务/password", "");
            String proxyAddress = CacheConfig.get("/短信服务/阿里云短信验证码服务/httpproxyaddress", "");
            String proxyPort = CacheConfig.get("/短信服务/阿里云短信验证码服务/httpproxyport", "");
            String httpProxyUserName = CacheConfig.get("/短信服务/阿里云短信验证码服务/httpproxyusername", "");
            String httpProxyPassword = CacheConfig.get("/短信服务/阿里云短信验证码服务/httpproxypassword", "");
            String endpoint = CacheConfig.get("/短信服务/阿里云短信验证码服务/endpoint", "");


            if (accessKeySecret.startsWith("encryped:"))
            {
                accessKeySecret = accessKeySecret.substring(9);
                accessKeySecret = FF.decryptString(accessKeySecret);

            }

            try
            {


                // 示例1：不使用代理
                AliyunSmsSender smsSender;

                if (!proxyAddress.isEmpty() && !proxyPort.isEmpty())
                {
                    Map<String, Object> proxyConfig = new HashMap<>();
                    proxyConfig.put("host", proxyAddress);
                    proxyConfig.put("port", proxyPort);
                    if (!httpProxyUserName.isEmpty())
                    {
                        proxyConfig.put("username", httpProxyUserName);
                        proxyConfig.put("password", httpProxyPassword);
                    }

                    smsSender = new AliyunSmsSender(accessKeyId, accessKeySecret,null, proxyConfig);

                }
                else
                {
                    smsSender = new AliyunSmsSender(accessKeyId, accessKeySecret,endpoint);
                }

                SendSmsResponse response = smsSender.sendSms(
                        tel,
                        sign,
                        templateid,
                        p
                );


                JSONObject ret = new JSONObject().put("Code", response.getCode())
                        .put("Message", response.getMessage());
                return ret.toString();
            } catch (Exception e)
            {

                FF.log("短信发送异常：");
                FF.log(e.getClass().getName());
                FF.log(e.getMessage());

                JSONObject ret = new JSONObject().put("Code", "error")
                        .put("Message", FF.exceptionMessage(e));
                return ret.toString();
            }
        }

        FF.log("验证码短信功能未启用");
        return new JSONObject().put("Code", "error").put("message", "验证码短信功能未启用").toString();


    }


}