package util;


import app.User;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.shared.Application;
import jun.db.impl.DataStoreFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import rpc.NeedRPCLog;
import webApp.App;

import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by zengjun on 2017/9/4.
 * <p>
 * 2017.09
 * 创建实例，仍是使用 Class.forName ,可以考虑使用common-pool 对象池的方式进行缓存，
 * <p>
 * 对象的方法，首次调用通过反射进制查询 ，  之后放入本地JVM缓存中。因为method 是java的对象，不适合
 * 放入到redis中缓存，所以使用的是本地的 ConcurrentHashMap 中
 */
@WebServlet(name = "RPCRouter2", urlPatterns = "/RPCRouter2")
public class RPCRouter2 extends HttpServlet
{

    private static String HomeURL = "";
    private static EurekaClient eurekaClient = null; //用来查询其它服务
    private static String virtualHostName = ""; // 所在应用提供的eureka服务的名称
    private static String hostIPAddress = ""; //所在应用的地址
    private static ConcurrentHashMap<String, Method> classMethodMap = new ConcurrentHashMap<String, Method>();
    private static ConcurrentHashMap<String, Boolean> methodNeedLog = new ConcurrentHashMap<String, Boolean>();

    private final static String flatReturn = "jun_only_return_flat_string";

    /*
        HttpClient在并发量高的时候，可能会出现连接池不够用的情况，可以通过配置总体最大连接池（maxConnTotal）
        和单个路由连接最大数（maxConnPerRoute），默认是(20，2)
        maxConnTotal 和 maxConnPerRoute 的区别？
        maxConnTotal 是整个连接池的大小，根据自己的业务需求进行设置
        maxConnPerRoute 是单个路由连接的最大数，可以根据自己的业务需求进行设置
            比如maxConnTotal =200，maxConnPerRoute =100，那么，如果只有一个路由的话，那么最大连接数也就是100了；
            如果有两个路由的话，那么它们分别最大的连接数是100，总数不能超过200
       */

    //2019.11.29 下面的几个超时时间，有点搞不清楚，后面统一使用传入的参数 timeoutSecond * 1000 来控制
    // 下面几个超时的设置已经无用，暂时留着
    private static int socketTimeout = 60000;
    private static int connectTimeout = 60000;
    private static int connectionRequestTimeout = 60000;
    private static int maxConnTotal = 200;   //最大不要超过1000
    private static int maxConnPerRoute = 100;//实际的单个连接池大小，如tps定为50，那就配置50


    private final String CONTENT_TYPE = "text/html;charset=UTF-8";

    public static void init(String homeURL, EurekaClient client, String vipName, String hostIP)
    {
        HomeURL = homeURL;
        eurekaClient = client;
        //当需要调用其它服务时，需要把自身的信息传递过去做权限控制
        virtualHostName = vipName;
        hostIPAddress = hostIP;

    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
    {


        String paramString = getStringFromServletInputStream(request.getInputStream());
        JSONObject ret = dispatch(paramString, request, response, 300);  //120秒超时
        String retValue = "";

        try
        {
            response.setContentType(CONTENT_TYPE);


            if (ret instanceof JSONObject)
            { //当返回的数据很大时，在客户端解析json会花时间
                //如果强制返回平面数据，而不是JSON格式的数据，那么
                retValue = ((JSONObject) ret).getString(RPCBase.flatReturn, "");
            }
            if (retValue.isEmpty()) retValue = ret.toString();


        } catch (Exception e)
        {
            ret.put("success", false);
            ret.put("message", e.getMessage());
            retValue = ret.toString();

        } finally
        {

        }

        response.getWriter().print(retValue);


    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
    {
        response.setContentType(CONTENT_TYPE);
        response.getWriter().write("仅能以Post方式调用");
    }


    private static JSONObject RPC(HttpServletRequest req, HttpServletResponse res, String serviceName,
                                  String className, String methodName, JSONObject param)
    {

        JSONObject ret = null;
        Object rpc = null;
        try
        {
            //创建对象实例
            rpc = Class.forName(className).newInstance();
            ((RPCBase) rpc).init(req, res);

            String methodFullName = className + "." + methodName;

            String err = ((RPCBase) rpc).rightVerify(methodFullName, param);
            if (!err.isEmpty()) throw new Exception(err);

            Method m = classMethodMap.get(methodFullName);


            if (m == null)
            {
                Class c = rpc.getClass();
                m = c.getMethod(methodName, new Class[]{JSONObject.class});
                classMethodMap.put(methodFullName, m);

                for (Annotation annotation : m.getDeclaredAnnotations())
                {
                    if (annotation instanceof NeedRPCLog)
                    {
                        methodNeedLog.put(methodFullName, true);
                        break;
                    }
                }
            }

            ret = (JSONObject) m.invoke(rpc, new Object[]{param});
            if (ret == null)
            {
                ret = new JSONObject();
                ((JSONObject) ret).put("success", true);
                ((JSONObject) ret).put("message", "");
            }
            //如果有NeedRPCLog注解在方法上，那么才记录日志 ，避免日志过多
            if( methodNeedLog.containsKey( methodFullName) )  RpcCallLog(req, className, methodName, param, "");

        } catch (Exception e)
        {
            FF.log(e.getMessage());
            ret = new JSONObject();

            ((JSONObject) ret).put("success", false);
            ((JSONObject) ret).put("message", e.getMessage());

        } finally
        {

            ((JSONObject) ret).put("rpcCallTimestamp", System.currentTimeMillis());

        }

        return ret;
    }

    public static JSONObject dispatch(String serviceName, String className, String methodName, JSONObject param, HttpServletRequest req, HttpServletResponse res, boolean broadcast) throws ServletException, IOException
    {
        return dispatch(serviceName, className, methodName, param, req, res, broadcast, 300);

    }

    /**
     * 本函数并不在本类中调用，它是服务器上需要进行远程调用时，用本函数
     * 当  broadcast=true时，表示是广播模式，每个服务器都要执行， 此时返回值无意义，为null
     * 否则返回执行结果
     *
     * @param serviceName
     * @param className
     * @param methodName
     * @param param
     * @param req
     * @param res
     * @param broadcast
     * @return
     * @throws ServletException
     * @throws IOException
     */
    public static JSONObject dispatch(String serviceName, String className, String methodName, JSONObject param, HttpServletRequest req, HttpServletResponse res, boolean broadcast, int timeoutSecond) throws ServletException, IOException
    {

        if (serviceName.isEmpty()) return RPC(req, res, serviceName, className, methodName, param);

        JSONObject p = new JSONObject();

        p.put("classname", className);
        p.put("methodname", methodName);
        p.put("parameter", param);

        String paramString = p.toString();
        return dispatchToService(req, res, paramString, serviceName, className, methodName, param, broadcast, timeoutSecond);

    }


    private static JSONObject dispatch(String paramString, HttpServletRequest req, HttpServletResponse res, int timeoutSecond) throws ServletException, IOException
    {

        JSONObject param = null;
        JSONObject ret = null;


        JSONObject p = new JSONObject(paramString);

        String serviceName = p.getString("$servicename", "").trim();
        String className = p.getString("classname", "").trim();
        String methodName = p.getString("methodname", "").trim();
        param = p.getJSONObject("parameter", null);
        if (param == null) param = new JSONObject();


        if (!serviceName.isEmpty())
        {
            ret = dispatchToService(req, res, paramString, serviceName, className, methodName, param, false, timeoutSecond);
            return ret;
        }

        return RPC(req, res, serviceName, className, methodName, param);


    }

    private static JSONObject dispatchToService(HttpServletRequest req, HttpServletResponse res, String paramString,
                                                String serviceName, String className, String methodName, JSONObject param, boolean broadcast, int timeoutSecond)
    {

        try
        {
            if (broadcast)
            {
                ArrayList<String> serviceHomePageURLs = ServiceUtil.getAllHomeURLForService(serviceName);
                for (String serviceHomePageURL : serviceHomePageURLs)
                {
                    dispatchToService(req, res, paramString, serviceName, className, methodName, param, serviceHomePageURL, timeoutSecond);
                }
                return null;
            }
            else
            {
                String serviceHomePageURL = ServiceUtil.getHomeURLForService(serviceName);
                return dispatchToService(req, res, paramString, serviceName, className, methodName, param, serviceHomePageURL, timeoutSecond);
            }
        } catch (Exception e)
        {
            return new JSONObject().put("success", false).put("message", e.getMessage());
        }

    }

    public  static JSONObject dispatchToService(HttpServletRequest req, HttpServletResponse res, String paramString,
                                                String serviceName, String className, String methodName, JSONObject param, String serviceHomePageURL, int timeoutSecond)
    {


        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        HttpPost post = null;

        JSONObject ret = null;

        try
        {


            //直接把$servicename去掉，避免递归地远程调用，不用json.parse解析后的对象，再toString 是为了速度
            paramString = FF.replaceAll(paramString, "[$]servicename", "_servicename"); //避免重复的远程调用
            //如果服务就是自已，那么就不需要再走一次HttpPost了
            if (serviceHomePageURL.equalsIgnoreCase(HomeURL))
                return RPC(req, res, serviceName, className, methodName, param);

            RequestConfig config = RequestConfig.custom()
                    .setSocketTimeout(timeoutSecond * 1000)
                    .setConnectTimeout(timeoutSecond * 1000)
                    .setConnectionRequestTimeout(timeoutSecond * 1000).build();

            SSLContextBuilder builder = new SSLContextBuilder();
            builder.loadTrustMaterial(null, new TrustStrategy()
            {
                // 证书校验忽略
                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException
                {
                    return true;
                }
            });
            // 创建链接

            httpClient = HttpClients.custom().setSSLContext(builder.build())
                    .setSSLHostnameVerifier(NoopHostnameVerifier.INSTANCE)
                    .setDefaultRequestConfig(config)
                    .setMaxConnTotal(maxConnTotal)
                    .setMaxConnPerRoute(maxConnPerRoute).build();

            String url = serviceHomePageURL + "/RPCRouter?timestamp=" + DataStoreFactory.newGUID();
            post = new HttpPost(url);
            // 设置超时时间
            RequestConfig requestConfig = RequestConfig.custom()
                    .setConnectTimeout(timeoutSecond * 1000).setConnectionRequestTimeout(timeoutSecond * 1000)
                    .setSocketTimeout(timeoutSecond * 1000).build();
            post.setConfig(requestConfig);

            // 构造消息头
            post.setHeader("Content-Type", "text/html; charset=UTF-8");
            post.setHeader("charset", "UTF-8");
            //把用户信息传过去，注意是用cookie
            if (req != null)
            {
                String tokenId = FF.getTokenIdFromRequest(req);
                post.setHeader(FF.ENCRYPTED_TOKENID, FF.encryptString(tokenId));
                post.setHeader("rpcRouteRemoteAddr", req.getRemoteAddr()); //把调用者的IP地址也传过去

            }
            else
            {
                post.setHeader(FF.ENCRYPTED_TOKENID, "server");
                post.setHeader("rpcRouteRemoteAddr", App.IPADDRESS); //把调用者的IP地址也传过去
            }

            StringEntity myEntity = new StringEntity(paramString, "UTF-8");
            post.setEntity(myEntity);
            response = httpClient.execute(post);
            HttpEntity resultEntity = response.getEntity();
            if (resultEntity != null)
            {
                String responseText = EntityUtils.toString(resultEntity, "UTF-8");
                ret = new JSONObject(responseText);

            }
            else
            {
                ret = new JSONObject();
                ((JSONObject) ret).put("success", false).put("message", url + "返回null");
            }

        } catch (Exception e)
        {
            ret = new JSONObject();
            ((JSONObject) ret).put("success", false).put("message", e.getMessage());


        } finally
        {
            //@off
            if (response != null)  try{ response.close(); } catch (Exception e) { }
            // dbf.getConnection(); 为什么放这么莫名其秒的一句，是因为下面post的释放与dbf中的释放名称相同
            //在统计 getConnection与 releaseConnection出现次数，导到后者多了一次，所以增加这么一句来中合次数
            if (post != null)   try{post.releaseConnection();} catch (Exception e){}
            if (httpClient != null)   try{ httpClient.close();} catch (Exception e) { }
            //@on
        }

        return ret;


    }

    public static String getStringFromServletInputStream(ServletInputStream sis)
    {
        StringBuilder sb = new StringBuilder();
        InputStreamReader reader = null;
        char[] buff = new char[1024];
        int length = 0;
        try
        {
            reader = new InputStreamReader(sis, "UTF-8");
            while ((length = reader.read(buff)) != -1)
            {
                String s = new String(buff, 0, length);
                sb.append(s);
            }
        } catch (Exception e)
        {

        } finally
        {
            //@off
            try  {reader.close();   } catch (Exception e)  {  }
            //@on
        }


        return sb.toString();
    }


    static void RpcCallLog(HttpServletRequest request, String classname, String funcname, JSONObject param, Object sessionID) throws Exception
    {


        /*
        HashMap log= new HashMap();
		log.put( "address", request.getRemoteAddr());
		log.put( "classname", classname + "." + funcname);
		log.put("parameter", (param.length() > 200 ? param.substring(0, 200) : param));
		log.put( "calldate", new Date());
		log.put( "username", sessionID);

		RemoteScriptingLog.newLog(log);

		*/
        String ps= param.toString();
        if( ps.length()>100)  ps=ps.substring(0,100)+"...";

        FF.log("RPC:"+ request.getRemoteAddr()+"/"+classname+"."+funcname+"/"+ps+"/"+ User.getUserFromRequest(request).getName() );

    }

    private static String[] localIPs = FF.getAllIPAddress();

    public static boolean isOneOfServers(String ip)
    {

        if( ip.isEmpty()) return true;
        if (ip.equals("127.0.0.1")) return true;
        if (ip.equals("0:0:0:0:0:0:0:1")) return true;
        if (ip.equals("localhost")) return true;

        for (int i = 0; i < localIPs.length; i++)
        {
            if (localIPs[i].equals(ip)) return true;
        }

        List<Application> apps = eurekaClient.getApplications().getRegisteredApplications();

        for (int i = 0; i < apps.size(); i++)
        {
            Application one = apps.get(i);
            List<InstanceInfo> infos = one.getInstances();
            for (int j = 0; j < infos.size(); j++)
            {
                InstanceInfo info = infos.get(j);

                if (info.getIPAddr().equals(ip)) return true;
            }
        }

        return false;
    }


}


