package util;


import app.User;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.shared.Application;
import http.OkHttpUtil;
import jun.db.impl.DataStoreFactory;

import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.tomcat.jni.SSLContext;
import org.json.JSONObject;
import rpc.NeedRPCLog;
import webApp.App;
import websocketRPC.RPCInject;
import websocketRPC.WSRPC;
import websocketRPC.log.RPCLog;
import websocketRPC.log.RPCLogPool;

import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPOutputStream;

/**
 * Created by zengjun on 2017/9/4.
 * <p>
 * 2017.09
 * 创建实例，仍是使用 Class.forName ,可以考虑使用common-pool 对象池的方式进行缓存，
 * <p>
 * 对象的方法，首次调用通过反射进行查询 ，  之后放入本地JVM缓存中。因为method 是java的对象，不适合
 * 放入到redis中缓存，所以使用的是本地的 ConcurrentHashMap 中
 */
@WebServlet(name = "RPCRouter", urlPatterns = "/RPCRouter")
public class RPCRouter extends HttpServlet
{

    public static String HomeURL = "";
    private static EurekaClient eurekaClient = null; //用来查询其它服务
    private static String virtualHostName = ""; // 所在应用提供的eureka服务的名称
    private static String hostIPAddress = ""; //所在应用的地址
    private static ConcurrentHashMap<String, Method> classMethodMap = new ConcurrentHashMap<String, Method>();
    private static ConcurrentHashMap<String, String> methodNeedLog = new ConcurrentHashMap<String, String>();

    private final static String flatReturn = "jun_only_return_flat_string";

    /*
        HttpClient在并发量高的时候，可能会出现连接池不够用的情况，可以通过配置总体最大连接池（maxConnTotal）
        和单个路由连接最大数（maxConnPerRoute），默认是(20，2)
        maxConnTotal 和 maxConnPerRoute 的区别？
        maxConnTotal 是整个连接池的大小，根据自己的业务需求进行设置
        maxConnPerRoute 是单个路由连接的最大数，可以根据自己的业务需求进行设置
            比如maxConnTotal =200，maxConnPerRoute =100，那么，如果只有一个路由的话，那么最大连接数也就是100了；
            如果有两个路由的话，那么它们分别最大的连接数是100，总数不能超过200
       */


    private final String CONTENT_TYPE = "text/html;charset=UTF-8";

    public static void init(String homeURL, EurekaClient client, String vipName, String hostIP)
    {
        HomeURL = homeURL;
        eurekaClient = client;
        //当需要调用其它服务时，需要把自身的信息传递过去做权限控制
        virtualHostName = vipName;
        hostIPAddress = hostIP;

    }


    private void rpcTM(String info)
    {
        FF.log(info);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
    {


        String paramString = getStringFromServletInputStream(request.getInputStream());
        //1200秒超时，不太合理，但是出现过第三方的调用 需要20分钟的情况
        //这种情况应该让对方直接返回，然后再提供结果查询接口，循环查询结果来处理
        JSONObject ret = dispatch(paramString, request, response, 1200);
        String retValue = "";

      //  boolean $callInJava = ret.getBoolean("$callInJava", false);
        try
        {
          //  if (!$callInJava)
            response.setContentType(CONTENT_TYPE);
            response.setHeader("Pragma", "No-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Expires", "0");



            /* 允许跨域的主机地址 */
            response.setHeader("Access-Control-Allow-Origin", "*");
            /* 允许跨域的请求方法GET, POST, HEAD 等 */
            response.setHeader("Access-Control-Allow-Methods", "*");
            /* 重新预检验跨域的缓存时间 (s) */
            response.setHeader("Access-Control-Max-Age", "36000");
            /* 允许跨域的请求头 */
            response.setHeader("Access-Control-Allow-Headers", "*");
            /* 是否携带cookie */
            response.setHeader("Access-Control-Allow-Credentials", "true");

            //浏览器将CORS请求分为两类：简单请求（simple request）和非简单请求（not-simple-request）。
            // 非简单请求 会在正式通信之前，增加一次HTTP请求，称之为预检请求。浏览器会先发起OPTIONS方法到服务器，
            // 以获知服务器是否允许该实际请求。

            if(request.getMethod().equals("OPTIONS")){
                response.setStatus(HttpServletResponse.SC_OK);
                return;
            }
            // 经过以上处理，可以解决非同域前端的跨域调用问题。已实测通过



            if (ret instanceof JSONObject)
            { //当返回的数据很大时，在客户端解析json会花时间
                //如果强制返回平面数据，而不是JSON格式的数据，那么
               // if (!$callInJava)
                    retValue = ((JSONObject) ret).getString(RPCBase.flatReturn, "");
            }

            if ( /*!$callInJava && */ retValue.isEmpty()) retValue = ret.toString();


        } catch (Exception e)
        {
            ret.put("success", false);
            ret.put("message", e.getMessage());
            retValue = ret.toString();

        } finally
        {

        }

     /*   if ($callInJava)
        {
            //
            //   GZIPOutputStream gos = new GZIPOutputStream(response.getOutputStream());
            ObjectOutputStream os = new ObjectOutputStream(new BufferedOutputStream(response.getOutputStream()));
            os.writeObject(ret);
            os.flush();
            os.close();
            //   gos.close();
        }
        else

      */
        {
            response.getWriter().print(retValue);
        }


    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
    {
        response.setContentType(CONTENT_TYPE);
        response.getWriter().write("仅能以Post方式调用");
    }


    public static JSONObject RPC(HttpServletRequest req, HttpServletResponse res, String serviceName,
                                 String className, String methodName, JSONObject param)
    {

        TimeStamp tm = new TimeStamp(false);

        long startTime = System.currentTimeMillis();
        JSONObject ret = null;
        RPCBase rpc = null;

        try
        {
            //创建对象实例
            rpc = RPCClassBuilder.newInstance(className);

            ((RPCBase) rpc).init(req, res);

            tm.stamp("RPCRouter  forName 创建类实例 " + className);

            String methodFullName = className + "." + methodName;

            String err = ((RPCBase) rpc).rightVerify(methodFullName, param);
            if (!err.isEmpty()) throw new Exception(err);

            Method m = classMethodMap.get(methodFullName);

            tm.stamp("RPCRouter  get Method  " + methodFullName);

            if (m == null)
            {
                Class c = rpc.getClass();
                m = c.getMethod(methodName, new Class[]{JSONObject.class});
                classMethodMap.put(methodFullName, m);

                for (Annotation annotation : m.getDeclaredAnnotations())
                {
                    if (annotation instanceof NeedRPCLog)
                    {
                        methodNeedLog.put(methodFullName, ((NeedRPCLog) annotation).comment());
                        break;
                    }
                }

                tm.stamp("RPCRouter  扫描注解 ");

            }

            //2020.11.01 增加执行前注入
            if (RPCInject.injectAble(App.appName, className, methodName, "before"))
            {
                ret = RPCInject.beforeRPC(App.appName, className, methodName, param, req, res);
                if (ret != null)
                {
                    if (!ret.getBoolean("success", false))
                    {
                        tm.stamp(methodFullName + "执行前注入脚本返回:" + ret.toString() + "  执行终止");
                        return ret;
                    }
                }
            }

            ret = (JSONObject) m.invoke(rpc, new Object[]{param});
            tm.stamp("RPCRouter  执行调用完成  ");

            if (ret == null)
            {
                ret = new JSONObject();
                ((JSONObject) ret).put("success", true);
                ((JSONObject) ret).put("message", "");
            }


            if (RPCInject.injectAble(App.appName, className, methodName, "after"))
            {
                RPCInject.afterRPC(App.appName, className, methodName, param);
            }

            tm.stamp("全部完成 ");
            //如果有NeedRPCLog注解在方法上，那么才记录日志 ，避免日志过多
            if (methodNeedLog.containsKey(methodFullName))
            {
                RpcCallLog(req, methodFullName, param, methodNeedLog.get(methodFullName),tm.getCost());
            }


        } catch (Exception e)
        {
            FF.log(e.getMessage());
            ret = new JSONObject();

            ((JSONObject) ret).put("success", false);
            ((JSONObject) ret).put("message", e.getMessage());

        } finally
        {
            RPCClassBuilder.returnObject(rpc); //回归对象池，回归前会放弃对 rquest, response的引用
            long endTime = System.currentTimeMillis();
            ((JSONObject) ret).put("rpcCallTimestamp", endTime);
            ((JSONObject) ret).put("rpcCallCost", endTime - startTime);


        }

        return ret;
    }

    public static JSONObject dispatch(String serviceName, String className, String methodName, JSONObject param, HttpServletRequest req, HttpServletResponse res, boolean broadcast) throws ServletException, IOException
    {
        return dispatch(serviceName, className, methodName, param, req, res, broadcast, 1200);

    }

    /**
     * 本函数并不在本类中调用，它是服务器上需要进行远程调用时，用本函数
     * 当  broadcast=true时，表示是广播模式，每个服务器都要执行， 此时返回值无意义，为null
     * 否则返回执行结果
     *
     * @param serviceName
     * @param className
     * @param methodName
     * @param param
     * @param req
     * @param res
     * @param broadcast
     * @return
     * @throws ServletException
     * @throws IOException
     */
    public static JSONObject dispatch(String serviceName, String className, String methodName, JSONObject param, HttpServletRequest req, HttpServletResponse res, boolean broadcast, int timeoutSecond) throws ServletException, IOException
    {

        if (serviceName.isEmpty()) return RPC(req, res, serviceName, className, methodName, param);

        JSONObject p = new JSONObject();

        p.put("classname", className);
        p.put("methodname", methodName);
        p.put("parameter", param);

        String paramString = p.toString();
        return dispatchToService(req, res, paramString, serviceName, className, methodName, param, broadcast, timeoutSecond);

    }


    private static JSONObject dispatch(String paramString, HttpServletRequest req, HttpServletResponse res, int timeoutSecond) throws ServletException, IOException
    {

        JSONObject param = null;
        JSONObject ret = null;


        JSONObject p = new JSONObject(paramString);

        String serviceName = p.getString("$servicename", "").trim();
        String className = p.getString("classname", "").trim();
        String methodName = p.getString("methodname", "").trim();
        boolean $callInJava = p.getBoolean("$callInJava", false);

        param = p.getJSONObject("parameter", null);
        if (param == null) param = new JSONObject();


        //标记20200404  ,增加了判断  serveName 是不是本服务
        if (!serviceName.isEmpty() && !serviceName.equalsIgnoreCase(App.appName))
        {
            ret = dispatchToService(req, res, paramString, serviceName, className, methodName, param, false, timeoutSecond);
            ret.put("$callInJava", $callInJava);
            return ret;
        }

        ret = RPC(req, res, serviceName, className, methodName, param);
        ret.put("$callInJava", $callInJava);
        return ret;


    }

    private static JSONObject dispatchToService(HttpServletRequest req, HttpServletResponse res, String paramString,
                                                String serviceName, String className, String methodName, JSONObject param, boolean broadcast, int timeoutSecond)
    {

        return WSRPC.dispatch(serviceName, className, methodName, param, req, res, broadcast, timeoutSecond);


    }


    public static String getStringFromServletInputStream(ServletInputStream sis)
    {
        StringBuilder sb = new StringBuilder();
        InputStreamReader reader = null;
        char[] buff = new char[1024];
        int length = 0;
        try
        {
            reader = new InputStreamReader(sis, "UTF-8");
            while ((length = reader.read(buff)) != -1)
            {
                String s = new String(buff, 0, length);
                sb.append(s);
            }
        } catch (Exception e)
        {

        } finally
        {
            //@off
            try  {reader.close();   } catch (Exception e)  {  }
            //@on
        }


        return sb.toString();
    }


    public static void RpcCallLog(HttpServletRequest request, String fullfuncname, JSONObject param, String comment,long cost) throws Exception
    {
        String ps = param.toString();
        if (ps.length() > 1000) ps = ps.substring(0, 1000) + "......";

        FF.log("RPC:" + fullfuncname + "/" + ps);

        if (!RPCLogPool.needSave) return;

        User user = User.getUserFromRequest(request);


        RPCLogPool.push(new RPCLog(
                FF.getIpAddr(request),
                App.appName + "/" + fullfuncname,
                ps,
                new Date(),
                user.getShowName(),
                user.lastloginclientcode, user.getId(), comment ,cost)

        );


    }

    private static String[] localIPs = FF.getAllIPAddress();

    public static boolean isOneOfServers(String ip)
    {


        if (ip.isEmpty()) return true;
        if (ip.equals("127.0.0.1")) return true;
        if (ip.equals("0:0:0:0:0:0:0:1")) return true;
        if (ip.equals("localhost")) return true;


        for (int i = 0; i < localIPs.length; i++)
        {
            if (localIPs[i].equals(ip)) return true;
        }

        List<Application> apps = eurekaClient.getApplications().getRegisteredApplications();

        for (int i = 0; i < apps.size(); i++)
        {
            Application one = apps.get(i);
            List<InstanceInfo> infos = one.getInstances();
            for (int j = 0; j < infos.size(); j++)
            {
                InstanceInfo info = infos.get(j);

                if (info.getIPAddr().equals(ip)) return true;
            }
        }

        return false;


    }


}


