package util;

import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.PooledObjectState;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import webApp.App;

import java.util.concurrent.TimeUnit;

public class RPCClassFactory implements PooledObjectFactory<RPCBase>
{

    private String className;

    public RPCClassFactory(String className)
    {
        this.className = className;
    }

    @Override
    public PooledObject<RPCBase> makeObject()
    {
        try
        {

            Object rpc = null;
            rpc = Class.forName(className).newInstance();
            ((RPCBase)rpc).className= className;
            DefaultPooledObject ret = new DefaultPooledObject(rpc);
            return ret;

        } catch (Exception e)
        {
            FF.log("创建失败: " + e.getMessage());
        }
        return null;
    }


    @Override
    public void destroyObject(PooledObject<RPCBase> pooledObject) throws Exception
    {
        FF.log(className+"实例被销毁");
        RPCBase obj = pooledObject.getObject();
        obj.clear();
    }

    @Override
    public boolean validateObject(PooledObject<RPCBase> pooledObject)
    {
        return pooledObject.getState().compareTo(PooledObjectState.IDLE) == 0;
    }

    @Override
    public void activateObject(PooledObject<RPCBase> pooledObject) throws Exception
    {
        //  System.out.println("zbus 休息的消息发布者被激活");
    }

    @Override
    public void passivateObject(PooledObject<RPCBase> pooledObject) throws Exception
    {
        //  System.out.println(" zbus 消息发布者休息去了");
    }
}
