package util;

import io.zbus.mq.MqClient;
import mq_zbus.MessageProducerFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

import java.lang.reflect.Constructor;
import java.util.concurrent.ConcurrentHashMap;

public class RPCClassBuilder
{

     static ConcurrentHashMap<String, ObjectPool<RPCBase>> classPool = new ConcurrentHashMap<>();
  //  static ConcurrentHashMap<String, Constructor<?> > constructorPool = new ConcurrentHashMap<>();


    private static ObjectPool<RPCBase> getPool(String className)
    {
        if (classPool.containsKey(className)) return classPool.get(className);

        RPCClassFactory factory = new RPCClassFactory(className);

        GenericObjectPoolConfig config = new GenericObjectPoolConfig();

        int maxTotal = FF.getVMProperty("RPC_POOL_MAXTOTAL", 1000);
        int maxIdle = FF.getVMProperty("RPC_POOL_MAXIDLE", 10);

        int minIdle = FF.getVMProperty("RPC_POOL_MINIDLE", 1);

        int maxWaitMillis = FF.getVMProperty("RPC_POOL_MAXWAITMILLIS", -1); //-1 表示一直等


        config.setJmxNameBase(className + "_pool");
        config.setMaxTotal(maxTotal);
        config.setMaxIdle(maxIdle);
        config.setMinIdle(minIdle);
        config.setMaxWaitMillis(maxWaitMillis);

        config.setJmxEnabled(true);
        config.setJmxNamePrefix("RPC-CB");
        config.setJmxNameBase(className);

        ObjectPool<RPCBase> pool = new GenericObjectPool(factory, config);
        classPool.put(className, pool);
        return pool;

    }


    public static RPCBase newInstance(String className) throws Exception
    {
       /* Constructor<?> c=  constructorPool.get(className);
        if(c==null)
        {
            c = Class.forName(className).getDeclaredConstructor();
            constructorPool.put(className,c);
        }
        return (RPCBase)(  c.newInstance());

        */
        ObjectPool<RPCBase> pool = getPool(className);

        RPCBase rpc = pool.borrowObject();
        return rpc;

    }

    public static void returnObject( RPCBase obj)
    {

        String className= obj.className;
         try
         {
             ObjectPool<RPCBase> pool = getPool(className);
             obj.clear();
             pool.returnObject(obj);
         }catch (Exception e)
         {
             FF.log( className+" 的一个实例回归对象池失败 ，"+ FF.exceptionMessage(e));
         }

    }

}
