/*
 * 创建日期: 2007-7-19
 *
 *  
 * 功能描述：远程调用分发器
 *
 */

package util;

import app.User;

import org.json.JSONObject;
import org.slf4j.MDC;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.StringTokenizer;

public class RPCBase extends Throwable
{



    public static String flatReturn = "jun_only_return_flat_string";

    public HttpServletRequest request;
    public HttpServletResponse response;

    public String className="";

    public RPCBase()
    {

    }

    public static RPCBase newInstance(String className) throws  Exception
    {

        return  RPCClassBuilder.newInstance(className);
    }

    public static void returnObject( RPCBase obj)
    {
        RPCClassBuilder.returnObject( obj);
    }

    public void init(HttpServletRequest req, HttpServletResponse res )
    {
        request = req;
        response = res;

    }

    public void  clear()
    {
        request=null;
        response=null;
    }


    public final String   rightVerify ( String method, JSONObject param)
    {

        //2019.12.27 想把下面的去掉，但是直接运行到 [标记20191227-1]，
        //如果控制只能在服务器上执行，那么要检测一下请求方所在的IP地址是不是注册过的Eureka服务器

        if( method.indexOf("removeLocalFormCache") >=0)
        {
            int a;
            a=1;
        }


        if( mustCalledOnOneOfServers(method, param))
        {

            //在集群中部署时，下面的处理可能不准确，取消了这个控制

            /*
            String ip= param.getString("${rpcRouteRemoteAddr}$","",true);
            if( ip.isEmpty() && request!=null) ip=request.getHeader("rpcRouteRemoteAddr");//可能是网页调用传用服务器，然后由服务器转的，所以要取得原始的调用方，看看它来自何处
            if(ip==null) ip="";
            //有些接口，是允许网页中调用的，有些不能，所以要取得最初的调用者
            if( ip.isEmpty() && request!=null) ip=FF.getClientIpAddr(  request);
            if( !RPCRouter.isOneOfServers( ip))
            {
               return  method+"必须在服务器间调用，"+ip+"不是服务器" ;

            }
            */

            //通常而言，只能在注册服务器之间调用的，通常是服务器这间的功能调用 ，这个就不需要校验用户了，
            //通常以性能为第一考虑
            // 把这里注释掉后，出现了无法找到服务的情况，说明在启动中，一些调用它是服务间的调用，此时还没有用户登录信息
            //如果这里中直接return掉，下面的对用户信息的校验 ，就过不去，因为可能服务尚在启动中，无法获取用户信息
            // 会出现 无法连接  sso 服务，因为此时 sso还没有启完成 。

            return "";
        }

        // [标记20191227-1]

        if( mustLogin(method, param))
        {
            if( request==null)
            {
                return (method+"必须是登录后才能执行，但是被执行时 request =null ");

            }

            User   user = User.getUserFromRequest(request);

            if (user.getId() < 0)
            {
                stackTrace();
              return (method+"必须是登录后才能执行");

            }

            if (mustBeSysUser(method, param))
            {

                if (!user.isSysUser())
                {
                    return (method+"必须是有系统管理权限的人员才能执行");

                }
            }

            if (mustBeGroupMaster(method, param))
            {

                if (!user.isGroupMaster())
                {
                    return (method+"必须是部门管理员才能执行");

                }
            }



        }


        String err=verify( method, param);
        if(!err.isEmpty())
        {

                return (method+err);

        }


        //如果允许
        if( canVerifyByScript(method, param))
        {
            if (!rightVerifyByScript(method, param))
            {
                return (method + "在系统脚本中被控制为不允许执行");

            }
        }

        boolean b= methodRightVerify(method ,param);
        if(!b) return "method 被脚本控制了权限";
        return "";
    }

    public void stackTrace()
    {

        try
        {

            ByteArrayOutputStream b = new ByteArrayOutputStream();
            PrintStream pw = new PrintStream(b);
            printStackTrace(pw);
            // FF.log( b.toString());
            StringTokenizer stk = new StringTokenizer(b.toString(), "\n");
            int n = 0;
            while (stk.hasMoreElements())
            {
                String t = stk.nextToken();
                if (t.startsWith("	at") || true)
                {
                    n++;
                    if (n > 0)
                    {
                        FF.log(t);

                    }
                    if (n > 5) break;
                }
            }

        } catch (Exception e)
        {

        }

    }

    public boolean  mustLogin(  String method, JSONObject param)
    {
        return true;
    }

    public boolean  mustBeSysUser(  String method, JSONObject param)
    {
        return false;
    }

    public boolean  mustBeGroupMaster(  String method, JSONObject param)
    {
        return false;
    }

    public String  verify(    String method, JSONObject param)
    {
        return "";
    }

    public boolean  canVerifyByScript(String method, JSONObject param)
    {
        return false;
    }

    //必须是在注册的服务器之间调用吗
    public boolean mustCalledOnOneOfServers(String method, JSONObject param)
    {
        return false;
    }

    private boolean  rightVerifyByScript(String method,JSONObject param)
    {
        try
        {

            //请求人信息也放入参数

            JSONObject req = new JSONObject();

            req.put("remoteAddr", request.getRemoteAddr());
            req.put("remoteHost", request.getRemoteHost());
            req.put("remoteUser", request.getRemoteUser());
            req.put("remotePort", request.getRemotePort());

            JSONObject p  = new JSONObject();
            p.put("task", method);
            p.put("data", param);
            p.put("request", req);//请求人信息也放入参数


            JSONObject ret = RPCRouter.dispatch("script", "script.rpcTask", "runTask", p, request, response,false);
            String  b= ret.getString("returnValue","");
            //只有明确返回false才是不允许，否则都是允许
            if(b.equalsIgnoreCase("false"))
            {

                return false;
            }
            return true;
        }catch(Exception e)
        {
            return true;
        }
    }



    /**
     * 可以覆盖此函数定制权限校验
     * @param method
     * @return
     */
    public boolean  methodRightVerify(String method , JSONObject param)
    {
        return true;
    }


}
