package util;


import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Element;
import com.itextpdf.text.pdf.*;
import config.CacheConfig;
import webApp.App;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;

//import org.junit.Test;

public class PdfWaterMark
{

    public static void addWaterMark(String srcPdfPath, String tarPdfPath,   int offset,  String WaterMarkContent)
    {
        try( OutputStream os= Files.newOutputStream(Paths.get(tarPdfPath)))
        {
            addWaterMark(srcPdfPath, os, offset, WaterMarkContent);
        }catch(Exception e)
        {
            FF.log("加水印异常："+FF.exceptionMessage(e));
        }

    }


    public static void addWaterMark(String srcPdfPath, OutputStream os,   int offset,  String WaterMarkContent)
    {

        float alpha=0.1f;
        try
        {
            alpha=Float.valueOf(CacheConfig.get("/文件服务/PDF文件水印/concentration", "0.1"));

            alpha = Math.min(1, Math.max(0, alpha));
        }catch(Exception e)
        {
            alpha=0.1f;
        }

        int gap= CacheConfig.get("/文件服务/PDF文件水印/gap",1); //水印间隔倍数

        int md= CacheConfig.get("/文件服务/PDF文件水印/density",4); // 重复4次水印
        md=  Math.max(1, Math.min(20,md));
        FF.log("水印浓度：" + alpha);
        FF.log("水印密度："+ md);
        FF.log("水印间隔倍数："+ gap);
       try
       {
            PdfReader reader = new PdfReader(srcPdfPath);
            PdfStamper stamper = new PdfStamper(reader, os);
            PdfGState gs = new PdfGState();
            String fontPath = App.AppRoot + "/HarmonyOS_Sans_SC_Regular.ttf";
            FF.log("水印字体路径："+fontPath);
            BaseFont font = BaseFont.createFont(fontPath, BaseFont.IDENTITY_H, BaseFont.NOT_EMBEDDED);
            gs.setFillOpacity(alpha);// 设置透明度

            int total = reader.getNumberOfPages() + 1;
            PdfContentByte content;

            float waterMarkWidth = 0;
            String[] t = WaterMarkContent.split("[\\n]");


            for (int i = 1; i < total; i++)
            {
                content = stamper.getOverContent(i);
                float width = reader.getPageSize(i).getWidth();
                float height = reader.getPageSize(i).getHeight();

                //if( width< 100 || height<100) md=1; //太小了，不要重复，只显示一次水印

                if (width < height)
                {
                    waterMarkWidth = (float) (width / md);
                }
                else
                {
                    waterMarkWidth = (float) (height / md);
                }


                float fontSize = 1;
                float delta = 0.05f;
                if (width < 100 || height < 100)
                {
                    fontSize = 0.05f;
                    delta = 0.01f;

                }
                while (true)
                {
                    float tw = 0;
                    for (int ti = 0; ti < t.length; ti++)
                    {
                        //40*delta是表示水印间的间隔 ， 当图片较大时， 图片间隔 40px， 图片斩将小时，间隔 4px
                        float w = (float) ((font.getWidthPoint(t[ti], fontSize) / 1.414) + gap * 40 * delta);
                        tw = Math.max(w, tw);
                    }

                    if (tw > waterMarkWidth) break;
                    fontSize += delta;
                    if (fontSize > 100) break;
                }
                fontSize -= delta; //因为是超过了，所以减一号字

                if (fontSize < 0.5f) fontSize = 0.5f;

                FF.log("水印字体大小 ："+ fontSize);

                int rn = (int) Math.ceil(height / waterMarkWidth);
                int cn = (int) Math.ceil(width / waterMarkWidth);

                if (rn < 1) rn = 1;
                if (cn < 1) cn = 1;

                content.setGState(gs);
                content.setColorFill(BaseColor.DARK_GRAY); //水印颜色
                content.setFontAndSize(font, fontSize); //水印字体样式和大小

                FF.log("水印分"+rn+"行"+cn+"列");

                for (int row = 0; row < rn; row++)
                {
                    for (int col = 0; col < cn; col++)
                    {


                        int x = (int) (col * waterMarkWidth + fontSize);  ///+ fontSize 是微调一下， 不然第一个字会显示不全， 大概数字，不需要很精确
                        int y = (int) (offset + row * waterMarkWidth + fontSize);
                        for (int ti = 0; ti < t.length; ti++)
                        {
                            String info = t[ti];

                            content.beginText();
                            content.showTextAligned(Element.ALIGN_LEFT, info, x + ti * (int) (fontSize * 1.2 / 1.414), y - ti * (int) (fontSize * 1.2 / 1.414), 45); //水印内容和水印位置

                            content.endText();
                        }
                    }
                }
            }
            stamper.close();
        }catch(Exception e)
        {
            FF.log("加水印异常："+FF.exceptionMessage(e));
        }


    }


    public static void main(String[] arg)
    {

        String source = "/Users/zengjun/Downloads/Sheet1.pdf";
        String target = "/Users/zengjun/Downloads/Sheet1-a.pdf";


        App.AppRoot="/Users/zengjun/IdeaProjects/jun/out/artifacts/formEngine";
        PdfWaterMark pwm = new PdfWaterMark();

        try
        {
            pwm.addWaterMark(source, target,    0,"管理员 2022-12-01\n中在要要要要要要在在在大\n在在在在在大 在在在在在在在在在在在");

        } catch (Exception e1)
        {
            FF.log( FF.exceptionMessage(e1));
        }
    }


}