package pdf;

import com.aspose.cad.InterruptionTokenSource;
import com.aspose.cad.fileformats.cad.CadDrawTypeMode;
import com.aspose.cad.fileformats.cad.CadImage;
import com.aspose.cad.fileformats.tiff.enums.TiffExpectedFormat;
import com.aspose.cad.imageoptions.CadRasterizationOptions;
import com.aspose.cad.imageoptions.PdfOptions;
import com.aspose.cad.imageoptions.SvgOptions;
import com.aspose.cad.*;
import com.aspose.cad.fileformats.cad.CadDrawTypeMode;
import com.aspose.cad.fileformats.cad.CadImage;
import com.aspose.cad.fileformats.tiff.enums.TiffExpectedFormat;
import com.aspose.cad.imageoptions.*;
import com.aspose.cells.License;

import com.aspose.cad.imageoptions.TiffOptions;
import com.aspose.cells.License;
import com.aspose.cells.PdfSaveOptions;
import com.aspose.cells.Workbook;
import com.aspose.words.SaveFormat;
import util.FF;

import java.io.*;
import java.nio.file.Files;
import java.nio.file.Paths;

public class PdfUtil
{


    public static void main(String[] args)
    {
        // String srcFilePath = "/Users/zengjun/Downloads/快奇包装模板.xlsx";
        // PdfUtil.excel2pdf(srcFilePath);

        String file = "/Users/zengjun/Documents/客户数据/凭证影像化/凭证影像化系统操作指南.docx";
        PdfUtil.word2pdf(file, "/Users/zengjun/Downloads/a.pdf");
    }

    /**
     * excel 转 pdf
     *
     * @param excelFilePath excel文件路径
     */
    public static void excel2pdf(String excelFilePath)
    {
        excel2pdf(excelFilePath, null, null);
    }

    /**
     * excel 转 pdf
     *
     * @param excelFilePath excel文件路径
     * @param convertSheets 需要转换的sheet
     */
    public static void excel2pdf(String excelFilePath, int[] convertSheets)
    {
        excel2pdf(excelFilePath, null, convertSheets);
    }

    /**
     * excel 转 pdf
     *
     * @param excelFilePath excel文件路径
     * @param pdfFilePath   pdf文件路径
     */
    public static void excel2pdf(String excelFilePath, String pdfFilePath)
    {
        excel2pdf(excelFilePath, pdfFilePath, null);
    }

    /**
     * excel 转 pdf
     *
     * @param excelFilePath excel文件路径
     * @param pdfFilePath   pdf文件路径
     * @param convertSheets 需要转换的sheet
     */
    public static void excel2pdf(String excelFilePath, String pdfFilePath, int[] convertSheets)
    {
        try
        {
            pdfFilePath = pdfFilePath == null ? getPdfFilePath(excelFilePath) : pdfFilePath;
            // 验证 License
            getExcelLicense();
            Workbook wb = new Workbook(excelFilePath);
            FileOutputStream fileOS = new FileOutputStream(pdfFilePath);
            PdfSaveOptions pdfSaveOptions = new PdfSaveOptions();
            pdfSaveOptions.setOnePagePerSheet(true);
            if (null != convertSheets)
            {
                printSheetPage(wb, convertSheets);
            }
            wb.save(fileOS, pdfSaveOptions);
            fileOS.flush();
            fileOS.close();
            System.out.println("convert success");
        } catch (Exception e)
        {
            FF.log(FF.exceptionMessage(e));
        }
    }

    /**
     * 获取 生成的 pdf 文件路径，默认与源文件同一目录
     *
     * @param excelFilePath excel文件
     * @return 生成的 pdf 文件
     */
    private static String getPdfFilePath(String excelFilePath)
    {
        return excelFilePath.split("\\.")[0] + ".pdf";
    }

    /**
     * 获取 license 去除水印
     * 若不验证则转化出的pdf文档会有水印产生
     */
    private static void getExcelLicense()
    {
        String licenseFilePath = "excel-license.xml";
        try
        {
            InputStream is = PdfUtil.class.getClassLoader().getResourceAsStream(licenseFilePath);
            com.aspose.cells.License license = new License();
            license.setLicense(is);
        } catch (Exception e)
        {
            FF.log(FF.exceptionMessage(e));
        }
    }

    /**
     * 隐藏workbook中不需要的sheet页。
     *
     * @param sheets 显示页的sheet数组
     */
    private static void printSheetPage(Workbook wb, int[] sheets)
    {
        for (int i = 1; i < wb.getWorksheets().getCount(); i++)
        {
            wb.getWorksheets().get(i).setVisible(false);
        }
        if (null == sheets || sheets.length == 0)
        {
            wb.getWorksheets().get(0).setVisible(true);
        }
        else
        {
            for (int i = 0; i < sheets.length; i++)
            {
                wb.getWorksheets().get(i).setVisible(true);
            }
        }
    }


    public static void word2pdf(String wordFilePath, String pdfFilePath)
    {
        try
        {
            pdfFilePath = pdfFilePath == null ? getPdfFilePath(wordFilePath) : pdfFilePath;


            java.io.File file = new java.io.File(pdfFilePath);
            try (FileOutputStream os = new FileOutputStream(file))
            {
                com.aspose.words.Document doc = new com.aspose.words.Document(wordFilePath);
                doc.save(os, SaveFormat.PDF);
            }

        } catch (Exception e)
        {
            FF.log(FF.exceptionMessage(e));
        }
    }

    public static void cad2other(String dwgFile, String toFile, String viewAs)
    {
        if (viewAs.equalsIgnoreCase("pdf")) cadToPdf(dwgFile, toFile);
        if (viewAs.equalsIgnoreCase("svg")) cad2svg(dwgFile, toFile);

    }


    public static void cad2svg(String dwgFile, String svgFile)
    {

        String cadFilePath = dwgFile;
        try
        {
            getCADLicense();

            File file = new File(cadFilePath);
            InputStream inputStream = Files.newInputStream(file.toPath());
            String svgFilePath = svgFile;
            CadImage cadImage = (CadImage) CadImage.load(inputStream);
            SvgOptions svgOptions = new SvgOptions();
            CadRasterizationOptions rasterizationOptions = new CadRasterizationOptions();
            rasterizationOptions.setAutomaticLayoutsScaling(true);
            rasterizationOptions.setContentAsBitmap(true);
            rasterizationOptions.setLayouts(new String[]{"Model"});
            rasterizationOptions.setDrawType(CadDrawTypeMode.UseDrawColor);
            // SVG 全局背景色
            //      rasterizationOptions.setBackgroundColor(Color.getRed());
            //      rasterizationOptions.setDrawColor(Color.fromName("Lime"));
            rasterizationOptions.setExportAllLayoutContent(false);
            svgOptions.setVectorRasterizationOptions(rasterizationOptions);
            // 设置一个值，该值指示是否必须将文本转换为形状
            svgOptions.setTextAsShapes(true);
            //      svgOptions.setMinimumLinewidth((float) 0.3);
            //      svgOptions.setMinimumLinewidth(0.1f);
            // 是否应重新调整子像素线宽 。 false 不调整. 设
            svgOptions.setRescaleSubpixelLinewidths(false);
            //      svgOptions.setUseAbsoluteRescaling(true);
            System.out.println("开始转换为SVG");
            cadImage.save(svgFilePath, svgOptions);
            System.out.println("转换完成");
        } catch (Exception e)
        {
            FF.log(FF.exceptionMessage(e));
        }


    }


    /**
     * cad文件转pdf
     *
     * @param inputFilePath  cad文件路径
     * @param outputFilePath pdf输出文件路径
     * @return 转换是否成功
     */
    public static Boolean cadToPdf(String inputFilePath, String outputFilePath)
    {

        getCADLicense();

        // 创建CAD延时处理器
        final InterruptionTokenSource source = new InterruptionTokenSource();
        // 创建SVG、PDF和TIFF选项
        final SvgOptions svgOptions = new SvgOptions();
        final PdfOptions pdfOptions = new PdfOptions();
        final TiffOptions tiffOptions = new TiffOptions(TiffExpectedFormat.TiffJpegRgb);

        //获取输出文件格式
        String cadPreviewType = outputFilePath.substring(outputFilePath.lastIndexOf(".") + 1);

        // 获取输出文件路径中的目录
        int index = outputFilePath.lastIndexOf("/");
        String folder = outputFilePath.substring(0, index);
        File path = new File(folder);
        // 如果目录不存在，则创建新的目录
        if (!path.exists())
        {
            path.mkdirs();
        }
        // 创建输出文件
        File outputFile = new File(outputFilePath);

        try
        {
            // 加载CAD文件并设置指定的编码
            LoadOptions opts = new LoadOptions();
            opts.setSpecifiedEncoding(CodePages.SimpChinese);
            final Image cadImage = Image.load(Files.newInputStream(Paths.get(inputFilePath)), opts);

            try
            {
                // 设置矢量化质量
                RasterizationQuality rasterizationQuality = new RasterizationQuality();
                rasterizationQuality.setArc(RasterizationQualityValue.High);
                rasterizationQuality.setHatch(RasterizationQualityValue.High);
                rasterizationQuality.setText(RasterizationQualityValue.High);
                // rasterizationQuality.setOle(RasterizationQualityValue.High);
                rasterizationQuality.setObjectsPrecision(RasterizationQualityValue.High);
                rasterizationQuality.setTextThicknessNormalization(true);

                // 设置CAD矢量化选项
                CadRasterizationOptions cadRasterizationOptions = new CadRasterizationOptions();
                cadRasterizationOptions.setBackgroundColor(Color.getWhite());
                cadRasterizationOptions.setPageWidth(cadImage.getWidth());
                cadRasterizationOptions.setPageHeight(cadImage.getHeight());
                cadRasterizationOptions.setUnitType(cadImage.getUnitType());
                cadRasterizationOptions.setAutomaticLayoutsScaling(false);
                cadRasterizationOptions.setNoScaling(false);
                cadRasterizationOptions.setQuality(rasterizationQuality);
                cadRasterizationOptions.setDrawType(CadDrawTypeMode.UseObjectColor);
                cadRasterizationOptions.setExportAllLayoutContent(true);
                //  cadRasterizationOptions.setVisibilityMode(VisibilityMode.AsScreen);

                // 根据cadPreviewType选择不同的输出格式选项
                switch (cadPreviewType)
                {
                    case "svg":
                        svgOptions.setVectorRasterizationOptions(cadRasterizationOptions);
                        svgOptions.setInterruptionToken(source.getToken());
                        break;
                    case "pdf":
                        pdfOptions.setVectorRasterizationOptions(cadRasterizationOptions);
                        pdfOptions.setInterruptionToken(source.getToken());
                        break;
                    case "tif":
                        tiffOptions.setVectorRasterizationOptions(cadRasterizationOptions);
                        tiffOptions.setInterruptionToken(source.getToken());
                        break;
                }

                // 保存CAD文件为指定格式
                try (OutputStream stream = Files.newOutputStream(outputFile.toPath()))
                {
                    switch (cadPreviewType)
                    {
                        case "svg":
                            cadImage.save(stream, svgOptions);
                            break;
                        case "pdf":
                            cadImage.save(stream, pdfOptions);
                            break;
                        case "tif":
                            cadImage.save(stream, tiffOptions);
                            break;
                    }
                } catch (IOException e)
                {
                    FF.log(FF.exceptionMessage(e));
                    return false;
                } finally
                {
                    // 释放资源并中断任务
                    cadImage.dispose();
                    source.interrupt();
                    source.dispose();
                }
                return true;

            } finally
            {
                // 释放资源
                source.dispose();
                cadImage.dispose();
            }
        } catch (Exception e)
        {
            FF.log(FF.exceptionMessage(e));
            return false;
        } finally
        {
            // 释放资源
            source.dispose();
        }
    }


    /**
     * 获取 license 去除水印
     * 若不验证则转化出的pdf文档会有水印产生
     */
    private static void getWordLicense()
    {
        String licenseFilePath = "word-license.xml";
        try
        {
            InputStream is = PdfUtil.class.getClassLoader().getResourceAsStream(licenseFilePath);
            com.aspose.words.License license = new com.aspose.words.License();
            license.setLicense(is);
        } catch (Exception e)
        {
            FF.log(FF.exceptionMessage(e));
        }
    }

    private static void getCADLicense()
    {

        try
        {
            //去水印的。不要删除

            InputStream is = com.aspose.cad.License.class.getResourceAsStream("/lisencecad.xml");
            com.aspose.cad.License license = new com.aspose.cad.License();
            license.setLicense(is);

        } catch (Exception e)
        {
            FF.log(FF.exceptionMessage(e));
        }
    }


}
