package util;


import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Image;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import jun.db.impl.DataStoreFactory;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.io.*;
import java.util.Date;

public class PDF_addstamp
{


    public static void main(String[] arg)
    {
        String info = "张三  \n" + FF.get_yyyyMMdd_HHmm_FormatedDate(new Date());

     //   addStamp("d:/temp/设计模式精简手册.pdf", info, "d:/temp", "d:/temp/a.pdf", true);
        addStamp$$$("/Users/zengjun/appFileRoot/FileServer/default/fo2pdf/619e1c010374da1baa6314ab.pdf",
                 info, "/Users/zengjun/appFileRoot/FileServer/default/fo2pdf/",
                 "/Users/zengjun/appFileRoot/FileServer/default/fo2pdf/a.pdf", true);

      //   addTitle( "/Users/zengjun/Downloads/deleteAfterDownloaded.pdf","20210100001" , "/Users/zengjun/Downloads/",
      //             "/Users/zengjun/Downloads/aaa.pdf" );

         System.exit(0);
    }

    public static String createImage(String info, String tempPath)
    {

        int w =400;
        int h = 400;


        BufferedImage img = new BufferedImage(w, h, BufferedImage.TYPE_INT_RGB);
        Graphics2D graphics = (Graphics2D) img.getGraphics();

        // ----------  增加下面的代码使得背景透明  -----------------
        img = graphics.getDeviceConfiguration().createCompatibleImage(w, h, Transparency.TRANSLUCENT);
        graphics.dispose();
        graphics = img.createGraphics();
        // ----------  背景透明代码结束  -----------------


        graphics.setColor(Color.darkGray);

        AlphaComposite ac = AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 0.3f);
        graphics.setComposite(ac);

        //消除文字锯齿
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING,RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
//消除画图锯齿

        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);


        graphics.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);



        int fontSize =  22  ;
        graphics.setFont(new Font("SimHei", 1, fontSize));
        //graphics.translate(this.getWidth() / 2, this.getHeight() / 2);
        graphics.rotate(-0.25 * Math.PI);//旋转

        String[] t= info.split("[\\n]");

        for(int i=0;i<t.length;i++)
        {
            graphics.drawString(t[i], -200, 300 + (i-1)*25 );
        }
        String fileName = "";
        try
        {

            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream(bo);

            ImageIO.write(img, "png", bos);
            bos.flush();
            bos.close();
            byte[] ret = bo.toByteArray();
            File file = new File(tempPath, DataStoreFactory.newGUID() + ".png");
            fileName = file.getPath();
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(ret);
            fos.close();
        } catch (Exception e)
        {

        } finally
        {
            graphics.dispose();
        }

        return fileName;
    }


    public static String createTitleImage(String info, String tempPath)
    {

        int w = 300;
        int h = 40;


        BufferedImage img = new BufferedImage(w, h, BufferedImage.TYPE_INT_RGB);
        Graphics2D graphics = (Graphics2D) img.getGraphics();


        // ----------  增加下面的代码使得背景透明  -----------------
        img = graphics.getDeviceConfiguration().createCompatibleImage(w, h, Transparency.TRANSLUCENT);
        graphics.dispose();
        graphics = img.createGraphics();
        // ----------  背景透明代码结束  -----------------




        AlphaComposite ac = AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 0.5f);
        graphics.setComposite(ac);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int fontSize = 24;
        Font font = new Font("SimHei", 1, fontSize);
        graphics.setFont(font);

        FontRenderContext frc = graphics.getFontRenderContext();
        TextLayout layout = new TextLayout(info, font, frc);

        //水平居右，垂直居中
        int x = (int) (w - layout.getAdvance()-10 );
        int y = (int) (layout.getAscent() + (h - layout.getAscent() - layout.getDescent() - layout.getLeading()) / 2)+10;



        graphics.setColor(Color.white);
        graphics.drawString(info, x, y);

        graphics.setColor(Color.black);
        graphics.drawString(info, x+1, y+1);
        graphics.setColor(Color.white);
        graphics.drawString(info, x+2, y+2);

        String fileName = "";
        try
        {

            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream(bo);

            ImageIO.write(img, "png", bos);
            bos.flush();
            bos.close();
            byte[] ret = bo.toByteArray();
            File file = new File(tempPath, DataStoreFactory.newGUID() + ".png");
            fileName = file.getPath();
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(ret);
            fos.close();
        } catch (Exception e)
        {

        } finally
        {
            graphics.dispose();
        }

        return fileName;
    }

    public static void addTitle(String pdfPath, String info, String tempPath, String sPdfPath)
    {
        PdfReader reader = null;
        PdfStamper stamp = null;
        Image img = null;

        String imgFile = "";
        try
        {
            reader = new PdfReader(pdfPath); //("h:\\ITextTest.pdf", "World".getBytes());,后面的表示含有密码
            stamp = new PdfStamper(reader, new FileOutputStream(sPdfPath));

            imgFile = createTitleImage(info, tempPath);
            img = Image.getInstance(imgFile);


            float imgWidth = img.getWidth();
            float imgHeight = img.getHeight();


            int total = reader.getNumberOfPages();
            //System.out.println(img.getWidth()+">>"+reader.getPageSize(1).width());
            // System.out.println(total);


            for (int i = 1; i <= total; i++) // 每一页都加水印
            {
                float pdfWidth = reader.getPageSize(i).getWidth();
                float pdfHeight = reader.getPageSize(i).getHeight();
                PdfContentByte under = stamp.getOverContent(i);
                img.setAbsolutePosition(pdfWidth - imgWidth, pdfHeight - imgHeight); //位置
                under.addImage(img);


            }


        } catch (Exception e)
        {

        } finally
        {
            FF.deleteFile(imgFile);
            try
            {

                stamp.close();
            } catch (DocumentException e)
            {

            } catch (IOException e)
            {

            }
        }
    }

    @Deprecated
    public static void addStamp$$$ (String pdfPath, String info, String tempPath, String sPdfPath, boolean everyPage)
    {
        addStamp$$$(pdfPath, info, tempPath, sPdfPath, everyPage, 0);
    }

    /*
     * pdf盖章操作，简单地加印章图片到指定位置
     * @param pdfPath pdf路径名 "d:/test/form.pdf"
     * @param imgPath 要添加的图片路径名 "d:\\test/tt.gif"
     * @param sPdfPath 加盖印章的pdf路径名 "d:\\test/ITextTest2.pdf"
     */
    public static void addStamp$$$(String pdfPath, String info, String tempPath, String sPdfPath, boolean everyPage, int yOffset)
    {
        PdfReader reader = null;
        PdfStamper stamp = null;
        Image img = null;

        String imgFile = "";
        try
        {
            reader = new PdfReader(pdfPath); //("h:\\ITextTest.pdf", "World".getBytes());,后面的表示含有密码
            stamp = new PdfStamper(reader, new FileOutputStream(sPdfPath));

            imgFile = createImage(info, tempPath);
            img = Image.getInstance(imgFile);

            //img.scaleAbsolute(50, 50); // 缩放到固定像素
            //img.scalePercent(0.5f, 0.5f); // 相对缩放


            float imgWidth = img.getWidth();
            float imgHeight = img.getHeight();


            int total = reader.getNumberOfPages();
            //System.out.println(img.getWidth()+">>"+reader.getPageSize(1).width());
            // System.out.println(total);


            for (int i = 1; i <= total; i++) // 每一页都加水印
            {
                float pdfWidth = reader.getPageSize(i).getWidth();
                float pdfHeight = reader.getPageSize(i).getHeight();

                int delta=300;
                int nx = (int) (Math.ceil(pdfWidth * 1.0 / delta));  //水平打 水印次数
                int ny = (int) (Math.ceil(pdfHeight * 1.0 / delta));  //水平打 水印次数


                PdfContentByte under = stamp.getOverContent(i);//.getUnderContent(i);
                for (int ix = 0;  ix <  nx ; ix++)
                {
                    for (int iy = 0; iy < ny; iy++)
                    {
                        img.setAbsolutePosition(ix * delta, iy * delta); //位置
                        under.addImage(img);
                    }
                }


                if (!everyPage) break;
            }


        } catch (Exception e)
        {

        } finally
        {
            FF.deleteFile(imgFile);
            try
            {

                stamp.close();
            } catch (DocumentException e)
            {

            } catch (IOException e)
            {

            }
        }
    }

}
