package util;


import com.aspose.cells.License;
import com.aspose.pdf.Document;
import com.aspose.pdf.devices.JpegDevice;
import com.aspose.pdf.devices.Resolution;
import dfs.ImageInfo;
import dfs.UploadFile;
import org.json.JSONArray;
import org.json.JSONObject;
import pdf.PdfUtil;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Date;

public class PDF2JPG
{
    private static void getLicense()
    {
        String licenseFilePath = "aspose-pdf-18.9.license.xml";
        try
        {
            InputStream is = PdfUtil.class.getClassLoader().getResourceAsStream(licenseFilePath);

            com.aspose.pdf.License license = new com.aspose.pdf.License();
            license.setLicense(is);

        } catch (Exception e)
        {
            FF.log(FF.exceptionMessage(e));
        }
    }

    public static JSONArray pdf2jpg (String filename, String toPath, String name ,int dpi ) {

        JSONArray ret = new JSONArray();
        getLicense();

        //去水印的。不要删除
        try
        {

            // Load PDF file
            Document pdfDocument = new Document(filename);

            // 创建分辨率对象（300 DPI）
            Resolution resolution = new Resolution(dpi);
            // 创建 Jpeg 设备
            JpegDevice jpegDevice = new JpegDevice(resolution, 100);
            int PC=pdfDocument.getPages().size();
            // 遍历每一页
            FF.log("共"+PC+"页");
            for (int pageCount = 1; pageCount <= PC; pageCount++)
            {
                // 定义输出文件路径
                String outputPath = FF.pathJoin( toPath  , name+"-"+ pageCount + ".jpg");
                FF.log( outputPath);
                // 使用文件流保存当前页为图片
                try (FileOutputStream imageStream = new FileOutputStream(outputPath))
                {
                    // 转换页面为图片并保存
                    jpegDevice.process(pdfDocument.getPages().get_Item(pageCount), imageStream);
                    ret.put( oneFile(outputPath));

                } catch (IOException e)
                {
                   FF.log( FF.exceptionMessage(e));
                }
            }


        }catch (Exception e)
        {
            FF.log(  e.getMessage());

        }
        return  ret;
    }

    public static org.json.JSONObject oneFile(String file)
    {
        JSONObject one = new JSONObject();
        one.put("path", file);
        File f = new File(file);
        long l = f.length();

        one.put("fileSize", f.length());
        DateTool dt = new DateTool();
        Date now = new Date();

        one.put("createDate",   ""+now.getTime()  );

        ImageInfo ii = UploadFile.getImageInfo(file);

        one.put("width", ii.width);
        one.put("height", ii.height);



        return one;

    }
}
