package util;

import org.apache.regexp.RE;

import java.sql.Connection;
import java.util.Date;

public class NoFactory
{

    public static String newBillNo(String dsn, String tableName, String col ,  String pattern, String billDateCol ,  Date billDate, String where)
    {
        DBF dbf = DBF.getInstance();
        Connection con = null;
        try
        {
            con = dbf.getConnection(dsn);
            if (con == null) return dsn + "不是合法的数据库连接名";

            if( billDate==null) billDate=new Date();
            if( billDateCol==null) billDateCol=  "";
/*
            单据号的组成规则：
            $表示单据号前缘
                    y表示年
            m表示月
                    d表示日
            1表示全局流水号
            2表示当年流水号
            3表示当月流水号
            4表示当日流水号
            示例：
            $-yymmdd-4444 表示前缀-6位年月日-4位当日流水号
            $-yymm-3333 表示前缀-4位年月-4位当月流水号
            11111111 表示8位全局流水号
*/

            StringBuilder sb = new StringBuilder(100);

            DateTool dt = new DateTool();

            int y = dt.getYear(billDate);
            int m = dt.getMonth(billDate);
            int d = dt.getDayOfMonth(billDate);

            pattern=FF.replaceAll(pattern,"'" ,""); //去掉单引号

            if( pattern.isEmpty())  pattern="{11111111}";
            if( !billDateCol.isEmpty())
            {
                pattern = parseYear(pattern, billDateCol, y);
                pattern = parseMonth(pattern, billDateCol, m);
                pattern = parseDay(pattern, billDateCol, d);
            }

            pattern = parseYearNo(con, tableName, col ,y, pattern, billDateCol,where);
            pattern = parseMonthNo(con, tableName, col ,y, m, pattern, billDateCol,where);
            pattern = parseDayNo(con, tableName, col ,y, m, d, pattern, billDateCol,where);

            String billno = parseAllNo(con, tableName, col ,pattern, billDateCol,where);


            return billno;

        } catch (Exception e)
        {
            return e.getMessage();
        } finally
        {
            dbf.releaseConnection(con);
        }
    }


    //替换年份
    public static String parseYear(String pattern,String billDateCol, int y)
    {
        return parseDate(pattern, "y", billDateCol,y);

    }

    public static String parseMonth(String pattern,String billDateCol, int m)
    {
        return parseDate(pattern, "m",billDateCol, m);

    }

    public static String parseDay(String pattern, String billDateCol,int d)
    {
        return parseDate(pattern, "d", billDateCol,d);

    }


    //替换年份
    public static String parseDate(String pattern, String mask, String billDateCol, int v)
    {

        RE r = new RE("[{](" + mask + "+)[}]");

        while (r.match(pattern))
        {
            int start = r.getParenStart(1);
            int end = r.getParenEnd(1);
            int len = end - start  ;

            pattern = pattern.substring(0, start-1) + FF.right("0000000000" + v, len) + pattern.substring(end+1  );
        }
        return pattern;
    }

    // 按年排号

    public static String parseYearNo(Connection con, String tableName, String col,int y, String pattern, String billDateCol, String where)
    {
        String rq1 = FF.right("0000" + y, 4) + ".01.01";  //包头
        String rq2 = FF.right("0000" + (y + 1), 4) + ".01.01";//不包尾
        return parseDateNo(con, tableName, col,rq1, rq2, pattern, "2",billDateCol, where);

    }

    public static String parseMonthNo(Connection con, String tableName, String col, int y, int m, String pattern, String billDateCol, String where)
    {
        DateTool dt = new DateTool();

        String rq1 = FF.get_yyyyMMdd_Date(dt.createDate(y, m, 1));//包头
        String rq2 = FF.get_yyyyMMdd_Date(dt.nextDate(dt.createDate(y, m, 1), 1, "month"));//  不包尾
        return parseDateNo(con, tableName, col, rq1, rq2, pattern, "3", billDateCol, where);

    }

    public static String parseDayNo(Connection con, String tableName,String col, int y, int m, int d, String pattern, String billDateCol, String where)
    {
        DateTool dt = new DateTool();

        String rq1 = FF.get_yyyyMMdd_Date(dt.createDate(y, m, d));//包头
        String rq2 = FF.get_yyyyMMdd_Date(dt.nextDate(dt.createDate(y, m, d), 1, "day"));//  不包尾
        return parseDateNo(con, tableName, col,rq1, rq2, pattern, "4", billDateCol,where);

    }

    public static String parseAllNo(Connection con, String tableName, String col,String pattern, String billDateCol,String where)
    {

        return parseDateNo(con, tableName, col,null, null, pattern, "1",   billDateCol,where);

    }


    public static String parseDateNo(Connection con, String tableName,  String col,String rq1, String rq2, String pattern, String mask, String billDateCol,String where)
    {

        String t= pattern;
        t=FF.replaceAll(t,"\\{","");
        t=FF.replaceAll(t,"\\}","");
        String p2like = pattern2Like(pattern);

        String sql = " select max("+col+")  from " + tableName +
                " where " + DBFunction.dbf_len(con) + "("+col+") =" + DBFunction.dbf_len(con) + "('"+t +"') and  " +
                 col+" like  '"+p2like+"' ";
        if (rq1 != null && rq2 != null && ! billDateCol.isEmpty()) sql = sql + " and     "+  billDateCol +">='" + rq1 + "'  and  "+  billDateCol + "<'" + rq2 + "'    ";
        if (!where.trim().isEmpty()) sql = sql + " and " + where;
        FF.log("生成新单据号："+sql);

        RE r = new RE("[{]("+mask+"+)[}]");
        while (r.match(pattern))
        {

            int start = r.getParenStart(1);
            int end = r.getParenEnd(1);
            int len =  end -start  ;


            String no = FF.getStringFromSQL(con, sql);
            if (no.isEmpty())
            {
                no = FF.right("0000000000000000000000000000000000000", len);
            }
            else
            {
                no = no.substring(start-1, end-1);//去掉占位符中的{占用的一位 ，临时解决方案
            }

            boolean  first=true;
            while(true)
            {
                no = FF.stringInc(no);

                if( first) //第一次替换时，有{ } 两个占位符，所以位置修正成 start-1 , end+1
                {
                    pattern = pattern.substring(0, start - 1) + no + pattern.substring(end + 1);
                }else {
                    //第二次及以后再替换时， 开始 位置不变，但是结束位置要左移2位，
                    pattern = pattern.substring(0, start - 1) + no + pattern.substring(end -1);
                }

                String tsql="select id from "+tableName+" where  "+ FF.appendWhere( " billno='"+ pattern+"' " ,where, "and" );
                //检测是是否已存在
                //比如 在 2023.04.01 新增一张单据， 单据号是  X-20230401-0001
                // 然后又把该单据的日期改成 其它日期，但是单据号并不修改。于是当再次新增 2023.04.01日的单据时， 获取的新单据号仍然是 X-20230401-0001
                // 因为该日并没有单据存在，所以序号是0001开始。但是这样单据号的确是重复了。所以增加一下检测，直到不存在为止
                if( FF.getStringFromSQL(con,tsql).isEmpty()) break;
                first=false;
            }

        }
        return pattern;
    }


        public static String pattern2Like(String input) {
            // 第一步：将下划线 _ 替换成 \_
            String step1 = input.replace("_", "\\_");

            // 第二步：处理大括号内的内容，替换为相应长度的下划线
            StringBuilder result = new StringBuilder();
            int i = 0;
            int n = step1.length();

            while (i < n) {
                if (step1.charAt(i) == '{') {
                    // 找到大括号的开始
                    int start = i;
                    int end = step1.indexOf('}', i);

                    if (end != -1) {
                        // 计算大括号内内容的长度
                        int contentLength = end - start - 1;

                        // 生成相应长度的下划线字符串
                        String underscores = "________________________________".substring(0,  contentLength);

                        // 添加到结果中
                        result.append(underscores);

                        // 跳过处理过的大括号内容
                        i = end + 1;
                    } else {
                        // 如果没有找到闭合的大括号，保持原样
                        result.append(step1.charAt(i));
                        i++;
                    }
                } else {
                    // 普通字符直接添加
                    result.append(step1.charAt(i));
                    i++;
                }
            }

            return result.toString();
        }

        public static void main(String[] args) {
            // 测试示例
            String input = "{yyy}YY-DD{MM}_SS-{111}";
            String output = pattern2Like(input);
            System.out.println("输入: " + input);
            System.out.println("输出: " + output);
            // 预期输出: "_____YY-DD___\\_SS-_____"
        }

}
