package util;

import io.zbus.mq.MqClient;
import io.zbus.transport.DataHandler;
import io.zbus.transport.Message;
import mq_zbus.MessageProducerFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.json.JSONObject;
import webApp.App;
import websocketRPC.WSRPC;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;


public class LogService
{


    static int MaxCacheSize = 10000; //最多堆积消息条数
    static ConcurrentLinkedQueue<JSONObject> messageCache = new ConcurrentLinkedQueue< >();


    static volatile boolean exitSend = false;
    static SimpleDateFormat SDF = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss SSS");



    public static Thread quickSendMessageThread;


    public static void init( )
    {


        quickSendMessageThread = new Thread()
        {


            @Override
            public void run()
            {
                while (true)
                {

                    /*为什么不用LinkedBlockingQueue
                        由于LinkedBlockingQueue   ，take方法在队列空的时候会阻塞，直到有队列成员被放进来。
                        所以当没有消息时，它一直阻塞，就无法中断它，当然解决办法也是有的，发送一个特定内容的消息
                        让它退出阻塞，并判断消息是不是某特定消息，是，就终止线程。
                        */
                    while (messageCache.isEmpty())
                    {
                        if (exitSend) return;
                        try
                        {
                            FF.sleep(20);
                        } catch (Exception e)
                        {
                        }
                    }


                    //poll并不阻塞队列，当队列为空时，它直接返回null ,所以msg是可能为null的，所以前面要处理一下，避免没有消息时进入下面的处理
                    JSONObject msg = messageCache.poll();
                    //如果没有消息了，并且需要结束，那么退出吧
                    if (msg == null && exitSend) return;

                    if (msg == null) continue;

                    //发送消息
                    WSRPC.dispatch("log", "app.LogReceive" , "onLogReceive", msg , FF.EHR,null,false);


                }
            }

        };
        quickSendMessageThread.setName("日志归档线程-"+ App.appName);
        quickSendMessageThread.start();
    }



    public static void destroy()
    {
        try
        {
            exitSend = true;//通知快速发送线程可以结束了

            messageCache.clear();

        } catch (Exception e)
        {

        }
    }



    /**
     * 快速发送消息
     *
     * @param topic
     * @param tags
     * @param keys
     * @param msgbody
     */
    public static boolean quickSend(  String msgbody)
    {

        if (msgbody == null) return false;
        if (msgbody.isEmpty()) return false;


        try
        {

            //当太多快速消息积累无法发送时，丢掉开始的那些
            if( (int)(Math.random()*(100-1)+1 ) ==17 ) // %1的机会去检测
            {
                if (messageCache.size() > MaxCacheSize)
                {

                    System.out.println("oneWay 方式的消息堆积过多无法发送，丢弃所有未发送的消息");
                    messageCache.clear();
                }
            }

            JSONObject msg = new JSONObject();

            msg.put("message", msgbody);    //set business data in body
            msg.put("vipname", App.getInstance().getVirtualHostName());
            msg.put("address", App.IPADDRESS_AND_PORT);
            msg.put("time", SDF.format(new Date()));
            messageCache.add(msg);
            return true;

        } catch (Exception ex)
        {


            return false;
        }
    }

}
