package util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class InMemoryDistributedLock {
    private static final ConcurrentHashMap<String, Lock> LOCK_MAP = new ConcurrentHashMap<>();

    public static boolean tryLock(String lockKey, long timeout, TimeUnit unit) {
        Lock lock = LOCK_MAP.computeIfAbsent(lockKey, k -> new ReentrantLock());
        try {
            return lock.tryLock(timeout, unit);
        } catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public static void unlock(String lockKey) {
        Lock lock = LOCK_MAP.get(lockKey);
        if (lock != null) {
            lock.unlock();
        }
    }
}