package util;

import javax.imageio.*;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;

public class ImageInfoReader {

    public static void main(String[] args) {
        File imageFile = new File("/Users/zengjun/appFileRoot/FileServer/default/imgUploadTest/1201065961998952454~1.jpg"); // 替换为你的图片路径

        try (ImageInputStream input = ImageIO.createImageInputStream(imageFile)) {
            // 获取图片阅读器
            Iterator<ImageReader> readers = ImageIO.getImageReaders(input);

            if (!readers.hasNext()) {
                System.out.println("无法识别图片格式");
                return;
            }

            ImageReader reader = readers.next();
            reader.setInput(input);

            // 获取基础信息
            String format = reader.getFormatName();
            int width = reader.getWidth(0);
            int height = reader.getHeight(0);

            System.out.println("图片类型: " + format.toUpperCase());
            System.out.println("图片尺寸: " + width + "x" + height);

            // 获取元数据
            IIOMetadata metadata = reader.getImageMetadata(0);
            printMetadata(metadata);

            reader.dispose();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void printMetadata(IIOMetadata metadata) {
        System.out.println("\n==== 元数据信息 ====");

        // 获取支持的元数据格式
        String[] formats = metadata.getMetadataFormatNames();
        for (String format : formats) {
            System.out.println("\n元数据格式: " + format);
            try {
                // 将元数据转换为XML格式输出
                System.out.println(metadata.getAsTree(format));
            } catch (IllegalArgumentException e) {
                System.out.println("无法转换此格式的元数据");
            }
        }
    }
}