package util;


import dfs.ImageInfo;
import dfs.UploadFile;
import jun.db.impl.DataStoreFactory;

import javax.imageio.ImageIO;
import java.awt.*;

import java.awt.image.BufferedImage;
import java.io.*;
import java.util.Date;

public class IMG_addstamp
{


    public static void main(String[] arg)
    {
        String info = "张三  " + FF.get_yyyyMMdd_HHmm_FormatedDate(new Date());

        addStamp("/Users/zengjun/Downloads/b1.jpg", info, "/Users/zengjun/Downloads", "/Users/zengjun/Downloads/ass.jpg", 0);

        System.exit(0);
    }

    public static String createImage(String info, String tempPath)
    {

        int w = 400;
        int h = 400;


        BufferedImage img = new BufferedImage(w, h, BufferedImage.TYPE_INT_RGB);
        Graphics2D graphics = (Graphics2D) img.getGraphics();


        // ----------  增加下面的代码使得背景透明  -----------------
        img = graphics.getDeviceConfiguration().createCompatibleImage(w, h, Transparency.TRANSLUCENT);
        graphics.dispose();
        graphics = img.createGraphics();
        // ----------  背景透明代码结束  -----------------


        graphics.setColor(Color.black);

        AlphaComposite ac = AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 0.1f);
        graphics.setComposite(ac);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int fontSize = (int) (36.0 / Math.max(1, info.length() / 16.0));
        graphics.setFont(new Font("simSun", 1, fontSize));
        //graphics.translate(this.getWidth() / 2, this.getHeight() / 2);
        graphics.rotate(-0.25 * Math.PI);//旋转

        graphics.drawString(info, -200, 300);
        String fileName = "";
        try
        {

            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream(bo);

            ImageIO.write(img, "png", bos);
            bos.flush();
            bos.close();
            byte[] ret = bo.toByteArray();
            File file = new File(tempPath, DataStoreFactory.newGUID() + ".png");
            fileName = file.getPath();
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(ret);
            fos.close();
        } catch (Exception e)
        {

        } finally
        {
            graphics.dispose();
        }

        return fileName;
    }

    public static void addStamp(String pdfPath, String info, String tempPath, String sPdfPath)
    {
        addStamp(pdfPath, info, tempPath, sPdfPath, 0);
    }

    /*
     * pdf盖章操作，简单地加印章图片到指定位置
     * @param pdfPath pdf路径名 "d:/test/form.pdf"
     * @param imgPath 要添加的图片路径名 "d:\\test/tt.gif"
     * @param sPdfPath 加盖印章的pdf路径名 "d:\\test/ITextTest2.pdf"
     */
    public static void addStamp(String pdfPath, String info, String tempPath, String sPdfPath, int yOffset)
    {
        String imgFile = "";
        Image img = null;
        try
        {
            Image srcImg = ImageIO.read(new File(pdfPath));
            BufferedImage buffImg = new BufferedImage(srcImg.getWidth(null),
                                                      srcImg.getHeight(null), BufferedImage.TYPE_INT_RGB);

            // 1、得到画笔对象
            Graphics2D g = buffImg.createGraphics();



            g.drawImage( srcImg, 0, 0, null);


            imgFile = createImage(info, tempPath);
            img = ImageIO.read(new File(imgFile));

            ImageInfo ii = UploadFile.getImageInfo(imgFile);

            int imgWidth = ii.width;
            int imgHeight = ii.height;


            ImageInfo sii = UploadFile.getImageInfo(pdfPath);

            int pdfWidth = sii.width;
            int pdfHeight = sii.height;
            int deltaX = 300; //水平距离多少再打一个水印
            int n = (int) (Math.ceil(pdfWidth * 1.0 / deltaX));  //水平打 水印次数
            int ny = (int) (Math.ceil(pdfHeight * 1.0 / deltaX));  //垂直打 水印次数


            for (int x = 0; x < n; x++)
            {
                for( int y=0;y<ny;y++)
                {
                    g.drawImage(img, x * deltaX, y*deltaX, imgWidth, imgHeight, null); //位置
                }
            }

            // 7、释放资源
            g.dispose();

            // 8、生成图片

            ImageIO.write(buffImg, sii.type, new FileOutputStream(sPdfPath));

        } catch (Exception e)
        {

        } finally
        {
            //  FF.deleteFile(imgFile);

        }
    }

}
