package util;

import org.apache.http.Consts;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.params.CoreConnectionPNames;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;

import javax.net.ssl.SSLException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import java.nio.charset.CodingErrorAction;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

public class HttpUtil
{

    public static volatile boolean shutdowned = false;
    /*
    有几个需要注意的地方：
1.如果你的客户端连接的目标服务器只有一个，那么大可设置最大route连接数和最大连接池连接数相同，以便高效利用连接池中创建的连接。
2.创建的httpClient对象是线程安全的，如果连接的目标服务器只有一个的话，创建一个全局对象即可。一个对象好比开了一个浏览器，
 多个线程无需每次请求时专门开一个浏览器，统一一个即可。
3.如果httpClient对象不再使用，记得关闭，释放与服务器保持连接的socket，以便服务器更高效的释放资源。

    * */


    private static PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
    private static SSLContextBuilder sslContextBuilder;
    private static RequestConfig config;
    private static ConcurrentHashMap<String, CloseableHttpClient> httpClientMap = new ConcurrentHashMap<String, CloseableHttpClient>();

    static
    {
        /*


        a、connectionRequestTimeout—从连接池中取连接的超时时间

        这个时间定义的是从ConnectionManager管理的连接池中取出连接的超时时间， 如果连接池中没有可用的连接，则request会被阻塞，
        最长等待connectionRequestTimeout的时间，如果还没有被服务，则抛出ConnectionPoolTimeoutException异常，不继续等待。

        b、connectTimeout—连接超时时间

        这个时间定义了通过网络与服务器建立连接的超时时间，也就是取得了连接池中的某个连接之后到接通目标url的连接等待时间。
        发生超时，会抛出ConnectionTimeoutException异常。

        c、socketTimeout—请求超时时间

        这个时间定义了socket读数据的超时时间，也就是连接到服务器之后到从服务器获取响应数据需要等待的时间，
        或者说是连接上一个url之后到获取response的返回等待时间。发生超时，会抛出SocketTimeoutException异常。

        */
        int connectTimeout = FF.getVMProperty("HTTPCLIENT_CONNECTION_TIMEOUT", 5 * 1000);
        int socketTimeout = FF.getVMProperty("HTTPCLIENT_SOCKET_TIMEOUT", 300 * 1000);
        //该值就是连接不够用的时候等待超时时间，一定要设置，而且不能太大 ()
        int connectionRequestTimeout = FF.getVMProperty("HTTPCLIENT_CONNECTION_REQUEST_TIMEOUT", 5 * 1000);


        int maxTotal = FF.getVMProperty("HTTPCLIENT_POOL_MAXTOTAL", 200);
        int maxPerRoute = FF.getVMProperty("HTTPCLIENT_POOL_MAX_PER_ROUTE", 50);

        cm.setMaxTotal(maxTotal);
        cm.setDefaultMaxPerRoute(maxPerRoute);

        //Http connection相关配置
        ConnectionConfig connectionConfig = ConnectionConfig.custom()
                .setMalformedInputAction(CodingErrorAction.IGNORE)
                .setUnmappableInputAction(CodingErrorAction.IGNORE)
                .setCharset(Consts.UTF_8)
                .build();

        /**
         * request请求相关配置
         */
        config = RequestConfig.custom()
                .setConnectTimeout(connectTimeout)         //连接超时时间
                .setSocketTimeout(socketTimeout)          //读超时时间（等待数据超时时间）
                .setConnectionRequestTimeout(connectionRequestTimeout)    //从池中获取连接超时时间
                .build();

        sslContextBuilder = new SSLContextBuilder();
        try
        {
            sslContextBuilder.loadTrustMaterial(null, new TrustStrategy()
            {
                // 证书校验忽略
                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException
                {
                    return true;
                }
            });


        } catch (Exception e)
        {

        }

    }

    public static CloseableHttpClient getHttpClient(String homeURL)
    {
        if (shutdowned) return null;
        if (httpClientMap.containsKey(homeURL)) return httpClientMap.get(homeURL);


        synchronized (HttpUtil.class)
        {

            //需要再次判断是不是在其它线程中已经创建了
            if (httpClientMap.containsKey(homeURL)) return httpClientMap.get(homeURL);
            try
            {
                CloseableHttpClient httpClient = HttpClients.custom().setSSLContext(sslContextBuilder.build())
                        .setSSLHostnameVerifier(NoopHostnameVerifier.INSTANCE)
                        .setDefaultRequestConfig(config)
                        .build();
                httpClientMap.put(homeURL, httpClient);
                return httpClient;

            } catch (Exception e)
            {
                FF.log("初始化 getHttpClient异常" + e.getMessage());
                return null;
            }
        }

    }

    public static void shutdown()
    {
        shutdowned = true;

        Iterator<CloseableHttpClient> it = httpClientMap.values().iterator();
        while (it.hasNext())
        {
            try
            {
                it.next().close();
            } catch (Exception e)
            {

            }
        }

        httpClientMap.clear();

    }


}
