package util;

import com.netflix.appinfo.InstanceInfo;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.HikariPoolMXBean;
import org.json.JSONArray;
import org.json.JSONObject;
import webApp.App;

import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.sql.DataSource;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;

/**
 * 从 Eureka中获取服务的信息
 */
public class HikariCPState extends RPCBase
{


    @Override
    public boolean mustLogin(String method, JSONObject param)
    {
        return true;
    }


    public JSONObject getHikariCPState(JSONObject param)
    {
        JSONObject ret = new JSONObject("{success:true}");


        JSONArray ja = new JSONArray();
        ret.put("items", ja);

        ArrayList<String> poolNames = DBF.getPoolNames();
        for (String name : poolNames)
        {
            DataSource dss = DBF.getDataSource(name);
            if (!(dss instanceof HikariDataSource)) continue;


            try
            {
                MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                ObjectName poolName = new ObjectName("com.zaxxer.hikari:type=Pool (" + name + ")");
                HikariPoolMXBean poolProxy = JMX.newMXBeanProxy(mBeanServer, poolName, HikariPoolMXBean.class);

                JSONObject one = new JSONObject();
                one.put("service", App.appName);
                one.put("ip", App.IPADDRESS);
                one.put("name", name);
                one.put("active", poolProxy.getActiveConnections());
                one.put("idle", poolProxy.getIdleConnections());
                one.put("wait", poolProxy.getThreadsAwaitingConnection());
                one.put("total", poolProxy.getTotalConnections());

                ja.put(one);
            } catch (Exception e)
            {
                ret.put("message", e.getMessage());
            }


        }
        return ret;


    }
}
