package util;


import org.json.JSONObject;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

@WebServlet(name = "HTTPPostProxy", urlPatterns = "/HTTPPostProxy")
public class HTTPPostProxy extends HttpServlet
{

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
    {

        doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
    {


        request.setCharacterEncoding("UTF-8"); //很重要

        /* 允许跨域的主机地址 */
        response.setHeader("Access-Control-Allow-Origin", "*");
        /* 允许跨域的请求方法GET, POST, HEAD 等 */
        response.setHeader("Access-Control-Allow-Methods", "*");
        response.setHeader("Cache-Control", "no-cache");
        /* 重新预检验跨域的缓存时间 (s) */
        response.setHeader("Access-Control-Max-Age", "36000");
        /* 允许跨域的请求头 */
        response.setHeader("Access-Control-Allow-Headers", "Authorization, Content-Type, Depth, User-Agent, X-File-Size, X-Requested-With, X-Requested-By, If-Modified-Since, X-File-Name, X-File-Type, Cache-Control, Origin");

        /* 是否携带cookie */
        response.setHeader("Access-Control-Allow-Credentials", "true");

        response.setHeader("XDomainRequestAllowed", "1");

        response.setContentType("text/html; charset=UTF-8");

        if (request.getMethod().equals("OPTIONS"))
        {
            response.setStatus(HttpServletResponse.SC_OK);
            return;
        }

        try
        {

            JSONObject param = BuildParamFromRequest.buildParam(request, response, true, false);
            String url= param.getString("url","");
            String configString= param.getString("configString","");
            boolean returnString =param.getBoolean("returnString", true);
            String method= param.getString("method","POST");



            Object ret=null;
            if( method.equalsIgnoreCase("POST"))
            {
                ret = FF.$httpPost(url, configString, returnString);
            }else {
                ret= FF.httpGet(url, configString);
            }
            output(response, ret);


        }catch(Exception e)
        {
            errorOutput(response, e.getMessage());
        }

    }


    public void errorOutput(HttpServletResponse response, String ret) throws IOException
    {
        JSONObject jsonRet = new JSONObject();
        jsonRet.put("success", false);
        jsonRet.put("message", ret);
        output(response, jsonRet.toString());
    }



    public void output(HttpServletResponse response, Object ret) throws IOException
    {

        response.setContentType("text/html; charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        response.getOutputStream().write(ret.toString().getBytes("UTF-8"));
    }



}
