package util;

import org.htmlparser.Node;
import org.htmlparser.Parser;
import org.htmlparser.filters.NodeClassFilter;
import org.htmlparser.tags.InputTag;
import org.htmlparser.tags.SelectTag;
import org.htmlparser.tags.TextareaTag;
import org.htmlparser.util.NodeList;
import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;

public class HTML
{

    /**
     * 从html中把 input的ID，及值分析出来
     * @param html
     * @return
     */
    public static JSONArray parseData(String html)
    {
        JSONArray ret= new JSONArray();
        Parser parser;
        parser = Parser.createParser(html);
        NodeList list;

        try
        {
            list = parser.extractAllNodesThatMatch(new NodeClassFilter(InputTag.class));

            ArrayList<String> ids=new ArrayList<String>();

            for (int k = 0; k < list.size(); k++)
            {
                Node node = list.elementAt(k);
                InputTag input = (InputTag) node;
                JSONObject one= new JSONObject();
                String type= input.getAttribute("type");

                if( type==null) type="";
                if( type.equalsIgnoreCase("radio"))
                {
                    one.put("id",input.getAttribute("name"));
                }else
                {
                    one.put("id", input.getAttribute("id"));
                }
                String id=one.getString("id","");
                if(  ids.contains( id)) continue;

                ids.add(id);
                one.put("type", type );

                //如果是单选，那么不好确定缺省值
                one.put("value", type.equalsIgnoreCase("radio")?"":input.getAttribute("value"));
                one.put("placeholder",input.getAttribute("placeholder"));
                one.put("unload",input.getAttribute("unload"));



                ret.put(one);
            }

            //要重新再来过，不然，下面匹配不到
            parser = Parser.createParser(html);
            list = parser.extractAllNodesThatMatch(new NodeClassFilter(SelectTag.class));

            for (int k = 0; k < list.size(); k++)
            {
                Node node = list.elementAt(k);
                SelectTag select = (SelectTag) node;
                JSONObject one= new JSONObject();
                one.put("id",select.getAttribute("id"));

                one.put("placeholder",select.getAttribute("placeholder"));
                one.put("unload",select.getAttribute("unload"));
                ret.put(one);
            }

            //要重新再来过，不然，下面匹配不到
            parser = Parser.createParser(html);
            list = parser.extractAllNodesThatMatch(new NodeClassFilter(TextareaTag.class));

            for (int k = 0; k < list.size(); k++)
            {
                Node node = list.elementAt(k);
                TextareaTag textarea = (TextareaTag) node;
                JSONObject one= new JSONObject();
                one.put("id",textarea.getAttribute("id"));
                one.put("type",textarea.getAttribute("type"));

                one.put("value",textarea.getValue());
                one.put("placeholder",textarea.getAttribute("placeholder"));
                one.put("unload",textarea.getAttribute("unload"));
                ret.put(one);
            }

        } catch (Exception e)
        {

            FF.log( FF.exceptionMessage(e));
        }
        return ret;
    }

}
