package util;

import app.Ilog;
import jun.db.core.ColumnProperty;
import jun.db.core.DataAdapter;
import jun.db.core.DataStore;
import jun.db.impl.DataStoreFactory;
import org.json.JSONArray;
import org.json.JSONObject;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;

public class FormUtil
{



    /**
     * 本函数用在打开模板时，创建表的结果时检测表是否需要创建，此时，如果数据库中表的字段数，与这里的字段数相等，就不检测字段了以提高性能
     * 还用在手工点击 检测表时，此时强制检测
     *
     * @param dsn
     * @param tablename
     * @param primaryKey
     * @param one
     * @param log
     * @param syncComment 是否同步备注信息到数据库中
     * @throws Exception
     */
    public static void $CheckTable(TimeStamp tm, String dsn, String tablename, String primaryKey, JSONObject one, Ilog log,
                                   boolean syncComment, boolean forceCheck, String corporationid, ArrayList<String> already) throws Exception
    {
        DBF dbf = DBF.getInstance();
        Connection con = null;
        try
        {

            if (!corporationid.isEmpty() && log != null)
            {
                String corporationName = FF.getStringFromSQL("", "select name from app_corporation where id='" + corporationid + "'");
                log.Tip("<br><span>企业：<strong>" + corporationName + " </strong> </span><hr>");

            }
            //有可能多个企业共用一个实际的数据库连接，那么要避免重复的检测
            String realDBPool = DBF.getMapedName(dsn, corporationid);

            if (already != null)
            {
                if (already.contains(realDBPool + tablename))
                {
                    if (log != null)
                    {
                        log.Tip("<br><span> 连接" + realDBPool + "上已经做过了检测，不需要再检测</span>");
                    }
                    return;
                }
            }


            if (log != null) log.Tip("<br><span>检测表：<strong>" + tablename + " </strong> </span><hr>");

            if (already != null) already.add(realDBPool + tablename);

            //租户连接支持
            con = dbf.getConnection(dsn, corporationid);


            DataAdapter da = DataStoreFactory.createDataAdapter(con);

            tm.stamp("开始创建" + tablename + " datastore　来检查字段");

            DataStore ds = DataStoreFactory.newDataStore(con, "select  *  from " + tablename);

            /*  花了1  秒，所以不能放在这里，移到数据库设置中
            String tableComment = one.getString("label", "");
            if (!tableComment.isEmpty()) da.setTableComment(con, tablename, tableComment);
            */
            tm.stamp("创建" + tablename + " datastore 开始");

            JSONArray columns = one.getJSONArray("column");


            //下面时 2670秒，影响性能，所以仅在配置的字段数与实际的字段数不相同时，才检测
            // 通常没有问题，除非是删除一个字段，又加上一个字段，此时字段总数不变，但是实际上字段信息发生了改变
            // 这种情况，不多，可以通过手工点击建表来弥补

            //2021.08.23 增加对字段默认值的设置
            HashMap<String, String> columnsDefaultDefine = da.getColumnsDefaultValueDefine(con, tablename);

            boolean gguidExist=false;
            boolean billnoExist=false;
            if (ds.getColumnCount() < columns.length() || forceCheck)
            {
                tm.stamp("字段数不对，检测表结构");
                //表如果已存在，即使没有数据，也不要随意删除再重建，因为可能有索引，或视图
                if (ds.getColumnCount() > 0)
                {

                    // 表已经存在
                    ds = DataStoreFactory.newDataStore(con, "select * from " + tablename);
                    ds.setOnceRetrieveCount(1);
                    ds.retrieve();

                    boolean holdData = ds.getRowCount() > 0;

                    for (int ei = 0; ei < columns.length(); ei++)
                    {
                        JSONObject oneCol = columns.getJSONObject(ei);

                        String colname = oneCol.getString("name", "").toLowerCase().trim();
                        if( colname.equalsIgnoreCase("gguid")) gguidExist=true;
                        if( colname.equalsIgnoreCase("billno")) billnoExist=true;
                        if (ds.col2Index(colname) < 0) // 字段不存在,那么追加它
                        {
                            StringBuffer sql = new StringBuffer();
                            sql.append("alter  table ").append(tablename).append("  add  ");
                            sql.append(colname).append("  ");
                            //					增加字段类型转换
                            String colType = oneCol.getString("type", "");
                            String dbDefaultValue = oneCol.getString("dbdefaultvalue", "");
                            colType = checkColType(con, colType);
                            sql.append(colType);
                            sql.append("   null ");
                            //有一段时间，会billtype设置了默认值  '' ,有点问题， 所以加了了 ！!dbDefaultValue.equals("''")
                            if (!dbDefaultValue.isEmpty() && !dbDefaultValue.equals("''")  ) sql.append(" default " + dbDefaultValue);
                            FF.log("为表" + tablename + "追加字段:" + sql);
                            if (log != null)
                                log.Tip("<br><span>为表" + tablename + "追加字段:</span><br><font color=green>" + sql + "</font>");
                            String info = FF.SafeExecute(con, sql.toString());
                            if (info.isEmpty()) info = colname + " <font color=green>[✔]</font>";
                            if (log != null) log.Tip(info);
                        }
                        else
                        {
                            //看看字段是否需要修改
                            String colType = oneCol.getString("type", "");
                            colType = checkColType(con, colType);//已经把标准类型映射成con数据库相关的类型

                            ColumnProperty pCP = ds.getColumnProperty(colname);

                            String dbDefaultValue = oneCol.getString("dbdefaultvalue", "");
                            String currentDBDefaultValue = FF.getStringFromMap(columnsDefaultDefine, colname, "");
                            if (!currentDBDefaultValue.equals(dbDefaultValue))
                            {
                                String sql = da.assembleSetColumnDefaultValueDefine(tablename, colname, dbDefaultValue);
                                FF.log("修改" + colname + "字段默认值:" + sql);
                                if (log != null)
                                    log.Tip("<br><span>为表" + tablename + "修改字段默认值:</span><br><font color=green>" + sql + "</font>");

                                String info = FF.SafeExecute(con, sql);
                                if (info.isEmpty()) info = colname + " <font color=green>[✔]</font>";
                                if (log != null) log.Tip(info);


                            }

                            //当前字段类型
                            String currentColType = da.assembleColumnType(pCP.getDataTypeName(), pCP.getPrecision(), pCP.getScale(), pCP.getColumnTypeRedefine());

                            //去掉空格
                            colType = FF.replaceAll(colType, " ", "");
                            currentColType = FF.replaceAll(currentColType, " ", "");

                            //当前类型，数字型，统一成decimal
                            currentColType = FF.replaceAllWithoutRegix(currentColType,"numeric","decimal");

                            //对于mysql 如果执行了 drop default ，那么需要重新设置一下类型， 不然当该字段 不提供数据时，无法插入新行
                            if (!colType.equalsIgnoreCase(currentColType) ||
                                    (!currentDBDefaultValue.equals(dbDefaultValue) && dbDefaultValue.isEmpty())
                            )
                            {
                                String sql = da.assembleAlterColumnSyntax(tablename, colname, colType);
                                if (holdData)
                                {
                                    log.Tip("<br><font color=red>" + colname + "在数据库中类型为:" + currentColType + ",但当前定义发生变化为：" + colType +
                                                    "<br>由于已经存在了数据，所以并不自动调整字段类型，如果确信需要调整字段类型，请手工执行：  <br>" + sql + "</font>");


                                }
                                else
                                {
                                    FF.log("修改" + colname + "字段类型:" + sql);
                                    if (log != null)
                                        log.Tip("<br><span>为表" + tablename + "修改字段:</span><br><font color=green>" + sql + "</font>");
                                    String info = FF.SafeExecute(con, sql);

                                    if (info.isEmpty()) info = colname + " <font color=green>[✔]</font>";
                                    if (log != null) log.Tip(info);
                                }
                            }
                            else
                            {
                                FF.log(colname + " <font color=green>[✔]</font>");
                                if (log != null) log.Tip(colname + " <font color=green>[✔]</font>");
                            }


                        }

                    }

                    //再检测一遍
                    ds = DataStoreFactory.newDataStore(con, "select  *  from " + tablename);
                    if (ds.getColumnCount() < columns.length())
                    {
                        String errInfo = tablename + "中的字段少于数据库设置中的字段个数，可能存在同名字段（仅大小写不同），或字段定义不合法而无法创建的字段";

                        if (log != null)
                        {
                            log.Tip("<br><span style='color:red'> " + errInfo + "</font>");
                        }
                        throw new Exception(errInfo);
                    }

                }
                else
                // 表不存在
                {
                    primaryKey = " " + primaryKey.replaceAll(",", " , ") + "  "; // 把逗号换成前后都有空格的逗号
                    primaryKey = primaryKey.toLowerCase();

                    StringBuffer sql = new StringBuffer();
                    sql.append("create table ").append(tablename).append(" ( \n");

                    ArrayList<String> defaultValueSQL = new ArrayList<>();


                    for (int ei = 0; ei < columns.length(); ei++)
                    {
                        JSONObject oneCol = columns.getJSONObject(ei);

                        String colname = oneCol.getString("name", "").toLowerCase().trim();
                        if( colname.equalsIgnoreCase("gguid")) gguidExist=true;
                        if( colname.equalsIgnoreCase("billno")) billnoExist=true;

                        sql.append(colname).append("  ");
                        String colType = oneCol.getString("type", "");
                        //2007.06.06 增加字段类型转换
                        colType = checkColType(con, colType);
                        sql.append(colType);
                        if (primaryKey.indexOf(" " + colname + " ") >= 0)
                        {
                            sql.append("  not null ");
                        }
                        else
                        {
                            sql.append(" null ");
                        }

                        String dbDefaultValue = oneCol.getString("dbdefaultvalue", "");
                        if (!dbDefaultValue.isEmpty())
                        {
                            defaultValueSQL.add(da.assembleSetColumnDefaultValueDefine(tablename, colname, dbDefaultValue));
                            sql.append(" default ").append(dbDefaultValue);
                        }

                        sql.append(",\n");

                    }

                    // 对于数据表，不要主键
                    if( primaryKey.isEmpty()) primaryKey = "id";

                    if (!primaryKey.trim().isEmpty())
                    {
                        sql.append(" primary key ( ").append(primaryKey).append(" )");
                    }

                    //如果没有拼上主键的语句，那么最后肯定是以，结尾
                    //那么要去掉这个逗号
                    if (sql.toString().endsWith(",")) sql.deleteCharAt(sql.length() - 1);

                    sql.append(")\n");
                    //
                    FF.log("创建表：" + tablename);
                    FF.log(sql);
                    // 创建一个索引

                    if (log != null)
                    {
                        log.Tip("<br><span>创建数据表：" + tablename + "</font>");
                        log.Tip("<br><span> " + sql + " ");

                    }
                    String info = FF.SafeExecute(con, sql.toString());
                    if( info.isEmpty())  info="<h3 style='color:green;'>"+tablename+"创建成功</h3>";
                    if (log != null && !info.isEmpty()) log.Tip(info);


                    //2021.08.23 增加字段默认值的设置
                    // 在建表中的  default ...  这个单独拿出来在查询工具中执行，是没问题的，但是在程序里执行， 创建的表中，指定的默认值没有生效
                    // 所以只好单独在建表后，重新设置一下字段的数据库级的默认值
                    for (int di = 0; di < defaultValueSQL.size(); di++)
                    {
                        String dsql = defaultValueSQL.get(di);
                        String tinfo = FF.SafeExecute(con, dsql);
                        if (log != null)
                        {
                            log.Tip("<br><span> " + dsql + " ");
                            if (!tinfo.isEmpty()) log.Tip(tinfo);
                        }

                    }




                }

                if( gguidExist)
                {
                    String indexSQL = "create index   i_" + tablename + "_gguid   on  " + tablename + " (  gguid )";
                    if (log != null) log.Tip("<br><span>创建索引：" + indexSQL + "</font>");
                    String info = FF.SafeExecute(con, indexSQL);
                    if (log != null && !info.isEmpty()) log.Tip(info);
                }

                if( billnoExist)
                {

                    String indexSQL = "create unique index   ui_" + tablename + "_billno   on  " + tablename + " ( billno )";
                    if (log != null) log.Tip("<br><span>创建索引：" + indexSQL + "</font>");
                    String info = FF.SafeExecute(con, indexSQL);
                    if (log != null && !info.isEmpty()) log.Tip(info);
                }


                //如果是一个代码表， 那么在  code上创建一个唯一索引
                DataStore tds = DataStoreFactory.newDataStore(con, "select * from " + tablename);
                if (tds.columnExists("code") && tds.columnExists("billtype") && tds.columnExists("internalcode"))
                {

                    String indexSQL = "create unique index   i_" + tablename + "_code  on  " + tablename + " ( code )";
                    if (DBFunction.isSqlServer(con)) indexSQL += " where code is not null ";
                    if (log != null) log.Tip("<br><span>创建索引：" + indexSQL + "</font>");
                    String info = FF.SafeExecute(con, indexSQL);
                    if (log != null && !info.isEmpty()) log.Tip(info);
                }


                //同步字段备注
                columns = one.getJSONArray("column");
                for (int ei = 0; ei < columns.length(); ei++)
                {
                    JSONObject oneCol = columns.getJSONObject(ei);

                    String colname = oneCol.getString("name", "").toLowerCase().trim();
                    String colLabel = oneCol.getString("label", "");
                    if (!colLabel.isEmpty())
                    {
                        //如果没有备注，那么设置上备注，否则不覆盖
                        if (da.getColumnComment(con, tablename, colname).isEmpty())
                        {
                            da.setCoumnComment(con, tablename, colname, colLabel);
                        }
                    }

                }
            }
            else
            {
                if (log != null)
                {
                    log.Tip("<br><span  style='color:green'>字段数没有发生变化，所以无需扫描表结构</span>");
                }
            }


            tm.stamp(tablename + "表结构检查结束");
        } catch (Exception e)
        {
            throw e;
        } finally
        {
            dbf.releaseConnection(con);
        }
    }


    //建表时，对类型进行检查
    public static String checkColType(Connection con, String colType)
    {

        DataAdapter da = DataStoreFactory.createDataAdapter(con);
        String cold = "";
        int p = colType.indexOf("(");
        if (p > 0)
        {
            cold = colType.substring(p);
            colType = colType.substring(0, p);
        }

        colType = colType.toLowerCase(); //很重要
        colType = da.getMappedDataType(colType) + cold;

        return colType;

    }

}
