package util;

import config.Config;
import jun.db.core.DataStore;
import jun.db.impl.DataStoreFactory;
import org.ehcache.impl.internal.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONObject;
import webApp.App;
import websocketRPC.WSRPC;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;

public class FormCache
{
    public static final String EncryptKey = "w54tg80u"; //随机的字符串
    public static final String CS_DATAMASK = "$datamask";
    public static final String CS_ENCRYPT_MODE = "$encryptmode";

    public static final String CS_FunctionList = "functionList";
    public static final String CS_FunctionCheckpoint = "functionCheckpoint";
    public static final String CS_updatedisabledcolumns = "updatedisabledcolumns"; //不可更新的表及字段清单，格式是[ 表名.字段名]
    public static final String CS_modifyLogColumns = "modifylogcolumns"; // 需要修改日志的字段清单 ，格式是[ 表名.字段名]

    private static final ConcurrentHashMap<String, String> localFormCache = new ConcurrentHashMap<>(); //本地缓存

    public static java.util.concurrent.ConcurrentHashMap<String, Long> templateId2LastModified = new java.util.concurrent.ConcurrentHashMap<>();


    //模块配置信息的本地缓存 , 注意注意： 由于此信息在脚本服务中也要用到，但是本信息又是一个内部缓存
    // 所以当需要复位时， 脚本服务中的 ，此缓存也要清除复位 ， 而这个操作，在 formEngine服务的 formengine.ScriptAPI.resetModule2TemplateIdAndModuleDefine
    // 函数中做了处理，
    public static final ConcurrentHashMap<String, String> moduleCache = new ConcurrentHashMap<>(); //本地缓存
    //模块配置信息的本地缓存的缓存时间
    public static java.util.concurrent.ConcurrentHashMap<String, Long> moduleCache2LastModified = new java.util.concurrent.ConcurrentHashMap<>();


    public static Exception TABLE_OR_QUERY_DEFINE_NOT_EXISTS = new Exception("无法从缓存中共聚模板的数据库的定义，禁止对数据库做操作");


    public static String buildKey(String templateid)
    {
        return "template:" + templateid+":";  //2025.02.09 最后加了一个：，方便批量删除key
    }


    public static ArrayList<String> unCacheCols;

    static
    {
        String[] t = new String[]{"id", "pid", "name", "namepath", "fullname", "innerorder", "description"};
        unCacheCols = new ArrayList<String>(Arrays.asList(t));
    }

    public static ArrayList<String> cachedCols = new ArrayList<String>();

    public static void removeAllFormCacheInCacheCenter()
    {
        DBF dbf = DBF.getInstance();
        Connection con = null;
        try
        {
            con = dbf.getConnection();

            DataStore ds = DataStoreFactory.newDataStore(con, "select id from app_template where nodetype='leaf' ");
            int n = ds.retrieve();
            for (int i = 0; i < n; i++)
            {
                String templateid = ds.getString(i, "id");
                removeFormCacheInCacheCenter(templateid);

            }


        } catch (Exception e)
        {

        } finally
        {
            dbf.releaseConnection(con);
        }

    }


    public static void removeAllLocalFormCache()
    {
        DBF dbf = DBF.getInstance();
        Connection con = null;
        try
        {
            con = dbf.getConnection();

            DataStore ds = DataStoreFactory.newDataStore(con, "select id from app_template where nodetype='leaf' ");
            int n = ds.retrieve();
            for (int i = 0; i < n; i++)
            {
                String templateid = ds.getString(i, "id");

                removeLocalFormCache(templateid);
            }

            clearModuleConfigCache("", "");

        } catch (Exception e)
        {

        } finally
        {
            dbf.releaseConnection(con);
        }

    }


    /**
     * 这个是清除服务内部的form缓存
     *
     * @param templateid
     */
    public static void removeLocalFormCache(String templateid)
    {

        if(App.appName.equalsIgnoreCase("formEngine"))
        {
            FF.log("模板 " + templateid + " 的本地缓存移除");

            if (templateid.isEmpty())
            {
                localFormCache.clear();
                templateId2LastModified.clear();
            }
            else
            {
                String key = buildKey(templateid);

                //本地缓存清除
                localFormCache.remove(key);
                templateId2LastModified.put(templateid, -1L); //最后修改日期
            }
        }else {

          JSONObject ret=  WSRPC.dispatch("formEngine", "formengine.FormEngine", "removeLocalFormCache",
                           new JSONObject().put("templateid" ,templateid) , FF.EHR,null,false);

          FF.log( ret);


        }


    }

    /**
     * 下面的是放在cache中心的缓存
     *
     * @param templateid
     */
    public static void removeFormCacheInCacheCenter(String templateid)
    {
        FF.log("模板 " + templateid + " 的缓存移除");
        String key = buildKey(templateid);


        //整体缓存去除
        AppCache.removeCacheMatch(key);
        //分项缓存去除 ,理论上，上面macth删除了，下面的就不需要了，出于 兼容，下面的也还是保留
        for (int i = 0; i < cachedCols.size(); i++)
        {
            String col = cachedCols.get(i);
            AppCache.removeCache(key + "->" + col);
            FF.log("移除缓存：" + key + "->" + col);
        }

        AppCache.removeCache(key + "->tableOrQuery");

        AppCache.removeCache(key + "->" + CS_FunctionList); //服务端脚本函数名缓存，用于单据保存时，如果有相应的事件响应函数，那么就触发，不然就不触发 ，提高性能
        AppCache.removeCache(key + "->" + CS_FunctionCheckpoint); //服务端脚本函数名缓存，用于单据保存时，如果有相应的事件响应函数，那么就触发，不然就不触发 ，提高性能

        FF.log("模板 " + templateid + " 的缓存移除完成");
    }

    public static void buildCache(String templateid)
    {

        buildCache(templateid, null);


    }

    public static void buildCache(String templateid, JSONObject ret)
    {
        String con = "";

        if (ret == null) ret = new JSONObject();//

        TimeStamp ts = new TimeStamp(true);
        ts.stamp("buildCache - start");
        //把 v_app_template 中的内容各自缓存起来
        DataStore ds = DataStoreFactory.newDataStore(con, "select * from v_app_template ");
        ds.retrieve("id='" + templateid + "'");

        //2023.02.24增加升级操作
        //以前创建的模板没有初始化 script_h5，但它必须要初始化
        //2023.09.26 取消了复制
        /*
        if (ds.getString(0, "scriptid_h5").isEmpty())
        {
            FF.log("升级模板，增加移动端脚本，克隆桌面端模板的脚本");
            // 创建 script_h5 节点，避免在模板设置中编辑脚本时，没有节点id而无法编辑
            Config config = new Config("app_template", "");
            config.setPosition(templateid);
            String script = config.get("script", "");
            //把脚本复制过去
            config.set("script_h5", script, "column");
            // 重新检索一下
            ds.retrieve("id='" + templateid + "'");

        }

         */

        ts.stamp("buildCache -  retrieve from  v_app_template ");
        for (int i = 0; i < ds.getColumnCount(); i++)
        {
            String col = ds.getColumnName(i);
            if (unCacheCols.contains(col)) continue;
            if (!cachedCols.contains(col)) cachedCols.add(col);

            String v = ds.getString(0, col);
            if (ret != null) ret.put(col, v);
            AppCache.setCache(buildKey(templateid) + "->" + col, v);
            ts.stamp("buildCache -  setCache for " + col);
        }


        // 对ui中的 ddlbFilterBy以及  treeFilterContext 做加密
        String ui = ret.getString("ui", "");
        JSONArray nullArray = new JSONArray();
        JSONObject nullObj = new JSONObject();


        JSONObject uiObj = new JSONObject(ui);
        JSONArray sheets = uiObj.getJSONArray("sheets", nullArray);
        boolean changed = false;
        for (int i = 0; i < sheets.length(); i++)
        {
            JSONArray cells = sheets.getJSONObject(i).getJSONArray("cells", nullArray);
            for (int ci = 0; ci < cells.length(); ci++)
            {
                JSONObject cell = cells.getJSONObject(ci);
                JSONObject editstyle = cell.getJSONObject("editstyle", null);
                if (editstyle != null)
                {

                    String ddlbFilterBy = editstyle.getString("ddlbFilterBy", "");
                    if (!ddlbFilterBy.isEmpty())
                    {
                        ddlbFilterBy = FF.encryptString(ddlbFilterBy, EncryptKey);
                        editstyle.put("ddlbFilterBy_encrypted", ddlbFilterBy);
                        changed = true;
                    }

                    String treeFilterBy = editstyle.getString("treeFilterBy", "");
                    if (!treeFilterBy.isEmpty())
                    {
                        treeFilterBy = FF.encryptString(treeFilterBy, EncryptKey);
                        editstyle.put("treeFilterBy_encrypted", treeFilterBy);
                        changed = true;
                    }
                }

                //补全的SQL加密
                JSONObject appData = cell.getJSONObject("appData", null);
                if (appData != null)
                {
                    String valueChangedToAutoCompleteQuery = appData.getString("valueChangedToAutoCompleteQuery", "");
                    if (!valueChangedToAutoCompleteQuery.isEmpty())
                    {
                        valueChangedToAutoCompleteQuery = FF.encryptString(valueChangedToAutoCompleteQuery, EncryptKey);
                        appData.put("valueChangedToAutoCompleteQuery_encrypted", valueChangedToAutoCompleteQuery);
                        changed = true;
                    }

                    for (int k = 1; k <= 4; k++)
                    {
                        String valueChangedToQuery = appData.getString("valueChangedToQuery" + k, "");
                        if (!valueChangedToQuery.isEmpty())
                        {
                            valueChangedToQuery = FF.encryptString(valueChangedToQuery, EncryptKey);
                            appData.put("valueChangedToQuery" + k + "_encrypted", valueChangedToQuery);
                            changed = true;
                        }
                    }

                }


                //树控件中的数据过滤条件加密
                JSONArray bricks = cell.getJSONArray("bricks", null);
                if (bricks != null)
                {
                    for (int bi = 0; bi < bricks.length(); bi++)
                    {
                        JSONObject brick = bricks.getJSONObject(bi);
                        JSONObject config = brick.getJSONObject("config", nullObj);
                        String treeFilterBy = config.getString("treeFilterBy", "");
                        if (!treeFilterBy.isEmpty())
                        {
                            treeFilterBy = FF.encryptString(treeFilterBy, EncryptKey);
                            config.put("treeFilterBy_encrypted", treeFilterBy);
                            changed = true;
                        }

                        // filterButton 中的过滤条件
                        JSONObject editStyle = config.getJSONObject("editStyle", nullObj);
                        if (editStyle != null)
                        {
                            String ddlbFilterBy = editStyle.getString("ddlbFilterBy", "");
                            if (!ddlbFilterBy.equalsIgnoreCase(""))
                            {
                                ddlbFilterBy = FF.encryptString(ddlbFilterBy, EncryptKey);
                                editStyle.put("ddlbFilterBy_encrypted", ddlbFilterBy);
                                changed = true;
                            }
                        }
                    }
                }

            }
        }

        if (changed) ret.put("ui", uiObj.toString());


        //缓存表单中的表名结果集名称 ,标记20190702

        DataStore maskDS = DataStoreFactory.newDataStore(con, "select * from v_app_db_datamask");
        DataStore encryptModeDS = DataStoreFactory.newDataStore(con, "select * from v_app_db_encryptmode");


        ts.stamp("buildCache - get  from v_app_db_datamask ");
        ds = DataStoreFactory.newDataStore(con, "  select *   from v_app_db ");
        ds.retrieve("   templateid='-" + templateid + "' ");

        ts.stamp("buildCache - retrieve is over ,there is  " + ds.getRowCount() + " count");
        JSONObject js = new JSONObject();
        for (int i = 0; i < ds.getRowCount(); i++)
        {
            String name = ds.getString(i, "name");
            JSONObject one = ds.getJSON(i, true);
            js.put(name, one); // 以表名或结果集名为名称，缓存对象

            //

            //把有数据掩码的字段配置也缓存起来
            int mc = maskDS.retrieve("  templateid='-" + templateid + "'  and query_table_name='" + name + "' ");

            ts.stamp("buildCache - retrieve datamask for " + name);
            if (mc > 0)
            {
                JSONObject mask = new JSONObject();

                for (int mi = 0; mi < mc; mi++)
                {

                    String col = maskDS.getString(mi, "colname");
                    String datamask = maskDS.getString(mi, "datamask").trim();
                    mask.put(col, datamask);
                }
                one.put(CS_DATAMASK, mask);
            }

            //2023.12.29 把有数据加密的字段配置也缓存起来
            mc = encryptModeDS.retrieve("  templateid='-" + templateid + "'  and query_table_name='" + name + "' ");

            ts.stamp("buildCache - retrieve encryptMode  for " + name);
            if (mc > 0)
            {
                JSONObject em = new JSONObject();

                for (int mi = 0; mi < mc; mi++)
                {

                    String col = encryptModeDS.getString(mi, "colname");
                    String encryptMode = encryptModeDS.getString(mi, "encryptMode").trim();
                    em.put(col, encryptMode);
                }
                one.put(CS_ENCRYPT_MODE, em);
            }


        }

        ts.stamp("buildCache - set  templateid->tableorQuery  start");

        AppCache.setCache(buildKey(templateid) + "->tableOrQuery", js.toString());

        ts.stamp("buildCache - set  templateid->tableorQuery over");

    }

    /**
     * 得到模板中所有的结果集名称及常规属性
     *
     * @param templateid
     * @return
     */
    public static JSONObject getTableOrQueryInTemplate(String templateid)
    {

        //缓存的内容格式，参看 ,标记20190702
        String t = AppCache.getCache(buildKey(templateid) + "->tableOrQuery", "");
        if (t.isEmpty())
        {

            FormCache.buildCache(templateid, null);
            t = AppCache.getCache(buildKey(templateid) + "->tableOrQuery", "");

        }
        return new JSONObject(t);
    }


    /**
     * 清除模块的缓存，通常在模块的模板或ID修改后，清除，现在简化处理了，只要是模块修改，都清除
     *
     * @param id
     * @param code
     */
    public static void clearModuleConfigCache(String id, String code)
    {
        //AppCache.removeCache( id + "->ModuleConfig");
        //if( !code.isEmpty()) AppCache.removeCache( code + "->ModuleConfig");

        if (id.isEmpty())   //如果不带 id,就是清除所有 ，否则就只是清除指定的
        {
            moduleCache.clear();
            moduleCache2LastModified.clear();
        }
        else
        {
            moduleCache.remove(id);
            moduleCache2LastModified.remove(id);
            //code 有可能为null，因为单据模块可以不设置code
            if (!code.isEmpty())
            {
                moduleCache.remove(code);
                moduleCache2LastModified.remove(code);
            }
        }


    }

    /**
     * 得到 单据或报表模块的定义  , 改用局部缓存
     *
     * @param type
     * @param idOrCode
     * @return
     */
    public static JSONObject getModuleConfig(String type, String idOrCode)
    {

        if (!type.equals("report")) type = "bill";

        //缓存的内容格式，参看 ,标记20190702
        // String t = AppCache.getCache(idOrCode + "->ModuleConfig", "");
        String t = "";
        if (moduleCache.containsKey(idOrCode)) t = moduleCache.get(idOrCode);

        if (t.isEmpty())
        {
            DBF dbf = DBF.getInstance();
            Connection con = null;
            try
            {
                con = dbf.getConnection();
                String sql = " select *   from v_app_" + type + " where  id='" + idOrCode + "'  or  code='" + idOrCode + "' ";
                //2022.10.27重大调整 ，因为 moduleCache是按 idOrCode 做key来缓存的，那么当 type搞错了，比如idOrCode是一个report ，但是
                // 调用 时，却传入了  type="bill"  这样就导致 idOrCode 对应的配置肯定是取不到了，于是缓存了[ ] 一个空配置到缓存中，下次即使再用 type="report"来
                // 获取信息，也将返回错误的[]
                sql = " select *   from v_app_" + type + " where  id='" + idOrCode + "'  or  code='" + idOrCode + "' ";
                DataStore ds = DataStoreFactory.newDataStore(con, sql);
                ds.retrieve();
                if (ds.getRowCount() == 0)
                {
                    //优先用指定的类型去取，如果取不到，那么再换另一个类型，再取一下
                    if (type.equals("report"))
                        sql = " select *   from v_app_bill where  id='" + idOrCode + "'  or  code='" + idOrCode + "' ";
                    if (type.equals("bill"))
                        sql = " select *   from v_app_report where  id='" + idOrCode + "'  or  code='" + idOrCode + "' ";
                    ds = DataStoreFactory.newDataStore(con, sql);
                    ds.retrieve();

                    //如果再取不到，那就是真的没有了
                }


                if (ds.getRowCount() > 0)
                {
                    t = ds.getJSON(0, true, false, false, true).toString();
                    //AppCache.setCache(ds.getString(0, "id") + "->ModuleConfig", t);
                    String id = ds.getString(0, "id");
                    moduleCache.put(id, t);
                    moduleCache2LastModified.put(id, System.currentTimeMillis());
                    String code = ds.getString(0, "code");
                    //if (!code.isEmpty()) AppCache.setCache(code + "->ModuleConfig", t);
                    if (!code.isEmpty())
                    {
                        moduleCache.put(code, t);
                        moduleCache2LastModified.put(code, System.currentTimeMillis());
                    }

                }
                else
                {
                    t = "{}";
                    //AppCache.setCache(idOrCode + "->ModuleConfig", t);
                    moduleCache.put(idOrCode, t);
                    moduleCache2LastModified.put(idOrCode, System.currentTimeMillis());

                }

                return new JSONObject(t);
            } catch (Exception e)
            {
                return new JSONObject();

            } finally
            {
                dbf.releaseConnection(con);
            }
        }
        return new JSONObject(t);
    }


    public static String getFormCache(String templateid)
    {
        return AppCache.getCache(buildKey(templateid), "");
    }

    public static String getFormLocalCache(String templateid)
    {
        return localFormCache.get(buildKey(templateid));
    }


    public static void setFormCache(String templateid, String formConfig)
    {
        String key = buildKey(templateid);
        localFormCache.put(key, formConfig);
        templateId2LastModified.put(templateid, new Date().getTime());

        AppCache.setCache(key, formConfig);


    }

    public static String getCache(String templateid, String what)
    {

        String ret = AppCache.getCache(buildKey(templateid) + "->" + what);
        if (ret == null) buildCache(templateid); //没有缓存，那么建立缓存

        ret = AppCache.getCache(buildKey(templateid) + "->" + what);
        if (ret == null)
        {
            FF.log("FormCache中可能没有对" + what + " 做缓存处理，请处理它，避免无效地重建缓存");
            ret = "";
        }

        return ret;
    }


    /**
     * 设置模板的服务端脚本中有哪些事件，在单据保存时要用到，参看 formEngine中的
     *
     * @param templateid
     * @param functionList
     */
    public static void setCacheForFunctionListOnServer(String templateid, String functionList)
    {
        if (functionList.isEmpty()) functionList = "[]";
        AppCache.setCache(buildKey(templateid) + "->" + CS_FunctionList, functionList);
    }


    public static void setCacheForFunctionCheckpointOnServer(String templateid, String functionCheckpoint)
    {
        AppCache.setCache(buildKey(templateid) + "->" + CS_FunctionCheckpoint, functionCheckpoint);
    }


    public static ArrayList<String> getUpdatedisabledColumns(String templateid)
    {
        String key = buildKey(templateid);

        String t = AppCache.getCache(key + "->" + CS_updatedisabledcolumns, "[]");
        JSONArray ja = new JSONArray(t);
        return ja.getArrayList();

    }

    public static JSONObject getModifylogColumns(String templateid)
    {
        String key = buildKey(templateid);

        String t = AppCache.getCache(key + "->" + CS_modifyLogColumns, "{}");
        JSONObject ja = new JSONObject(t);
        return ja;

    }


    /**
     * 算是指定模板的服务端脚本中的函数名清单（JSONArray)
     *
     * @param templateid
     * @return
     */
    public static String getCacheForFunctionListOnServer(String templateid)
    {
        String ret = AppCache.getCache(buildKey(templateid) + "->" + CS_FunctionList);
        if (ret == null || ret.isEmpty())
        { //参看 Notify  标记2019-703-1
            setCacheForFunctionListOnServer(templateid, FF.getStringFromSQL("", "select  value from app_script   " +
                    "  where  name='functionlist'  and " +
                    "               pid='" + templateid + "' "));
            ret = AppCache.getCache(buildKey(templateid) + "->" + CS_FunctionList);
        }

        return ret;
    }

    public static String getCacheForFunctionCheckpointOnServer(String templateid)
    {
        String ret = AppCache.getCache(buildKey(templateid) + "->" + CS_FunctionCheckpoint);
        if (ret == null)
        { //参看 Notify  标记2019-703-1
            setCacheForFunctionCheckpointOnServer(templateid, FF.getStringFromSQL("", "select  value from app_script   " +
                    "  where  name='functioncheckpoint'  and " +
                    "               pid='" + templateid + "' "));
            ret = AppCache.getCache(buildKey(templateid) + "->" + CS_FunctionCheckpoint);
        }

        return ret;
    }


    public static String getDBPoolForTableOrQuery(String templateId, String tableOrQueryName)
    {
        JSONObject dbConfig = FormCache.getTableOrQueryInTemplate(templateId);
        JSONObject one = dbConfig.getJSONObject(tableOrQueryName, null);
        if (one == null) return "";
        String dbpool = one.getString("dbpool", "default");
        if (dbpool.isEmpty()) dbpool = "default";
        return dbpool;
    }


}

