/*
 * Created on 2004-11-19
 *
 *
 * 2020.04.02  增加了 缓存构建好的 CSP内容
 *
 */

package util;


import LocalMemoryCache.InMemoryCacheWithDelayQueue;
import app.CustomizedHostnameVerifier;
import app.Ilog;
import app.TrustAllManager;
import app.User;
import appCache.UserAndDepartmentCache;
import ch.qos.logback.core.Appender;
import com.alibaba.druid.support.http.util.IPAddress;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;

import config.CacheConfig;
import dfs.*;
import freemarker.template.Configuration;
import freemarker.template.Template;
import http.OkHttpUtil;
import jun.db.core.DataAdapter;
import jun.db.core.DataStore;
import jun.db.core.ObjectTool;
import jun.db.util.*;

import jun.db.core.UniformDataType;
import jun.db.impl.DataStoreFactory;
import mq_zbus.MessageProducer;
import okhttp3.*;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;

import org.apache.http.client.config.CookieSpecs;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.*;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.apache.regexp.RE;
import org.apache.xmlbeans.impl.jam.JParameter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.nfunk.jep.function.PostfixMathCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.slf4j.MDC;
import webApp.App;
import webApp.PushLog;
import websocket.PushServer;
import websocketRPC.WSRPC;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.imageio.ImageIO;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.Query;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import javax.sql.XAConnection;
import java.awt.*;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.*;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.*;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.*;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.*;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.Date;
import java.util.List;
import java.util.Map.Entry;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

import static java.lang.ThreadLocal.*;
import static util.DBFunction.isSqlServer;
import static util.DBFunction.isSybase;


import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.BasicCookieStore;


/**
 *
 */
public class FF
{

    //httpClient
    private static CloseableHttpClient httpClient;

    static
    {

        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        //连接池最大生成连接数
        cm.setMaxTotal(1000);
        // 默认设置route最大连接数为
        cm.setDefaultMaxPerRoute(500);
        // 指定专门的route，设置最大连接数为80
        //HttpHost localhost = new HttpHost("locahost", 80);
        //cm.setMaxPerRoute(new HttpRoute(localhost), 50);

        /*
        首先创建了一个BasicCookieStore实例来存储cookie，然后通过HttpClientContext.create()
        创建了一个HttpClientContext实例，并将其cookie存储设置为我们刚刚创建的cookie store。
        在执行实际的HTTP请求时，HttpClient将使用这个上下文实例，而这个实例是没有任何cookie的。
        这样就实现了在执行请求前清除cookie的目的。
         */
        // 创建一个新的Cookie存储
        CookieStore cookieStore = new BasicCookieStore();
        // 创建HttpClientContext实例，并设置清除的Cookie存储
        HttpClientContext context = HttpClientContext.create();
        context.setCookieStore(cookieStore);

        HttpClientBuilder hcb = HttpClients.custom()
                .setConnectionManager(cm)  //线程池策略
                .setDefaultCookieStore(cookieStore); //cookie策略

        try
        {
            SSLContext sslContext = new SSLContextBuilder()
                    .loadTrustMaterial(null,
                                       new TrustStrategy()
                                       {
                                           //信任所有
                                           public boolean isTrusted(X509Certificate[] chain,
                                                                    String authType) throws CertificateException
                                           {
                                               return true;
                                           }
                                       }).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext);
            //https通用策略
            hcb.setSSLSocketFactory(sslsf);
        } catch (KeyManagementException e)
        {
            FF.log(FF.exceptionMessage(e));
        } catch (NoSuchAlgorithmException e)
        {
            FF.log(FF.exceptionMessage(e));
        } catch (KeyStoreException e)
        {
            FF.log(FF.exceptionMessage(e));
        }

        //
        httpClient = hcb.build();
    }

    public final static String SUCCESS = "success";
    public final static String MESSAGE = "message";

    public static ArrayList<Ilog> additionalLog = new ArrayList<Ilog>();

    public static final String CONTENT_TYPE = "text/html; charset=UTF-8";
    public static final String ScriptEngineEmulateUser = MD5("ScriptEngineEmulateUser");
    public static EmulateHttpServletRequest EHR = new EmulateHttpServletRequest();
    //用来缓存一些经常用到的需要加密的内容，比如 userid的加密 ， url地址的加密，频繁用到
    public static ConcurrentHashMap<String, String> cachedencryptString = new ConcurrentHashMap<>();

    //控制是否显示日志到控制台， 便于调试 ，但是正式运行时，是不能输出到控制台的
    private static boolean log2console = FF.fileExists("/Users/zengjun/IdeaProjects/jun/util/src/util/FF.java");

    public static Logger logger = null;
    public static boolean logToConsole = false;
    public static boolean logToFile = true;
    public static boolean zbusEnable = true;


    public static final String spaceToken = "~-~";


    public static String REGEX_LETTER = "[$A-Z_a-z0-9\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u00ff\u0100-\u1fff\u3040-\u318f\u3300-\u337f\u3400-\u3d2d\u4e00-\u9fff\uf900-\ufaff]+";
    public static String INCLUDE = "[$]include\\s*[(]\\s*['\"](" + REGEX_LETTER + ")['\"]\\s*[)]\\s*;{0,1}";

    public static String REQUIRE = "[$]require\\s*[(]\\s*['\"](" + REGEX_LETTER + ")['\"]\\s*[)]\\s*;{0,1}";


    public static boolean log2sa = false;
    public static String defaultEncryptKey = "Somebody";
    public static String homeURL = "";

    public final static String TOKENID = "tokenid";
    public static String ENCRYPTED_TOKENID;

    public final static String KEY_FileServer = "Superman";  // 打印助手中也要同步修改


    static
    {
        ENCRYPTED_TOKENID = FF.encryptString(TOKENID);
    }

    public static void setHomeURL(String url)
    {
        homeURL = url;
    }

    public static String getHomeURL()
    {
        return homeURL;
    }

    public static String getHomeURL(HttpServletRequest req)
    {
        String url = req.getRequestURL().toString();
        String uri = req.getRequestURI();
        String ret = url.substring(0, url.length() - uri.length());
        if (ret.endsWith("/")) ret = ret.substring(0, ret.length() - 1);
        return ret;
    }

    public static String getCachedEncryptedString(String str)
    {
        String ret = cachedencryptString.get(str);
        if (ret == null)
        {
            ret = FF.encryptString(str);
            cachedencryptString.put(str, ret);
        }
        return ret;
    }

    public static String getFirstPY(String str)
    {
        if (str == null) return "";
        if (str.isEmpty()) return "";
        String first_char = str.substring(0, 1);
        String ret = CnToSpell.getFullSpell(first_char);
        if (!ret.isEmpty()) ret = ret.substring(0, 1);
        return ret;
    }


    public static String getVMProperty(String propName, String defaultValue)
    {
        String s = System.getenv(propName);
        if (s == null) s = System.getProperty(propName);
        if (s == null) s = defaultValue;
        return s;

    }

    public static int getVMProperty(String propName, int defaultValue)
    {
        String s = System.getenv(propName);
        if (s == null) s = System.getProperty(propName);
        if (s == null) s = "" + defaultValue;
        return FF.String2Int(s);

    }

    /**
     * 把字符串中的特殊符号转换成
     *
     * @param s
     * @return
     */
    public static String escape(String s)
    {

        s = s.replaceAll("\\\\", "\\\\\\\\"); // 把\ 换成\\
        s = s.replaceAll("'", "\\\\'"); // 把 ' 换成 \'
        s = s.replaceAll("\"", "\\\\\""); // 把 " 换成 \"
        s = s.replaceAll("\\\\n", "");
        s = s.replaceAll("\\\\r", "");
        s = s.replaceAll("\\n", "");
        s = s.replaceAll("\\r", "");

        // FF.log(s);
        return s;
    }

    public static boolean isSQLFileForDialect(String dbpool, String fileName)
    {
        //不以$开头，那么就是通用的，也返回true
        if (!fileName.startsWith("$")) return true;
        String con = dbpool;
        if (isSqlServer(con)) return fileName.startsWith("$sqlserver_");
        if (DBFunction.isMySQL(con)) return fileName.startsWith("$mysql_");
        if (DBFunction.isOracle(con)) return fileName.startsWith("$oracle_");
        if (DBFunction.isH2(con)) return fileName.startsWith("$h2_");
        if (DBFunction.isPostgres(con)) return fileName.startsWith("$postgre_");

        return false;

    }

    public static String dropIndex(String dbpool, String indexName)
    {
        DBF dbf = DBF.getInstance();
        Connection con = null;

        try
        {
            con = dbf.getConnection(dbpool);
            DataAdapter da = DataStoreFactory.createDataAdapter(con);
            return da.dropIndex(con, indexName);


        } catch (Exception e)
        {
            String err = FF.exceptionMessage(e);
            FF.log("drop index  error: " + err);
            return err;
        } finally
        {
            dbf.releaseConnection(con);
        }


    }


    public static int getIntFromRequest(HttpServletRequest req, String name, int defaultValue)
    {
        String s = req.getParameter(name);
        if (s == null)
        {
            // FF.log("没有取到"+name+"  从queryString中取");
            s = getStringFromRequest(req, name, String.valueOf(defaultValue));
            if (s == null) return defaultValue;

        }

        if (s.trim().isEmpty()) return defaultValue;
        try
        {
            return new Integer(s).intValue();
        } catch (Exception e)
        {
            return defaultValue;
        }
    }

    public static String getStringFromRequest(HttpServletRequest req, String name, String defaultValue)
    {
        //2025.08.26 默认把sql注入防范功能改为默认开启

        String ret = getStringFromRequest(req, name, defaultValue, "", true);
        return ret;


    }


    public static String getStringFromRequest(HttpServletRequest req, String name, String defaultValue, String forceCharset, boolean sqlInject)
    {

        String s = req.getParameter(name);
        // 2007.07.10 如果是get方式传传递的参数，那么不可能会出现空格字符，如果出现，多半是
        // 页面中的数据经过浏览器中的escape函数编码后出现+字段，当取得它时+变成了空格
        // 所以需要把空格还原成+
        //2017.12 增加选项，是否需要把空格转成+号
        if (s != null)
        {

            if (req.getMethod().equalsIgnoreCase("get"))
            {
                String space2plus = req.getParameter("space2plus");
                if (space2plus == null) space2plus = "false";
                if (space2plus.equals("true"))
                {
                    while (s.indexOf(' ') > 0)
                    {
                        s = s.replace(' ', '+');
                    }
                }
            }
        }

        if (s == null)
        {
            s = getStringFromQueryString(req, req.getQueryString(), name, defaultValue, forceCharset);
        }

        if (s == null) return defaultValue;
        //如果地址栏中必须出现空格，那么使用一个特殊字符串表示空格
        // 这要主要用在定义工作台时， 如果参数中有空格，那么在编码前会自动替换成一个空格占位符
        // 传到服务器后，需要再替换回来
        s = FF.replaceAll(s, spaceToken, " "); //空格

        if (s.trim().isEmpty()) return defaultValue;

        // 不能在这里自动解码。因为，可能程序里就是要用没有解码的数据
        // s=escape.unescape(s); //自动解码一次，程序里不不需要再解码了

        //2025.01.01 增加 防止sql注入
        if (sqlInject) s = JSONObject.encodeForSQL(s);
        return s;
    }

    public static String HTML2Text(String s)
    {
        return HTML2Text(s, false);
    }

    public static String HTML2Text(String s, boolean holdBR)
    {


        StringBuffer sb = new StringBuffer();
        if (s == null) return s;


        int len = s.length();
        String tagName = "";
        boolean tagNameOver = false;
        boolean inTag = false;
        char c;
        for (int i = 0; i < len; i++)
        {
            c = s.charAt(i);
            if (c == '<')
            {
                inTag = true;
                tagName = "";
                tagNameOver = false;
            }
            else if (c == '>')
            {
                inTag = false;
                if (tagName.startsWith("/"))
                {
                    tagName = tagName.toLowerCase();
                    if (tagName.equals("/p")) sb.append("<br>");
                    if (tagName.equals("/div")) sb.append("<br>");

                }
            }
            else
            {
                if (!inTag) sb.append(c);
                if (inTag)
                {
                    if (c == ' ')
                    {
                        tagNameOver = true;
                    }

                    if (!tagNameOver) tagName = tagName + c;
                }
            }
        }

        //2007.03.16 增加特殊字符的替换
        s = sb.toString();
        s = replaceAll(s, "&nbsp;", " ");
        s = replaceAll(s, "&lt;", "<");
        s = replaceAll(s, "&gt;", ">");
        s = replaceAll(s, "\r", "");
        s = replaceAll(s, "\n", "");


        return s;
    }

    public static String stringInc(String code)
    {
        String newcode = "";
        char c;
        int i, n, delta, len;
        delta = 1;

        len = code.length();
        for (i = len - 1; i >= 0; i--)
        {
            c = code.charAt(i);

            if (delta == 1) //   if_001
            {
                if ((int) c >= (int) '0' && (int) c <= (int) '9')
                {
                    n = (int) c;
                    if ((int) n < (int) '9')
                    {
                        c = (char) ((byte) c + 1);
                        delta = 0;
                    }
                    else
                    {
                        c = '0';
                        delta = 1;
                    }
                }
                else
                {
                    if ((int) c >= (int) 'a' && (int) c <= (int) 'z')
                    {
                        if ((int) c < (int) 'z')
                        {
                            c = (char) ((byte) c + 1);
                            ;
                            delta = 0;
                        }
                        else
                        {
                            c = 'a';
                            delta = 1;
                        }
                    }
                    else
                    {
                        if ((int) c >= (int) 'A' && c <= (int) 'Z')
                        {
                            if ((int) c < (int) 'Z')
                            {
                                c = (char) ((byte) c + 1);
                                ;
                                delta = 0;
                            }
                            else
                            {
                                c = 'A';
                                delta = 1;
                            }
                        }
                    }
                }
            } // end if_001

            newcode = c + newcode;

            if (delta == 1 && i == 0) //如果到了第一位还有进位
            {
                if (code.equals(newcode)) //如果代码没有变，在末位添加
                    newcode = newcode + "0001";
                else
                    //在头部加一个‘1’
                    newcode = "1" + newcode;
            }
        }

        if (code.equals(newcode))
        {
            code = newcode + "0001";
        }
        else
        {
            code = newcode;
        }
        return code;
    }

    public static String getValueFromAppSecret(String path)
    {
        if (!path.startsWith("/")) return path; //如果是密文路径，必须是以/打头，如果不是，表示就是明文
        String t = getStringFromSQL("select value from app_secret where pid  in " +
                                            "(select id from app_secret where fullname='" + path + "') " +
                                            " and name='password' ");
        if (t.isEmpty()) return path;
        if (t.startsWith(App.PASSWORD_PREFIX)) t = t.substring(App.PASSWORD_PREFIX.length());
        t = decryptString(t, new String(Base32Coder.decode("NJ2W46TFNZTTCMRRGE======")));
        return t;
    }

    /**
     * @param queryString
     * @param name
     * @param defaultValue
     * @param forceCharset 如果不为'", 表示需要进行 URLDecoder.decode 转换
     * @return
     */
    public static String getStringFromQueryString(HttpServletRequest req, String queryString, String name, String defaultValue, String forceCharset)
    {
        if (queryString == null) return defaultValue;

        if (!queryString.startsWith("?")) queryString = "?" + queryString;
        // FF.log( queryString);

        RE re = new RE("([&?]){1}" + name + "=(.*)");
        if (re.match(queryString))
        {
            String s = queryString.substring(re.getParenStart(2), re.getParenEnd(2));
            int p = s.indexOf("&");
            if (p >= 0) s = s.substring(0, p);
            p = s.indexOf("?");
            if (p >= 0) s = s.substring(0, p);
            // FF.log( s);

            try
            {
                if (!forceCharset.isEmpty()) s = URLDecoder.decode(s, forceCharset);

                // 2008.03.12 如果是get方式传递的参数，其中肯定不应该有空格存在，有的话，也
                // 很可能是上面的URLDecoder.decoder把+转换成了空格
                if (req != null)
                {
                    if (req.getMethod().equalsIgnoreCase("get"))
                    {
                        while (s.indexOf(' ') > 0)
                        {
                            s = s.replace(' ', '+');
                        }
                    }
                }

            } catch (Exception e)
            {
                FF.log("getStringFromQueryString 发生意外:" + e.getMessage());
                // 如果把数据进行 escape编码后，，上面的 URLDecoder.decode 会引发异常
                s = Escape.unescape(s);

            }

            //如果地址栏中必须出现空格，那么使用一个特殊字符串表示空格
            // 这要主要用在定义工作台时， 如果参数中有空格，那么在编码前会自动替换成一个空格占位符
            // 传到服务器后，需要再替换回来
            s = FF.replaceAll(s, spaceToken, " "); //空格

            return s;

        }
        else
        {
            return defaultValue;
        }

    }

    public static String exceptionMessage(Throwable e)
    {
        if (e == null) return "";
        String msg = e.getMessage();
        if (msg == null) msg = "";
        msg = msg + exceptionMessage(e.getCause());
        if (msg.isEmpty() || msg.equalsIgnoreCase("null")) msg = e.getClass().getName();
        return msg;
    }

    /**
     * 得到一个去掉时间的日期
     *
     * @param d
     * @return
     */
    public static Date NoTimeDate(Date d)
    {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        int year = cal.get(Calendar.YEAR);
        int month = cal.get(Calendar.MONTH);
        int day = cal.get(Calendar.DAY_OF_MONTH);
        GregorianCalendar cal2 = new GregorianCalendar(year, month, day);
        return cal2.getTime();

    }

    /**
     * 保证 星期一是1
     *
     * @param week
     * @return
     */
    public static int WeekNo(int week)
    {
        if (week == Calendar.SATURDAY) return 6;
        if (week == Calendar.SUNDAY) return 7;
        return week - Calendar.MONDAY + 1;
    }

    /**
     * 返回某天的下N天
     *
     * @param d
     * @param n
     * @return
     */
    public static Date NextDay(Date d, int n)
    {
        Date ret = (Date) d.clone();
        Calendar cal = Calendar.getInstance();
        cal.setTime(ret);
        cal.add(Calendar.DAY_OF_MONTH, n);
        return cal.getTime();

    }


    public static byte[] readBytesFromFile(String fileName)
    {
        return readBytesFromFile(fileName, "UTF-8");
    }

    public static byte[] readBytesFromFile(String fileName, String charsetName)
    {

        String s = ReadFile(fileName, charsetName);


        return s.getBytes();

    }

    public static long fileSize(String file)
    {
        File f = new File(file);
        if (!f.exists()) return 0;
        return f.length();

    }


    @Deprecated
    public static String ReadFile(String fileName)
    {
        return readFile(fileName, null);
    }


    @Deprecated
    public static String ReadFile(String fileName, String charsetName)
    {
        return readFile(fileName, charsetName);
    }

    public static String readFile(String fileName)
    {
        return readFile(fileName, null);
    }

    // 把文件读入到byte中,
    // 2008.09.17 增加了字符集的自适应
    public static String readFile(String fileName, String charsetName)
    {

        if (!FF.fileExists(fileName)) return ""; // fileExists 内会对fileName做编码转换处理，所以不需要先转换

        //2010.02.22增加对文件名编码转换的支持
        fileName = (fileName);

        StringBuffer sb = new StringBuffer(1024);


        if (charsetName == null)
        {
            charsetName = DataStoreFactory.charsetDetect(fileName);
            if (!charsetName.equals("UTF-8"))
            {
                //FF.log("文件"+fileName+"字符集是："+charsetName);
            }
        }

        try (BufferedReader in = new BufferedReader(new InputStreamReader(Files.newInputStream(Paths.get(fileName)), charsetName)))
        {


            String line;
            boolean firstLine = true;
            while (true)
            {
                line = in.readLine();

                if (line == null) break;
                if (!firstLine) sb.append("\r\n");
                sb.append(line);
                firstLine = false;
            }


        } catch (Exception e)
        {

        }
        return sb.toString();
    }

    public static String readFromStream(InputStream is)
    {
        return readFromStream(is, "UTF-8");
    }

    public static String readFromStream(InputStream is, String charsetName)
    {


        StringBuffer sb = new StringBuffer(1024);

        BufferedReader in = null;
        if (charsetName == null) charsetName.equals("UTF-8");

        try
        {

            in = new BufferedReader(new InputStreamReader(is, charsetName));

            String line;
            boolean firstLine = true;
            while (true)
            {
                line = in.readLine();

                if (line == null) break;
                if (!firstLine) sb.append("\r\n");
                sb.append(line);
                firstLine = false;
            }

            in.close();
        } catch (Exception e)
        {

        } finally
        {
            try
            {
                if (in != null) in.close();

            } catch (Exception e)
            {

            }
        }
        return sb.toString();
    }


    public static boolean dirExists(String path)
    {
        File dir = new File((path));
        if (dir == null) return false;
        return dir.exists();
    }

    public static boolean MkDirs(String path)
    {

        File nextFile = new File((path));
        if (!nextFile.exists())
        {
            FF.log("创建目录：" + path);
            nextFile.mkdirs();
        }
        return nextFile.exists();
    }

    public static String pathJoin(String path1, String path2)
    {
        if (path2.isEmpty()) return path1;
        path1 = path1.replaceAll("\\\\", "/");
        path2 = path2.replaceAll("\\\\", "/");


        if (path2.startsWith("/") || path2.startsWith("\\")) path2 = path2.substring(1);
        if (path2.isEmpty()) return path1;

        if (!path1.endsWith("/") && !path1.endsWith("\\")) path1 = path1 + "/";
        return path1 + path2;
    }

    public static void makeSignFile(String path, String filename)
    {
        try
        {

            FF.MkDirs(path);

            File f = new File((path), (filename));

            if (!f.exists()) f.createNewFile();
        } catch (Exception e)
        {

        }

    }

    // 删除一级目录 ， 比如 DelDirs("d:/a/b/c/d") 是仅仅删除最末级的目录d
    public static boolean delTree(String path)
    {

        // path 是用于显示的路径，实际使用时需要转码
        if (path == null) return false;
        File dir = new File((path));
        if (!dir.exists()) return true;
        if (!dir.isDirectory()) return deleteFile(path);

        String files[] = dir.list();
        for (int i = 0; i < files.length; i++)
        {
            if (files[i].equals(".")) continue;
            if (files[i].equals("..")) continue;
            String f = (files[i]);
            delTree(path + File.separator + f);
        }

        return dir.delete();

    }

    public static boolean deleteFile(String file)
    {
        file = (file);
        File nextFile = new File(file);
        if (!nextFile.exists()) return true;

        return nextFile.delete();

    }

    public static boolean fileExists(String file)
    {
        file = (file);

        File nextFile = new File(file);
        return nextFile.exists();

    }


    /**
     * 判断 name是不是一个合法的文件名
     * 简单的办法就是以它为名称写一个文件，文件存在，就合法 ，文件不存在就肯定是名称不合法
     *
     * @param name
     * @return
     */
    public static boolean isValidFileName(String name)
    {
        String tempPath = App.FileRoot + "/FileServer/autoDeleteAfterOneHour";
        FF.MkDirs(tempPath);
        String tempFile = tempPath + "/" + DataStoreFactory.newLongID2String() + name; //避免其它人也用就个名称， 所以拼上一个数字
        FF.SaveToFile(tempFile, "test");

        boolean ret = FF.fileExists(tempFile);

        FF.deleteFile(tempFile);
        return ret;


    }

    public static void makeSurePathOfFileExists(String fileName)
    {
        int p = fileName.lastIndexOf("/");
        String path = fileName;
        if (p > 0) path = fileName.substring(0, p);
        MkDirs(path);
    }

    public static String fileSizeTip(long fieSize)
    {
        DecimalFormat df = new DecimalFormat("###,###,###.0");
        DecimalFormat df2 = new DecimalFormat("###,###,###");

        String size;
        if (fieSize < 1024)
        {
            size = fieSize + "B";
            ;
        }
        else if (fieSize < 1024 * 1024)
        {

            size = df.format(fieSize / 1024.0) + "K";
        }
        else if (fieSize < 1024 * 1024 * 1024)
        {
            size = df.format(fieSize / (1024 * 1024.0)) + "M";
        }
        else if (fieSize < 1024 * 1024 * 1024 * 1024)
        {
            size = df.format(fieSize / (1024 * 1024.0 * 1024)) + "G";
        }
        else
        {
            size = "too big";
        }
        return size;
    }

    /**
     * 保证文本是没有回车，不带绝对路径, 没有双引号
     *
     * @param request
     * @param content
     * @return
     */
    public static String SafeHTMLSource(HttpServletRequest request, String content, boolean escapeDYH)
    {

        if (request != null)
        {

            String s1 = "http://" + request.getServerName() + ":8080";
            String s2 = "http://" + request.getServerName() + ":9080";
            String s3 = "http://" + request.getServerName();
            content = FF.replaceAll(content, s1, "");
            content = FF.replaceAll(content, s2, "");
            content = FF.replaceAll(content, s3, "");

        }

        content = content.replaceAll("\r\n", "");
        content = content.replaceAll("\r", "");
        content = content.replaceAll("\n", "");

        if (escapeDYH) content = content.replaceAll("'", "&#039;");

        return content;
    }

    public static String removeAbsoluteURLPath(HttpServletRequest request, String content)
    {

        if (request != null)
        {

            String s1 = "http://" + request.getServerName() + ":" + request.getServerPort();
            // String s2 = "http://" + request.getServerName() + ":9080" ;
            String s3 = "http://" + request.getServerName();
            content = FF.replaceAll(content, s1, "");
            // content =FF.replaceAll( content, s2, "");
            content = FF.replaceAll(content, s3, "");

        }

        return content;
    }

    //本地文件复制到临时目录供下载 ，然后自动再删除
    public static String file2TempUrl(String file)
    {
        String[] t = splitFileName(file);
        String shortName = "";
        String extName = "";
        if (t.length == 2) shortName = t[1];
        if (t.length == 3)
        {
            shortName = t[1] + "." + t[2];
            extName = t[2];
        }

        String tempFile = App.FileRoot + "/FileServer/autoDeleteAfterOneHour/" + DataStoreFactory.newGUID() + "." + extName;
        FF.fileCopy(file, tempFile, true);

        try
        {
            String url = "deleteAfterDownloaded?" +
                    "sourcename=" + FF.encryptString(tempFile, DowneloadAndDelete.pwd) +
                    "&filename=" + FF.encryptString(shortName, DowneloadAndDelete.pwd) +
                    "&action=download";
            return url;
        } catch (Exception e)
        {
            FF.log("file2TempUrl  error:" + e.getMessage());
            return file;
        }

    }

    // 与 SafeHTMLSource 是有区别的
    // 侧重于单引号的替换
    public static String SafeScriptString(HttpServletRequest request, String content)
    {

        if (request != null)
        {

            String s1 = "http://" + request.getServerName() + ":" + String.valueOf(request.getLocalPort());
            String s2 = "http://" + request.getServerName();
            content = content.replaceAll(s1, "");
            content = content.replaceAll(s2, "");
        }

        content = content.replaceAll("\r\n", "");
        content = content.replaceAll("\r", "");
        content = content.replaceAll("\n", "");

        content = content.replaceAll("\\\\", "\\\\\\\\"); // 要放在替换 ' 前面

        content = content.replaceAll("'", "\\\\'");

        return content;
    }


    public static String appendWhere(String w, String s, String andor)
    {
        return appendWhere(w, s, andor, true);
    }

    public static String appendWhere(String w, String s, String andor, boolean parentheses)
    {
        if (w == null) w = "";
        if (s == null) s = "";
        if (w.trim().isEmpty()) return s;
        if (s.trim().isEmpty()) return w;

        //需不需要用括号括起来
        if (parentheses) return "(" + w + ")  " + andor + "  (" + s + ")";
        return w + " " + andor + " " + s;
    }


    /**
     * 得到应用的根目录
     *
     * @param req
     * @return
     */
    public static String getAppRootRealPath(HttpServletRequest req)
    {
        return FF.getAppRealPath(req.getSession().getServletContext(), "");

    }

    public static String encryptString(String s)
    {
        return encryptString(s, defaultEncryptKey);
    }

    public static String encryptString(String s, String keys)
    {

        if (keys.length() < 8) keys = keys + "00000000".substring(0, 8 - keys.length());

        try
        {
            byte rawKeyData[] = keys.getBytes();
            // DES算法要求有一个可信任的随机数源
            SecureRandom sr = new SecureRandom();

            // 从原始密匙数据创建DESKeySpec对象
            DESKeySpec dks = new DESKeySpec(rawKeyData);

            // 创建一个密匙工厂，然后用它把DESKeySpec转换成
            // 一个SecretKey对象
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey key = keyFactory.generateSecret(dks);

            // Cipher对象实际完成加密操作
            Cipher cipher = Cipher.getInstance("DES");

            // 用密匙初始化Cipher对象
            cipher.init(Cipher.ENCRYPT_MODE, key, sr);

            // 现在，获取数据并加密
            byte data[] = s.getBytes();

            // 正式执行加密操作
            byte encryptedData[] = cipher.doFinal(data);

            // 进一步处理加密后的数据
            return new String(Base32Coder.encode(encryptedData));
        } catch (Exception e)
        {
            return s;
        }
    }

    public static String getEncryptKey()
    {
        return FF.get_yyyyMMdd_Date(new Date());
    }

    public static String decryptString(String s)
    {
        if (s == null) return s;
        if (s.isEmpty()) return s;
        return decryptString(s, defaultEncryptKey);
    }

    public static String decryptString(String s, String keys)
    {
        if (s == null) return s;
        if (s.isEmpty()) return s;
        if (keys.length() < 8) keys = keys + "00000000".substring(0, 8 - keys.length());

        try
        {
            // DES算法要求有一个可信任的随机数源
            SecureRandom sr = new SecureRandom();

            byte rawKeyData[] = keys.getBytes();

            // 从原始密匙数据创建一个DESKeySpec对象
            DESKeySpec dks = new DESKeySpec(rawKeyData);

            // 创建一个密匙工厂，然后用它把DESKeySpec对象转换成
            // 一个SecretKey对象
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey key = keyFactory.generateSecret(dks);

            // Cipher对象实际完成解密操作
            Cipher cipher = Cipher.getInstance("DES");

            // 用密匙初始化Cipher对象
            cipher.init(Cipher.DECRYPT_MODE, key, sr);

            // 现在，获取数据并解密
            byte encryptedData[] = Base32Coder.decode(s);

            // 正式执行解密操作
            byte decryptedData[] = cipher.doFinal(encryptedData);

            // 进一步处理解密后的数据
            return new String(decryptedData);
        } catch (Exception e)
        {
            //FF.log(e);
            return "";
        }

    }

    public static String String2Code(String s)
    {

        StringBuffer sb = new StringBuffer(1024);

        for (int i = 0; i < s.length(); i++)
        {
            int a = (int) (s.charAt(i));
            if (a > 255)
            {
                sb.append("&#" + new Integer(a) + ";");
            }
            else
            {
                sb.append(String.valueOf(s.charAt(i)));

            }
        }
        return sb.toString();
    }


    public static String replaceAll(String source, String what, String to)
    {
        RE re = new RE(what);
        while (re.match(source))
        {
            source = source.substring(0, re.getParenStart(0)) + to + source.substring(re.getParenEnd(0));
        }
        return source;

    }

      /**
         * 将字符串中所有出现的指定内容替换为另外的内容
         * @param source 原始字符串
         * @param target 要被替换的内容
         * @param replacement 替换为的内容
         * @return 替换后的字符串
         */
        public static String replaceAllWithoutRegix(String source, String target, String replacement) {
        // 处理边界情况
        if (source == null || target == null || replacement == null) {
            return source;
        }
        if (target.isEmpty()) {
            return source;
        }

        StringBuilder result = new StringBuilder();
        int startIndex = 0;
        int targetLength = target.length();
        int foundIndex;

        // 循环查找并替换所有出现的target
        while ((foundIndex = source.indexOf(target, startIndex)) != -1) {
            // 添加target之前的部分
            result.append(source, startIndex, foundIndex);
            // 添加替换内容
            result.append(replacement);
            // 更新查找起始位置
            startIndex = foundIndex + targetLength;
        }

        // 添加最后剩余的部分
        result.append(source.substring(startIndex));

        return result.toString();
    }

    public static String SafeExecute(String sql)
    {
        return SafeExecute("", sql);
    }

    public static String SafeExecute(String dsn, String sql)

    {
        return SafeExecute(dsn, sql, true);
    }

    public static String SafeExecute(String dsn, String sql, boolean printError)
    {

        DBF dbf = DBF.getInstance();
        Connection con = null;
        int ret = 0;
        try
        {
            con = dbf.getConnection(dsn);
            return SafeExecute(con, sql, printError);
        } catch (Exception e)
        {
            return e.getMessage();
        } finally
        {
            dbf.releaseConnection(con);
        }
    }

    public static String SafeExecute(Connection con, String sql)
    {
        return SafeExecute(con, sql, true);
    }


    /**
     * 在主数据库，及user_id 对应的数据库中执行指定SQL
     *
     * @param user_id
     * @param sqlList1
     * @param sqlList2
     * @return
     */
    public static String XAExecuteSQL(int user_id, ArrayList<String> sqlList1, ArrayList<String> sqlList2)
    {

        DBF dbf = DBF.getInstance();
        XAConnection con = null, userCon = null;

        try
        {

            con = dbf.getXAConnection();

            userCon = dbf.getXAConnection(user_id);

            XA xa = new XA();

            xa.execute(con, userCon, sqlList1, sqlList2);

            return "";
        } catch (Exception e)
        {

            return e.getMessage();
        } finally
        {
            dbf.releaseXAConnection(con);
            dbf.releaseXAConnection(userCon);

        }
    }


    public static String stackTrace()
    {
        StringBuffer sb = new StringBuffer();
        try
        {

            ByteArrayOutputStream b = new ByteArrayOutputStream();
            PrintStream pw = new PrintStream(b);
            Throwable th = new Throwable();
            th.printStackTrace(pw);
            // FF.log( b.toString());
            StringTokenizer stk = new StringTokenizer(b.toString(), "\n");
            int n = 0;
            while (stk.hasMoreElements())
            {
                String t = stk.nextToken();
                if (t.startsWith("	at") || true)
                {
                    if (t.indexOf("java.lang.Throwable") > 0) continue;

                    if (t.indexOf("util.FF.stackTrace") > 0) continue;
                    if (t.indexOf("util.FF.SafeExecute") > 0) continue;
                    if (t.indexOf("util.DBF.getConnection") > 0) continue;  //.releaseConnection 配对


                    if (t.indexOf("org.apache.jasper.runtime.HttpJspBase.service") > 0) break;
                    n++;
                    if (n > 0)
                    {
                        sb.append(t).append("\n");

                    }
                    if (n > 20) break;
                }
            }

        } catch (Exception e)
        {

        }
        return sb.toString();
    }

    public static String SafeExecute(Connection con, String sql, boolean printError)
    {

        if (sql == null || sql.isEmpty())
        {
            FF.log("SafeExecute执行null语句，其中的调用层次是：\n" + stackTrace());
        }

        Statement cmd = null;
        try
        {
            cmd = con.createStatement();
            DataAdapter da = DataStoreFactory.createDataAdapter(con);
            sql = da.toLocalSyntax(sql);
            cmd.execute(sql);

        } catch (SQLException e)
        {
            String err = "<font color=red>Error：" + e.getMessage() + "</font><br>源语句是：<font color=green>" + sql + "</font>";
            if (printError) log(err);
            return err;
        } finally
        {
            try
            {
                cmd.close();
            } catch (Exception er)
            {
            }

        }

        return "";
    }

    public static String SafeExecute(Connection con, String[] sqlList, boolean printError)
    {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < sqlList.length; i++)
        {
            list.add(sqlList[i]);
        }
        return SafeExecute(con, list, printError);
    }

    public static String SafeExecute(String con, String[] sqlList, boolean printError)
    {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < sqlList.length; i++)
        {
            list.add(sqlList[i]);
        }
        return SafeExecute(con, list, printError);
    }

    public static String SafeExecute(String dbpool, ArrayList sqlList, boolean printError)
    {
        DBF dbf = DBF.getInstance();
        Connection con = null;
        try
        {
            con = dbf.getConnection(dbpool);
            return SafeExecute(con, sqlList, printError);
        } catch (Exception e)
        {

        } finally
        {
            dbf.releaseConnection(con);
        }
        return "";

    }

    public static String SafeExecute(Connection con, ArrayList sqlList, boolean printError)
    {

        Statement cmd = null;
        try
        {
            cmd = con.createStatement();
            DataAdapter da = DataStoreFactory.createDataAdapter(con);
            //log("批量执行语句开始");
            for (int i = 0; i < sqlList.size(); i++)
            {
                String sql = (String) sqlList.get(i);
                sql = da.toLocalSyntax(sql);
                //  log(sql);
                cmd.addBatch(sql);
            }
            cmd.executeBatch();
            // log("批量执行语句结束");
        } catch (SQLException e)
        {
            String err = "SafeExecute提示：" + e.getMessage() + "\r\n源语句是：" + sqlList.toString();
            if (printError) log(err);
            return err;
        } finally
        {
            try
            {
                cmd.close();
            } catch (Exception er)
            {
            }

        }

        return "";
    }


    public static String getChineseFormatedDate(Object d)
    {
        return date2String(d, "yyyy.MM.dd");
    }

    public static String date2String(Object d, String format)
    {

        SimpleDateFormat SDF = new SimpleDateFormat(format);
        if (d == null) return "";
        Date td = null;
        if (d instanceof String) td = ParserDate.getDate(d.toString());
        if (d == null) return "";
        if (d instanceof Date) return SDF.format((Date) d);

        return "";

    }

    public static String get_yyyyMMdd_Date(Object d)
    {
        return date2String(d, "yyyy.MM.dd");

    }

    public static int get_yyyyMMdd_Int(Object d)
    {
        SimpleDateFormat SDF = new SimpleDateFormat("yyyyMMdd");
        if (d == null) return 0;
        Date td = null;
        if (d instanceof String) td = ParserDate.getDate(d.toString());
        if (d == null) return 0;

        if (d instanceof Date)
        {
            String s = SDF.format((Date) d);

            return FF.String2Int(s);
        }
        return 0;
    }

    public static int get_yyyyMMdd_DateInt(Object d)
    {
        return get_yyyyMMdd_Int(d);
    }

    public static String get_MMdd_HHmm_FormatedDate(Object d)
    {
        return date2String(d, "MM.dd HH:mm");

    }

    public static String get_HHmm_FormatedDate(Object d)
    {
        return date2String(d, "HH:mm");

    }

    public static String get_MMdd_FormatedDate(Object d)
    {
        return date2String(d, "MM月dd日");

    }

    public static String get_yyyyMMdd_HH_FormatedDate(Object d)
    {
        return date2String(d, "yyyy.MM.dd HH时");

    }

    public static String get_yyyyMMdd_HHmm_FormatedDate(Object d)
    {
        return date2String(d, "yyyy.MM.dd HH:mm");

    }

    public static String get_yyyyMMddHHmmss_noDotFormatedString(Object d)
    {
        return date2String(d, "yyyyMMddHHmmss");

    }

    public static boolean tableExists(Connection con, String table)
    {

        DataStore ds = DataStoreFactory.newDataStore(con, "select  *  from " + table,
                                                     false/*表示忽略错误，不记录错误日志，因为表可能就是不存在，SQL会出错，但此错误不需要记录*/
                , null);


        if (ds.getColumnCount() == 0) return false;
        return true;
    }

    public static boolean tableExists(String con, String table)
    {

        DataStore ds = DataStoreFactory.newDataStore(con, "select  *  from " + table);
        if (ds.getColumnCount() == 0) return false;
        return true;
    }

    /**
     * 数据库中存在指定名称的对象吗
     *
     * @param con
     * @param objName
     * @return
     */
    public static boolean dbObjectNameExists(Connection con, String objName)
    {
        boolean isSybase = isSybase(con);
        boolean isSqlServer = isSqlServer(con);

        if (isSybase || isSqlServer)
        {
            DataStore ds = DataStoreFactory.newDataStore(con, "select  name  from sysobjects where name='" + objName + "'");
            return (ds.getRowCount() > 0);
        }
        else
        {
            if (FF.logger != null && FF.logToFile)
            {
                try
                {
                    FF.logger.error("FF.dbObjectNameExists 不支持该数据库 " + con.getMetaData().getDriverName());
                } catch (Exception e)
                {
                    FF.logger.error("FF.dbObjectNameExists  发生异常" + e.getMessage());
                }
            }
            return false;
        }

    }

    static public double round(double num, int i)
    {
        if (num >= 0)
        {
            return Math.floor(num * Math.pow(10, i) + 0.5) / (double) (Math.pow(10, i));
        }
        else
        {
            return Math.ceil(num * Math.pow(10, i) - 0.5) / (double) (Math.pow(10, i));
        }
    }

    static public Object getValueFromSQL(Connection con, String sql)
    {
        try
        {
            DataStore ds = DataStoreFactory.newDataStore(con, sql);
            ds.retrieve();
            if (ds.getRowCount() > 0) return ds.getValue(0, 0);
            return null;
        } catch (Exception e)
        {
            return null;
        }
    }

    static public int getIntFromSQL(Connection con, String sql)
    {
        Object v = null;
        DataStore ds = DataStoreFactory.newDataStore(con, sql);
        ds.retrieve();
        if (ds.getRowCount() > 0) v = ds.getValue(0, 0);
        if (v == null) return 0;
        return new Integer(String.valueOf(v)).intValue();
    }

    static public int getIntFromSQL(String cons, String sql)
    {
        DBF dbf = DBF.getInstance();
        Connection con = null;
        int ret = 0;
        try
        {
            con = dbf.getConnection(cons);
            Object v = null;
            DataStore ds = DataStoreFactory.newDataStore(con, sql);
            ds.retrieve();
            if (ds.getRowCount() > 0) v = ds.getValue(0, 0);
            if (v == null) return 0;
            return new Integer(String.valueOf(v)).intValue();

        } catch (Exception e)
        {
            return 0;
        } finally
        {
            dbf.releaseConnection(con);
        }

    }

    static public String getStringFromSQL(Connection con, String sql)
    {
        return getStringFromSQL(con, sql, "");
    }

    static public String getStringFromSQL(Connection con, String sql, String defaultValue)
    {
        DBF dbf = DBF.getInstance();

        PreparedStatement stmt = null;
        ResultSet rs = null;
        try
        {
            //使用prepared statement 防止SQL注入
            stmt = con.prepareStatement(sql);
            rs = stmt.executeQuery();
            if (rs.next())
            {
                //再比对一下用户名
                String v = rs.getString(1);
                if (v == null) v = defaultValue;
                return v;
            }
            else
            {
                return defaultValue;
            }
        } catch (Exception e)
        {
            return defaultValue;
        } finally
        {
            dbf.release(stmt);
            dbf.release(rs);
        }

    }

    static public String getStringFromSQL(String sql)
    {
        return getStringFromSQL("", sql);
    }

    static public String getStringFromSQL(String dsn, String sql)
    {
        return getStringFromSQL(dsn, sql, "");
    }

    static public String getStringFromSQL(String dsn, String sql, String defaultValue)
    {
        DBF dbf = DBF.getInstance();
        Connection con = null;
        int ret = 0;
        try
        {
            con = dbf.getConnection(dsn);

            return getStringFromSQL(con, sql, defaultValue);

        } catch (Exception e)
        {
            return "";
        } finally
        {
            dbf.releaseConnection(con);
        }

    }

    static public double getDoubleFromSQL(Connection con, String sql)
    {
        Object v = null;
        DataStore ds = DataStoreFactory.newDataStore(con, sql);
        ds.retrieve();
        if (ds.getRowCount() > 0) v = ds.getValue(0, 0);
        if (v == null) return 0.0;
        return Double.valueOf(String.valueOf(v)).doubleValue();
    }

    public static JSONObject getJSONObjectFromSQL(String dbpool, String sql)
    {

        DataStore ds = DataStoreFactory.newDataStore(dbpool, sql);
        ds.setOnceRetrieveCount(1);
        ds.retrieve();
        if (ds.getRowCount() == 0) return new JSONObject();
        return ds.getJSON(0, false);

    }

    public static JSONArray getJSONArrayFromSQL(String dbpool, String sql)
    {

        DataStore ds = DataStoreFactory.newDataStore(dbpool, sql);
        ds.retrieve();
        return ds.getData(false, true);

    }

    public static JSONArray getJSONArrayFromSQL(Connection con, String sql)
    {

        DataStore ds = DataStoreFactory.newDataStore(con, sql);
        ds.retrieve();
        return ds.getData(false, true);

    }

    // 必须指定高度，且当嵌在Table中是用 % 可能出现不能显示
    public static String BuildFlashURL(String url, String width, String height)
    {

        return "<object classid=\"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\" codebase=\"http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,29,0\" width=\"" + width
                + "\" height=\"" + height + "\">" + "  <PARAM NAME=wmode VALUE=opaque>" + "<param name=\"movie\" value=\"" + url + "\">" + "  <param name=\"quality\" value=\"high\">"
                + "  <embed src=\"" + url + "\" quality=\"high\" pluginspage=\"http://www.macromedia.com/go/getflashplayer\" type=\"application/x-shockwave-flash\" width=\"" + width + "\" height=\""
                + height + "\"></embed>" + "</object>";
    }

    public static void sleep(int ms)
    {
        try
        {
            Thread.sleep(ms);
        } catch (Exception e)
        {

        }

    }

    public static double String2Double(String s)
    {
        try
        {
            return new Double(s.trim()).doubleValue();
        } catch (Exception e)
        {
            return 0;
        }
    }

    public static Date String2Date(String s)
    {
        DateTool dt = new DateTool();
        return dt.yyyyMMdd2Date(s);
    }

    public static int String2Int(String s)
    {
        if (s == null) return 0;
        try
        {
            s = s.trim();
            return new Integer(s).intValue();
        } catch (Exception e)
        {
            return 0;
        }
    }

    public static long String2Long(String s)
    {
        try
        {
            return new Long(s).longValue();
        } catch (Exception e)
        {
            return (long) 0;
        }
    }

    public static boolean isValidName(String col)
    {
        try
        {
            col = col.trim();
            RE r = new RE("[a-zA-Z]([a-zA-Z0-9_])*");
            r.match(col);
            if (r.getParenCount() == 0) return false;
            if (r.getParenStart(0) != 0) return false;
            if (r.getParenEnd(0) != col.length()) return false;
            return true;
        } catch (Exception e)
        {
            return false;
        }

    }

    /**
     * 是由数字，字母，下划线组成的字符串吗，注意不需要以字母开头
     *
     * @param col
     * @return
     */
    public static boolean isValidLetter(String col)
    {
        try
        {
            col = col.trim();
            RE r = new RE("([a-zA-Z0-9_])+");
            r.match(col);
            if (r.getParenCount() == 0) return false;
            if (r.getParenStart(0) != 0) return false;
            if (r.getParenEnd(0) != col.length()) return false;
            return true;
        } catch (Exception e)
        {
            return false;
        }

    }

    public static void SaveToFile(String path, String fileName, byte[] what)
    {
        String file = path + "/" + fileName;
        //文件名转换成操作系统支持的名称
        file = (file);

        try (BufferedOutputStream bos = new BufferedOutputStream(Files.newOutputStream(Paths.get(file)));)
        {
            bos.write(what);
            bos.flush();
            bos.close();
        } catch (Exception e)
        {

        }

    }

    public static void SaveToFile(String path, String fileName, String what) throws Exception
    {
        String file = path + "/" + fileName;
        SaveToFile(file, what, false);

    }

    public static String getFlowableDBPool()
    {
        String dbpool = CacheConfig.get("/系统配置/工作流/dbpool", "");
        return dbpool;
    }


    public static void SaveToFile(String fullFileName, String what)
    {
        SaveToFile(fullFileName, what, false);
    }

    /**
     * 2008.09.17 强制把文件使用UTF-8编码保存
     *
     * @param fullFileName
     * @param what
     * @param append
     */
    public static void SaveToFile(String fullFileName, String what, boolean append)
    {
        //文件名转换成操作系统支持的名称
        fullFileName = (fullFileName);

        try
        {
            int p1 = fullFileName.lastIndexOf("/");
            int p2 = fullFileName.lastIndexOf("\\");
            int p = Math.max(p1, p2);
            if (p > 0)
            {
                String path = fullFileName.substring(0, p);
                FF.MkDirs(path);
            }
            OutputStreamWriter fw = new OutputStreamWriter(new FileOutputStream(fullFileName, append), "UTF-8");

            fw.write(what);
            fw.close();
        } catch (Exception e)
        {

        }

    }

    /**
     * 从s中得到所有字段名称 s 遵循这样的规则 <col> value</col>... <col2> value</col2>
     *
     * @param s
     * @return
     */
    public static ArrayList/* <String> */getColumnList(String s)
    {

        ArrayList/* <String> */ret = new ArrayList/* <String> */();

        try
        {
            s = s.trim();
            RE r = new RE("<([a-zA-Z]([a-zA-Z0-9_])*)>");
            while (true)
            {
                r.match(s);
                if (r.getParenCount() == 0) break;
                String col = s.substring(r.getParenStart(1), r.getParenEnd(1));

                ret.add(col);
                s = s.substring(r.getParenEnd(0));
            }
        } catch (Exception e)
        {

        }
        return ret;
    }

    public static String getHostName()
    {
        String s = "";
        try
        {
            s = InetAddress.getLocalHost().getHostName();
        } catch (Exception e)
        {
            s = "";
        }
        return s;
    }

    /**
     * 本函数仅应该用在服务器访问自已时,转换地址用
     *
     * @param homeUrl
     * @return
     */
    public static String homeUrl2LocalUrl(String homeUrl)
    {
        int p1 = homeUrl.indexOf(":");
        int p2 = homeUrl.indexOf(":", p1 + 1);
        if (p2 < 0) p2 = homeUrl.indexOf("/", p1 + 3);
        if (p2 < 0) p2 = homeUrl.length();

        homeUrl = homeUrl.substring(0, p1 + 3) + "localhost" + homeUrl.substring(p2);
        //System.out.println( homeUrl);
        //2009.06.15 自已调用时，直接使用localhost替换服务器地址。
        //因为可能存在服务器无法使用域名访问自已的情况
        return homeUrl;
    }

    public static String appendURL(String homeurl, String shortUrl)
    {
        if (homeurl.endsWith("/") || homeurl.endsWith("\\")) homeurl = homeurl.substring(0, homeurl.length() - 1);
        if (shortUrl.startsWith("/") || shortUrl.startsWith("\\")) shortUrl = shortUrl.substring(1);
        return homeurl + "/" + shortUrl;

    }

    public static void pageContextSetAttribute(Object pageContext, String name, boolean value)
    {
        pageContextSetAttribute(pageContext, name, new Boolean(value));
    }

    public static void pageContextSetAttribute(Object pageContext, String name, int value)
    {
        pageContextSetAttribute(pageContext, name, new Integer(value));
    }

    public static void pageContextSetAttribute(Object pageContext, String name, Object value)
    {
        if (pageContext == null) return;

        if (value == null)
        {
            value = "";
            FF.log("pageContext在设置" + name + "时，数据为null");
        }

        if ((pageContext instanceof PageContext))
        {
            ((PageContext) pageContext).setAttribute(name, value);
        }
        else
        {
        /*
        2019.08
         不理解，为什么要用反射，
         可能的原因是，tomcat低版本没有这个东西，另一个可能的原因是兼容websphere
         不管出于什么原因，现在作废了

         出于兼容，还是保留，观察一段时间，如果没有用，再删除

         */

            Class c = pageContext.getClass();

            Class[] paracs = new Class[2];

            paracs[0] = String.class;
            paracs[1] = Object.class;

            Object[] params = new Object[2];
            params[0] = name;
            params[1] = value;
            try
            {
                Method m = c.getMethod("setAttribute", paracs);

                m.invoke(pageContext, params);
            } catch (Exception e)
            {

            }
        }


    }


    //注意， log 服务，注册了对 log 主题的接收 ， 其它服务，是增加了对system主题的接收，
    //所以下面要用system主题 ，参看 App.registMessageConsumer
    public static void sendMessage(String topic, String tag, String msg)
    {
        String key = App.getInstance().getAppname() + System.currentTimeMillis();
        if (App.zbusMQ_valid) MessageProducer.quickSend(topic, tag, key, msg);

    }

    // 这个也不是很保险，因为eureka信息是有缓存的，得到的服务信息，可能是失效的，也有可能刚注册的服务，不能立即通过这里得到
    //于是这个服务就无法收到此处的消息。所以请不要相信就里的消息一定能送达
    public static void dispatchToAllService(String topic, String tag, String msg)
    {
        FF.log("直接通过 eureka 注册的服务信息向各个服务分发消息：topic=" + topic + "    tag=" + tag + "   msg: " + msg);
        String key = App.getInstance().getAppname() + System.currentTimeMillis();
        //各所有服务发送消息

        JSONObject message = new JSONObject();
        message.put("tag", tag);
        message.put("topic", topic);
        message.put("message", msg);

        //获取所有的服务名称
        List<Application> apps = App.eurekaClient.getApplications().getRegisteredApplications();

        ArrayList<String> services = new ArrayList<>();
        //获取所有服务的名称
        for (int i = 0; i < apps.size(); i++)
        {
            Application app = apps.get(i);

            List<InstanceInfo> infos = app.getInstances();
            FF.log(app.getName() + "服务有" + infos.size() + "个实例");
            // 这个也不是很保险，因为eureka信息是有缓存的，得到的服务信息，可能是失效的，也有可能刚注册的服务，不能立即通过这里得到
            //于是这个服务就无法收到此处的消息。所以请不要相信就里的消息一定能送达
            if (!infos.isEmpty()) services.add(infos.get(0).getVIPAddress()); //只取一个就行了，因为它们名字是一样的
        }


//注意是广播，每个服务的各个副本都会得到消息
        for (int i = 0; i < services.size(); i++)
        {

            WSRPC.dispatch(services.get(i), "webApp.InnerMessageConsumer", "onMessage", message, null, null, true);
        }


    }

    public static void log(Object obj)
    {
        if (obj == null) return;
        if (!CacheConfig.get("/日志/系统日志输出", true)) return;

        try
        {

            String info = "[" + MDC.get("currentUserName") + "][" + App.IPADDRESS + "]";
            String t = MDC.get("isDeveloper");
            if (t == null) t = "false";
            if (t.isEmpty()) t = "false";
            boolean isDeveloper = t.equalsIgnoreCase("true");


            String objString = obj.toString();
            if (isDeveloper)
            {

                if (CacheConfig.get("/日志/前端日志查看/enabled", "false").equalsIgnoreCase("true"))
                {
                    t = MDC.get("currentUserId");
                    if (t == null) t = "1";
                    if (t.isEmpty()) t = "1";
                    int userid = FF.String2Int(t);
                    String currentGUID = MDC.get("currentGUID");
                    PushServer.sendMessage(userid, "serverLogInfo-" + currentGUID, "[" + FF.date2String(new Date(), "HH:mm:ss.SSS") + "]" + objString);
                }
            }

            if (info == null) info = "";
            if (info.equals("[null]") || info.equals("[未登录]"))
            {
                info = objString;
            }
            else
            {
                info += objString;
            }


            //if (zbusEnable) mq_zbus.MessageProducer.sendLog("", info);
            if (App.logServie_valid) LogService.quickSend(info);


            if (logger != null && logToFile) logger.info(info);

            //基于docker的部署，如果没有console的输出，无法看到docker管理工具中输出的日志
            //这个我估计还是哪里没有搞清楚，直接用 Syste.out.println 有点 low ,但是有效果
            // stdout 这种方式可能会有负作用，容器内存不断增大，不清楚是不是亮个引起的
            //所以在 2021.10.06 取消了下面的输出

            if (log2console) System.out.println(info);


            for (int i = 0; i < additionalLog.size(); i++)
            {
                additionalLog.get(i).Tip(info);
            }
        } catch (Exception e)
        {

        }
    }


    public static void main(String[] arg)
    {
        System.out.println(FF.date2String(new Date(), "HH:mm:ss.SSS"));
    }

    /**
     * 得到本机的所有IP地址
     *
     * @return
     */
    public static String[] getAllIPAddress()
    {
        FF.log("查询本机所有IP");
        ArrayList<String> ret = new ArrayList<>();
        try
        {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();

            while (nets.hasMoreElements())
            {
                NetworkInterface netint = nets.nextElement();
                if (null != netint.getHardwareAddress())
                {
                    List<InterfaceAddress> list = netint.getInterfaceAddresses();
                    for (InterfaceAddress interfaceAddress : list)
                    {
                        InetAddress address = interfaceAddress.getAddress();
                        String localip = address.toString();
                        if (localip.indexOf(":") > 0) continue;
                        localip = localip.replaceAll("/", "");
                        ret.add(localip);

                    }
                }
            }
        } catch (Exception e)
        {

        }

        String[] t = new String[ret.size()];
        ret.toArray(t);
        FF.log("本机所有 IP:" + StringUtils.join(t, " "));
        return t;

    }

    /**
     * 得到的是可以用来做UDP广播的地址
     *
     * @return
     */
    public static String[] getAllBroadcastIPAddress()
    {
        ArrayList<String> ret = new ArrayList<>();
        try
        {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();

            while (nets.hasMoreElements())
            {
                NetworkInterface netint = nets.nextElement();
                if (null != netint.getHardwareAddress())
                {
                    List<InterfaceAddress> list = netint.getInterfaceAddresses();
                    for (InterfaceAddress interfaceAddress : list)
                    {
                        InetAddress ip = interfaceAddress.getBroadcast();
                        if (ip == null) continue;
                        String localip = ip.getHostAddress();
                        if (localip.indexOf(":") > 0) continue;
                        localip = localip.replaceAll("/", "");
                        ret.add(localip);

                    }
                }
            }
        } catch (Exception e)
        {

        }

        String[] t = new String[ret.size()];
        ret.toArray(t);
        return t;

    }

    public static void sendUDPMessage(String broadIP, int port, String msg)
    {


        try
        {

            DatagramSocket sendSocket = new DatagramSocket();
            // 由于数据报的数据是以字符数组传的形式存  储的，所以传转数据
            byte[] buf = msg.getBytes("UTF-8");
            // 确定发送方的IP地址及端口号，地址为本地网络
            InetAddress ip = InetAddress.getByName(broadIP);
            // 创建发送类型的数据报
            DatagramPacket sendPacket = new DatagramPacket(buf, buf.length, ip, port);
            // 通过套接字发送数据
            sendSocket.send(sendPacket);
            sendSocket.close();
        } catch (Exception e)
        {
            // e.printStackTrace();
        }
    }

    /**
     * 从指定端口读取UDP信息，
     *
     * @param port       端口
     * @param timeout    超时时间(单位毫秒)
     * @param maxMsgSize 消息最大大小
     * @return
     */
    public static JSONObject getUDPMessage(int port, int timeout, int maxMsgSize)
    {
        JSONObject ret = new JSONObject();

        // 定义一个接收端，并且指定了接收的端口号
        try (DatagramSocket socket = new DatagramSocket(port);)
        {

            byte[] buf = new byte[maxMsgSize];
            // 解析数据包
            DatagramPacket packet = new DatagramPacket(buf, buf.length);

            socket.setSoTimeout(timeout);
            socket.receive(packet);

            String ip = packet.getAddress().getHostAddress();

            buf = packet.getData();
            String data = new String(buf, 0, packet.getLength(), "UTF-8");

            ret.put("success", true);
            ret.put("ip", ip);
            ret.put("message", data);

            FF.log("收到 " + ip + " 发来的消息：" + data);
        } catch (Exception e)
        {
            ret.put("success", false);
            ret.put("message", e.getMessage());
            return ret;
        }

        return ret;


    }


    public static void log(int n)
    {
        log(new Integer(n));
    }

    public static void log(char c)
    {
        log(String.valueOf(c));
    }

    public static void log(boolean c)
    {
        log(new Boolean(c));
    }

    /**
     * DataStore 中的数据转换成JSON格式
     *
     * @param ds
     * @return
     */
    public static JSONArray dataStore2JSONArray(DataStore ds)
    {
        JSONArray ret = new JSONArray();
        try
        {

            for (int i = 0; i < ds.getRowCount(); i++)
            {
                JSONObject obj = new JSONObject();
                for (int j = 0; j < ds.getColumnCount(); j++)
                {
                    Object v = ds.getValue(i, j);
                    if (v == null)
                    {
                        switch (ds.getColumnProperty(j).getUniformDataType())
                        {
                            case UniformDataType.$Integer:
                                v = new Integer(0);
                                break;
                            case UniformDataType.$Numeric:
                                v = new Double(0);
                                break;
                            case UniformDataType.$String:
                                v = "";
                            case UniformDataType.$Datetime:
                                v = ""; // 如果是日期，并且为null ,那么设置值为'',
                                // 因此在Grid中显示时需要判断数据的类型
                            default:
                                v = "";

                        }
                    }
                    if (v instanceof BigDecimal)
                    {
                        String t = (String) ObjectTool.ChangeType(v, ObjectTool.java_lang_String);
                        //2012.04.20
                        //如果是小数，那么直接转换成字符串， 因为本函数主要用在取数据后整理成json 格式让extjs中的jsonStore用，
                        //但是当小位很多时，在js中会丢失精度，所以强制转换成字符串，可以保留精度
                        if (t.length() > 12)
                        {
                            obj.put(ds.getColumnName(j), t);
                        }
                        else
                        {
                            obj.put(ds.getColumnName(j), v);
                        }

                    }
                    else
                    {
                        obj.put(ds.getColumnName(j), v);
                    }
                }
                ret.put(obj);
            }
        } catch (Exception e)
        {

        }

        return ret;

    }

    public static JSONObject dataStoreRow2JSONObject(DataStore ds)
    {
        return dataStoreRow2JSONObject(ds, 0);
    }

    public static JSONObject dataStoreRow2JSONObject(DataStore ds, int row)
    {
        JSONObject obj = new JSONObject();
        try
        {

            int i = row;

            for (int j = 0; j < ds.getColumnCount(); j++)
            {
                Object v = ds.getValue(i, j);
                if (v == null)
                {
                    switch (ds.getColumnProperty(j).getUniformDataType())
                    {
                        case UniformDataType.$Integer:
                            v = new Integer(0);
                            break;
                        case UniformDataType.$Numeric:
                            v = new Double(0);
                            break;
                        case UniformDataType.$String:
                            v = "";
                            break;
                        case UniformDataType.$Datetime:
                            v = ""; // 如果是日期，并且为null ,那么设置值为'', 因此在Grid中显示时需要判断数据的类型
                            break;
                        default:
                            v = "";

                    }
                }
                obj.put(ds.getColumnName(j), v);
            }
            return obj;
        } catch (Exception e)
        {

        }

        return obj;

    }

    /**
     * 把连续的空格替换成1 个空格
     *
     * @param s
     * @return
     */
    public static String removeMoreSpace(String s)
    {
        s = s.replaceAll("　", " "); // 中文空格按成英文空格
        s = s.replaceAll("                ", " ");
        s = s.replaceAll("               ", " ");
        s = s.replaceAll("              ", " ");
        s = s.replaceAll("             ", " ");
        s = s.replaceAll("            ", " ");
        s = s.replaceAll("           ", " ");
        s = s.replaceAll("          ", " ");
        s = s.replaceAll("         ", " ");
        s = s.replaceAll("        ", " ");
        s = s.replaceAll("       ", " ");
        s = s.replaceAll("      ", " ");
        s = s.replaceAll("     ", " ");
        s = s.replaceAll("    ", " ");
        s = s.replaceAll("   ", " ");
        s = s.replaceAll("  ", " ");
        s = s.replaceAll(" ", " ");
        return s;
    }

    public static String HTMLSpace(int n)
    {
        if (n <= 0) return "";
        StringBuffer ret = new StringBuffer(n);
        for (int i = 0; i < n; i++)
        {
            ret.append("&nbsp; ");

        }
        return ret.toString();
    }


    public static String executeShellCommand(String command)
    {


        FF.log("执行命令：" + command);

        Runtime runtime = Runtime.getRuntime();

        StringBuffer sb = new StringBuffer();

        try
        {
            Process process = runtime.exec(command);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line;

            while ((line = reader.readLine()) != null)
            {
                if (sb.length() > 0) sb.append("\n");
                sb.append(line);

            }

            int exitCode = process.waitFor();
            return sb.toString();
        } catch (Exception e)
        {
            FF.log(FF.exceptionMessage(e));
            return "";
        }
    }

    /**
     * 把queryString 中的参数取出来，并转换成JSON格式
     *
     * @param request
     * @return
     */
    public static String QueryString2JSON(HttpServletRequest request, boolean sqlInject)
    {

        JSONObject json = new JSONObject();
        Enumeration enu = request.getParameterNames();
        while (enu.hasMoreElements())
        {
            String name = (String) enu.nextElement();
            String value = FF.getStringFromRequest(request, name, "", "", sqlInject);
            json.put(name, value);//注意 ，这里绝不能用 UTF-8 因为，它通常已经被解码了，不能重复解码，在tomcat中是通过配置URIEncoding="UTF-8"来实现的
        }
        return json.toString();

    }

    public static JSONObject QueryString2JSON(String url)
    {

        JSONObject ret = new JSONObject();
        int p = url.indexOf("?");
        if (p >= 0) url = url.substring(p + 1);
        String[] t = url.split("&");
        for (int i = 0; i < t.length; i++)
        {
            String s = t[i];
            p = s.indexOf("=");
            if (p > 0)
            {
                try
                {
                    //2024.12.21 增加解码处理
                    String name = URLDecoder.decode(s.substring(0, p).trim(), "UTF-8");
                    String value = URLDecoder.decode(s.substring(p + 1).trim(), "UTF-8");
                    ret.put(name, value);
                } catch (Exception e)
                {
                    String name = s.substring(0, p).trim();
                    String value = s.substring(p + 1).trim();
                    ret.put(name, value);
                }
            }
        }
        return ret;

    }


    public static String isnull(String value, String valueReplaceNull)
    {
        if (value == null) return valueReplaceNull;
        if (value.isEmpty()) return valueReplaceNull;
        return value;

    }


    /**
     * 给指定的表名称创建一个同结构的临时表
     *
     * @param con
     * @param table
     * @return
     */
    public static String cloneTempTable(Connection con, String table, String pk)
    {
        int i = 0;
        String ret = "";
        while (true)
        {
            ret = "t" + i + "_" + table;
            if (!FF.tableExists(con, ret)) break;
            if (i > 10000) return ""; // 防止无休止地循环
            i++;
        }

        DataStore ds = DataStoreFactory.newDataStore(con, "select * from " + table);
        try
        {
            String syntax = ds.getCreateTableSyntax(ret, pk);
            FF.logger.info(syntax);
            FF.SafeExecute(con, syntax);
            if (FF.tableExists(con, ret)) return ret;
            throw new Exception(syntax + "语句无法创建表");
        } catch (Exception e)
        {
            FF.logger.error(e.getMessage());
            return "";
        }

    }

    public static String getStringFromMap(HashMap map, String key, String defaultValue)
    {
        return getStringFromMap((Map) map, key, defaultValue);
    }

    public static String getStringFromMap(Map map, String key, String defaultValue)
    {
        if (map == null) return defaultValue;
        if (map.containsKey(key))
        {
            Object obj = map.get(key);
            if (obj == null) return defaultValue;
            return obj.toString();
        }
        return defaultValue;
    }

    public static int getIntFromMap(HashMap map, String key, int defaultValue)
    {
        return getIntFromMap((Map) map, key, defaultValue);
    }

    public static int getIntFromMap(Map map, String key, int defaultValue)
    {
        if (map == null)
        {
            FF.log("FF.getIntFromMap中第一个参数为null");
            return defaultValue;
        }
        String s = getStringFromMap(map, key, "" + defaultValue);
        return FF.String2Int(s);
    }

    /**
     * @param file
     * @param width
     * @param height
     * @return 0 不需要做任何事，1 转换OK，2需要改名
     */
    public static int resizePicture(String file, int width, int height)
    {

        String ext = "";
        double Ratio = 0.0;
        File F = new File(file);

        //首先判断上传的图片是gif还是JPG ImageIO只能将gif转换为png
        String newName = file.substring(0, file.lastIndexOf(".")) + ".jpg";
        File df = new File(newName);

        try
        {
            BufferedImage Bi = ImageIO.read(F);
            //假设图片宽 高 最大为120 120
            Image Itemp = Bi.getScaledInstance(width, height, BufferedImage.SCALE_SMOOTH);

            //如果是拉大，那么不要处理
            if ((Bi.getHeight() <= height) || (Bi.getWidth() <= width)) return 0;
            if ((Bi.getHeight() == height) && (Bi.getWidth() == width)) return 0;

            Ratio = Math.max(height * 1.0 / Bi.getHeight(), width * 1.0 / Bi.getWidth());
            AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(Ratio, Ratio), null);
            Itemp = op.filter(Bi, null);

            ImageIO.write((BufferedImage) Itemp, "jpg", df);
            return (newName.equals(file)) ? 1 : 2;
        } catch (Exception ex)
        {
            FF.log(ex.getMessage());
            return -1;
        }

    }

    /**
     * 去掉回车和Tab
     *
     * @param s
     * @return
     */
    public static String removeNRTab(String s)
    {
        //2009-05-27 去掉回车tab
        s = FF.replaceAll(s, "\r\n", " ");
        s = FF.replaceAll(s, "\n", " ");
        s = FF.replaceAll(s, "\t", " ");
        s = FF.replaceAll(s, "　", " "); //中文空格替换掉

        return s;

    }

    public static String 去掉空格回车Tab中文空格(String s)
    {


        s = FF.replaceAll(s, "　", " "); //中文空格替换掉
        s = s.replaceAll("\\s", "");
        return s;

    }


    @Test
    public void test1()
    {
        String t = "abc de   f    \n\tghi";
        String s1 = t.replaceAll("\\s", "");
        String s2 = FF.removeNRTab(t);
        String s3 = FF.去掉空格回车Tab中文空格(t);
        System.out.println(s1);
        System.out.println(s2);
        System.out.println(s3);

        System.out.println("120%".replaceAll("%", ""));


    }

    public static String removeInlineComment(String sql)
    {
        StringBuilder result = new StringBuilder();
        boolean inComment = false;
        boolean inQuotes = false;

        for (int i = 0; i < sql.length(); i++)
        {
            char c = sql.charAt(i);

            if (!inQuotes && !inComment && c == '-' && i < sql.length() - 1 && sql.charAt(i + 1) == '-')
            {
                inComment = true;
                i++;
            }
            else if (inComment && c == '\n')
            {
                inComment = false;
                result.append("\n");
            }
            else if (!inComment && c == '\'')
            {
                inQuotes = !inQuotes;
                result.append(c);
            }
            else if (!inComment)
            {
                result.append(c);
            }
        }

        return result.toString();


    }

    //去掉SQL语句中的非法字符 ，并把回车，tab,中文空格换成英文空格
    public static String removeInvalidCharOfSQL(String sql)
    {
        //  去掉以  -- 或// 定义的SQL注释
        sql = FF.removeInlineComment(sql); // 在线的注释去掉
        // 去掉回车tab,中文空格
        sql = FF.removeNRTab(sql);
        return sql;
    }

    public static void checkNullObjectOfMap(Map map)
    {
        Iterator it = map.keySet().iterator();
        while (it.hasNext())
        {
            Object key = it.next();
            Object value = map.get(key);
            if (value == null) map.put(key, "");
            if (value instanceof Map) checkNullObjectOfMap((Map) value);
            if (value instanceof List) checkNullObjectOfList((List) value);

        }
    }

    public static void checkNullObjectOfList(List map)
    {
        Iterator it = map.iterator();
        while (it.hasNext())
        {
            Object value = it.next();
            if (value instanceof Map) checkNullObjectOfMap((Map) value);
            if (value instanceof List) checkNullObjectOfList((List) value);

        }
    }

    public static String hashMapToString(Map map)
    {
        String string = "{";
        for (Iterator it = map.entrySet().iterator(); it.hasNext(); )
        {
            Entry e = (Entry) it.next();
            string += "'" + e.getKey() + "':";
            Object v = e.getValue();
            if (v instanceof Map)
            {
                string += hashMapToString((Map) v) + "',";
            }
            else
            {
                string += "'" + e.getValue() + "',";
            }
        }
        string = string.substring(0, string.lastIndexOf(","));
        string += "}";
        return string;
    }

    /**
     * 把JSON转换成 HashMap 和ArrayList
     *
     * @param jsData
     * @param map
     */
    public static void addJSON2Map(JSONObject jsData, HashMap map)
    {
        if (jsData == null) return;
        try
        {
            Iterator it = jsData.keys();
            while (it.hasNext())
            {
                String key = it.next().toString();
                Object v = jsData.get(key);

                if (v instanceof JSONObject)
                {
                    HashMap m = new HashMap();
                    map.put(key, m);
                    addJSON2Map((JSONObject) v, m);
                    continue;
                }

                if (v instanceof JSONArray)
                {
                    ArrayList lst = new ArrayList();
                    map.put(key, lst);
                    addJSONArray2List((JSONArray) v, lst);
                    continue;

                }

                map.put(key, v);

            }
        } catch (Exception e)
        {

        }
    }

    public static void addJSONArray2List(JSONArray jsData, ArrayList list)
    {
        try
        {
            for (int i = 0; i < jsData.length(); i++)
            {
                Object v = jsData.get(i);

                if (v instanceof JSONObject)
                {
                    HashMap m = new HashMap();
                    list.add(m);
                    addJSON2Map((JSONObject) v, m);
                    continue;
                }

                if (v instanceof JSONArray)
                {
                    ArrayList lst = new ArrayList();
                    list.add(lst);
                    addJSONArray2List((JSONArray) v, lst);
                    continue;
                }

                list.add(v);

            }
        } catch (Exception e)
        {

        }
    }

    public static HashMap json2map(JSONObject json)
    {
        return json2map(json, false);
    }

    public static HashMap json2map(JSONObject json, boolean forceToString)
    {
        HashMap map = new HashMap();
        Iterator it = json.keys();
        while (it.hasNext())
        {
            String key = (String) it.next();
            if (forceToString)
            {
                Object value = json.getString(key, "");
                map.put(key, value);
            }
            else
            {
                Object value = json.get(key, (Object) null);
                map.put(key, value);
            }
        }

        return map;
    }

    /**
     * 最后是不以\结尾
     *
     * @param context
     * @param path
     * @return
     */
    public static String getAppRealPath(ServletContext context, String path)
    {
        String p = context.getRealPath(path);
        if (p.endsWith("/") || p.endsWith("\\")) p = p.substring(0, p.length() - 1);
        return p;

    }

    public static int countOfStr(String str, String con)
    {
        str = " " + str;
        if (str.endsWith(con))
        {
            return str.split(con).length;
        }
        else
        {
            return str.split(con).length - 1;
        }
    }

    public static void stringBufferAppendLine(StringBuffer sb, String s)
    {
        sb.append(s);
        sb.append("\r\n");
    }


    //把QueryString中的指定的参数去掉
    public static String removeFromQueryString(String s, String[] params)
    {
        if (s.trim().isEmpty()) return "";

        String param = URLUtil.getParameterStringOfURL(s);

        LinkedHashMap map = URLUtil.splitParameter(param);

        for (int i = 0; i < params.length; i++)
        {
            map.remove(params[i]);
        }

        Iterator it = map.keySet().iterator();
        StringBuffer sb = new StringBuffer(1024);
        while (it.hasNext())
        {
            String key = (String) it.next();
            String value = (String) map.get(key);
            if (sb.length() == 0)
            {
                sb.append("?").append(key).append("=").append(value);
            }
            else
            {
                sb.append("&").append(key).append("=").append(value);
            }
        }

        return sb.toString();
    }

    public static String stringAdd(String s1, String s2, String splitChar)
    {
        if (!s1.endsWith(splitChar)) s1 = s1 + splitChar;
        return s1 + s2;
    }

    public final static String MD5(String s)
    {
        return MD5(s, null);
    }

    public final static String MD5(String s, String charset)
    {

        char hexDigits[] =
                {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try
        {
            byte[] strTemp;
            if (charset == null)
            {
                strTemp = s.getBytes();
            }
            else
            {
                strTemp = s.getBytes(charset);
            }

            MessageDigest mdTemp = MessageDigest.getInstance("MD5");
            mdTemp.update(strTemp);
            byte[] md = mdTemp.digest();
            int j = md.length;
            char str[] = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; i++)
            {
                byte byte0 = md[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xf];
                str[k++] = hexDigits[byte0 & 0xf];
            }
            return new String(str);
        } catch (Exception e)
        {
            return null;
        }
    }


    public static String getStringFromURL(String surl, String charset)
    {
        try
        {
            FF.trustAllHttpsCertificates();

            URL url = new URL(surl);
            URLConnection urlcon = url.openConnection();

            //绕过证书验证，验证主机名和服务器验证方案的匹配是可接受的
            if (urlcon instanceof HttpsURLConnection)
            {
                ((HttpsURLConnection) urlcon).setHostnameVerifier(new CustomizedHostnameVerifier());
            }

            urlcon.setConnectTimeout(60 * 1000);
            urlcon.setReadTimeout(60 * 1000);

            urlcon.setDoOutput(true);
            urlcon.setUseCaches(false);

            OutputStream os = urlcon.getOutputStream();
            os.write(0);
            os.flush();
            os.close();
            os = null;

            InputStream is = urlcon.getInputStream();

            byte[] b = new byte[1024];

            ByteArrayOutputStream bos = new ByteArrayOutputStream();

            while (true)
            {
                int rc = is.read(b);
                if (rc <= 0) break;
                bos.write(b, 0, rc);
            }

            bos.close();
            String ret = new String(bos.toByteArray(), charset);
            return ret;
        } catch (Exception e)
        {
            FF.log(e.getMessage());
            return null;
        }

    }


    public static String postStringToURL(String surl, String params, String encoding, boolean needBase64Encode) throws Exception
    {

        try
        {

            FF.trustAllHttpsCertificates();
            HttpURLConnection http;

            URL url = new URL(surl);

            http = (HttpURLConnection) url.openConnection();
            //绕过证书验证，验证主机名和服务器验证方案的匹配是可接受的
            if (http instanceof HttpsURLConnection)
            {
                ((HttpsURLConnection) http).setHostnameVerifier(new CustomizedHostnameVerifier());
            }

            http.setRequestMethod("POST");
            http.setConnectTimeout(60 * 1000);
            http.setReadTimeout(60 * 1000);
            http.setRequestProperty("Content-Type", "application/text");
            http.setDoOutput(true);
            http.setDoInput(true);


            http.connect();
            OutputStream os = http.getOutputStream();
            os.write(params.getBytes(encoding));//传入参数
            os.flush();
            os.close();

            InputStream is = http.getInputStream();
            int size = is.available();
            byte[] b = new byte[size];
            is.read(b);

            http.disconnect();

            if (!needBase64Encode)
            {
                String t = new String(b, encoding);
                return t;
            }
            else
            {
                return new String(Base64Coder.encode(b));
            }

        } catch (Exception er)
        {
            log(surl);
            throw er;
        } finally
        {

        }
    }

    public static boolean getImageFromURLAndSave(String surl, String saveToFileName)
    {

        String file = (saveToFileName);

        BufferedOutputStream bos = null;


        try (java.io.BufferedOutputStream bufferedOutputStream = bos = new BufferedOutputStream(Files.newOutputStream(Paths.get(file))))
        {


            URL url = new URL(surl);
            URLConnection urlcon = url.openConnection();

            InputStream is = urlcon.getInputStream();

            byte[] b = new byte[1024];

            while (true)
            {
                int rc = is.read(b);
                if (rc <= 0) break;
                bos.write(b, 0, rc);
            }

            return FF.fileExists(file);
        } catch (Exception e)
        {
            FF.log(e.getMessage());
            return false;
        }

    }

    public static String getClientIpAddr(HttpServletRequest request)
    {
        if (request == null) return "localhost";

        String ip = request.getHeader(" x-forwarded-for ");
        if (ip == null || ip.isEmpty() || " unknown ".equalsIgnoreCase(ip))
        {
            ip = request.getHeader(" Proxy-Client-IP ");
        }
        if (ip == null || ip.isEmpty() || " unknown ".equalsIgnoreCase(ip))
        {
            ip = request.getHeader(" WL-Proxy-Client-IP ");
        }
        if (ip == null || ip.isEmpty() || " unknown ".equalsIgnoreCase(ip))
        {
            ip = request.getRemoteAddr();
        }
        return ip;


    }


    public static void unZip(File srcFile, String destDirPath) throws RuntimeException
    {
        long start = System.currentTimeMillis();

        // 判断源文件是否存在

        if (!srcFile.exists())
        {
            throw new RuntimeException(srcFile.getPath() + "所指文件不存在");

        }

        // 开始解压

        ZipFile zipFile = null;

        try
        {
            zipFile = new ZipFile(srcFile);

            Enumeration<?> entries = zipFile.entries();

            while (entries.hasMoreElements())
            {
                ZipEntry entry = (ZipEntry) entries.nextElement();

                FF.log("解压" + entry.getName());

                // 如果是文件夹，就创建个文件夹

                if (entry.isDirectory())
                {
                    String dirPath = destDirPath + "/" + entry.getName();

                    File dir = new File(dirPath);

                    dir.mkdirs();

                }
                else
                {
                    // 如果是文件，就先创建一个文件，然后用io流把内容copy过去

                    File targetFile = new File(destDirPath + "/" + entry.getName());

                    // 保证这个文件的父文件夹必须要存在

                    if (!targetFile.getParentFile().exists())
                    {
                        targetFile.getParentFile().mkdirs();

                    }

                    targetFile.createNewFile();

                    // 将压缩文件内容写入到这个文件中

                    InputStream is = zipFile.getInputStream(entry);

                    FileOutputStream fos = new FileOutputStream(targetFile);

                    int len;

                    int BUFFER_SIZE = 64 * 1024; //64K
                    byte[] buf = new byte[BUFFER_SIZE];

                    while ((len = is.read(buf)) != -1)
                    {
                        fos.write(buf, 0, len);

                    }

                    // 关流顺序，先打开的后关闭

                    fos.close();

                    is.close();

                }

            }

            long end = System.currentTimeMillis();

            FF.log("解压完成，耗时：" + (end - start) + " ms");

        } catch (Exception e)
        {
            throw new RuntimeException("unzip error from ZipUtils", e);

        } finally
        {
            if (zipFile != null)
            {
                try
                {
                    zipFile.close();

                } catch (IOException e)
                {
                    FF.log(FF.exceptionMessage(e));

                }

            }

        }

    }

    public static String logicPath2RealPath(String path)
    {

        try
        {
            String homeURL = ServiceUtil.getHomeURLForService("app");
            path = FF.replaceAll(path, "[{]appFileRoot[}]", App.FileRoot);
            path = FF.replaceAll(path, "[{]appRoot[}]", App.AppRoot);
            path = FF.replaceAll(path, "[{]home[}]", homeURL);

            if (path.startsWith("fileServer?")) path = homeURL + "/" + path;
            if (path.startsWith("/fileServer?")) path = homeURL + path;
            if (path.startsWith("fop")) path = homeURL + "/" + path;
            if (path.startsWith("/fop")) path = homeURL + path;


            if (path.startsWith("downeloadAndDeleteForExportPDF")) path = homeURL + "/" + path;
            if (path.startsWith("/downeloadAndDeleteForExportPDF")) path = homeURL + path;

            if (path.startsWith("deleteAfterDownloaded")) path = homeURL + "/" + path;
            if (path.startsWith("/deleteAfterDownloaded")) path = homeURL + path;

        } catch (Exception e)
        {
            FF.log("logicPath2RealPath异常" + FF.exceptionMessage(e));
        }
        return path;
    }


    // 将文件下载到本地临时文件
    public static String toLocalTempFile(String fileURL, String extName) throws Exception
    {
        String tempFileName = fileURL;
        tempFileName = FF.logicPath2RealPath(tempFileName);


        if (tempFileName.toLowerCase().startsWith("http"))
        {

            String tempPath = App.FileRoot + "/FileServer/autoDeleteAfterOneHour/";
            FF.MkDirs(tempPath);

            String tempFile = DataStoreFactory.newGUID() + "." + extName;
            FF.downloadFile(tempFileName, tempPath, tempFile);

            if (!FF.fileExists(tempPath + tempFile))
            {
                throw new Exception(tempFileName + "无法下载");
            }
            tempFileName = tempPath + tempFile;
        }
        return tempFileName;
    }

    public static JSONArray getFileTree(String path)
    {

        JSONArray ret = new JSONArray();

        path = logicPath2RealPath(path);


        if (!path.endsWith("/")) path = path + "/";


        File[] files = new File(path).listFiles();

        List<File> list;

        if (files == null)
        {

            list = new ArrayList<>();

        }
        else
        {

            list = Arrays.asList(files);

        }

        FF.log("有" + list.size() + "个文件或目录 ，现在排序");

        Collections.sort(list, new Comparator<File>()
        {

            @Override
            public int compare(File o1, File o2)
            {

                if (o1.isDirectory() && o2.isFile())

                    return -1;


                if (o1.isFile() && o2.isDirectory())

                    return 1;

                String name1 = o1.getName().toUpperCase();

                char c1 = name1.toCharArray()[0];

                String name11 = name11 = CnToSpell.getFullSpell(name1);

                if (c1 >= 0x4E00 && c1 <= 0x9FA5)
                {

                    name1 = "." + name11;

                }
                else if (c1 < 48)
                {

                    name1 = "{" + name11;

                }
                else if (c1 > 57 && c1 < 65)
                {

                    name1 = "{" + name11;

                }

                String name2 = o2.getName().toUpperCase();

                char c2 = name2.toCharArray()[0];

                String name22 = CnToSpell.getFullSpell(name2);

                if (c2 >= 0x4E00 && c2 <= 0x9FA5)
                {

                    name2 = "." + name22;

                }
                else if (c2 < 48)
                {

                    name2 = "{" + name22;

                }
                else if (c2 > 57 && c2 < 65)
                {

                    name2 = "{" + name22;

                }

                return name1.compareTo(name2);

            }

        });

        FF.log("排序完成");

        for (int i = 0; i < list.size(); i++)
        {
            File f = list.get(i);

            String extName = f.getName();
            FF.log(extName);
            if (extName.indexOf(".") > 0)
            {
                extName = extName.substring(extName.lastIndexOf(".") + 1);
            }
            else
            {
                extName = "";
            }

            if (f.isDirectory()) extName = "目录";

            FF.log(extName);


            JSONObject one = new JSONObject();
            one.put("parentPath", path);
            one.put("name", f.getName());
            one.put("type", extName);
            one.put("fullName", path + f.getName());
            one.put("isDir", f.isDirectory());
            one.put("lastModified", FF.get_yyyyMMdd_HHmm_FormatedDate(new Date(f.lastModified())));

            one.put("fileSize", InnerFileServer.fileSize(f));

            ret.put(one);

            if (f.isDirectory())
            {
                one.put("children", getFileTree(path + f.getName()));
            }

        }

        return ret;

    }


    public static String getIpAddr(HttpServletRequest request)
    {
        return getClientIpAddr(request);
    }

    public static String checkStringAsFileName(String name)
    {

        name = replaceAll(name, "<", "");// (less than)
        name = replaceAll(name, ">", "");// (greater than)
        name = replaceAll(name, ":", "");// (colon)
        name = replaceAll(name, "\"", "");// (double quote)
        name = replaceAll(name, "/", "");// (forward slash)
        name = replaceAll(name, "\\\\", "");// (backslash)
        name = replaceAll(name, "[|]", "");// (vertical bar or pipe)
        name = replaceAll(name, "[?]", "");// (question mark)
        name = replaceAll(name, "[*]", "");// (asterisk)
        name = name.trim();

        String[] errorName =
                {"CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};

        String un = name.toUpperCase();
        for (int i = 0; i < errorName.length; i++)
        {
            if (un.equals(errorName[i]))
            {
                name = name + "_";
                break;
            }
        }
        return name;
    }

    public static String parentPath(String path)
    {
        String t = path;
        if (t.endsWith("\\") || t.endsWith("/")) t = t.substring(0, t.length() - 1);
        int p1 = t.lastIndexOf("\\");
        int p2 = t.lastIndexOf("/");
        int p = Math.max(p1, p2); // 因为 path中可能  \ 与 / 混用
        if (p > 0) t = t.substring(0, p);
        return t;

    }

    /**
     * 把一个完整的文件路径分成3部分， 分别是所在目录， 文件名主体， 文件扩展名
     *
     * @param path
     * @return
     */
    public static String[] splitFileName(String path)
    {
        String[] ret = new String[3];

        String t = path;
        if (t.endsWith("\\") || t.endsWith("/")) t = t.substring(0, t.length() - 1);
        int p1 = t.lastIndexOf("\\");
        int p2 = t.lastIndexOf("/");
        int p = Math.max(p1, p2); // 因为 path中可能  \ 与 / 混用
        if (p > 0)
        {
            ret[0] = t.substring(0, p);
            t = t.substring(p + 1);

        }
        else
        {
            ret[0] = ""; //没有上级目录

        }

        p = t.lastIndexOf(".");
        if (p > 0)
        {
            ret[1] = t.substring(0, p);
            ret[2] = t.substring(p + 1);
        }
        else
        {
            ret[1] = t;
            ret[2] = "";
        }

        return ret;

    }


    public static String fileCopy(String fromFile, String toFile, boolean overWrite)
    {

        try
        {

            FF.MkDirs(parentPath(toFile));
            DirCopyUtil.copy(new File((fromFile)), new File((toFile)), overWrite);
        } catch (Exception e)
        {
            return e.getMessage();

        }
        if (FF.fileExists(toFile)) return "";
        return "复制失败";
    }

    /**
     * 克隆一个文件，新文件在旧文件名前或后加上前后缀， 返回新文件名
     *
     * @param fromFile
     * @param prefix
     * @param suffix
     * @param overWrite
     * @return
     */
    public static String fileClone(String fromFile, String prefix, String suffix, boolean overWrite)
    {
        String[] p = splitFileName(fromFile);
        String toFile = p[0] + "/" + prefix + p[1] + suffix + "." + p[2];
        fileCopy(fromFile, toFile, overWrite);
        return toFile;
    }

    public static String[] splitString2Array(String s, int len)
    {

        ArrayList list = new ArrayList();

        while (s.length() > len)
        {

            String t = s.substring(0, len);
            list.add(s);
            s = s.substring(len);

        }

        if (!s.isEmpty()) list.add(s);

        String[] ret = new String[list.size()];

        list.toArray(ret);
        return ret;

    }

    public static String right(String s, int n)
    {
        if (s == null) return s;
        if (s.length() <= n) return s;
        return s.substring(s.length() - n);
    }

    public static InputStream String2InputStream(String str)
    {
        ByteArrayInputStream stream = new ByteArrayInputStream(str.getBytes());
        return stream;
    }

    public static String inputStream2String(InputStream is)
    {
        try
        {
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            StringBuffer buffer = new StringBuffer();
            String line = "";
            while ((line = in.readLine()) != null)
            {
                buffer.append(line);
            }
            return buffer.toString();
        } catch (Exception e)
        {
            return null;
        }
    }

    public static void timeoutLog(String info)
    {
        DBF dbf = DBF.getInstance();
        Connection con = null;
        int ret = 0;
        try
        {
            con = dbf.getConnection();
            Object v = null;
            DataStore ds = DataStoreFactory.newDataStore(con, "select * from oa_timeout_log");
            ds.setUpdateProperty("oa_timeout_log", "id", "*|~id", "id");

            ds.insertRow(0);
            ds.setValue(0, "rq", new Date());
            ds.setValue(0, "log", info);
            if (!ds.update(true)) throw new Exception(ds.getError().getMessage());

        } catch (Exception e)
        {
            FF.log(e.getMessage());

        } finally
        {
            dbf.releaseConnection(con);
        }

    }

    /**
     * 取出一个指定长度大小的随机正整数.
     *
     * @param length int 设定所取出随机数的长度。length小于11
     * @return int 返回生成的随机数。
     */
    public static int buildRandom(int length)
    {
        int num = 1;
        double random = Math.random();
        if (random < 0.1)
        {
            random = random + 0.1;
        }
        for (int i = 0; i < length; i++)
        {
            num = num * 10;
        }
        return (int) ((random * num));
    }

    public static String map2xml(Map<String, String> packageParams, String needCDATAwrap)
    {
        needCDATAwrap = "," + needCDATAwrap + ",";

        StringBuffer sb = new StringBuffer();
        Set es = packageParams.entrySet();
        Iterator it = es.iterator();
        while (it.hasNext())
        {
            Entry entry = (Entry) it.next();
            String k = (String) entry.getKey();
            String v = (String) entry.getValue();

            sb.append("<" + k + ">");
            if (needCDATAwrap.indexOf("," + k + ",") >= 0)
            {
                sb.append("<![CDATA[" + v + "]]>");
            }
            else
            {
                sb.append(v);
            }
            sb.append("</" + k + ">");

        }
        return sb.toString();

    }

    public static JSONArray objectArray2JSONArray(Object[] vs)
    {

        JSONArray ret = new JSONArray();

        for (int i = 0; i < vs.length; i++)
        {
            Object v = vs[i];
            if (v == null) continue;
            if (v instanceof Map)
            {
                ret.put(map2JSONObject((Map) v));
            }
            else if (v.getClass().isArray())
            {
                ret.put(objectArray2JSONArray((Object[]) v));
            }
            else
            {
                ret.put(v);
            }
        }

        return ret;
    }


    public static JSONObject map2JSONObject(Map packageParams)
    {
        JSONObject ret = new JSONObject();

        Set es = packageParams.entrySet();
        Iterator it = es.iterator();
        while (it.hasNext())
        {
            Entry entry = (Entry) it.next();
            String k = (String) entry.getKey();
            Object v = entry.getValue();


            //2023.07.20 修正
            //不能这么处理， 本来是空值 ，现在变成空字符串了，这个有负作用
            //比如   {col1:null, col2:null}  脚本中应该返回这个数据，结果被转换成 {col:'', col2:''} 那么更新到数据库中 null, 与 '' 是不一样的
            // if (v == null)v="";

            if (v == null)
            {
                ret.put(k, v);
                continue;
            }

            if (v.getClass().isArray())
            {
                Object[] vs = (Object[]) v;
                ret.put(k, objectArray2JSONArray(vs));


            }
            else if (v instanceof Map)
            {
                ret.put(k, map2JSONObject((Map) v));
            }
            else
            {
                ret.put(k, v);
            }
        }
        return ret;

    }

    public static String xml2json(String str)
    {
        try
        {
            return XML.toJSONObject(str).toString(4);
        } catch (JSONException e)
        {

            log(e.getMessage());
            return "";
        }
    }

    public static String json2xml(String str)
    {

        try
        {
            JSONObject jsonObj = new JSONObject(str);
            return XML.toString(jsonObj);
        } catch (JSONException e)
        {
            log(e.getMessage());
            return "";
        }

    }

    @Test
    public void test_json2xml()
    {
        JSONObject js = new JSONObject();
        JSONObject node = new JSONObject();
        js.put("root", node);
        node.put("-id", "123334");
        node.put("-code", "aaaaaa");
        JSONObject sub = new JSONObject();
        node.put("sub", sub);
        sub.put("-name", "aaa");
        sub.put("#text", "bbbb");
        System.out.println(json2xml(js.toString()));
    }

    @Test
    public void test_json2xml_2()
    {
        String s = " {\"ufinterface\":{\"-isexchange\":\"Y\",\"-billtype\":\"gl\",\"-replace\":\"Y\",\"voucher\":{\"voucher_head\":{\"date\":\"2022-08-10\",\"attachment_number\":\"0\",\"fiscal_year\":\"2022\",\"voucher_making_system\":\"GL\",\"voucher_type\":\"付款凭证\",\"voucher_id\":65,\"company\":\"300104\",\"enter\":\"13588727210\",\"accounting_period\":\"08\"},\"-id\":\"F0001742\"},\"voucher_body\":{\"entry\":[{\"primary_credit_amount\":\"0\",\"credit_quantity\":\"0.00000000\",\"document_date\":\"2022-08-10\",\"debit_quantity\":\"0.00000000\",\"secondary_credit_amount\":\"0.00000000\",\"abstract\":\"支付普莱斯特货款/6月货款\",\"unit_price\":\"0.00000000\",\"secondary_debit_amount\":\"0.00000000\",\"primary_debit_amount\":\"59371.4000\",\"natural_credit_currency\":\"0\",\"auxiliary_accounting\":{\"item\":[{\"#text\":\"01\",\"-name\":\"客户模式\"},{\"#text\":\"11611\",\"-name\":\"客商辅助核算\"}]},\"exchange_rate1\":\"0.00000000\",\"exchange_rate2\":\"1.00000000\",\"account_code\":\"220201\",\"currency\":\"CNY\",\"entry_id\":1,\"natural_debit_currency\":\"59371.4000\"},{\"primary_credit_amount\":\"59371.4000\",\"credit_quantity\":\"0.00000000\",\"document_date\":\"2022-08-10\",\"debit_quantity\":\"0.00000000\",\"secondary_credit_amount\":\"0.00000000\",\"abstract\":\"支付普莱斯特货款/6月货款\",\"unit_price\":\"0.00000000\",\"secondary_debit_amount\":\"0.00000000\",\"primary_debit_amount\":\"0\",\"natural_credit_currency\":\"59371.4000\",\"auxiliary_accounting\":{\"item\":[]},\"exchange_rate1\":\"0.00000000\",\"exchange_rate2\":\"1.00000000\",\"account_code\":\"100233\",\"currency\":\"CNY\",\"entry_id\":2,\"natural_debit_currency\":\"0\"}]},\"-account\":\"U8cloud\",\"-sender\":\"OA\",\"-proc\":\"add\"}} ";
        System.out.println(json2xml(s));
    }

    /**
     * 看看参数，如果是以session_开头的，那么保存到 session 缓存中去
     *
     * @param request
     */
    public static void processUserSessionValueOnRequest(HttpServletRequest request)
    {
        String token = null;
        Enumeration<String> enu = request.getParameterNames();
        while (enu.hasMoreElements())
        {
            String key = String.valueOf(enu.nextElement());
            if (key.startsWith("session_"))
            {
                String value = FF.getStringFromRequest(request, key, "");

                if (token == null) token = FF.getTokenIdFromRequest(request);
                FF.setValueToUserSession(token, key, value);
            }
        }

    }

    /**
     * 把数据放到当前用户的缓存中。注意，不能用userid做键，因为允许同一个用户在不同地方登录。
     * 此处设置的数据是与当前登录相关而不是与用户相关，这样可以避免同一用户在不同机器上登录后数据的互动串
     * 比如通过隐式登录，所以的用户都映射到同一个用户，但是通过 另外的一个标记来标记不同的用户，这个用户标记
     * 就是与当前登录相关的，而不应该与映射到的用户相关
     *
     * @param token
     * @param name
     * @param value
     */
    public static void setValueToUserSession(String token, String name, String value)
    {
        int timeout = CacheConfig.get("/缓存及会话服务/会话", 28800);//秒
        AppCache.setCache("UserSession:" + token + ":" + name, value, false, CacheConfig.get("", timeout));
    }

    public static String getValueFromUserSession(String token, String name, String defaultValue)
    {

        int timeout = CacheConfig.get("/缓存及会话服务/会话", 28800);//秒
        String ret = AppCache.getCache("UserSession:" + token + ":" + name, defaultValue);
        return ret;
    }

    //在用户刚刚登录后执行
    public static void removeValueInUserSession(String token, String key)
    {
        AppCache.removeCache("UserSession:" + token + ":" + key);
    }

    //在用户刚刚登录后执行
    public static void removeAllValueInUserSession(String token)
    {
        AppCache.removeCacheMatch("UserSession:" + token + ":");
    }


    public static void setSessionValue(HttpServletRequest request, String name, Object value)
    {

        if (request == null) return;
        HttpSession session = request.getSession();
        //2020.03.01 出现 session为null的情况，
        if (session == null) return;
        session.setAttribute(name, value);

    }

    public static Object getSessionValue(HttpServletRequest request, String name, Object defaultValue)
    {
        if (request == null) return defaultValue;
        HttpSession session = request.getSession();
        if (session == null) return defaultValue;
        Object v = session.getAttribute(name);
        if (v == null) return defaultValue;
        return v;
    }

    /**
     * 获取第一个企业做默认企业
     *
     * @return
     */
    public static String getDefaultCorporationId()
    {
        String corporationid = FF.getStringFromSQL("", " select min(id) from app_corporation " +
                "  where nodetype='node'  and  (value='true' or value is null ) ");
        return corporationid;
    }

    /**
     * 开始设置的cookie 只能设，在浏览器上也可看到，但是无法读取。原因可能是值中由于做Encrypting 出现 = "等字符，这些不能在 cookie中出现
     * 加上了base32编码，就正常了
     *
     * @param res
     * @param name
     * @param path
     * @param value
     * @param maxAge
     */

    public static void setCookie(HttpServletResponse res, String name, String path, String value, int maxAge)
    {
        name = name.toLowerCase();
        if (value.isEmpty()) value = null; //null表示删除

        if (value != null) value = FF.encryptString(value);
        name = FF.encryptString(name);
        FF.log("name:" + name);
        FF.log("value:" + value);


        StringBuilder cookieBuilder = new StringBuilder();
        cookieBuilder.append(name).append("=").append(value).append("; ");
        cookieBuilder.append("Path=/; ");
        cookieBuilder.append("HttpOnly; "); // 根据需求添加
        //Secure 属性的核心用处是：指示浏览器只能通过 HTTPS 协议发送这个 Cookie，而不能通过不安全的 HTTP 协议发送。
        //所以通常不能加上，加上了，这个cookie可能就没了
      //  cookieBuilder.append("Secure; ");   // 如果SameSite=None或需要HTTPS，则必须添加
        cookieBuilder.append("SameSite=").append("Strict"); // Lax, Strict, None

        // 直接将构建好的字符串添加到响应头
        res.addHeader("Set-Cookie", cookieBuilder.toString());



    }

    public static String getCookie(HttpServletRequest req, String name, String path, String defaultValue)
    {

        Cookie[] cookies = req.getCookies();
        if (cookies == null) return defaultValue;
        name = FF.encryptString(name);

        for (int i = 0; i < cookies.length; i++)
        {
            Cookie c = cookies[i];
            FF.log(c.getName() + " :  " + c.getValue());

            if (c.getName().equalsIgnoreCase(name))
            {
                String s = c.getValue();
                if (s.isEmpty()) return s;
                s = FF.decryptString(s);
                return s;
            }
        }
        return defaultValue;
    }


    public static int getTomcatPort()
    {
        int tomcatPort;
        try
        {
            MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
            Set<ObjectName> objectNames = beanServer.queryNames(new ObjectName("*:type=Connector,*"),
                                                                Query.match(Query.attr("protocol"), Query.value("HTTP/1.1")));

            tomcatPort = Integer.valueOf(objectNames.iterator().next().getKeyProperty("port"));
        } catch (Exception e)
        {
            return 8080;
        }
        return tomcatPort;
    }

    public static void delay(int ms)
    {
        try
        {
            Thread.sleep(ms);
        } catch (Exception e)
        {
        }
    }

    //浏览器端把 document.cookies 传过来，从中取用户信息
    public static String getTokenIdFromCookieString(String cookies)
    {

        //常规情况下，在cookie中保存有当前用户的令牌，
        // 当RPCRouterl中转发POST调用时，cookie 是没有的，所以令牌是放在header中，


        String tokenid = "";
        String[] ts = cookies.split(";");
        for (String t : ts)
        {
            String[] s = t.split("=");
            if (s.length != 2) continue;

            String name = s[0];
            String value = s[1];
            if (name.equals(ENCRYPTED_TOKENID))
            {
                tokenid = FF.decryptString(value);
                break;
            }
        }


        if (tokenid == null) tokenid = "";
        return tokenid;

    }

    public static void removeTokenIdFromResponse(HttpServletResponse response)
    {
        Cookie killMyCookie = new Cookie(ENCRYPTED_TOKENID, null);
        killMyCookie.setMaxAge(0);
        killMyCookie.setPath("/");
        response.addCookie(killMyCookie);
    }


    public static String getTokenIdFromRequest(HttpServletRequest request)
    {

        if (request == null)
        {
            //FF.log("getTokenIdFromRequest: request=null");
            return "";
        }

        if (request instanceof EmulateHttpServletRequest) return ScriptEngineEmulateUser;
        //常规情况下，在cookie中保存有当前用户的令牌，
        // 当RPCRouter中转发POST调用时，cookie 是没有的，所以令牌是放在header中，
        try
        {

            String tokenid = "";
            Cookie[] cks = request.getCookies();
            if (cks != null)
            {
                for (Cookie ck : cks)
                {
                    String name = ck.getName();
                    if (name.equals(ENCRYPTED_TOKENID))
                    {
                        tokenid = FF.decryptString(ck.getValue());
                        break;
                    }
                }
            }
            //当在cookie中无法找到用户令牌时，就到header中去找
            if (tokenid.equalsIgnoreCase(""))
            {

                // [标记20190612-2]
                tokenid = request.getHeader(FF.ENCRYPTED_TOKENID);
                if (tokenid != null) tokenid = FF.decryptString(tokenid);
            }

            // 支持 rest方式的runTask，通过 Authorization传入token
            if (tokenid == null)
            {
                tokenid = request.getHeader("Authorization");
                if (tokenid != null)
                {
                    if (tokenid.startsWith("Bearer ")) tokenid = tokenid.substring(7).trim();
                    String t = FF.decryptString(tokenid);
                    //可能是通过  getAccessToken获取的
                    tokenid = new JSONObject(t).getString("token", null);
                    //如果不是，那么可能是通过  login 在脚本中心获取 的，都支持
                    if (tokenid == null) tokenid = t;
                }
            }
            //2020.06.14 增加， 当在刚刚登录 校验完成 ，设置好cookie时，此时直接读是读不到的，必须要回到客户端后，再回来，转一圈后才能从request中读取response中带过去的cookie
            //所以在request中增加用 setAttribute 增加属性，然后立马就可以再读出来 ，
            // 这个应用场景主要是用在刚刚登录，然后就 WSRPC ，此时只能从 request的 attribute中读取tokenid

            if (tokenid == null)
            {
                tokenid = (String) request.getAttribute(FF.ENCRYPTED_TOKENID);
            }

            //2021.12.28 支持直接从url参数中获取
            //为什么去掉了，参看 doc/关于登录的细节.md  注意看下面的新增处理
/*
            if (tokenid == null)
            {
                tokenid = FF.getStringFromRequest(request, "accessToken", null);
                if (tokenid != null)
                {
                    String t =   FF.decryptString(tokenid); //猜测它是用sso登录获取的token，那么解析一下
                    //可能是sso返回的token，需要再取一次
                    tokenid = new JSONObject(t).getString("token", null);
                    if (tokenid == null) tokenid = t;  //可能不是sso的token，就是login生成的token

                }
            }
*/

            //2022.01.09 增加对 accesstoken的直接支持
            //为什么要直接支持呢， 因为当使用iframe集成页面时，由于Samesite的限制，里面的登录跳转后设置cookie 是不会成功的，详情请搜索 Samesite
            //所以 当url上有  accessToken参数时， 走登录跳转页，就样登录一次后， 所有其它页面都会是已登录状态
            //当  url有  accesstoken参数时， 直接认定为已登录， 但是这样，只是该页被认定为已登录，如果再跳转到其它页面，还是会被认为未登录
            // 并且页面上的xhr调用，都不会有cookie信息， 必须自行用头信息来模拟
            if (tokenid == null)
            {
                tokenid = FF.getStringFromRequest(request, "innerAccessToken", null);
                if (tokenid != null)
                {
                    String t = FF.decryptString(tokenid); //猜测它是用sso登录获取的token，那么解析一下
                    //可能是sso返回的token，需要再取一次
                    tokenid = new JSONObject(t).getString("token", null);
                    if (tokenid == null) tokenid = t;  //可能不是sso的token，就是login生成的token

                }
            }

            if (tokenid == null) tokenid = "";
            //  if (tokenid.isEmpty()) FF.log("getTokenIdFromRequest: 无法在cookie及header 中获取token");
            return tokenid;

        } catch (Exception e)
        {
            User.debugLog("getTokenIdFromRequest:  exception " + e.getMessage());

            return "";
        }
    }


    /**
     * 判断ip、端口是否可连接
     *
     * @param host
     * @param port
     * @return
     */
    public static boolean isHostConnectable(String host, int port)
    {
        Socket socket = new Socket();
        try
        {
            socket.connect(new InetSocketAddress(host, port));
        } catch (IOException e)
        {
            //e.printStackTrace();
            return false;
        } finally
        {
            try
            {
                socket.close();
            } catch (IOException e)
            {

            }
        }
        return true;
    }

    /**
     * 判断ip是否可以连接 timeOut是超时时间
     */


    public static boolean isHostReachable(String host, Integer timeOut)
    {
        try
        {
            return InetAddress.getByName(host).isReachable(timeOut);
        } catch (UnknownHostException e)
        {
            //e.printStackTrace();
        } catch (IOException e)
        {

        }
        return false;
    }


    public static Object runScript(String scriptCode, JSONObject param) throws Exception
    {
        return runScript(scriptCode, param, null, null);
    }


    public static Object runScript(String scriptCode, JSONObject param, HttpServletRequest request, HttpServletResponse response) throws Exception
    {


        //请求人信息也放入参数
        JSONObject p = new JSONObject();
        p.put("task", scriptCode);
        p.put("data", param);

        if (request != null)
        {
            JSONObject req = new JSONObject();
            p.put("request", req);//请求人信息也放入参数
            req.put("remoteAddr", request.getRemoteAddr());
            req.put("remoteHost", request.getRemoteHost());
            req.put("remoteUser", request.getRemoteUser());
            req.put("remotePort", request.getRemotePort());

        }

        // 服务隔离支持
        String sharding = AppCache.getCache("ScriptSharding:" + scriptCode, "");

        JSONObject ret = WSRPC.dispatch("script",
                                        "script.rpcTask",
                                        "runTask",
                                        p,
                                        request == null ? EHR : request,
                                        response, false, 300, sharding);
        //2020.03.05 如果调用异常，直接throw，而不是返回 一个null ，这样与正常返回 null值 区分开来
        // 因为有些脚本执行后，就没有返回值 ，但是可能存在这个runTask远程调用失败的情况，这种情况需要返回 异常，而不是null值
        if (!ret.getBoolean("success", false)) throw new Exception(ret.getString("message", ""));

        Object b = ret.get("returnValue");
        return $jsRet(b);

    }

    //运行临时的脚本
    public static Object runScript(String id, String scriptSource, HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        return runScript(id, scriptSource, request, response, "ss:serverScript");
    }

    /**
     * 动态执行指定的脚本源码， 脚本源码，不需要用main包围起来， 由系统自动包。
     * <p>
     * 在脚本中，可以使用两个全局对象， urlArgs 用于访问url上的参数  request 对象用于访问客户地址
     *
     * @param id           用于脚本引擎缓存的标识
     * @param scriptSource 脚本源码
     * @param request
     * @param response
     * @return
     */
    public static Object runScript(String id, String scriptSource, HttpServletRequest request, HttpServletResponse response, String type) throws Exception
    {

        //请求人信息也放入参数
        JSONObject p = new JSONObject();

        p.put("type", type);
        p.put("task", id);
        p.put("source", scriptSource);
        p.put("urlArgs", QueryString2JSON(request, false));


        if (request != null)
        {
            JSONObject req = new JSONObject();
            p.put("request", req);//请求人信息也放入参数
            req.put("remoteAddr", getIpAddr(request));
            req.put("remoteHost", request.getRemoteHost());
            req.put("remoteUser", request.getRemoteUser());
            req.put("remotePort", request.getRemotePort());

        }


        //没有服务隔离设置，因为是直接运行脚本，不是预设的脚本中心的脚本
        JSONObject ret = WSRPC.dispatch("script", "script.rpcTask", "runTask", p,
                                        request == null ? EHR : request, response, false);

        //2020.03.05 如果调用异常，直接throw，而不是返回 一个null ，这样与正常返回 null值 区分开来
        // 因为有些脚本执行后，就没有返回值 ，但是可能存在这个runTask远程调用失败的情况，这种情况需要返回 异常，而不是null值
        if (!ret.getBoolean("success", false)) throw new Exception(ret.getString("message", ""));


        Object b = ret.get("returnValue");
        return $jsRet(b);

    }

    public static Object runFunction(String id, String funcName, JSONArray param, HttpServletRequest request, HttpServletResponse response, String currentGUID, String templateID, String moduleDefineKey) throws Exception
    {


        //请求人信息也放入参数
        JSONObject p = new JSONObject();

        p.put("type", "function");
        p.put("task", id);
        p.put("function", funcName);
        p.put("param", param);
        p.put("currentGUID", currentGUID);

        p.put("templateID", templateID); // 没有加密 ， 传到后台

        p.put("moduleDefineKey", moduleDefineKey);

        if (request != null)
        {
            JSONObject req = new JSONObject();
            p.put("request", req);//请求人信息也放入参数
            req.put("remoteAddr", getIpAddr(request));
            req.put("remoteHost", request.getRemoteHost());
            req.put("remoteUser", request.getRemoteUser());
            req.put("remotePort", request.getRemotePort());

        }


        JSONObject ret = WSRPC.dispatch("script", "script.rpcTask", "runTask", p,
                                        request == null ? EHR : request, response, false);

        //2020.03.05 如果调用异常，直接throw，而不是返回 一个null ，这样与正常返回 null值 区分开来
        // 因为有些脚本执行后，就没有返回值 ，但是可能存在这个runTask远程调用失败的情况，这种情况需要返回 异常，而不是null值
        if (!ret.getBoolean("success", false)) throw new Exception(ret.getString("message", ""));

        Object b = ret.get("returnValue");
        return $jsRet(b);

    }

    /**
     * 在脚本引擎中评估表达式的值
     *
     * @param id
     * @param request
     * @param response
     * @return
     */
    public static Object evaluateExpression(String id, String expression, HttpServletRequest request, HttpServletResponse response, String currentGUID, String templateID, JSONObject context) throws Exception
    {
        try
        {

            //请求人信息也放入参数
            JSONObject p = new JSONObject();

            p.put("type", "expression");
            p.put("task", id);
            p.put("currentGUID", currentGUID);//加过密
            p.put("templateID", templateID); // 没有加密 ， 传到后台
            p.put("expression", expression);
            p.put("context", context == null ? new JSONObject() : context); //


            if (request != null)
            {
                JSONObject req = new JSONObject();
                p.put("request", req);//请求人信息也放入参数
                req.put("remoteAddr", getIpAddr(request));
                req.put("remoteHost", request.getRemoteHost());
                req.put("remoteUser", request.getRemoteUser());
                req.put("remotePort", request.getRemotePort());

            }


            JSONObject ret = WSRPC.dispatch("script", "script.rpcTask", "runTask", p,
                                            request == null ? EHR : request, response, false);

            //2020.03.05 如果调用异常，直接throw，而不是返回 一个null ，这样与正常返回 null值 区分开来
            // 因为有些脚本执行后，就没有返回值 ，但是可能存在这个runTask远程调用失败的情况，这种情况需要返回 异常，而不是null值
            if (!ret.getBoolean("success", false)) throw new Exception(ret.getString("message", ""));


            Object b = ret.get("returnValue");

            return $jsRet(b);
        } catch (Exception e)
        {
            FF.log(e.getMessage());
            return e.getMessage();
        }
    }

    //所以 字符串null , JSONObject.NULL 等，都转换成null 返回
    //主要用于脚本返回值的处理
    private static Object $jsRet(Object b)
    {
        if (b == null) return b;
        if (b.equals(JSONObject.NULL)) return null;

        if (b instanceof String)
        {
            if (((String) b).equalsIgnoreCase("null")) return null;
        }

        return b;
    }


    public static String fileMD5(String fileName)
    {

        try (InputStream is = Files.newInputStream(Paths.get(fileName)))
        {
            return DigestUtils.md5Hex(is);
        } catch (Exception e)
        {
            return "";
        }

    }


    /**
     * 多行字符串
     * 入参括号中传入，使用 /* ....* /  形式注释
     *
     * @return
     */
    public static String $S()
    {

        ThreadLocal<String> threadLocal = new ThreadLocal<String>();
        String javaSource = threadLocal.get();
        try
        {
            StackTraceElement element = new RuntimeException().getStackTrace()[1];
            byte[] bytes = javaSource.getBytes("UTF-8");
            String s = convertStreamToString(new ByteArrayInputStream(bytes, 0, bytes.length), element.getLineNumber());
            return s.substring(s.indexOf("/*") + 2, s.indexOf("*/"));
        } catch (Exception e)
        {

        }

        return null;
    }

    private static String convertStreamToString(InputStream is, int lineNum)
    {
        /*
         * To convert the InputStream to String we use the BufferedReader.readLine()
         * method. We iterate until the BufferedReader return null which means
         * there's no more data to read. Each line will appended to a StringBuilder
         * and returned as String.
         */
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();

        String line = null;

        int relativeLine = 0;

        int i = 1;
        try
        {
            while ((line = reader.readLine()) != null)
            {
                if (i++ >= lineNum)
                {
                    sb.append(line + "\n");

                    if ((i - 1) != lineNum && line.contains("/*"))
                    {
                        relativeLine++;
                    }

                }
            }


        } catch (IOException e)
        {

        } finally
        {
            try
            {
                is.close();
            } catch (IOException e)
            {

            }
        }

        return sb.toString();
    }


    public static boolean ipInWhitelist(String ip, String whitelist)
    {
        if (ip.isEmpty()) return true;
        if (whitelist.isEmpty()) return true; //没有白名单，那么不需要控制
        whitelist = whitelist.replaceAll("\r|\n|\t", " ");
        String[] t = whitelist.split("(\\s)+", 9999);
        for (int i = 0; i < t.length; i++)
        {
            String one = t[i].trim();
            if (one.isEmpty()) continue;
            if (one.equals("*")) return true; // *
            if (one.equals(ip)) return true; //直接就相等
            //比较每一段
            if (segmentEquals(ip, one)) return true;

        }
        return false;

    }


    /**
     * @param ip1 ip地址
     * @param ip2 ip白名单项
     * @return
     */
    public static boolean segmentEquals(String ip1, String ip2)
    {
        String[] seg1 = ip1.split("[.]");
        String[] seg2 = ip2.split("[.]");

        for (int i = 0; i < Math.min(seg1.length, seg2.length); i++)
        {
            if (seg1[i].equals(seg2[i])) continue;
            if (seg2[i].equals("*")) continue;
            String t = seg2[i];
            if (t.indexOf("-") > 0)
            {
                String[] s = t.split("-");
                int start = FF.String2Int(s[0]);
                int end = FF.String2Int(s[1]);
                int n = FF.String2Int(seg1[i]);
                if (start <= n && end >= n) continue;
            }

            return false;
        }

        return true;

    }


    /**
     * 从POST方式提交的请求中整理出数据
     * <p>
     * 1 从header中
     * 2 从form-data中
     * 3 从body中
     *
     * @param request
     * @return
     */
    public static HashMap<String, String> getPostDataFromRequest(HttpServletRequest request)
    {
        HashMap<String, String> ret = new HashMap<String, String>();
        try
        {


            //header方式
            Enumeration hn = request.getHeaderNames();

            while (hn.hasMoreElements())
            {
                String head = hn.nextElement().toString();
                String v = request.getHeader(head);

                ret.put(head, v);

            }


            //判断表单个是否有多个部分组成,将整个请求做做为判断
            boolean isMultipart = ServletFileUpload.isMultipartContent(request);
            //判断是表单是否为多部分组成
            if (isMultipart == true)
            {
                //使用Apache文件上传组件处理文件上传步骤：
                //1、创建一个DiskFileItemFactory工厂
                DiskFileItemFactory factory = new DiskFileItemFactory();
                //2、创建一个文件上传解析器
                ServletFileUpload upload = new ServletFileUpload(factory);
                try
                {
                    //3、使用ServletFileUpload解析器解析上传数据，解析结果返回的是一个List<FileItem>集合，每一个FileItem对应一个Form表单的输入项
                    List<FileItem> items = upload.parseRequest(request);
                    //遍历集合
                    for (FileItem item : items)
                    {
                        //如果是普通的数据
                        if (item.isFormField())
                        {
                            //得到集合元素
                            String fieldName = item.getFieldName();
                            String value = item.getString("utf-8");
                            ret.put(fieldName, value);

                        }
                    }
                } catch (Exception e)
                {

                }
            }
            else
            {


                //body  raw data
                InputStream in = request.getInputStream();

                ByteArrayOutputStream bao = new ByteArrayOutputStream();

                byte[] b = new byte[4096];
                int len;
                while (true)
                {
                    len = in.read(b);
                    if (len == -1) break;

                    bao.write(b, 0, len);
                }
                bao.flush();
                bao.close();
                in.close();

                String json = bao.toString("UTF-8");

                JSONObject js = new JSONObject(json);
                Iterator<String> jk = js.getMap().keySet().iterator();
                while (jk.hasNext())
                {
                    String var = jk.next();

                    String v = js.getString(var, "");

                    ret.put(var, v);

                }


            }
        } catch (Exception e)
        {

        }
        return ret;

    }


    public static String getFileExtName(String fileName)
    {
        if (fileName.indexOf("deleteAfterDownloaded?") >= 0)
        {
            Map<String, String> map = URLUtil.splitParameter(fileName);
            String t = FF.getStringFromMap(map, "filename", "");
            t = FF.decryptString(t, DowneloadAndDelete.pwd);
            return getFileExtName(t);
        }

        if (fileName.indexOf("fileServer?") >= 0)
        {
            Map<String, String> map = URLUtil.splitParameter(fileName);
            String t = FF.getStringFromMap(map, "fileName", "");
            return getFileExtName(t);
        }


        int p = fileName.lastIndexOf(".");
        if (p > 0)
        {
            return fileName.substring(p + 1);
        }
        return "";
    }

    public static String getFileNameWithoutExtName(String fileName)
    {
        int p = fileName.lastIndexOf(".");
        if (p > 0)
        {
            return fileName.substring(0, p);
        }
        return fileName;
    }


    public static void trustAllHttpsCertificates() throws Exception
    {
        TrustManager[] trustAllCerts = new TrustManager[1];
        TrustManager tm = new TrustAllManager();
        trustAllCerts[0] = tm;
        SSLContext sc = SSLContext
                .getInstance("SSL");
        sc.init(null, trustAllCerts, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(sc
                                                              .getSocketFactory());


        HttpsURLConnection.setDefaultHostnameVerifier(new CustomizedHostnameVerifier());

    }

    /**
     * 等待，直到系统表初始化完成
     */
    public static void waitUntilSystemTableInitOK()
    {
        boolean configSystemTableInitOK = false;
        while (!configSystemTableInitOK)
        {
            FF.log("等待系统表初始化完成...");

            try
            {
                JSONObject js = RPCRouter.dispatch("config", "webApp.AppInfo", "systemTableInitOK", new JSONObject(), null, null, false);
                configSystemTableInitOK = js.getBoolean("systemTableInitOK", false);
            } catch (Exception e)
            {

            }
            FF.delay(2000);
        }
    }

    public static boolean isMobile(HttpServletRequest request)
    {

        String userAgent = request.getHeader("user-agent");
        if (userAgent.indexOf("Android") > 0 ||
                userAgent.indexOf("webOS") > 0 ||
                userAgent.indexOf("iPhone") > 0 ||
                /*  userAgent.indexOf("iPad") > 0 || */
                userAgent.indexOf("iPod") > 0 ||
                userAgent.indexOf("BlackBerry") > 0 ||
                userAgent.indexOf("Windows Phone") > 0) return true;
        return false;
    }

    public static boolean isDD(HttpServletRequest request)
    {

        String userAgent = request.getHeader("user-agent").toLowerCase();
        if (userAgent.indexOf("dingtalk") > 0) return true;
        return false;
    }


    public static HttpServletRequest mockRequest(HttpServletRequest req)
    {

        Cookie[] cookies = req.getCookies();
        String ip = FF.getClientIpAddr(req);

        String tokenId = FF.getTokenIdFromRequest(req);
        String encrypedTokenid = FF.encryptString(tokenId);


        HttpServletRequest request = Mockito.mock(HttpServletRequest.class);
        //模拟返回cookie
        Mockito.when(request.getCookies()).thenReturn(cookies);
        //在FF.getClientIpAddr需要用到 getRemoteAddr ，返回IP，所以mock一下

        Mockito.when(request.getRemoteAddr()).thenReturn(ip);
        //FF.getTokenIdFromRequest中需要从 request中获取tokern， mock一下 ，参看 [标记20190612-2]
        Mockito.when(request.getHeader(FF.ENCRYPTED_TOKENID)).thenReturn(encrypedTokenid);
        return request;
    }


    /**
     * 内部消息
     *
     * @param userid
     * @param info
     */
    public static void chatWidth(int userid, String info)
    {

        try
        {
            WSRPC.dispatch("im", "api.IM", "chat",
                           new JSONObject().put("toUserId", userid).put("topic", "chat").put("message", info), EHR, null, false);

        } catch (Exception e)
        {

        }
    }

    /**
     * 微信消息
     *
     * @param userid
     * @param info
     */
    public static void chatWidthApp(int userid, String info, String apps)
    {

        apps = FF.replaceAll(apps, " ", "");
        if (apps.isEmpty()) return;
        try
        {
            WSRPC.dispatch("script", "debug.ScriptAgent", "messageFunction",
                           new JSONObject().put("method", "chatWithApp")
                                   .put("userid", userid)
                                   .put("info", info)
                                   .put("apps", apps),
                           EHR, null, false);

        } catch (Exception e)
        {

        }
    }


    /**
     * 钉钉消息
     *
     * @param userid
     * @param info
     */
    public static void chatWidth_dd(int userid, String info)
    {

        try
        {
            WSRPC.dispatch("script", "debug.ScriptAgent", "messageFunction",
                           new JSONObject().put("method", "chatWith_dd").put("userid", userid).put("info", info), EHR, null, false);

        } catch (Exception e)
        {

        }
    }

    /**
     * 解析表达式中的符号
     *
     * @param expression
     * @return
     */
    public static String parseExpressionToken(String expression)
    {
        try
        {
            JSONObject ret = WSRPC.dispatch("script", "script.ScriptUtil", "parseToken",
                                            new JSONObject().put("expression", expression), null, null, false);

            if (!ret.getBoolean("success", false)) throw new Exception(ret.getString("message", ""));
            String s = ret.getString("tokens");
            return s;
        } catch (Exception e)
        {
            FF.log(e);
            return "";
        }
    }


    /**
     * 对单个数据值 ，做及SQL注入的处理， 比如name的值 ，password的值
     * ret并不是一个sql，只是一个值 ，一个可能被注入sql的值
     *
     * @param ret
     * @return
     */
    public static String encodeForSQL(String ret)
    {
        ret = ret.replaceAll("'", "");  //去掉所有的单引号

        //去掉单引号以及去掉空格，基本上可以排除绝大部分注入。再强大的注入，空格给你去掉了，就没法执行了

        ret = ret.replaceAll("(\\s)*", "");  //去掉所有的空格
        ret = ret.replaceAll("--", "");  //去掉所有的双减号，避免被注释掉条件

        //https://blog.csdn.net/weixin_33970449/article/details/93234570
        ret = ret.replaceAll("/[*]", "");//内联注释语句去掉
        ret = ret.replaceAll("[*]/", "");

        //去掉，及  join , union
        //https://www.cnblogs.com/i-honey/p/8203954.html

        //  ret = ret.replaceAll(",", "");  2022.12 去掉， 一些多选数据，可能是用，分隔，如果去掉，就不好处理
        ret = ret.replaceAll("(\\s)+[Uu][Nn][Ii][Oo][Nn](\\s)+", ""); // union
        ret = ret.replaceAll("(\\s)+[Jj][Oo][Ii][Nn](\\s)+", "");  // join

        return ret;
    }


    /**
     * 创建md5摘要,规则是:按参数名称a-z排序,遇到空值的参数不参加签名。
     */
    public static String createSign(SortedMap<String, String> packageParams, String partner_key)
    {
        StringBuffer sb = new StringBuffer();
        Set es = packageParams.entrySet();
        Iterator it = es.iterator();
        while (it.hasNext())
        {
            Entry entry = (Entry) it.next();
            String k = (String) entry.getKey();
            String v = (String) entry.getValue();
            if (null != v && !v.isEmpty() && !"sign".equals(k)
                    && !"key".equals(k))
            {
                sb.append(k + "=" + v + "&");
            }
        }
        sb.append("key=" + partner_key);

        String sign = FF.MD5(sb.toString(), "UTF-8").toUpperCase();

        return sign;

    }


    public static JSONObject downloadFile(String homeURL, String localPath, String file)
    {
        return downloadFile(homeURL, localPath, file, null);
    }

    public static JSONObject downloadFile(String homeURL, String localPath, String file, JSONObject config)
    {

        JSONObject ret = new JSONObject().put(SUCCESS, true);

        int bytesum = 0;
        int byteread = 0;
        try
        {
            if (!homeURL.toLowerCase().startsWith("http"))
            {
                String t = ServiceUtil.getHomeURLForService("app");
                if (!homeURL.startsWith("/")) homeURL = "/" + homeURL;
                homeURL = t + homeURL;


            }

            if (homeURL.indexOf("fileServer?") >= 0 && homeURL.indexOf("sign") < 0) //系统提供的文件服务器，为了绕开权限控制，自动加一个签名
            {
                //先将url参数放入
                JSONObject queryParam = FF.QueryString2JSON(homeURL);
                String serverIndex = queryParam.getString("serverIndex", "1");
                String objectName = queryParam.getString("objectName", "");
                String bucketName = queryParam.getString("bucketName", "");
                //2023.09.15修正 ，早些时候一些bucketName中有中文字符，且没有编码，在下面的访问中可能会异常，所以把它去掉，去掉也不会影响访问
                if (!bucketName.isEmpty())
                {
                    homeURL = FF.replaceAll(homeURL, "bucketName=" + bucketName + "&", "");
                }
                String sign = FF.encryptString(serverIndex + "." + objectName, FF.KEY_FileServer);
                homeURL = homeURL + "&sign=" + sign;

                //2023.05 由于本地文件系统中 docx 及 xlsx 如果是查看，那么会自动转换成pdf，所以这里要处理一下 action

                if (homeURL.indexOf("&action=view") > 0)
                    homeURL = FF.replaceAll(homeURL, "&action=view", "&action=download");

                FF.log("下载地址调整为：" + homeURL);

            }
            FF.trustAllHttpsCertificates();

            homeURL = URLUtil.URLEncoder(homeURL);

            FF.log("经过编码后的url地址为： " + homeURL);

            URL url = new URL(homeURL);
            URLConnection conn = url.openConnection();


            //绕过证书验证，验证主机名和服务器验证方案的匹配是可接受的
            if (conn instanceof HttpsURLConnection)
            {
                ((HttpsURLConnection) conn).setHostnameVerifier(new CustomizedHostnameVerifier());
            }

            // 不能加下面这个， 有些网站会返回 403 错误， 去掉下面就可以了
             //conn.setRequestProperty("Content-Type", "application/octet-stream");

            conn.setUseCaches(false);

            if (config == null) config = new JSONObject();
            JSONObject header = config.getJSONObject("header", null);
            if (header != null)
            {
                Iterator<String> it = header.getMap().keySet().iterator();
                while (it.hasNext())
                {
                    String key = it.next();
                    String value = header.getString(key, "");
                    ((HttpURLConnection) conn).setRequestProperty(key, value);
                }
            }

            InputStream inStream = conn.getInputStream();

            FF.MkDirs(localPath);

            String localFile = FF.pathJoin(localPath, file);
            try (
                    FileOutputStream fs = new FileOutputStream(localFile)
            )
            {

                byte[] buffer = new byte[64 * 1204];
                int length;
                while ((byteread = inStream.read(buffer)) != -1)
                {
                    bytesum += byteread;
                    fs.write(buffer, 0, byteread);
                }
            } catch (Exception e1)
            {

            }
            ret.put("fileSize", bytesum);
            ret.put("file", localFile);
            String url_ret = /*ServiceUtil.getHomeURLForService("fop") */  "/downeloadAndDeleteForExportPDF?" +
                    "sourcename=" + FF.encryptString(localFile, DowneloadAndDeleteForExportPDF.pwd) +
                    "&filename=" + file +
                    "&action=download";
            ret.put("url", url_ret);

        } catch (Exception e)
        {

            FF.log("下载失败 " + FF.exceptionMessage(e) + ";请检查url地址是否正确");
            ret.put(SUCCESS, false);
            ret.put(MESSAGE, FF.exceptionMessage(e));
        }

        return ret;

    }


    /**
     * 从服务中心获取zbus的访问地址
     *
     * @return
     */
    public static String getZBusNameServer()
    {
        //需要从配置中取
        ArrayList<ServiceInfo> list = ServiceUtil.getAllServerInfoForService("zbus");

        if (list.isEmpty())
        {
            FF.log("暂时无法从Eureka中获取zbus服务地址信息，稍候再试");
            return "";
        }

        StringBuffer sb = new StringBuffer(1024);

        try
        {
            for (ServiceInfo info : list)
            {


                if (sb.length() > 0) sb.append(";");
                sb.append(info.address).append(":").append("" + info.port);  //走内网
            }
        } catch (Exception e)
        {
        }

        return sb.toString();
    }


    public static String getStringFromServletInputStream(ServletInputStream sis)
    {
        StringBuilder sb = new StringBuilder();
        InputStreamReader reader = null;
        char[] buff = new char[1024];
        int length = 0;
        try
        {
            reader = new InputStreamReader(sis, "UTF-8");
            while ((length = reader.read(buff)) != -1)
            {
                String s = new String(buff, 0, length);
                sb.append(s);
            }
        } catch (Exception e)
        {

        } finally
        {
            //@off
            try  {reader.close();   } catch (Exception e)  {  }
            //@on
        }


        return sb.toString();
    }

    //开通默认应用给某个企业
    public static JSONObject addDefaultApp2Corporation(String corporationid)
    {
        String appid = FF.getFirstAppId();
        JSONObject ret = WSRPC.dispatch("config", "tree.CorporationManage", "addCorporationApplication",
                                        new JSONObject().put("corporationid", corporationid).put("appid", appid),
                                        EHR, null);

        DataStore ds = DataStoreFactory.newDataStore("", "select id , name from app_app where id='" + appid + "'");
        ds.retrieve();
        return ds.getJSON(0, true);

    }

    /**
     * 得到当前会话的企业ID
     *
     * @param request
     * @return
     */
    public static String getCurrentCorporationIdForCurrenUser(HttpServletRequest request)
    {
        try
        {
            String tokenid = FF.getTokenIdFromRequest(request);

            String lastWorkingCorporation = UserAndDepartmentCache.getSessionLastCorporationInfo(tokenid);
            JSONObject js = new JSONObject(lastWorkingCorporation);


            //当前人员所管理的企业
            int userid = User.getUserFromTokenId(tokenid).getId();
            String corporations = UserAndDepartmentCache.getUserCorproationInfo(userid);

            JSONObject first = null;
            String ret = js.getString("id", "");

            FF.log(" corporations = " + corporations);

            JSONArray ja = new JSONArray(corporations);

            if (ja == null) ja = new JSONArray();
            for (int i = 0; i < ja.length(); i++)
            {
                JSONObject one = ja.getJSONObject(i);
                if (i == 0) first = one;
                if (ret.equals(one.getString("id", ""))) return ret;  //当当前企业id的在是当前人员所能管理的，那么返回它
            }


            //到这里，就说明 当前记录的企业ID并不是当前人员所能管理的，那么重新设置
            if (first != null)
            {
                UserAndDepartmentCache.setSessionLastCorporationInfo(tokenid, first.toString());

                return first.getString("id", "");
            }
            return "";
        } catch (Exception e)
        {

            FF.log(FF.exceptionMessage(e));
            return "";
        }

    }


    public static String getMoudleConfig(String type, String id)
    {

        return WSRPC.dispatch("formEngine", "formengine.FormEngine", "getMoudleConfig",
                              new JSONObject().put("type", type).put("id", id), null, null, false).toString();


        /*
        try
        {
          // 当 url 是  https 时，可能存在问题
            String url = ServiceUtil.getHomeURLForService("formEngine") + "/moduleConfig?type=" + type + "&id=" + id;
            return  FF.getStringFromURL(url , "UTF-8");
        }catch(Exception e)
        {
            return  new JSONObject().put("success", false).put("message" , FF.exceptionMessage(e)).toString();
        }

        */
    }


    public static String freemarkerString(String str, JSONObject js)
    {

        try
        {
            Configuration cfg = new Configuration();
            cfg.setNumberFormat("#"); //避免 数字加等分位
            cfg.setDefaultEncoding("UTF-8");

            cfg.setTemplateLoader(new StringTemplateLoader(str));

            Template t = cfg.getTemplate("");
            StringWriter out = new StringWriter();

            HashMap root = new HashMap();
            FF.addJSON2Map(js, root);
            FF.checkNullObjectOfMap(root);

            t.process(root, out);
            String ret = out.toString();

            return ret;
        } catch (Exception e)
        {
            return e.getMessage();
        }
    }

    public static String freemarkerResource(String resourePath, JSONObject js)
    {


        try
        {

            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourePath);
            String str = FF.readFromStream(is);
            return freemarkerString(str, js);

        } catch (Exception e)
        {
            return e.getMessage();
        }
    }

    public static void pushMessage(String topic, String msg, int toWhom)
    {
        //保持脚本服务的无状态性，就不要有有状态的连接，所以把消息转改到 app 服务中
        //  PushServer.sendMessage(toWhom, topic, msg);
        //用广播模式，是因为可能 app会是多个实例，客户端指不定是连接到哪个上面
        WSRPC.dispatch("im", "api.IM", "pushMessage",
                       new JSONObject().put("toWhom", toWhom).put("topic", topic).put("message", msg),
                       EHR, null, false);

    }

    public static String okHttpFormPost(String url, String configString)
    {

        return $okHttpFormPost(url, configString);
    }

    public static String $okHttpFormPost(String url, String configString)
    {

        JSONObject config = new JSONObject(configString);



        int timeout = config.getInt("timeout", 60); //默认60秒

        OkHttpClient client = OkHttpUtil.getOkHttpClient(timeout);


        RequestBody body = null;

        //2022.08.15 由于某个短信服务商的http 的接口不能用 MultipartBody ，所以改成 FormBody ，不清楚以前的某个应用是否会有问题
        // 加一个参数，来表明使用哪个类型
        String bodyType = config.getString("bodyType", "MultipartBody");
        JSONArray files = config.getJSONArray("files",   new JSONArray());
        if (bodyType.equals("MultipartBody") || files.length() > 0)
        {
            MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            JSONObject form = config.getJSONObject("form", new JSONObject());

            Iterator<String> it = form.getMap().keySet().iterator();
            while (it.hasNext())
            {
                String k = it.next().toString();
                String v = form.getString(k, "");

                builder.addFormDataPart(k, v);

            }


            for (int i = 0; i < files.length(); i++)
            {
                JSONObject one = files.getJSONObject(i);
                String name = one.getString("name", "");
                if( name.indexOf(".")<0)
                {
                    return new JSONObject().put("success", false).put("message", "files中的 name 必须是带扩展名的文件名").toString();
                }


                String extName = FF.splitFileName(name)[2];
                String file = one.getString("file", "");
                String mediaType= one.getString("mediaType","");

                if(  mediaType.isEmpty())  mediaType =  MimeMappings.getMimeType(extName);
                try
                {

                    file = FF.toLocalTempFile(file, extName);
                }catch (Exception e)
                {
                    FF.log("httpPost 上传文件异常："+ e.getMessage());
                    continue;
                }
                File f = new File(file);
                MediaType mt = MediaType.parse(mediaType);

                FF.log("mime type : " + mt.toString());
                FF.log("mime type : " + mediaType );
                FF.log("filename="+ f.getName());

                builder.addFormDataPart(name, f.getName(), RequestBody.create(mt, f));
            }

            body = builder.build();
        }
        else
        {

            FormBody.Builder builder = new FormBody.Builder();

            JSONObject form = config.getJSONObject("form", new JSONObject());

            Iterator<String> it = form.getMap().keySet().iterator();
            while (it.hasNext())
            {
                String k = it.next().toString();
                String v = form.getString(k, "");

                builder.add(k, v);
            }
            body = builder.build();
        }


        Request.Builder requestBuilder = new Request.Builder()
                .url(url)
                .method("POST", body);


        JSONObject header = config.getJSONObject("header", new JSONObject());
        if (header != null)
        {
            Iterator<String> it = header.getMap().keySet().iterator();
            while (it.hasNext())
            {
                String key = it.next();
                String value = header.getString(key, "");
                requestBuilder.addHeader(key, value);
            }
        }

        Request request = requestBuilder.build();

        try (
                Response response = client.newCall(request).execute()
        )
        {

            JSONObject ret = new JSONObject();
            ret.put("success", true).put("response", response.body().string());
            //2020.09.12 增加返回的header
            Headers hs = response.headers();
            if (hs != null)
            {
                JSONObject resHeader = new JSONObject();
                ret.put("header", resHeader);
                Iterator<String> its = hs.names().iterator();
                while (its.hasNext())
                {
                    String headerName = its.next();
                    String value = hs.get(headerName);
                    resHeader.put(headerName, value);
                }

            }

            return ret.toString();
        } catch (Exception e)
        {
            return new JSONObject().put("success", false).put("message", e.getMessage()).toString();
        }

    }


    /**
     * https通用策略
     *
     * @return HttpClientBuilder 返回类型
     * @throws
     * @Title: createSSLClientDefault
     */
    private static HttpClientBuilder createSSLClientDefault()
    {
        try
        {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy()
            {
                //信任所有
                public boolean isTrusted(X509Certificate[] chain,
                                         String authType) throws CertificateException
                {
                    return true;
                }
            }).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext);
            return HttpClients.custom().setSSLSocketFactory(sslsf);
        } catch (KeyManagementException e)
        {
            FF.log(FF.exceptionMessage(e));
        } catch (NoSuchAlgorithmException e)
        {
            FF.log(FF.exceptionMessage(e));
        } catch (KeyStoreException e)
        {
            FF.log(FF.exceptionMessage(e));
        }
        return null;
    }


    public static String httpPost(String url, String configString)
    {
        return (String) $httpPost(url, configString, true);
    }


    public static String httpPut(String resourceUrl, String configString)
    {
        JSONObject ret = new JSONObject();


        try
        {
            JSONObject config = new JSONObject(configString);
            int timeout = config.getInt("timeout", 60) * 1000; //默认60秒

            URL url = new URL(resourceUrl);
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();

            JSONObject header = config.getJSONObject("header", null);
            if (header != null)
            {
                Iterator<String> it = header.getMap().keySet().iterator();
                while (it.hasNext())
                {
                    String key = it.next();
                    String value = header.getString(key, "");

                    connection.setRequestProperty(key, value);

                }
            }


            connection.setDoOutput(true);

            connection.setDoInput(true);

            connection.setRequestMethod("PUT");
            connection.setUseCaches(false);


            connection.setReadTimeout(timeout);
            connection.setConnectTimeout(timeout);
            connection.connect();


            OutputStream out = connection.getOutputStream();


            JSONObject stream = config.getJSONObject("stream", null);
            if (stream != null)
            {
                String name = stream.getString("name", "");
                String extName = FF.splitFileName(name)[2];
                String streamURL = stream.getString("url", "");

                String tempFile = FF.toLocalTempFile(streamURL, extName);
                ret.put("fileSize", FF.fileSize(tempFile));
                if (!FF.fileExists(tempFile)) throw new Exception(streamURL + "无法访问");


                try (InputStream is = new FileInputStream(new File(tempFile));)
                {

                    byte[] b = new byte[1024];
                    int temp;
                    while ((temp = is.read(b)) != -1)
                    {
                        out.write(b, 0, temp);
                    }

                    out.flush();
                    out.close();

                    int responseCode = connection.getResponseCode();

                    ret.put("statusCode", responseCode);

                } catch (Exception e)
                {
                    throw e;
                }
            }
            else
            {
                out.flush();
                out.close();
            }


            try (InputStream his = connection.getInputStream();)
            {
                int size = his.available();
                byte[] b2 = new byte[size];
                his.read(b2);

                ret.put("success", true).put("response", new String(b2, "UTF-8"));

            } catch (Exception e2)
            {
                throw e2;
            } finally
            {
                connection.disconnect();
            }



            return ret.toString();
        } catch (Exception e)
        {
            return ret.put(FF.SUCCESS, false).put(FF.MESSAGE, FF.exceptionMessage(e)).toString();
        }
    }

    public static Object $httpPost(String url, String configString, boolean returnString)
    {

        //高并发场景下的 HttpClient 优化，QPS 大大提升
        // https://zhuanlan.zhihu.com/p/627673158?utm_id=0


        //如果要处理  cookie ,参看
        //  https://shuizhu.blog.csdn.net/article/details/126589479?spm=1001.2101.3001.6650.2&utm_medium=distribute.pc_relevant.none-task-blog-2%7Edefault%7ECTRLIST%7ERate-2-126589479-blog-117637804.235%5Ev40%5Epc_relevant_anti_t3_base&depth_1-utm_source=distribute.pc_relevant.none-task-blog-2%7Edefault%7ECTRLIST%7ERate-2-126589479-blog-117637804.235%5Ev40%5Epc_relevant_anti_t3_base&utm_relevant_index=5

        //参看 httpClient4.5.2.jar 中的 EntityBuild


        // 在 HttpClient  4.4版本中，似乎没有找到对 form-data 的支持，只有 x-www-form-urlencoded
        // 感觉 OkHttpClient 的API更简单，但是下面的也用得比较稳定了，就不改了

        JSONObject ret = new JSONObject();

        boolean httpClientNeedClose = false;
        CloseableHttpClient httpclient = null;
        CloseableHttpResponse response = null;
        HttpEntityEnclosingRequestBase post = null;
        try
        {
            JSONObject config = new JSONObject(configString);

            String proxy = config.getString("proxy", "");
            if (!proxy.isEmpty())
            {
                if (!proxy.endsWith("/")) proxy += "/";
                proxy += "HTTPPostProxy";
                config.remove("proxy");
                JSONObject param = new JSONObject();
                param.put("url", url);
                param.put("configString", config.toString());
                param.put("returnString", returnString);
                param.put("method", "POST");

                String s = FF.postStringToURL(proxy, param.toString(), "UTF-8", false);
                return s;
            }

            JSONObject form = config.getJSONObject("form", null);
            if (form != null)
            {
                return FF.$okHttpFormPost(url, configString);
            }


            JSONObject keyStore = config.getJSONObject("keyStore", null);
            if (keyStore != null)
            {
                String keyStoreType = keyStore.getString("type", "PKCS12");
                String keyStorePath = keyStore.getString("path", "");
                String keyStorePass = keyStore.getString("password", "");

                SSLContext sslcontext = buildSSLContext(keyStoreType, keyStorePath, keyStorePass);
                // Allow TLSv1 protocol only
                SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1"},
                                                                                  null,
                                                                                  SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);

                httpclient = HttpClients.custom().setSSLSocketFactory(sslsf).build();
                httpClientNeedClose = true; //临时创建的，最后需要关闭
            }
            else
            {
                httpclient = httpClient; //全局的，不要关闭，它自已管理连接池
               /*
                httpclient = HttpClients.createDefault();
                httpClientNeedClose=true; //临时创建的，最后需要关闭

                */
            }

            //  2022.08.05 有的url用的是类似 rest风格，拼上参数就 404 ， 所以需要取消自动拼参数的处理
            // 2024.07.04 默认改成 false ， 如果自动拼上一个参数，对有些系统来说，它可能会带来异常，比如亿企赢的开票接口
            if (config.getBoolean("no-cache", false))
            {
                if (url.indexOf("?") > 0)
                {
                    url = url + "&";
                }
                else
                {
                    url = url + "?";
                }


                url = url + "httpPostTimestampForPreventCache=" + DataStoreFactory.newGUID();

            }


            //以流的方式上传文件
            JSONObject stream = config.getJSONObject("stream", null);
            if (stream != null)
            {
                post = new HttpPut(url);

            }
            else
            {
                post = new HttpPost(url);
            }

            // 设置超时时间
            int timeout = config.getInt("timeout", 60) * 1000; //默认60秒
            RequestConfig requestConfig = RequestConfig.custom()
                    .setConnectTimeout(timeout)
                    .setConnectionRequestTimeout(timeout)
                    .setSocketTimeout(timeout).build();
            post.setConfig(requestConfig);

            JSONObject setting = config.getJSONObject("config", new JSONObject());


            String responseCharset = setting.getString("responseCharset", "UTF-8");

            // 构造消息头
            post.setHeader("Content-Type", "text/html; charset=" + responseCharset);


            JSONObject header = config.getJSONObject("header", null);
            if (header != null)
            {
                Iterator<String> it = header.getMap().keySet().iterator();
                while (it.hasNext())
                {
                    String key = it.next();
                    String value = header.getString(key, "");
                    post.setHeader(key, value);

                }
            }

            //如果是内部调用，则生成一个 临时token，避开权限校验
            if (url.startsWith(ServiceUtil.getHomeURLForService("app")))
            {

                String token = UUID.randomUUID().toString();
                AppCache.setCache("innerTokenForHttpPost:" + token, "1", true, 60); //10秒有效

                post.setHeader("innerTokenForHttpPost", token); //用于内部的 httpPost调用时，不需要校验用户

            }


            String body = "";
            JSONObject bodyObj = config.getJSONObject("body", null);
            if (bodyObj == null)
            {
                body = config.getString("body", "");
            }
            else
            {
                body = bodyObj.toString();
            }

            String requestCharset = setting.getString("requestCharset", "UTF-8");

            //使用body参数
            if (config.getMap().containsKey("body"))
            {
                StringEntity myEntity = new StringEntity(body, requestCharset);
                post.setEntity(myEntity);
            }

            //2020.07.13 增加对form类型参数的支持
            JSONObject xform = config.getJSONObject("xform", null);
            if (xform != null)
            {


                List<NameValuePair> formparams = new ArrayList<NameValuePair>();
                Iterator it = xform.getMap().keySet().iterator();
                while (it.hasNext())
                {
                    String k = it.next().toString();
                    String v = xform.getString(k, "");

                    BasicNameValuePair base = new BasicNameValuePair(k, v);
                    formparams.add(base);
                }

                HttpEntity entity = new UrlEncodedFormEntity(formparams, "UTF-8");

                post.setEntity(entity);

            }

            //以流的方式上传文件

            if (stream != null)
            {
                String name = stream.getString("name", "");
                String extName = FF.splitFileName(name)[2];
                String streamURL = stream.getString("url", "");

                String tempFile = FF.toLocalTempFile(streamURL, extName);
                ret.put("fileSize", FF.fileSize(tempFile));
                if (!FF.fileExists(tempFile)) throw new Exception(streamURL + "无法访问");
                HttpEntity entity = new FileEntity(new File(tempFile));
                post.setEntity(entity);

            }

            response = httpclient.execute(post);
            HttpEntity resultEntity = response.getEntity();

            int statusCode = response.getStatusLine().getStatusCode();

            if (resultEntity != null)
            {

                String responseText;
                if (resultEntity.getContentType() != null &&
                        (resultEntity.getContentType().getValue().startsWith("image") ||
                                resultEntity.getContentType().getValue().equalsIgnoreCase("application/octet-stream")))
                {


                    InputStream inputStream = resultEntity.getContent();
                    byte[] data = new byte[65535];
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    try
                    {

                        while (true)
                        {
                            int rc = inputStream.read(data);
                            if (rc <= 0) break;
                            bos.write(data, 0, rc);

                        }


                    } catch (IOException e)
                    {

                    } finally
                    {
                        inputStream.close();
                        bos.close();
                    }
                    //
                    responseText = new String(Base64Coder.encode(bos.toByteArray()));
                    statusCode = response.getStatusLine().getStatusCode();
                }
                else
                {
                    responseText = EntityUtils.toString(resultEntity, responseCharset);

                    statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode == 302)
                    {
                        Header h = response.getFirstHeader("location"); // 跳转的目标地址是在 HTTP-HEAD上
                        String newuri = h.getValue(); // 这就是跳转后的地址，再向这个地址发出新申请
                        return $httpPost(newuri, configString, returnString);

                    }
                }

                ret.put("success", true).put("response", responseText).put("statusCode", statusCode);

                //2020.09.12 增加返回的header
                Header[] hs = response.getAllHeaders();
                if (hs != null)
                {
                    JSONObject resHeader = new JSONObject();
                    ret.put("header", resHeader);
                    for (int i = 0; i < hs.length; i++)
                    {
                        resHeader.put(hs[i].getName(), hs[i].getValue());
                    }

                }


                if (returnString) return ret.toString();
                return ret;
            }
            else
            {

                ret.put("success", false).put("message", url + "返回null");
                if (returnString) return ret.toString();
                return ret;
            }

        } catch (Exception e)
        {


            String errorMsg = FF.exceptionMessage(e);
            ret.put("success", false).put("message", errorMsg);
            if (returnString) return ret.toString();
            return ret;

        } finally
        {
            //@off
            if (response != null)  try{ response.close(); } catch (Exception e) { }
            if (post != null)   try{post.releaseConnection();} catch (Exception e){}  //.getConnection 配对

            //不需要client.close，如果关闭了会出问题，4.X以上版本。 只关闭response 就可以了 response.close.
            if (httpclient != null && httpClientNeedClose)   try{ httpclient.close();} catch (Exception e) { }

            //@on

        }
    }


    public static String httpGet(String url, String configString)
    {


        JSONObject config = new JSONObject(configString);


        boolean httpClientNeedClose = false;
        CloseableHttpClient httpclient = null;
        CloseableHttpResponse response = null;
        HttpGet post = null;
        try
        {

            String proxy = config.getString("proxy", "");
            if (!proxy.isEmpty())
            {
                if (!proxy.endsWith("/")) proxy += "/";
                proxy += "HTTPPostProxy";
                config.remove("proxy");
                JSONObject param = new JSONObject();
                param.put("url", url);
                param.put("configString", config.toString());
                param.put("method", "GET");
                String s = FF.postStringToURL(proxy, param.toString(), "UTF-8", false);
                return s;
            }


            JSONObject keyStore = config.getJSONObject("keyStore", null);
            if (keyStore != null)
            {
                String keyStoreType = keyStore.getString("type", "PKCS12");
                String keyStorePath = keyStore.getString("path", "");
                String keyStorePass = keyStore.getString("password", "");

                SSLContext sslcontext = buildSSLContext(keyStoreType, keyStorePath, keyStorePass);
                // Allow TLSv1 protocol only
                SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1"},
                                                                                  null,
                                                                                  SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);

                httpclient = HttpClients.custom().setSSLSocketFactory(sslsf).build();
                httpClientNeedClose = true; //临时创建的，最后需要关闭
            }
            else
            {
                httpclient = httpClient; //全局的，不要关闭，它自已管理连接池

               /*
                httpclient = HttpClients.createDefault();
                  httpClientNeedClose=true; //临时创建的，最后需要关闭

                */
            }

            //  2022.08.05 有的url用的是类似 rest风格，拼上参数就 404 ， 所以需要取消自动拼参数的处理

            if (config.getBoolean("no-cache", true))
            {
                if (url.indexOf("?") > 0)
                {
                    url = url + "&";
                }
                else
                {
                    url = url + "?";
                }


                url = url + "httpGetTimestampForPreventCache=" + DataStoreFactory.newGUID();

            }

            post = new HttpGet(url);
            // 设置超时时间
            int timeout = config.getInt("timeout", 60) * 1000; //默认60秒
            RequestConfig requestConfig = RequestConfig.custom()
                    .setConnectTimeout(timeout)
                    .setConnectionRequestTimeout(timeout)
                    .setSocketTimeout(timeout).build();
            post.setConfig(requestConfig);

            // 构造消息头
            post.setHeader("Content-Type", "text/html; charset=UTF-8");
            post.setHeader("charset", "UTF-8");


            JSONObject header = config.getJSONObject("header", null);
            if (header != null)
            {
                Iterator<String> it = header.getMap().keySet().iterator();
                while (it.hasNext())
                {
                    String key = it.next();
                    String value = header.getString(key, "");
                    post.setHeader(key, value);

                }
            }


            JSONObject setting = config.getJSONObject("config", new JSONObject());


            String requestCharset = setting.getString("requestCharset", "UTF-8");
            String responseCharset = setting.getString("responseCharset", "UTF-8");


            response = httpclient.execute(post);
            HttpEntity resultEntity = response.getEntity();

            int statusCode = response.getStatusLine().getStatusCode();

            if (resultEntity != null)
            {

                String responseText;
                if (resultEntity.getContentType() != null && (resultEntity.getContentType().getValue().startsWith("image")
                        || resultEntity.getContentType().getValue().equalsIgnoreCase("application/octet-stream")))
                {


                    InputStream inputStream = resultEntity.getContent();
                    byte[] data = new byte[65535];
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    try
                    {

                        while (true)
                        {
                            int rc = inputStream.read(data);
                            if (rc <= 0) break;
                            bos.write(data, 0, rc);

                        }


                    } catch (IOException e)
                    {

                    } finally
                    {
                        inputStream.close();
                        bos.close();
                    }
                    //
                    responseText = new String(Base64Coder.encode(bos.toByteArray()));
                    statusCode = response.getStatusLine().getStatusCode();
                }
                else
                {
                    responseText = EntityUtils.toString(resultEntity, responseCharset);

                    statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode == 302)
                    {
                        Header h = response.getFirstHeader("location"); // 跳转的目标地址是在 HTTP-HEAD上
                        String newuri = h.getValue(); // 这就是跳转后的地址，再向这个地址发出新申请
                        return httpGet(newuri, configString);

                    }
                }
                JSONObject ret = new JSONObject();
                ret.put("success", true).put("response", responseText).put("statusCode", statusCode);

                //2020.09.12 增加返回的header
                Header[] hs = response.getAllHeaders();
                if (hs != null)
                {
                    JSONObject resHeader = new JSONObject();
                    ret.put("header", resHeader);
                    for (int i = 0; i < hs.length; i++)
                    {
                        resHeader.put(hs[i].getName(), hs[i].getValue());
                    }

                }


                return ret.toString();
            }
            else
            {
                JSONObject ret = new JSONObject();
                ret.put("success", false).put("message", url + "返回null");
                return ret.toString();

            }

        } catch (Exception e)
        {

            JSONObject ret = new JSONObject();
            String errorMsg = FF.exceptionMessage(e);
            ret.put("success", false).put("message", errorMsg);
            return ret.toString();


        } finally
        {
            //@off
            if (response != null)  try{ response.close(); } catch (Exception e) { }
            if (post != null)   try{post.releaseConnection();} catch (Exception e){}  //.getConnection 配对
            if (httpclient != null && httpClientNeedClose)   try{ httpclient.close();} catch (Exception e) { }

            //@on

        }
    }

    /**
     * 设置信任自签名证书
     *
     * @param keyStoreType 密钥库类型
     * @param keyStorePath 密钥库路径
     * @param keyStorepass 密钥库密码
     * @return
     */
    public static SSLContext buildSSLContext(String keyStoreType, String keyStorePath, String keyStorePass) throws
            Exception
    {
        SSLContext sc = null;


        try (
                FileInputStream instream = new FileInputStream(new File(keyStorePath))
        )
        {
            KeyStore trustStore = KeyStore.getInstance(keyStoreType);

            trustStore.load(instream, keyStorePass.toCharArray());
            // 相信自己的CA和所有自签名的证书
            sc = SSLContexts.custom().loadTrustMaterial(trustStore, new TrustSelfSignedStrategy()).build();

        } catch (Exception e)
        {
            FF.log(FF.exceptionMessage(e));
        }
        return sc;
    }

    //当应用还没有启动好时，使用此变量充当缓存
    public final static ConcurrentHashMap<String, String> tempCache = new ConcurrentHashMap<>();

    public static String buildTipInfoURL(String info)
    {
        String id = DataStoreFactory.newGUID();

        String key = "cachedTipInfo:" + id;
        AppCache.setCache(key, info, true, 60);

        //有可能在启动时， cache服务还没有启动，所以临时缓存一下
        if (tempCache.size() > 100) tempCache.clear(); //避免撑爆
        tempCache.put(key, info);


        return "tipinfo.jsp?info=" + id;
    }

    public static String getCachedTipInfo(String id)
    {
        String key = "cachedTipInfo:" + id;
        String info = AppCache.getCache(key, "");
        if (info.isEmpty())
        {
            //有可能在启动时， cache服务还没有启动，所以临时缓存一下
            info = tempCache.get(key);
            tempCache.remove(key);
        }
        return info;
    }

    public static String getFirstAppId()
    {
        return FF.getStringFromSQL("", "select id  from app_app where nodetype='leaf'  order by id asc ");
    }

    public static String appName2AppId(String appName)
    {
        return FF.getStringFromSQL("", "select id  from app_app where nodetype='leaf'  and name='" + appName + "'  ");
    }


    public static String buildPWD(String pwd, int userid)
    {
        String salt = buildSalt(userid);
        return buildPWD(pwd, salt);
    }

    public static String buildSalt(int userid)
    {
        String salt = FF.encryptString("userid:" + userid);
        salt = FF.right(salt, 8);
        return salt;
    }

    public static String buildPWD(String pwd, String salt)
    {

        String t = salt;
        if (t == null) t = getRandomString(8);

        String s = FF.MD5(FF.encryptString(pwd, t));
        s = s.substring(0, s.length() - 8);
        s = s + t;
        return s;
    }

    public static String getRandomString(int length)
    {

        String str = "abcdefghijklmnopqrstuvwxyz0123456789";

        Random random = new Random();

        StringBuffer sb = new StringBuffer();

        for (int i = 0; i < length; i++)
        {

            int number = random.nextInt(36);

            sb.append(str.charAt(number));

        }

        return sb.toString();

    }


    public static void base64ImageSave(String fileName, String code)
    {

        //解码出来保存

        // FF.log("base64编码数据恢复成图片：" + fileName);
        // FF.log(code);


        try (BufferedOutputStream bos = new BufferedOutputStream(Files.newOutputStream(new File(fileName).toPath()));)
        {

            byte[] b = Base64.decodeBase64(code);
            bos.write(b, 0, b.length);
            bos.flush();
            bos.close();
        } catch (Exception e)
        {
            FF.log("恢复图片异常：" + FF.exceptionMessage(e));
        }

        // if( ! FF.fileExists( fileName)) FF.log(fileName+" 没有正确生成");
    }


    /**
     * 上传一个本地文件或可下载的文件，到开放平台中（不一定是本系统，可以是其它系统，所以需要提供 token）
     *
     * @param server
     * @param fileName
     * @param filePath
     * @param token
     * @param config
     * @return
     */
    public static String uploadFileTo(String server, String fileName, String filePath, String token, String config)
    {

        JSONObject ret = new JSONObject().put(FF.SUCCESS, true);
        JSONObject cfg = new JSONObject(config);

        if (!server.endsWith("/")) server += "/";

        try
        {
            //请求地址
            String urlStr = server + "UploadFile";//

            Map<String, String> fieldMap = new HashMap<String, String>();
            String configData = cfg.toString(); //表单字段映射
            fieldMap.put("uploadData", URLEncoder.encode(configData, "UTF-8"));
            //要上传的文件
            Map<String, String> filesMap = new HashMap<String, String>();

            if (filePath.toLowerCase().startsWith("http"))
            {
                String tempPath = App.FileRoot + "/FileServer/autoDeleteAfterOneHour/";
                FF.MkDirs(tempPath);
                String extName = FF.getFileExtName(fileName);
                String tempFile = DataStoreFactory.newGUID() + "." + extName;
                FF.downloadFile(filePath, tempPath, tempFile);

                if (!FF.fileExists(tempPath + tempFile))
                {
                    throw new Exception(filePath + "无法下载");
                }
                filePath = tempPath + tempFile;
            }


            filesMap.put(fileName, filePath);
            String result = uploadFormFile(urlStr, fieldMap, filesMap, token);
            return result;
        } catch (Exception e)
        {
            ret.put(FF.SUCCESS, false);
            ret.put(FF.MESSAGE, e.getMessage());
        }

        return ret.toString();

    }


    /**
     * 使用jdk自带的HttpURLConnection手工撸一个上传
     *
     * @param urlStr
     * @param textMap
     * @param fileMap
     * @param token
     * @return
     */
    private static String uploadFormFile(String
                                                 urlStr, Map<String, String> textMap, Map<String, String> fileMap, String token)
    {


        String result = "";
        HttpURLConnection conn = null;

        //分隔符
        String finalSplit = "---------------------------123821742118716";
        try
        {

            FF.trustAllHttpsCertificates();
            URL url = new URL(urlStr);
            conn = (HttpURLConnection) url.openConnection();

            //绕过证书验证，验证主机名和服务器验证方案的匹配是可接受的
            if (conn instanceof HttpsURLConnection)
            {
                ((HttpsURLConnection) conn).setHostnameVerifier(new CustomizedHostnameVerifier());
            }


            conn.setConnectTimeout(300 * 1000);
            conn.setReadTimeout(300 * 1000);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 6.1; zh-CN; rv:1.9.2.6)");

            conn.setRequestProperty("Authorization", token);


            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + finalSplit);
            OutputStream out = new DataOutputStream(conn.getOutputStream());
            //文本域
            if (textMap != null)
            {
                StringBuffer strBuf = new StringBuffer();
                Iterator<Entry<String, String>> iter = textMap.entrySet().iterator();
                while (iter.hasNext())
                {
                    Entry<String, String> entry = iter.next();
                    String inputName = (String) entry.getKey();
                    String inputValue = (String) entry.getValue();
                    if (inputValue == null)
                    {
                        continue;
                    }
                    inputValue = new String(inputValue.getBytes("UTF-8"));
                    strBuf.append("\r\n").append("--").append(finalSplit).append("\r\n");
                    strBuf.append("Content-Disposition: form-data; name=\"" + inputName + "\"\r\n\r\n");
                    strBuf.append(inputValue);
                }
                out.write(strBuf.toString().getBytes("UTF-8"));
            }

            // 上传文件
            if (fileMap != null)
            {
                Iterator<Entry<String, String>> iter = fileMap.entrySet().iterator();
                while (iter.hasNext())
                {
                    Entry<String, String> entry = iter.next();
                    String inputName = (String) entry.getKey();
                    String inputValue = (String) entry.getValue();
                    if (inputValue == null)
                    {
                        continue;
                    }
                    File file = new File(inputValue);
                    String filename = file.getName();

                    String contentType = "application/octet-stream; charset=utf-8";
                    StringBuffer strBuf = new StringBuffer();
                    strBuf.append("\r\n").append("--").append(finalSplit).append("\r\n");
                    strBuf.append("Content-Disposition: form-data; name=\"" + inputName + "\"; filename=\"" + filename + "\"\r\n");
                    strBuf.append("Content-Type:" + contentType + "\r\n\r\n");
                    out.write(strBuf.toString().getBytes());
                    DataInputStream in = new DataInputStream(Files.newInputStream(file.toPath()));
                    int bytes = 0;
                    byte[] bufferOut = new byte[1024];
                    while ((bytes = in.read(bufferOut)) != -1)
                    {
                        out.write(bufferOut, 0, bytes);
                    }
                    in.close();
                }
            }
            byte[] endData = ("\r\n--" + finalSplit + "--\r\n").getBytes();
            out.write(endData);
            out.flush();
            out.close();
            // 读取返回数据
            StringBuffer strBuf = new StringBuffer();
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null)
            {
                strBuf.append(line).append("\n");
            }
            result = strBuf.toString();
            reader.close();
            reader = null;
        } catch (Exception e)
        {
            FF.log("上传文件请求失败！" + urlStr);

        } finally
        {
            if (conn != null)
            {
                conn.disconnect();
                conn = null;
            }
        }
        return result;
    }

}

