/*

 */

package util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class DirCopyUtil
{

	public static void copy(File src , File dest  ) throws IOException
	{
		copy( src, dest, null);
	}
	
	public static void copy(File src , File dest ,String reName ) throws IOException
	{
		copy (src, dest,  reName,true);
	}

	public static void copy(File src , File dest, boolean overWrite) throws IOException
	{
		copy (src, dest, null,overWrite);
	}
	
	public static void copy(File src , File dest,String reName,boolean overWrite) throws IOException
	{
		getCopyable(src).copy(dest ,reName,overWrite);
	}

	//this is the factory pattern.
	public static Copyable getCopyable(File src)
	{
		//if the source if file then return a file copier
		if (src.isFile()) { return new FileCopier(src); }
		/*
		 * else it has to be a directory copier, we could also enhance it to be other type of copier such as httpcopier
		 * etc...
		 */
		return new DirCopier(src);

	}

	interface Copyable
	{
		 
		void copy(File dest, boolean overWrite) throws IOException;
		void copy(File dest, String reName, boolean overWrite) throws IOException;
		
		
	}

	static class DirCopier implements Copyable
	{
		File	srcDir;

		public DirCopier(File srcDir)
		{
			if (!srcDir.isDirectory()) { throw new IllegalArgumentException("passed in paremter has to be directory" + srcDir); }
			this.srcDir = srcDir;
		}
		
		
	 
		/**
		 * copy current directory content under 'destRoot' directory
		 * 
		 * @param destRoot
		 *                       the destination root directory, all the file and sub directory will be copied under this destRoot
		 *                       directory, if destRoot doesn't exist, this will create the directory.
		 * @throws IOException
		 * 把 srcDir Copy到 destRoot中
		 * 例如： 把 c:\aa\bb\cc Copy到   c:\ee下
		 * 首先是要在 c:\ee下建一个cc ,然后把cc 下的子目录和文件Copy 到c:\ee\cc 下,这一点要注意
		 * 因为通常的操作是选中一个目录，然后把它Copy到目标地点。
		 * 		 */
		public void copy(File destRoot ,  boolean overWrite) throws IOException
		{
			copy( destRoot, null, overWrite);
		}
		public void copy(File destRoot ,String reName, boolean overWrite) throws IOException
		{
			//          1) if destRoot is not exist it will create it
			if (!destRoot.exists())
			{
				if (!destRoot.mkdirs()) { throw new IOException("unable to create dir:" + destRoot); }
			}
			if (!destRoot.isDirectory()) { throw new IllegalArgumentException("passed in paremter has to be directory" + destRoot); }
			
			File toDir = new File( destRoot , reName==null?srcDir.getName():reName);
			if (!toDir.exists())
			{
				if (!toDir.mkdirs()) { throw new IOException("unable to create dir:" + destRoot); }
			}
			destRoot= toDir;
			
			File[] dirContents = srcDir.listFiles();
			//we know dirContents can not be null since only file will return null, so no need to check null
			for (int i = 0; i < dirContents.length; i++)
			{
				getCopyable(dirContents[i]).copy(destRoot , overWrite);
			}
		}

	}

	static class FileCopier implements Copyable
	{
		File	src;

		public FileCopier(File src)
		{
			if (!src.isFile()) { throw new IllegalArgumentException("passed in paremter has to be file" + src); }
			this.src = src;
		}

		
		public void copy(File dest  ,boolean overWrite) throws IOException
		{
			copy( dest, null,overWrite);
		}
		/**
		 * Copy the current file to the dest file, if the dest file doesn't exist it will be created.
		 * 
		 * @param dest
		 *                       the destination file
		 * @throws IOException
		 */
		public void copy(File dest ,String reName,boolean overWrite) throws IOException
		{
			
			
			if (dest.exists()  && !dest.isFile()) // 如果是目录
			{
				File newDest;
				newDest= new File( dest , reName==null? src.getName() :reName);
				
				if ( newDest.exists() && overWrite ) 
				{
						newDest.delete();
				
						newDest= new File( dest ,  reName==null? src.getName() :reName );
				}
				int i=1;
				while ( newDest.exists())
				{
					newDest=new File(dest,"copy"+String.valueOf(i)+(reName==null? src.getName() :reName));
					i++;
				}
				
				newDest.createNewFile();
				dest=newDest;
					
			}else
			{


				File newDest;
				newDest= dest;
				
				if ( newDest.exists() && overWrite ) 
				{
					//bug fixed  要复制的内容与源是同一个，并且还要覆盖，搞什么飞机，直接退回 ，不然删除newDest 实际上把源文件给删除了
						if( newDest.getPath().equals(this.src.getPath())) return;

						newDest.delete();
		 				newDest= new File( dest.getPath() );
				}
				int i=1;
				while ( newDest.exists())
				{
					newDest=new File(dest.getParent() ,"copy"+String.valueOf(i)+(reName==null? dest.getName() :reName));
					i++;
				}
				dest=newDest;
			}
			
			
			
			//do straight file copy
			FileInputStream in = new FileInputStream(src);
			FileOutputStream out = new FileOutputStream(dest);
			byte[] buffer = new byte[1024 * 64]; //4k buffer
			int len = 0;
			while ((len = in.read(buffer, 0, buffer.length)) > 0)
			{
				out.write(buffer, 0, len);
			}
			in.close();
			out.close();
		}
	}
}