package util;


/**
 *
 *
 * 2018.05.28  增加：当开始运行时，设置运行标记，运行结束时，去掉标记，保证一个任务在结束前，不会重复执行
 */

import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

public class DelayRun
{

    public static ConcurrentHashMap<String , Timer> map= new ConcurrentHashMap<String,Timer>();
    public static ConcurrentHashMap<String , String> runnIngMap= new ConcurrentHashMap<String,String>();

    public static void delayRun(String key , TimerTask task , int delay)
    {

        if( runnIngMap.containsKey(key))
        {
            log( key+"延时任务已经在运行中，不需要重复运行");
            return;
        }

        if( map.containsKey(key))
        {
            log("历史延时任务"+key+"被取消，并重新开始记时，于"+delay+" ms后重新执行");
            map.get(key).cancel();
            map.remove(key);
        }else
        {
            log("新建延时任务"+key+"于"+delay+" ms后开始执行");
        }
        Timer timer=new Timer("延时任务"+key);
        map.put(key , timer);

        timer.schedule(new TimerTask()
        {
            @Override
            public void run()
            {

                runnIngMap.put(key ,"1");
                task.run();
                runnIngMap.remove(key);

                //默认情况下，任务执行线程不作为守护程序线程运行，因此它能够阻止应用程序终止。如果调用者想要快速终止计时器的任务执行线程，则调用者应该调用计时器的cancel方法。
                //众所周知 ， Timer.cancel() 被调用之后整个Timer 的 线程都会结束掉
                map.get(key).cancel();
                map.remove(key);
            }
        } , delay);

    }

    public static void log(String info)
    {
        FF.log ( info);
    }

}

